/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi;

import de.qfs.apps.qftest.demo.BaseDemo;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.log.Logger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class DNDDemo
extends BaseDemo {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.DNDDemo");
    private JList leftList;
    private JList rightList;

    public DNDDemo(boolean bl) {
        super(bl);
    }

    public static void main(String[] stringArray) {
        DNDDemo dNDDemo = new DNDDemo(false);
        BaseDemo.setupAndRun(stringArray, dNDDemo);
    }

    @Override
    protected void showFrameOrDialog() {
        Container container;
        Window window;
        JDialog jDialog;
        if (DNDDemo.logger.level >= 7) {
            logger.log(7, "showFrameOrDialog()", "");
        }
        if (this.asDialog) {
            jDialog = new JDialog(new JFrame(), "DNDDemo [dialog]", !this.isAsNonModal());
            window = jDialog;
            container = jDialog.getContentPane();
        } else {
            this.frame = new JFrame("DNDDemo [ Frame ]");
            window = this.frame;
            container = ((JFrame)this.frame).getContentPane();
        }
        window.setName("DNDDemo");
        jDialog = new Grid();
        jDialog.setName("grid");
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement("red");
        defaultListModel.addElement("green");
        defaultListModel.addElement("blue");
        defaultListModel.addElement("yello");
        defaultListModel.addElement("cyan");
        defaultListModel.addElement("magenta");
        this.leftList = new DNDList((ListModel)defaultListModel);
        this.leftList.setName("Base colours");
        JScrollPane jScrollPane = new JScrollPane(this.leftList);
        jScrollPane.setName("left pane");
        DefaultListModel<String> defaultListModel2 = new DefaultListModel<String>();
        defaultListModel2.addElement("orange");
        defaultListModel2.addElement("mauve");
        defaultListModel2.addElement("khaki");
        defaultListModel2.addElement("pink");
        defaultListModel2.addElement("seagreen");
        this.rightList = new DNDList((ListModel)defaultListModel2);
        this.rightList.setName("Mixed colours");
        JScrollPane jScrollPane2 = new JScrollPane(this.rightList);
        jScrollPane2.setName("right pane");
        jDialog.addLine(new Component[]{jScrollPane, jScrollPane2}, 1.0);
        container.add(jDialog);
        this.finishWindow(window, 300, 200);
    }

    public static class DNDList
    extends JList
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        DropTarget dropTarget = null;
        DragSource dragSource = null;
        int dragIndex;

        public DNDList(ListModel listModel) {
            super(listModel);
            this.setSelectionMode(0);
            this.dropTarget = new DropTarget(this, this);
            this.dragSource = DragSource.getDefaultDragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this, 0x40000003, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Rectangle rectangle;
            if (logger.level >= 7) {
                logger.log(7, "dragGestureRecognized(DragGestureEvent)", logger.level < 8 ? "" : "event: " + dragGestureEvent);
            }
            this.dragIndex = -1;
            int n = this.locationToIndex(dragGestureEvent.getDragOrigin());
            if (n >= 0 && n < this.getModel().getSize() && (rectangle = this.getCellBounds(n, n)).contains(dragGestureEvent.getDragOrigin())) {
                Object e = this.getModel().getElementAt(n);
                if (e != null) {
                    StringSelection stringSelection = new StringSelection(e.toString());
                    this.dragIndex = n;
                    this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, stringSelection, this);
                } else if (logger.level >= 5) {
                    logger.log(5, "dragGestureRecognized(DragGestureEvent)", "Nothing selected");
                }
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dragEnter(DropTargetDragEvent)", logger.level < 8 ? "" : "event: " + dropTargetDragEvent);
            }
            dropTargetDragEvent.acceptDrag(2);
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dragExit(DropTargetEvent)", logger.level < 8 ? "" : "event: " + dropTargetEvent);
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dragOver(DropTargetDragEvent)", logger.level < 8 ? "" : "event: " + dropTargetDragEvent);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (logger.level >= 7) {
                logger.log(7, "drop(DropTargetDropEvent)", logger.level < 8 ? "" : "event: " + dropTargetDropEvent);
            }
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    if (dropTargetDropEvent.getDropAction() == 2 || dropTargetDropEvent.getDropAction() == 1) {
                        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        ((DefaultListModel)this.getModel()).addElement(string);
                    }
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            }
            catch (IOException iOException) {
                if (logger.level >= 1) {
                    logger.log(1, "catch(IOException)", (Throwable)iOException);
                }
                dropTargetDropEvent.rejectDrop();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                if (logger.level >= 1) {
                    logger.log(1, "catch(UnsupportedFlavorException)", (Throwable)unsupportedFlavorException);
                }
                dropTargetDropEvent.rejectDrop();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dropActionChanged(DropTargetDragEvent)", logger.level < 8 ? "" : "event: " + dropTargetDragEvent);
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dragDropEnd(DragSourceDropEvent)", logger.level < 8 ? "" : "event: " + dragSourceDropEvent + ", success: " + dragSourceDropEvent.getDropSuccess() + ", action:" + dragSourceDropEvent.getDropAction() + ", dragIndex: " + this.dragIndex);
            }
            if (dragSourceDropEvent.getDropSuccess() && this.dragIndex >= 0 && (dragSourceDropEvent.getDropAction() == 2 || dragSourceDropEvent.getDropAction() == 0x40000000)) {
                ((DefaultListModel)this.getModel()).removeElementAt(this.dragIndex);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dragEnter(DragSourceDragEvent)", logger.level < 8 ? "" : "event: " + dragSourceDragEvent);
            }
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dragExit(DragSourceEvent)", logger.level < 8 ? "" : "event: " + dragSourceEvent);
            }
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dragOver(DragSourceDragEvent)", logger.level < 8 ? "" : "event: " + dragSourceDragEvent);
            }
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dropActionChanged(DragSourceDragEvent)", logger.level < 8 ? "" : "event: " + dragSourceDragEvent);
            }
        }
    }
}

