/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi;

import de.qfs.apps.qftest.demo.BaseDemo;
import de.qfs.lib.log.Logger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class DragDemo
extends BaseDemo {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.multi.DragDemo");

    public DragDemo(boolean bl) {
        super(bl);
    }

    public static void main(String[] stringArray) {
        DragDemo dragDemo = new DragDemo(false);
        BaseDemo.setupAndRun(stringArray, dragDemo);
    }

    @Override
    protected void showFrameOrDialog() {
        Container container;
        Window window;
        if (DragDemo.logger.level >= 7) {
            logger.log(7, "showFrameOrDialog()", "");
        }
        if (this.asDialog) {
            this.dialog = new JDialog(new Frame(), "DragDemo [ Dialog ]", !this.isAsNonModal());
            window = this.dialog;
            container = ((JDialog)this.dialog).getContentPane();
        } else {
            window = this.frame = new JFrame("DragDemo [ Frame ]");
            container = ((JFrame)this.frame).getContentPane();
        }
        window.setName("Drag demo");
        JLabel jLabel = new JLabel("Drag me");
        jLabel.setName("draglabel");
        jLabel.setOpaque(true);
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setSize(jLabel.getPreferredSize());
        DragListener dragListener = new DragListener();
        jLabel.addMouseListener(dragListener);
        jLabel.addMouseMotionListener(dragListener);
        container.setLayout(null);
        container.add(jLabel);
        this.finishWindow(window, 400, 300);
        jLabel.setLocation(100, 100);
    }

    private static class DragListener
    extends MouseAdapter
    implements MouseMotionListener {
        private int startX;
        private int startY;

        private DragListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (logger.level >= 7) {
                logger.log(7, "mousePressed(MouseEvent)", logger.level < 8 ? "" : "event: " + mouseEvent);
            }
            this.startX = mouseEvent.getX();
            this.startY = mouseEvent.getY();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (logger.level >= 7) {
                logger.log(7, "mousePressed(MouseEvent)", logger.level < 8 ? "" : "event: " + mouseEvent);
            }
            Component component = (Component)mouseEvent.getSource();
            Point point = component.getLocation();
            point.x += mouseEvent.getX() - this.startX;
            point.y += mouseEvent.getY() - this.startY;
            component.setLocation(point);
            component.getParent().validate();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

