/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi;

import de.qfs.apps.qftest.demo.BaseDemo;
import de.qfs.lib.log.Logger;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.Timer;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class DynamicMenus
extends BaseDemo
implements MenuListener {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.multi.DynamicMenus");
    private JMenuBar menubar;
    private JMenu namedMenu;
    private JMenu unnamedMenu;
    private JMenu namedNestedMenu;
    private JMenu unnamedNestedMenu;
    private JMenu dynamicMenuNamed;
    private JMenu dynamicMenuUnnamed;
    private JMenuItem namedFirstItem;
    private JMenuItem namedSecondItem;
    private JMenuItem unnamedFirstItem;
    private JMenuItem unnamedSecondItem;
    private JCheckBoxMenuItem namedFirstCheckItem;
    private JCheckBoxMenuItem namedSecondCheckItem;
    private JCheckBoxMenuItem namedNestedCheckItem;
    private JCheckBoxMenuItem unnamedFirstCheckItem;
    private JCheckBoxMenuItem unnamedSecondCheckItem;
    private JCheckBoxMenuItem unnamedNestedCheckItem;
    private JCheckBoxMenuItem namedMenuCheckItem;
    private JCheckBoxMenuItem unnamedMenuCheckItem;
    private AbstractAction dynMenuNamedAction;
    private AbstractAction dynMenuUnnamedAction;
    private AbstractAction dynMenuItemAction;
    private int dynMenuCount = 0;
    private JMenuItem lazyMenu;

    public DynamicMenus(boolean bl) {
        super(bl);
    }

    public static void main(String[] stringArray) {
        DynamicMenus dynamicMenus = new DynamicMenus(false);
        BaseDemo.setupAndRun(stringArray, dynamicMenus);
    }

    @Override
    protected void showFrameOrDialog() {
        Window window;
        if (DynamicMenus.logger.level >= 7) {
            logger.log(7, "showFrameOrDialog()", "");
        }
        if (this.asDialog) {
            JDialog jDialog = new JDialog(new JFrame(), "DynamicMenus", !this.isAsNonModal());
            window = jDialog;
            Container container = jDialog.getContentPane();
        } else {
            this.frame = new JFrame("DynamicMenus");
            window = this.frame;
            Container container = ((JFrame)this.frame).getContentPane();
        }
        window.setName("DynamicMenus");
        this.setupActions();
        this.setupMenus();
        this.finishWindow(window, 400, 200);
    }

    private void setupMenus() {
        this.menubar = new JMenuBar();
        this.menubar.setName("DynMenuBar");
        ((JFrame)this.frame).setJMenuBar(this.menubar);
        JMenu jMenu = new JMenu("Config");
        jMenu.setName("mConfig");
        jMenu.setMnemonic('c');
        this.menubar.add(jMenu);
        this.namedFirstCheckItem = new JCheckBoxMenuItem("Named Item first");
        this.namedFirstCheckItem.setName("NamedFirstCheckItem");
        this.namedFirstCheckItem.setMnemonic('n');
        this.namedFirstCheckItem.addActionListener(this.dynMenuItemAction);
        jMenu.add(this.namedFirstCheckItem);
        this.namedSecondCheckItem = new JCheckBoxMenuItem("Named Item second");
        this.namedSecondCheckItem.setName("NamedSecondCheckItem");
        this.namedSecondCheckItem.setMnemonic('m');
        this.namedSecondCheckItem.addActionListener(this.dynMenuItemAction);
        jMenu.add(this.namedSecondCheckItem);
        this.namedNestedCheckItem = new JCheckBoxMenuItem("Named Nested Menu");
        this.namedNestedCheckItem.setName("NamedNestedCheckItem");
        this.namedNestedCheckItem.setMnemonic('t');
        this.namedNestedCheckItem.addActionListener(this.dynMenuItemAction);
        jMenu.add(this.namedNestedCheckItem);
        jMenu.addSeparator();
        this.unnamedFirstCheckItem = new JCheckBoxMenuItem("Unnamed Item first");
        this.unnamedFirstCheckItem.setName("UnnamedFirstCheckItem");
        this.unnamedFirstCheckItem.setMnemonic('f');
        this.unnamedFirstCheckItem.addActionListener(this.dynMenuItemAction);
        jMenu.add(this.unnamedFirstCheckItem);
        this.unnamedSecondCheckItem = new JCheckBoxMenuItem("Unnamed Item second");
        this.unnamedSecondCheckItem.setName("UnnamedSecondCheckItem");
        this.unnamedSecondCheckItem.setMnemonic('s');
        this.unnamedSecondCheckItem.addActionListener(this.dynMenuItemAction);
        jMenu.add(this.unnamedSecondCheckItem);
        this.unnamedNestedCheckItem = new JCheckBoxMenuItem("Unnamed Nested Menu");
        this.unnamedNestedCheckItem.setName("UnnamedNestedCheckItem");
        this.unnamedNestedCheckItem.setMnemonic('u');
        this.unnamedNestedCheckItem.addActionListener(this.dynMenuItemAction);
        jMenu.add(this.unnamedNestedCheckItem);
        jMenu.addSeparator();
        this.namedMenuCheckItem = new JCheckBoxMenuItem("Dynamic Menu Named");
        this.namedMenuCheckItem.setName("NamedDynMenuCheckItem");
        this.namedMenuCheckItem.setMnemonic('d');
        this.namedMenuCheckItem.addActionListener(this.dynMenuNamedAction);
        jMenu.add(this.namedMenuCheckItem);
        this.unnamedMenuCheckItem = new JCheckBoxMenuItem("Dynamic Menu Unnamed");
        this.unnamedMenuCheckItem.setName("UnnamedDynMenuCheckItem");
        this.unnamedMenuCheckItem.setMnemonic('e');
        this.unnamedMenuCheckItem.addActionListener(this.dynMenuUnnamedAction);
        jMenu.add(this.unnamedMenuCheckItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenuItem.setName("miExit");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicMenus.this.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        this.namedMenu = new JMenu("Named");
        this.namedMenu.setName("mNamedDyn");
        this.namedMenu.setMnemonic('n');
        this.menubar.add(this.namedMenu);
        this.namedFirstItem = new JMenuItem("Named first");
        this.namedFirstItem.setName("NamedFirstItem");
        this.namedFirstItem.setMnemonic('n');
        this.namedSecondItem = new JMenuItem("Named second");
        this.namedSecondItem.setName("NamedSecondItem");
        this.namedSecondItem.setMnemonic('m');
        this.namedNestedMenu = new JMenu("Nested menu");
        this.namedNestedMenu.setName("namedNestedMenu");
        jMenuItem = new JMenuItem("Nested1");
        jMenuItem.setName("Nested menu 1");
        this.namedNestedMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Nested2");
        jMenuItem.setName("Nested menu 2");
        this.namedNestedMenu.add(jMenuItem);
        this.unnamedMenu = new JMenu("Unnamed");
        this.unnamedMenu.setMnemonic('u');
        this.menubar.add(this.unnamedMenu);
        this.unnamedFirstItem = new JMenuItem("Unnamed first");
        this.unnamedFirstItem.setMnemonic('u');
        this.unnamedSecondItem = new JMenuItem("Unnamed second");
        this.unnamedSecondItem.setMnemonic('v');
        this.unnamedNestedMenu = new JMenu("Nested menu");
        jMenuItem = new JMenuItem("Nested1");
        this.unnamedNestedMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Nested2");
        this.unnamedNestedMenu.add(jMenuItem);
        this.dynamicMenuNamed = new JMenu("DynNamed");
        this.dynamicMenuNamed.setMnemonic('d');
        this.dynamicMenuNamed.setName("mDynamic");
        this.dynamicMenuNamed.addMenuListener(this);
        JMenuItem jMenuItem2 = new JMenuItem("Dynamic first");
        jMenuItem2.setMnemonic('f');
        this.dynamicMenuNamed.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Dynamic second");
        jMenuItem3.setMnemonic('s');
        this.dynamicMenuNamed.add(jMenuItem3);
        this.dynamicMenuUnnamed = new JMenu("DynUnnamed");
        this.dynamicMenuUnnamed.setMnemonic('e');
        this.dynamicMenuUnnamed.addMenuListener(this);
        JMenuItem jMenuItem4 = new JMenuItem("Dynamic third");
        jMenuItem4.setMnemonic('t');
        this.dynamicMenuUnnamed.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Dynamic fourth");
        jMenuItem5.setMnemonic('o');
        this.dynamicMenuUnnamed.add(jMenuItem5);
        this.lazyMenu = new JMenu("Lazy");
        this.lazyMenu.setMnemonic('l');
        this.lazyMenu.setName("mLazy");
        this.menubar.add(this.lazyMenu);
        Timer timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = new JMenuItem("First lazy item");
                jMenuItem.setName("miLazyFirst");
                DynamicMenus.this.lazyMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("Second lazy");
                DynamicMenus.this.lazyMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("Third lazy item");
                jMenuItem.setName("miLazyThird");
                DynamicMenus.this.lazyMenu.add(jMenuItem);
            }
        });
        timer.setRepeats(false);
        timer.start();
        this.updateDynamicMenuNamed();
        this.updateDynamicMenuUnamed();
        this.updateDynamicMenuItems();
    }

    private void setupActions() {
        this.dynMenuNamedAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicMenus.this.updateDynamicMenuNamed();
            }
        };
        this.dynMenuUnnamedAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicMenus.this.updateDynamicMenuUnamed();
            }
        };
        this.dynMenuItemAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicMenus.this.updateDynamicMenuItems();
            }
        };
    }

    private void updateDynamicMenuNamed() {
        if (this.namedMenuCheckItem.isSelected()) {
            this.menubar.add(this.dynamicMenuNamed);
        } else {
            this.menubar.remove(this.dynamicMenuNamed);
        }
        this.menubar.updateUI();
    }

    private void updateDynamicMenuUnamed() {
        if (this.unnamedMenuCheckItem.isSelected()) {
            this.menubar.add(this.dynamicMenuUnnamed);
        } else {
            this.menubar.remove(this.dynamicMenuUnnamed);
        }
        this.menubar.updateUI();
    }

    private void updateDynamicMenuItems() {
        if (this.namedFirstCheckItem.isSelected()) {
            this.namedMenu.add(this.namedFirstItem);
        } else {
            this.namedMenu.remove(this.namedFirstItem);
        }
        if (this.namedSecondCheckItem.isSelected()) {
            this.namedMenu.add(this.namedSecondItem);
        } else {
            this.namedMenu.remove(this.namedSecondItem);
        }
        if (this.namedNestedCheckItem.isSelected()) {
            this.namedMenu.add(this.namedNestedMenu);
        } else {
            this.namedMenu.remove(this.namedNestedMenu);
        }
        if (this.unnamedFirstCheckItem.isSelected()) {
            this.unnamedMenu.add(this.unnamedFirstItem);
        } else {
            this.unnamedMenu.remove(this.unnamedFirstItem);
        }
        if (this.unnamedSecondCheckItem.isSelected()) {
            this.unnamedMenu.add(this.unnamedSecondItem);
        } else {
            this.unnamedMenu.remove(this.unnamedSecondItem);
        }
        if (this.unnamedNestedCheckItem.isSelected()) {
            this.unnamedMenu.add(this.unnamedNestedMenu);
        } else {
            this.unnamedMenu.remove(this.unnamedNestedMenu);
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        if (DynamicMenus.logger.level >= 7) {
            logger.log(7, "menuSelected(MenuEvent)", DynamicMenus.logger.level < 8 ? "" : "e: " + menuEvent);
        }
        if (menuEvent.getSource() == this.dynamicMenuNamed) {
            JMenuItem jMenuItem = new JMenuItem("Dynamic Item " + this.dynMenuCount);
            jMenuItem.setName("Dynamic Item " + this.dynMenuCount++);
            this.dynamicMenuNamed.add(jMenuItem);
        } else if (menuEvent.getSource() == this.dynamicMenuUnnamed) {
            JMenuItem jMenuItem = new JMenuItem("Dynamic Item " + this.dynMenuCount++);
            this.dynamicMenuUnnamed.add(jMenuItem);
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
        if (DynamicMenus.logger.level >= 7) {
            logger.log(7, "menuDeselected(MenuEvent)", DynamicMenus.logger.level < 8 ? "" : "e: " + menuEvent);
        }
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
        if (DynamicMenus.logger.level >= 7) {
            logger.log(7, "menuCanceled(MenuEvent)", DynamicMenus.logger.level < 8 ? "" : "e: " + menuEvent);
        }
    }
}

