/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi;

import de.qfs.apps.qftest.demo.BaseDemo;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.DaemonThread;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HiddenComponentDemo
extends BaseDemo {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.demo.multi.HiddenComponentDemo");
    private final String demoName = "HiddenComponentDemo";
    private final int frameWidth = 300;
    private final int frameHeight = 200;
    int numericValue = 0;

    public HiddenComponentDemo(boolean bl) {
        super(bl);
        if (HiddenComponentDemo.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "HiddenComponentDemo(boolean)", 77).addDetail("asDialog", bl)).log();
        }
    }

    public static void main(String[] stringArray) {
        if (HiddenComponentDemo.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "main(String[])", 95).addDetail("args", (Object)stringArray)).log();
        }
        HiddenComponentDemo hiddenComponentDemo = new HiddenComponentDemo(false);
        BaseDemo.setupAndRun(stringArray, hiddenComponentDemo);
    }

    @Override
    protected void showFrameOrDialog() {
        JPanel jPanel;
        Window window;
        Serializable serializable;
        if (HiddenComponentDemo.logger.level >= 7) {
            logger.lvlBuild(7, "showFrameOrDialog()", 112).log();
        }
        if (this.asDialog) {
            serializable = new JDialog(new JFrame(), "HiddenComponentDemo [dialog]", !this.isAsNonModal());
            window = serializable;
            jPanel = (JPanel)serializable.getGlassPane();
        } else {
            this.frame = new JFrame("HiddenComponentDemo [ Frame ]");
            window = this.frame;
            jPanel = (JPanel)((JFrame)this.frame).getContentPane();
        }
        window.setName("HiddenComponentDemo");
        jPanel.setLayout(new GridBagLayout());
        serializable = new GridBagConstraints();
        jPanel.setName("hiddenComponentPanel");
        ((GridBagConstraints)serializable).insets = new Insets(3, 5, 3, 5);
        JButton jButton = new JButton("Hide");
        jButton.setName("hideButton");
        final JTextField jTextField = new JTextField("");
        jTextField.setToolTipText("Set the timeout for the hidden component to reappear");
        jTextField.setName("timeoutTextField");
        jTextField.setPreferredSize(new Dimension(40, 20));
        JButton jButton2 = new JButton("Show with Timeout");
        jButton2.setName("showButton");
        final JTextField jTextField2 = new JTextField("This component is currently not hidden");
        jTextField2.setName("hiddenTextField");
        jTextField2.setMinimumSize(new Dimension(12, 12));
        jPanel.add((Component)jButton, serializable);
        jPanel.add(jTextField);
        jPanel.add((Component)jButton2, serializable);
        jPanel.add((Component)jTextField2, serializable);
        jPanel.setVisible(true);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "showFrameOrDialog().ActionListener.actionPerformed(ActionEvent)", 157).addDetail("e", (Object)actionEvent)).log();
                }
                jTextField2.setVisible(false);
            }
        });
        final AtomicInteger atomicInteger = new AtomicInteger();
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                long l;
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "showFrameOrDialog().ActionListener.actionPerformed(ActionEvent)", 166).addDetail("e", (Object)actionEvent)).log();
                }
                try {
                    l = Long.valueOf(jTextField.getText());
                    HiddenComponentDemo.this.frame.setTitle("HiddenComponentDemo");
                }
                catch (Exception exception) {
                    HiddenComponentDemo.this.frame.setTitle("No Integer value");
                    l = 0L;
                }
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, runnable -> new DaemonThread(runnable, "HiddenComponentDemo setVisibleThread " + atomicInteger.incrementAndGet()));
                scheduledThreadPoolExecutor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (logger.level >= 7) {
                            logger.lvlBuild(7, "showFrameOrDialog().ActionListener.actionPerformed(ActionEvent).Runnable.run()", 180).log();
                        }
                        jTextField2.setVisible(true);
                    }
                }, l, TimeUnit.MILLISECONDS);
            }
        });
        this.finishWindow(window, 600, 400);
    }
}

