/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi;

import de.qfs.apps.qftest.demo.BaseDemo;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JWindow;

public class NestedPopupMenu
extends BaseDemo {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.multi.NestedPopupMenu");
    private JPopupMenu popup;
    private String bufferedText;

    public NestedPopupMenu(boolean bl, boolean bl2) {
        super(bl, bl2);
    }

    public static void main(String[] stringArray) {
        NestedPopupMenu nestedPopupMenu = new NestedPopupMenu(false, false);
        BaseDemo.setupAndRun(stringArray, nestedPopupMenu);
    }

    @Override
    protected void showFrameOrDialog() {
        Container container;
        Window window;
        if (NestedPopupMenu.logger.level >= 7) {
            logger.log(7, "showFrameOrDialog()", "");
        }
        if (this.asDialog) {
            this.dialog = new JDialog(new Frame(), "PopupDemo [ Dialog ]", !this.isAsNonModal());
            window = this.dialog;
            container = ((JDialog)this.dialog).getContentPane();
        } else {
            window = this.frame = new JFrame("PopupDemo [ Frame ]");
            container = ((JFrame)this.frame).getContentPane();
        }
        window.setName("Popup demo");
        container.setLayout(new BorderLayout());
        final JTextField jTextField = new JTextField();
        jTextField.setName("First field");
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                NestedPopupMenu.this.bufferedText = jTextField.getText();
            }
        });
        JLabel jLabel = new JLabel("Click for Popup");
        jLabel.setName("Popup Label 1");
        final JTextArea jTextArea = new JTextArea("Multi\nLine\r\nText\r");
        jTextArea.setName("Second field");
        JLabel jLabel2 = new JLabel("Click for Popup");
        jLabel2.setName("Popup Label 2");
        JPasswordField jPasswordField = new JPasswordField();
        jPasswordField.setName("password");
        JLabel jLabel3 = new JLabel("Click for Popup");
        jLabel3.setName("Popup Label 3");
        JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{"First item", "Second item", "Third item", "Fourth item", "Fifth item", "Sixth item"});
        jComboBox.setName("Combo");
        JComboBox<Object> jComboBox2 = new JComboBox<Object>(new Object[]{"One", "Two", "Three"});
        jComboBox2.setEditable(true);
        jComboBox2.setName("EditableCombo");
        Grid grid = new Grid((Component[][])new Component[][]{{new JLabel("Some text"), jTextField}, {jLabel}, {new JLabel("More text"), jTextArea}, {jLabel2}, {new JLabel("Password"), jPasswordField}, {jComboBox}, {jLabel3}, {jComboBox2}});
        JButton jButton = new JButton("Close");
        jButton.setName("Button Close");
        JButton jButton2 = new JButton("Copy text");
        jButton2.setName("Button Copy");
        JButton jButton3 = new JButton("Create bad Window");
        jButton3.setName("Button Bad Window");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NestedPopupMenu.this.exit(0);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextArea.setText(NestedPopupMenu.this.bufferedText);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final JWindow jWindow = new JWindow(window);
                JButton jButton = new JButton("Hide");
                jButton.setName("Button Hide");
                jWindow.getContentPane().add(jButton);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        jWindow.setVisible(false);
                    }
                });
                jWindow.pack();
                SwingUtil.centerWindow((Window)jWindow);
                jWindow.show();
            }
        });
        grid.addLine(new Component[]{jButton, jButton2, jButton3});
        grid.setName("grid");
        container.add((Component)grid, "Center");
        container.setName("Pane");
        jLabel.addMouseListener(new PopupListener());
        jLabel2.addMouseListener(new PopupListener());
        jLabel3.addMouseListener(new PopupListener());
        this.setupPopupMenu();
        this.finishWindow(window, 500, 300);
    }

    private void setupPopupMenu() {
        this.popup = new JPopupMenu();
        this.popup.setName("outer popup");
        JMenuItem jMenuItem = new JMenuItem("First item");
        jMenuItem.setName("First item");
        this.popup.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("CheckboxItem");
        jMenuItem.setName("CheckboxItem");
        this.popup.add(jMenuItem);
        this.popup.addSeparator();
        JMenu jMenu = new JMenu("Nested menu");
        jMenu.setName("Nested menu");
        jMenuItem = new JMenuItem("Nested1");
        jMenuItem.setName("Nested menu 1");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Nested2");
        jMenuItem.setName("Nested menu 2");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Nested3");
        jMenuItem.setName("Nested menu 3");
        jMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("NestedCheckboxItem");
        jMenuItem.setName("Nested CheckboxItem");
        jMenu.add(jMenuItem);
        this.popup.add(jMenu);
        this.popup.addSeparator();
        jMenuItem = new JMenuItem("Third item");
        jMenuItem.setName("Third item");
        this.popup.add(jMenuItem);
    }

    public class PopupListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (NestedPopupMenu.this.popup == null) {
                NestedPopupMenu.this.setupPopupMenu();
            }
            SwingUtil.showPopup((JPopupMenu)NestedPopupMenu.this.popup, (Component)((Component)mouseEvent.getSource()), (int)mouseEvent.getX(), (int)mouseEvent.getY(), (boolean)false);
        }
    }
}

