/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi;

import de.qfs.apps.qftest.demo.BaseDemo;
import de.qfs.lib.log.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class OptionPane
extends BaseDemo {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.multi.OptionPane");
    private Window window;
    private Container pane;
    public static final int WIDTH = 800;
    public static final int HEIGHT = 400;
    private ButtonPanel typePanel;
    private ButtonPanel messagePanel;
    private ButtonPanel messageTypePanel;
    private ButtonPanel optionTypePanel;
    private ButtonPanel optionsPanel;
    private ButtonPanel inputPanel;
    private ButtonPanel messageTextPanel;
    private ButtonPanel titlePanel;
    private String messageString = "Meldung";
    private Icon messageIcon = new ImageIcon("blue-ball.gif");
    private Object messageObject = new Date();
    private SamplePanel messageComponent = new SamplePanel();

    public OptionPane(boolean bl) {
        super(bl);
    }

    public static void main(String[] stringArray) {
        OptionPane optionPane = new OptionPane(false);
        BaseDemo.setupAndRun(stringArray, optionPane);
    }

    @Override
    protected void showFrameOrDialog() {
        if (OptionPane.logger.level >= 7) {
            logger.log(7, "showFrameOrDialog()", "");
        }
        if (this.asDialog) {
            this.dialog = new JDialog(new Frame(), "OptionPaneDemo [ Dialog ]", !this.isAsNonModal());
            this.window = this.dialog;
            this.pane = ((JDialog)this.dialog).getContentPane();
        } else {
            this.frame = new JFrame("OptionPaneDemo [ Frame ]");
            this.window = this.frame;
            this.pane = ((JFrame)this.frame).getContentPane();
        }
        this.window.setName("Option Pane Demo");
        this.makeOptionDialogFrame();
        this.finishWindow(this.window, 800, 400);
    }

    public void makeOptionDialogFrame() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 4));
        this.typePanel = new ButtonPanel("Typ", new String[]{"Meldung", "Bestaetigung", "Option", "Eingabe"});
        this.typePanel.setName("TypePanel");
        this.messageTypePanel = new ButtonPanel("Meldungstyp", new String[]{"ERROR_MESSAGE", "INFORMATION_MESSAGE", "WARNING_MESSAGE", "QUESTION_MESSAGE", "PLAIN_MESSAGE"});
        this.messageTypePanel.setName("MessageTypePanel");
        this.messagePanel = new ButtonPanel("Meldung", new String[]{"String", "Symbol", "Komponente", "Andere", "Object[]"});
        this.messagePanel.setName("MessagePanel");
        this.optionTypePanel = new ButtonPanel("Bestaetigung", new String[]{"DEFAULT_OPTION", "YES_NO_OPTION", "YES_NO_CANCEL_OPTION", "OK_CANCEL_OPTION"});
        this.optionTypePanel.setName("OptionTypePanel");
        this.optionsPanel = new ButtonPanel("Option", new String[]{"String[]", "Icon[]", "Object[]"});
        this.optionsPanel.setName("OptionsPanel");
        this.inputPanel = new ButtonPanel("Eingabe", new String[]{"Textfeld", "Kombinationsfeld"});
        this.inputPanel.setName("InputPanel");
        this.messageTextPanel = new ButtonPanel("Messagetext", new String[]{"Dies ist ein langer Text, \ndamit er in mehrere Labels \n umgebrochen wird", "Bla Bla", "Hello World"});
        this.messageTextPanel.setName("MessageTextPanel");
        this.titlePanel = new ButtonPanel("Titletext", new String[]{"Dies ist ein Titel", "Bla Bla", "Hello World"});
        this.titlePanel.setName("TitlePanel");
        jPanel.add(this.typePanel);
        jPanel.add(this.messageTypePanel);
        jPanel.add(this.messagePanel);
        jPanel.add(this.messageTextPanel);
        jPanel.add(this.optionTypePanel);
        jPanel.add(this.optionsPanel);
        jPanel.add(this.inputPanel);
        jPanel.add(this.titlePanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setName("ShowPanel");
        JButton jButton = new JButton("Anzeigen");
        jButton.setName("ShowButton");
        jButton.addActionListener(new ShowAction());
        jPanel2.add(jButton);
        this.pane.add((Component)jPanel, "Center");
        this.pane.add((Component)jPanel2, "South");
    }

    public Object getMessage() {
        String string = this.messagePanel.getSelection();
        if (string.equals("String")) {
            return this.getMessageString();
        }
        if (string.equals("Symbol")) {
            return this.messageIcon;
        }
        if (string.equals("Komponente")) {
            return this.messageComponent;
        }
        if (string.equals("Object[]")) {
            return new Object[]{this.messageString, this.messageIcon, this.messageComponent, this.messageObject};
        }
        if (string.equals("Andere")) {
            return this.messageObject;
        }
        return null;
    }

    public String getTitleText() {
        return this.titlePanel.getSelection();
    }

    public Object getMessageString() {
        String string = this.messageTextPanel.getSelection();
        return string;
    }

    public Object[] getOptions() {
        String string = this.optionsPanel.getSelection();
        if (string.equals("String[]")) {
            return new String[]{"Gelb", "Blau", "Rot"};
        }
        if (string.equals("Icon[]")) {
            return new Icon[]{new ImageIcon("yellow-ball.gif"), new ImageIcon("blue-ball.gif"), new ImageIcon("red-ball.gif")};
        }
        if (string.equals("Object[]")) {
            return new Object[]{this.messageString, this.messageIcon, this.messageComponent, this.messageObject};
        }
        return null;
    }

    public int getType(ButtonPanel buttonPanel) {
        String string = buttonPanel.getSelection();
        try {
            return JOptionPane.class.getField(string).getInt(null);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    class ButtonPanel
    extends JPanel {
        private ButtonGroup group;

        public ButtonPanel(String string, String[] stringArray) {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string));
            this.setLayout(new BoxLayout(this, 1));
            this.setName("ButtonPanel");
            this.group = new ButtonGroup();
            String string2 = new String();
            for (int i = 0; i < stringArray.length; ++i) {
                JRadioButton jRadioButton = new JRadioButton(stringArray[i]);
                jRadioButton.setActionCommand(stringArray[i]);
                string2 = stringArray[i].replace(' ', '_');
                if (string2.length() > 20) {
                    string2 = string2.substring(0, 19);
                }
                jRadioButton.setName("rb" + string + string2);
                this.add(jRadioButton);
                this.group.add(jRadioButton);
                jRadioButton.setSelected(i == 0);
            }
        }

        public String getSelection() {
            return this.group.getSelection().getActionCommand();
        }
    }

    class SamplePanel
    extends JPanel {
        SamplePanel() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(Color.yellow);
            graphics.fill3DRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, true);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(10, 10);
        }
    }

    private class ShowAction
    implements ActionListener {
        private ShowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (OptionPane.this.typePanel.getSelection().equals("Bestaetigung")) {
                JOptionPane.showConfirmDialog(OptionPane.this.window, OptionPane.this.getMessage(), OptionPane.this.getTitleText(), OptionPane.this.getType(OptionPane.this.optionTypePanel), OptionPane.this.getType(OptionPane.this.messageTypePanel));
            } else if (OptionPane.this.typePanel.getSelection().equals("Eingabe")) {
                if (OptionPane.this.inputPanel.getSelection().equals("Textfeld")) {
                    JOptionPane.showInputDialog(OptionPane.this.window, OptionPane.this.getMessage(), OptionPane.this.getTitleText(), OptionPane.this.getType(OptionPane.this.messageTypePanel));
                } else {
                    JOptionPane.showInputDialog(OptionPane.this.window, OptionPane.this.getMessage(), OptionPane.this.getTitleText(), OptionPane.this.getType(OptionPane.this.messageTypePanel), null, new String[]{"Gelb", "Blau", "Rot"}, "Blau");
                }
            } else if (OptionPane.this.typePanel.getSelection().equals("Meldung")) {
                JOptionPane.showMessageDialog(OptionPane.this.window, OptionPane.this.getMessage(), OptionPane.this.getTitleText(), OptionPane.this.getType(OptionPane.this.messageTypePanel));
            } else if (OptionPane.this.typePanel.getSelection().equals("Option")) {
                JOptionPane.showOptionDialog(OptionPane.this.window, OptionPane.this.getMessage(), OptionPane.this.getTitleText(), OptionPane.this.getType(OptionPane.this.optionTypePanel), OptionPane.this.getType(OptionPane.this.messageTypePanel), null, OptionPane.this.getOptions(), OptionPane.this.getOptions()[0]);
            }
        }
    }
}

