/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi;

import de.qfs.apps.qftest.demo.BaseDemo;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.log.Logger;
import de.qfs.lib.util.Reflector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class ScrolledTabs
extends BaseDemo {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.multi.ScrolledTabs");
    private static Frame pFrame;

    public ScrolledTabs(boolean bl) {
        super(bl);
    }

    public static void main(String[] stringArray) {
        ScrolledTabs scrolledTabs = new ScrolledTabs(false);
        BaseDemo.setupAndRun(stringArray, scrolledTabs);
    }

    @Override
    protected void showFrameOrDialog() {
        Container container;
        Window window;
        JDialog jDialog;
        if (ScrolledTabs.logger.level >= 7) {
            logger.log(7, "showFrameOrDialog()", "");
        }
        if (this.asDialog) {
            jDialog = new JDialog(new JFrame(), "ScrolledTabs [dialog]", true);
            window = jDialog;
            container = jDialog.getContentPane();
        } else {
            this.frame = new JFrame("ScrolledTabs [ Frame ]");
            window = this.frame;
            container = ((JFrame)this.frame).getContentPane();
        }
        window.setName("ScrolledTabs");
        jDialog = new Grid();
        jDialog.setName("grid");
        final JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setName("Tabs");
        Reflector.safeCall((Object)jTabbedPane, (String)"setTabLayoutPolicy", Integer.TYPE, (Object)Reflector.safeGet(JTabbedPane.class, (String)"SCROLL_TAB_LAYOUT"));
        for (int i = 0; i < 10; ++i) {
            Grid grid = new Grid();
            if (i % 2 == 0) {
                grid.setName("gridForTab" + i);
            }
            JButton jButton = new JButton("Button on tab" + i);
            jButton.setToolTipText("Placed on tab" + i);
            if (i % 3 == 0) {
                jButton.setName("buttonForTab" + i);
            }
            grid.addLine(new Component[]{jButton});
            jTabbedPane.addTab("tab" + i, (Component)grid);
            jTabbedPane.setToolTipTextAt(i, "This is tab nr. " + i);
        }
        jTabbedPane.setToolTipText("This is the whole JTabbedPane");
        final JCheckBox jCheckBox = new JCheckBox("Scroll tabs");
        jCheckBox.setSelected(true);
        jCheckBox.setName("checkScroll");
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Reflector.safeCall((Object)jTabbedPane, (String)"setTabLayoutPolicy", Integer.TYPE, (Object)Reflector.safeGet(JTabbedPane.class, (String)(jCheckBox.isSelected() ? "SCROLL_TAB_LAYOUT" : "WRAP_TAB_LAYOUT")));
            }
        });
        jDialog.add(jCheckBox, 0.0);
        jDialog.add(jTabbedPane, 1.0);
        container.add(jDialog);
        this.finishWindow(window, 300, 200);
    }
}

