/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.chat.component;

import de.qfs.apps.qftest.demo.multi.carconfigurator.ai.Assistant;
import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.component.ChatArea;
import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.component.ChatBox;
import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.model.ModelMessage;
import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.swing.Background;
import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.swing.ChatEvent;
import de.qfs.lib.util.MapResourceBundle;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ChatFrame
extends JFrame {
    private ChatArea chatArea;
    final Assistant assistant;
    final MapResourceBundle rb;

    public ChatFrame(final Assistant assistant, MapResourceBundle mapResourceBundle) {
        this.assistant = assistant;
        this.rb = mapResourceBundle;
        this.initComponents();
        this.setTitle(mapResourceBundle.getString("dialog.CarConfig.chat.title", ""));
        this.chatArea.setName("chatArea");
        this.chatArea.addChatEvent(new ChatEvent(){

            @Override
            public void mousePressedSendButton(ActionEvent actionEvent) {
                String string = ChatFrame.this.chatArea.getText().trim();
                if ("".equals(string)) {
                    return;
                }
                ChatFrame.this.addChatMessage(string, true);
                ChatFrame.this.chatArea.clearTextAndGrabFocus();
                if (assistant != null) {
                    assistant.input(string);
                }
            }
        });
        if (assistant != null) {
            assistant.setCallback(string -> SwingUtilities.invokeLater(() -> this.addChatMessage((String)string, false)));
        }
    }

    private void addChatMessage(String string, boolean bl) {
        ChatBox.BoxType boxType;
        Icon icon;
        String string2;
        if (bl) {
            string2 = this.rb.getString("dialog.CarConfig.chat.username");
            icon = this.rb.getIcon("icon.CarConfig.chat.user", null);
            boxType = ChatBox.BoxType.RIGHT;
        } else {
            string2 = this.rb.getString("dialog.CarConfig.chat.robotname");
            icon = this.rb.getIcon("icon.CarConfig.chat.robot", null);
            boxType = ChatBox.BoxType.LEFT;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.rb.getString("dialog.CarConfig.chat.dateformat"));
        String string3 = simpleDateFormat.format(new Date());
        this.chatArea.addChatBox(new ModelMessage(icon, string2, string3, string), boxType);
    }

    private void initComponents() {
        Background background = new Background();
        this.chatArea = new ChatArea(this.rb);
        GroupLayout groupLayout = new GroupLayout(background);
        background.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.chatArea, -1, 438, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.chatArea, -1, 707, Short.MAX_VALUE).addContainerGap()));
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(background, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(background, -1, -1, Short.MAX_VALUE));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void reset() {
        this.chatArea.clearChatBox();
        if (this.assistant != null) {
            this.assistant.greet();
        }
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ChatFrame(null, new MapResourceBundle()).setVisible(true);
            }
        });
    }
}

