/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.chat.swing;

import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class AutoWrapText
extends StyledEditorKit {
    @Override
    public ViewFactory getViewFactory() {
        return new WrapColumnFactory();
    }

    private class WrapLabelView
    extends LabelView {
        public WrapLabelView(Element element) {
            super(element);
        }

        @Override
        public float getMinimumSpan(int n) {
            switch (n) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(n);
                }
            }
            throw new IllegalArgumentException("Invalid Axis:" + n);
        }
    }

    private class WrapColumnFactory
    implements ViewFactory {
        private WrapColumnFactory() {
        }

        @Override
        public View create(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new WrapLabelView(element);
                }
                if (string.equals("paragraph")) {
                    return new ParagraphView(element);
                }
                if (string.equals("section")) {
                    return new BoxView(element, 1);
                }
                if (string.equals("component")) {
                    return new ComponentView(element);
                }
                if (string.equals("icon")) {
                    return new IconView(element);
                }
            }
            return new LabelView(element);
        }
    }
}

