/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.controller;

import de.qfs.apps.qftest.demo.multi.carconfigurator.ai.Assistant;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCAssistant;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.lib.util.Misc;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;

public abstract class CCController {
    protected CCModel ccmodel;
    private CCModel.CCSpecial selectedSpecial;
    private final AtomicReference assistant = new AtomicReference();

    private static CCAssistant createAssistant() {
        return new CCAssistant(CCModel.getRb());
    }

    public void setSelectedSpecial(CCModel.CCSpecial cCSpecial) {
        this.specialsSelectionChanged(cCSpecial);
    }

    public void addModel(CCModel cCModel) {
        this.ccmodel = cCModel;
    }

    public void start() {
        this.initializeListeners();
        this.startView();
    }

    protected abstract void startView();

    public void initializeListeners() {
        this.ccmodel.m_basepriceProperty().addObserver((observable, object) -> this.basePriceChanged((Double)object));
        this.ccmodel.m_discountProperty().addObserver((observable, object) -> this.discountValueChanged((Integer)object));
        this.ccmodel.m_specialpriceProperty().addObserver((observable, object) -> this.specialPriceChanged((Double)object));
        this.ccmodel.takeAccessoryPriceIntoAccountProperty().addObserver((observable, object) -> this.accessoryPriceAddedChanged((Boolean)object));
    }

    public abstract void accessoryPriceAddedChanged(Boolean var1);

    public abstract void specialPriceChanged(double var1);

    public abstract void discountValueChanged(int var1);

    public abstract void basePriceChanged(double var1);

    public boolean isStandardUser() {
        return "tester".equals(this.ccmodel.getM_params().getUser());
    }

    public String getMainWindowTitle() {
        return "CarConfigurator Swing";
    }

    public void buggyStateChanged(boolean bl) {
        this.ccmodel.getM_params().setBuggy(bl);
    }

    public void takeAccessoryPriceIntoAccountStateChanged(boolean bl) {
        this.ccmodel.setTakeAccessoryPriceIntoAccount(bl);
    }

    public void loadtestStateChanged(boolean bl) {
        this.ccmodel.getM_params().setLoadtest(bl);
    }

    public void updateCalculatedPrice() {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        if (this.ccmodel.isTakeAccessoryPriceIntoAccount()) {
            for (CCModel.CCAccessory cCAccessory : this.ccmodel.getAccessoryCellsBase().values()) {
                Boolean bl = cCAccessory.getSelected();
                if (!bl.booleanValue()) continue;
                ++n;
                String string = cCAccessory.getAccessoryID();
                int n3 = this.findDoubles(string, this.ccmodel.getSpecial_accessories());
                if (n3 > 0) {
                    n2 += n3;
                    continue;
                }
                Double d2 = cCAccessory.getPrice();
                d += d2.doubleValue();
            }
        }
        double d3 = this.ccmodel.getM_params().isBuggy() ? this.calculatePriceBuggy(this.ccmodel.getM_baseprice(), this.ccmodel.getM_specialprice(), d, n, n2, this.ccmodel.getM_discount()) : this.calculatePriceOk(this.ccmodel.getM_baseprice(), this.ccmodel.getM_specialprice(), d, n, n2, this.ccmodel.getM_discount());
        this.updateAfterCalculation(d3, d);
    }

    public abstract void updateAfterCalculation(double var1, double var3);

    public void resetAll() {
        this.changeDiscount(0);
        this.changeBasePrice(0.0);
        this.changeSpecialPrice(0.0);
        this.ccmodel.initTableData();
        this.resetAllView();
    }

    public abstract void resetAllView();

    public double calculatePriceBuggy(double d, double d2, double d3, int n, int n2, double d4) {
        d4 = d4 > 10.0 ? 10.0 : d4;
        double d5 = (d + d2 + d3) / 100.0 * (100.0 - d4);
        return d5;
    }

    public double calculatePriceOk(double d, double d2, double d3, int n, int n2, double d4) {
        if (this.ccmodel.getM_params().isBuggy() && d >= 29000.0) {
            d = 0.0;
        }
        double d5 = (d + d2 + d3) / 100.0 * (100.0 - d4);
        return d5;
    }

    public abstract void logout();

    public void sleepForLoadtesting() {
        if (this.ccmodel.getM_params().isLoadtest()) {
            Random random = new Random();
            int n = random.nextInt(CCModel.getLOADTEST_WAITTIME());
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int findDoubles(String string, Set set) {
        if (this.ccmodel.getM_params().isBuggy()) {
            return 0;
        }
        String string2 = String.join((CharSequence)" ", set);
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string3 = stringTokenizer.nextToken();
                if (!string3.equals(string)) continue;
                ++n;
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        return n;
    }

    public boolean checkDiscount(String string) {
        try {
            Number number = this.ccmodel.getM_numberFormatter().parse(string.trim());
            this.changeDiscount(number.intValue());
        }
        catch (ParseException parseException) {
            return false;
        }
        if (this.ccmodel.getM_discount() < 0) {
            this.changeDiscount(0);
            return false;
        }
        if (!this.ccmodel.getM_params().isBuggy() && this.ccmodel.getM_discount() > 100) {
            this.changeDiscount(100);
        }
        return true;
    }

    public void checkDiscountShowError(String string) {
        if (!this.checkDiscount(string)) {
            String string2 = CCModel.getRb().getString("error.discount.invalid");
            this.showDiscountError(string2);
            this.changeDiscount(0);
        } else if (this.ccmodel.getM_discount() == 100) {
            String string3 = CCModel.getRb().getString("error.discount.hundred");
            this.showDiscountError(string3);
            this.changeDiscount(0);
        }
    }

    public abstract void showDiscountError(String var1);

    public void increaseDiscount(String string) {
        int n = 5;
        if (this.ccmodel.getM_params().isBuggy()) {
            n = 3;
        }
        try {
            Number number = this.ccmodel.getM_numberFormatter().parse(string);
            this.changeDiscount(number.intValue());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (this.ccmodel.getM_discount() < 0) {
            this.changeDiscount(0);
        }
        this.changeDiscount(this.ccmodel.getM_discount() + n);
        if (this.ccmodel.getM_discount() > 99) {
            this.changeDiscount(99);
        }
        this.updateCalculatedPrice();
    }

    public void changeBasePrice(double d) {
        this.ccmodel.setM_baseprice(d);
    }

    public void changeDiscount(int n) {
        this.ccmodel.setM_discount(n);
    }

    public void changeSpecialPrice(double d) {
        this.ccmodel.setM_specialprice(d);
    }

    public void changeUser(String string) {
        this.ccmodel.getM_params().setUser(string);
    }

    public void vehicleTableSelectionChanged(boolean bl, int n, boolean bl2) {
        if (bl) {
            this.changeBasePrice(0.0);
        } else if (this.ccmodel.getM_params().isBuggy() && bl2) {
            this.changeBasePrice(0.0);
        } else {
            Double d = ((CCModel.CCVehicle)this.ccmodel.getVehicleCellsBase().get((Object)n)).getPrice();
            this.changeBasePrice(d);
        }
        this.updateCalculatedPrice();
    }

    public void specialsSelectionChanged(CCModel.CCSpecial cCSpecial) {
        Double d = cCSpecial.getPrice();
        this.changeSpecialPrice(d);
        this.ccmodel.setSpecial_accessories(cCSpecial.getAccessories());
        this.updateSelectionAccessories();
        this.updateCalculatedPrice();
    }

    private void updateSelectionAccessories() {
        Object object;
        Object object2;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Object object3 : this.ccmodel.getAccessoryCellsBase().values()) {
            object2 = ((CCModel.CCAccessory)object3).getKey();
            object = ((CCModel.CCAccessory)object3).getAccessoryID();
            hashMap.put((String)object, (Integer)object2);
            this.changeAccessorySelectionStatus((Integer)object2, false);
        }
        Set set = this.ccmodel.getSpecial_accessories();
        if (!set.isEmpty()) {
            Object object3;
            object3 = set.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                if (!hashMap.containsKey(object2)) continue;
                object = (Integer)hashMap.get(object2);
                this.changeAccessorySelectionStatus((Integer)object, true);
            }
        }
    }

    public void changeAccessorySelectionStatus(int n) {
        CCModel.CCAccessory cCAccessory = (CCModel.CCAccessory)this.ccmodel.getAccessoryCellsBase().get((Object)n);
        CCModel.CCAccessory cCAccessory2 = CCModel.CCAccessory.builder().key(n).selected(cCAccessory.getSelected() == false).name(cCAccessory.getName()).price(cCAccessory.getPrice()).accessoryID(cCAccessory.getAccessoryID()).build();
        this.ccmodel.getAccessoryCellsBase().put((Object)n, (Object)cCAccessory2);
    }

    public void changeAccessorySelectionStatus(int n, boolean bl) {
        CCModel.CCAccessory cCAccessory = (CCModel.CCAccessory)this.ccmodel.getAccessoryCellsBase().get((Object)n);
        if (bl != cCAccessory.getSelected()) {
            CCModel.CCAccessory cCAccessory2 = CCModel.CCAccessory.builder().key(n).selected(bl).name(cCAccessory.getName()).price(cCAccessory.getPrice()).accessoryID(cCAccessory.getAccessoryID()).build();
            this.ccmodel.getAccessoryCellsBase().put((Object)n, (Object)cCAccessory2);
        }
    }

    public void calcPanelUpdate(String string) {
        if (this.checkDiscount(string)) {
            this.updateCalculatedPrice();
        }
    }

    public void vehiclesDialogNewAction(Double d, String string, String string2) {
        this.sleepForLoadtesting();
        if (d <= 0.0) {
            return;
        }
        int n = CCModel.getNextUniqueId();
        CCModel.CCVehicle cCVehicle = CCModel.CCVehicle.builder().key(n).name(string2).m_id(string).price(d).build();
        this.ccmodel.getVehicleCellsDialog().put((Object)n, (Object)cCVehicle);
    }

    public void vehiclesDialogChangeAction(int n, Double d, String string, String string2) {
        this.sleepForLoadtesting();
        if (d <= 0.0) {
            return;
        }
        if (this.ccmodel.getVehicleCellsDialog().containsKey((Object)n)) {
            CCModel.CCVehicle cCVehicle = CCModel.CCVehicle.builder().key(n).m_id(string).name(string2).price(d).build();
            this.ccmodel.getVehicleCellsDialog().put((Object)n, (Object)cCVehicle);
        }
    }

    public void vehiclesDialogDeleteAction(int n) {
        this.sleepForLoadtesting();
        if (this.ccmodel.getVehicleCellsDialog().containsKey((Object)n)) {
            this.ccmodel.getVehicleCellsDialog().remove((Object)n);
        }
    }

    public void vehiclesDialogConfirmAction() {
        this.ccmodel.getVehicleCellsBase().clear();
        this.ccmodel.getVehicleCellsBase().putAll((Map)this.ccmodel.getVehicleCellsDialog());
        this.sleepForLoadtesting();
    }

    public void vehiclesDialogCancelAction() {
        this.ccmodel.getVehicleCellsDialog().clear();
        this.ccmodel.getVehicleCellsDialog().putAll((Map)this.ccmodel.getVehicleCellsBase());
    }

    public void specialsDialogNewAction(String string, String string2, Double d, String string3) {
        if (d <= 0.0) {
            return;
        }
        this.sleepForLoadtesting();
        if (this.ccmodel.getM_params().isBuggy()) {
            try {
                Thread.sleep(122000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int n = CCModel.getNextUniqueId();
        CCModel.CCSpecial cCSpecial = CCModel.CCSpecial.builder().key(n).name(string).description(string2).price(d).accessories(Misc.setOf((Object[])Misc.fastSplit((String)string3, (char)' '))).build();
        this.ccmodel.getSpecialsCellsDialog().put((Object)n, (Object)cCSpecial);
    }

    public void specialsDialogChangedAction(String string, String string2, Double d, String string3, int n) {
        if (d <= 0.0) {
            return;
        }
        this.sleepForLoadtesting();
        CCModel.CCSpecial cCSpecial = CCModel.CCSpecial.builder().key(n).name(string).description(string2).price(d).accessories(Misc.setOf((Object[])Misc.fastSplit((String)string3, (char)' '))).build();
        this.ccmodel.getSpecialsCellsDialog().put((Object)n, (Object)cCSpecial);
    }

    public void specialsDialogDeleteAction(int n) {
        this.sleepForLoadtesting();
        if (n >= 0) {
            if (((CCModel.CCSpecial)this.ccmodel.getSpecialsCellsDialog().get((Object)n)).getPrice() == 0.0) {
                return;
            }
            this.ccmodel.getSpecialsCellsDialog().remove((Object)n);
        }
    }

    public void specialsDialogConfirmAction() {
        if (this.ccmodel.getM_params().isBuggy()) {
            throw new ArrayIndexOutOfBoundsException(1);
        }
        this.ccmodel.getSpecialsCellsBase().clear();
        this.ccmodel.getSpecialsCellsBase().putAll((Map)this.ccmodel.getSpecialsCellsDialog());
        this.sleepForLoadtesting();
    }

    public void specialsDialogCancelAction() {
        this.ccmodel.getSpecialsCellsDialog().clear();
        this.ccmodel.getSpecialsCellsDialog().putAll((Map)this.ccmodel.getSpecialsCellsBase());
    }

    public void accessoryDialogNewAction(Double d, String string, String string2) {
        this.sleepForLoadtesting();
        int n = CCModel.getNextUniqueId();
        CCModel.CCAccessory cCAccessory = CCModel.CCAccessory.builder().key(n).selected(false).name(string).price(d).accessoryID(string2).build();
        this.ccmodel.getAccessoryCellsDialog().put((Object)n, (Object)cCAccessory);
    }

    public void accessoryDialogChangeAction(int n, String string, String string2, Double d) {
        this.sleepForLoadtesting();
        CCModel.CCAccessory cCAccessory = CCModel.CCAccessory.builder().key(n).selected(false).name(string).price(d).accessoryID(string2).build();
        this.ccmodel.getAccessoryCellsDialog().put((Object)n, (Object)cCAccessory);
    }

    public void accessoryDialogDeleteAction(int n) {
        this.sleepForLoadtesting();
        this.ccmodel.getAccessoryCellsDialog().remove((Object)n);
    }

    public void accessoryDialogConfirmAction() {
        this.ccmodel.getAccessoryCellsBase().clear();
        this.ccmodel.getAccessoryCellsBase().putAll((Map)this.ccmodel.getAccessoryCellsDialog());
        this.updateSelectionAccessories();
    }

    public void accessoryDialogCancelAction() {
        this.ccmodel.getAccessoryCellsDialog().clear();
        this.ccmodel.getAccessoryCellsDialog().putAll((Map)this.ccmodel.getAccessoryCellsBase());
        this.sleepForLoadtesting();
    }

    public abstract void exit(int var1);

    public abstract void showSplash();

    public CCModel getCcmodel() {
        return this.ccmodel;
    }

    public CCModel.CCSpecial getSelectedSpecial() {
        return this.selectedSpecial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Assistant getAssistant() {
        Object object = this.assistant.get();
        if (object == null) {
            AtomicReference atomicReference = this.assistant;
            synchronized (atomicReference) {
                object = this.assistant.get();
                if (object == null) {
                    CCAssistant cCAssistant = CCController.createAssistant();
                    object = cCAssistant == null ? this.assistant : cCAssistant;
                    this.assistant.set(object);
                }
            }
        }
        return object == this.assistant ? null : object;
    }
}

