/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.model;

import de.qfs.apps.qftest.demo.multi.carconfigurator.ai.Assistant;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CCAssistant
implements Assistant {
    Consumer callback;
    final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    final Random rand = new Random();
    final MapResourceBundle rb;
    final Map patterns = new HashMap();

    public CCAssistant(MapResourceBundle mapResourceBundle) {
        this.rb = mapResourceBundle;
        this.initPatterns();
    }

    private void initPatterns() {
        Enumeration enumeration = this.rb.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("chat.responses.") || !string.endsWith(".pattern")) continue;
            String string2 = string.substring(0, string.length() - 8);
            this.patterns.put(Pattern.compile(this.rb.getString(string, "")), string2);
        }
    }

    @Override
    public void setCallback(Consumer consumer) {
        this.callback = consumer;
    }

    protected void output(String string) {
        this.output(string, 0);
    }

    protected void output(String string, int n) {
        if (this.callback != null && !Misc.emptyOrNull((String)string)) {
            this.scheduledExecutorService.schedule(() -> this.callback.accept(string), (long)(250 + n + Math.min(500, this.rand.nextInt(string.length() * 10))), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void greet() {
        this.output(this.getResponse("chat.responses.greeting"));
        this.output(this.getResponse("chat.responses.greeting-help"), 500);
    }

    private String getResponse(String string) {
        String[] stringArray = Misc.fastSplit((String)this.rb.getString(string, string), (char)'|');
        return stringArray[this.rand.nextInt(stringArray.length)].trim();
    }

    @Override
    public void input(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getResponse("chat.responses.intro"));
        stringBuilder.append("\n");
        stringBuilder.append(this.getResponseForInput(string));
        stringBuilder.append("\n");
        stringBuilder.append(this.getResponse("chat.responses.extro"));
        this.output(stringBuilder.toString());
    }

    private String getResponseForInput(String string) {
        for (Pattern pattern : this.patterns.keySet()) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            Object[] objectArray = new Object[matcher.groupCount()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = matcher.group(i + 1);
            }
            String string2 = this.getResponse((String)this.patterns.get(pattern));
            return new MessageFormat(string2).format(objectArray);
        }
        return this.getResponse("chat.responses.unknown");
    }
}

