/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCData;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;

public class AccessoryDialogTablePane
extends BorderPane {
    CCControllerFX cccontroller;
    CCModel ccmodel;
    private TableView accessoriesTablePanelTableView;
    private TextField accessoryNameTextField;
    private TextField accessoryIdTextField;
    private TextField accessoryPriceTextField;

    public AccessoryDialogTablePane(CCControllerFX cCControllerFX) {
        this.cccontroller = cCControllerFX;
        this.ccmodel = cCControllerFX.getCcmodel();
        this.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        GridPane gridPane = new GridPane();
        if (!this.ccmodel.getM_params().isCleanname()) {
            gridPane.setId(CCModel.getRb().getString("panel.accessories.table.id"));
        } else {
            gridPane.setId(CCModel.getRb().getString("dialog.accessories.table.id"));
        }
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(100.0);
        columnConstraints.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        gridPane.setHgap(3.0);
        gridPane.setVgap(3.0);
        gridPane.setPrefWidth(300.0);
        gridPane.setPrefHeight(100.0);
        Label label = new Label(CCModel.getRb().getString("dialog.accessories.name"));
        label.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label, 0, 1);
        this.accessoriesTablePanelTableView = new TableView();
        this.accessoriesTablePanelTableView.setId("AccessoriesTable");
        this.accessoriesTablePanelTableView.setMaxHeight(Double.MAX_VALUE);
        this.accessoriesTablePanelTableView.setMaxWidth(Double.MAX_VALUE);
        this.accessoriesTablePanelTableView.setEditable(false);
        this.accessoriesTablePanelTableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.accessoriesTablePanelTableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.accessoriesTablePanelTableView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new OnAccessoryTableColumnClickEventHandler());
        gridPane.add((Node)this.accessoriesTablePanelTableView, 0, 2);
        GridPane gridPane2 = new GridPane();
        gridPane2.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setMaxWidth(Double.NEGATIVE_INFINITY);
        columnConstraints2.setHgrow(Priority.SOMETIMES);
        ColumnConstraints columnConstraints3 = new ColumnConstraints();
        columnConstraints3.setMaxWidth(Double.MAX_VALUE);
        columnConstraints3.setHgrow(Priority.SOMETIMES);
        ColumnConstraints columnConstraints4 = new ColumnConstraints();
        columnConstraints4.setMaxWidth(Double.NEGATIVE_INFINITY);
        columnConstraints4.setHgrow(Priority.SOMETIMES);
        ColumnConstraints columnConstraints5 = new ColumnConstraints();
        columnConstraints5.setMaxWidth(Double.NEGATIVE_INFINITY);
        columnConstraints5.setHgrow(Priority.SOMETIMES);
        gridPane2.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints2, columnConstraints3, columnConstraints4, columnConstraints5});
        gridPane2.setHgap(3.0);
        gridPane2.setId(CCModel.getRb().getString("dialog.accessories.editpanel.id"));
        Label label2 = new Label(CCModel.getRb().getString("dialog.accessories.edit.name"));
        label2.setStyle("-fx-text-fill: blue;");
        gridPane2.add((Node)label2, 0, 0);
        this.accessoryNameTextField = new TextField("");
        this.accessoryNameTextField.setMaxWidth(400.0);
        this.accessoryNameTextField.setId(CCModel.getRb().getString("dialog.accessories.name.id"));
        gridPane2.add((Node)this.accessoryNameTextField, 0, 1);
        Label label3 = new Label(CCModel.getRb().getString("dialog.accessories.edit.id"));
        label3.setStyle("-fx-text-fill: blue;");
        gridPane2.add((Node)label3, 2, 0);
        this.accessoryIdTextField = new TextField("");
        this.accessoryIdTextField.setMaxWidth(45.0);
        this.accessoryIdTextField.setId(CCModel.getRb().getString("dialog.accessories.id.id"));
        gridPane2.add((Node)this.accessoryIdTextField, 2, 1);
        Label label4 = new Label(CCModel.getRb().getString("dialog.accessories.edit.price"));
        label4.setStyle("-fx-text-fill: blue;");
        gridPane2.add((Node)label4, 3, 0);
        this.accessoryPriceTextField = new TextField("");
        this.accessoryPriceTextField.setMaxWidth(100.0);
        this.accessoryPriceTextField.setId(CCModel.getRb().getString("dialog.accessories.newprice.id"));
        gridPane2.add((Node)this.accessoryPriceTextField, 3, 1);
        this.setCenter((Node)gridPane);
        this.setBottom((Node)gridPane2);
        this.updateAccessoryViewTable();
    }

    public String getAccessoryName() {
        return this.accessoryNameTextField.getText();
    }

    public void setAccessoryName(String string) {
        this.accessoryNameTextField.setText(string);
    }

    public String getAccessoryID() {
        return this.accessoryIdTextField.getText().replaceAll("\\s", "");
    }

    public void setAccessoryID(String string) {
        this.accessoryIdTextField.setText(string);
    }

    public Double getAccessoryPrice() {
        Double d;
        try {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumFractionDigits(2);
            String string = this.accessoryPriceTextField.getText().trim();
            d = numberFormat.parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            d = 0.0;
        }
        return d;
    }

    public void setAccessoryPrice(Double d) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(2);
        this.accessoryPriceTextField.setText(numberFormat.format(d));
    }

    public void reset() {
        this.accessoryNameTextField.setText("");
        this.accessoryIdTextField.setText("");
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(2);
        this.accessoryPriceTextField.setText(numberFormat.format(0.0));
    }

    public void updateAccessoryViewTable() {
        TableColumn tableColumn = new TableColumn();
        TableColumn tableColumn2 = new TableColumn();
        TableColumn tableColumn3 = new TableColumn();
        tableColumn.setMaxWidth(1.5032385536E11);
        tableColumn2.setMaxWidth(1.9327352832E10);
        tableColumn3.setMaxWidth(4.5097156608E10);
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        tableColumn2.setCellValueFactory((Callback)new PropertyValueFactory("accessoryID"));
        tableColumn3.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        tableColumn2.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(String string, boolean bl) {
                        super.updateItem((Object)string, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER;");
                return tableCell;
            }
        });
        tableColumn3.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(Double d, boolean bl) {
                        super.updateItem((Object)d, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : AccessoryDialogTablePane.this.ccmodel.getM_currencyFormatter().format(this.getItem());
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER-RIGHT;");
                return tableCell;
            }
        });
        if (this.ccmodel.getM_language() == CCModel.getGERMAN()) {
            tableColumn.setText("Beschreibung");
            tableColumn2.setText("ID");
            tableColumn3.setText("Preis");
        } else {
            tableColumn.setText("Description");
            tableColumn2.setText("ID");
            tableColumn3.setText("Price");
        }
        this.accessoriesTablePanelTableView.getColumns().setAll((Object[])new TableColumn[]{tableColumn, tableColumn2, tableColumn3});
        ObservableList observableList = FXCollections.observableArrayList();
        for (Integer n : this.ccmodel.getAccessoryCellsDialog().keySet()) {
            observableList.add(this.ccmodel.getAccessoryCellsDialog().get((Object)n));
        }
        Collections.sort(observableList, new Comparator(){

            public int compare(CCData cCData, CCData cCData2) {
                return cCData.getKeyForSort().compareTo(cCData2.getKeyForSort());
            }
        });
        this.accessoriesTablePanelTableView.setItems(observableList);
    }

    public TableView getAccessoriesTablePanelTableView() {
        return this.accessoriesTablePanelTableView;
    }

    public class OnAccessoryTableColumnClickEventHandler
    implements ChangeListener {
        public void changed(ObservableValue observableValue, CCModel.CCAccessory cCAccessory, CCModel.CCAccessory cCAccessory2) {
            if (AccessoryDialogTablePane.this.ccmodel.getM_params().isBuggy() && AccessoryDialogTablePane.this.accessoriesTablePanelTableView.getSelectionModel().getSelectedIndex() == AccessoryDialogTablePane.this.accessoriesTablePanelTableView.getItems().size() - 1) {
                AccessoryDialogTablePane.this.setAccessoryName("");
                AccessoryDialogTablePane.this.setAccessoryID("");
                AccessoryDialogTablePane.this.setAccessoryPrice(0.0);
                return;
            }
            if (!AccessoryDialogTablePane.this.accessoriesTablePanelTableView.getSelectionModel().isEmpty()) {
                CCModel.CCAccessory cCAccessory3 = (CCModel.CCAccessory)AccessoryDialogTablePane.this.accessoriesTablePanelTableView.getSelectionModel().getSelectedItem();
                AccessoryDialogTablePane.this.setAccessoryName(cCAccessory3.getName());
                AccessoryDialogTablePane.this.setAccessoryID(cCAccessory3.getAccessoryID());
                AccessoryDialogTablePane.this.setAccessoryPrice(cCAccessory3.getPrice());
            }
        }
    }
}

