/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCData;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.CCViewFX;
import java.util.Collections;
import java.util.Comparator;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;

public class AccessoryPane
extends GridPane {
    CCModel ccmodel = CCModel.getInstance();
    CCViewFX ccview;
    CCControllerFX cccontroller;
    private TableView accessoryView;
    ObservableList tableEntries = FXCollections.observableArrayList();
    public CheckBox accessoryChkBox;

    public AccessoryPane(CCControllerFX cCControllerFX) {
        this.cccontroller = cCControllerFX;
        this.ccview = CCViewFX.getInstance(cCControllerFX);
        this.setPadding(new Insets(7.0, 7.0, 7.0, 7.0));
        this.setHgap(5.0);
        this.setVgap(5.0);
        this.setPrefHeight(Double.MAX_VALUE);
        this.setMaxHeight(Double.MAX_VALUE);
        this.setId(CCModel.getRb().getString("panel.accessories.table.id"));
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(100.0);
        columnConstraints.setHgrow(Priority.ALWAYS);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        Label label = new Label(CCModel.getRb().getString("panel.accessories.name"));
        label.setStyle("-fx-text-fill: blue;");
        this.add((Node)label, 0, 0);
        this.accessoryView = new TableView();
        this.accessoryView.setId("AccessoryTable");
        this.accessoryView.setEditable(false);
        this.accessoryView.getSelectionModel().setCellSelectionEnabled(false);
        this.accessoryView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.add((Node)this.accessoryView, 0, 1);
        this.ccmodel.getAccessoryCellsBase().addObserver((observable, object) -> this.updateEntries());
        this.accessoryChkBox = new CheckBox(CCModel.getRb().getString("panel.accessories.withprice"));
        this.accessoryChkBox.setId(CCModel.getRb().getString("panel.accessories.checkbox.id"));
        this.accessoryChkBox.selectedProperty().setValue(Boolean.TRUE);
        this.accessoryChkBox.selectedProperty().addListener((ChangeListener)new AddAccessoryToFinalPriceChkBoxEventHandler());
        this.add((Node)this.accessoryChkBox, 0, 2);
    }

    public void updateAccessoryPane() {
        this.getChildren().remove((Object)this.accessoryView);
        this.accessoryView = new TableView();
        this.accessoryView.setId("AccessoryTable");
        this.accessoryView.setEditable(false);
        this.accessoryView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.add((Node)this.accessoryView, 0, 1);
        TableColumn tableColumn = new TableColumn();
        TableColumn tableColumn2 = new TableColumn();
        TableColumn tableColumn3 = new TableColumn();
        TableColumn tableColumn4 = new TableColumn();
        tableColumn.setMinWidth(30.0);
        tableColumn2.setMinWidth(200.0);
        tableColumn3.setMinWidth(50.0);
        tableColumn4.setMinWidth(100.0);
        tableColumn.setCellValueFactory(new Callback(){

            public ObservableValue call(TableColumn.CellDataFeatures cellDataFeatures) {
                final CCModel.CCAccessory cCAccessory = (CCModel.CCAccessory)cellDataFeatures.getValue();
                CheckBox checkBox = new CheckBox();
                checkBox.selectedProperty().setValue(cCAccessory.getSelected());
                checkBox.selectedProperty().addListener(new ChangeListener(){

                    public void changed(ObservableValue observableValue, Boolean bl, Boolean bl2) {
                        AccessoryPane.this.cccontroller.changeAccessorySelectionStatus(cCAccessory.getKey(), bl2);
                        AccessoryPane.this.cccontroller.updateCalculatedPrice();
                        AccessoryPane.this.cccontroller.getView().updateSelectedAccessories();
                    }
                });
                return new SimpleObjectProperty((Object)checkBox);
            }
        });
        tableColumn2.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        tableColumn3.setCellValueFactory((Callback)new PropertyValueFactory("accessoryID"));
        tableColumn4.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        tableColumn3.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(String string, boolean bl) {
                        super.updateItem((Object)string, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER;");
                return tableCell;
            }
        });
        tableColumn4.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(Double d, boolean bl) {
                        super.updateItem((Object)d, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : AccessoryPane.this.ccmodel.getM_currencyFormatter().format(this.getItem());
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER-RIGHT;");
                return tableCell;
            }
        });
        if (this.ccmodel.getM_language() == CCModel.getGERMAN()) {
            tableColumn.setText(" ");
            tableColumn2.setText("Beschreibung");
            tableColumn3.setText("ID");
            tableColumn4.setText("Preis");
        } else {
            tableColumn.setText(" ");
            tableColumn2.setText("Description");
            tableColumn3.setText("ID");
            tableColumn4.setText("Price");
        }
        this.accessoryView.getColumns().setAll((Object[])new TableColumn[]{tableColumn, tableColumn2, tableColumn3, tableColumn4});
        this.accessoryView.getItems().clear();
        this.updateEntries();
        this.accessoryView.setItems(this.tableEntries);
        this.cccontroller.getView().updateSelectedAccessories();
    }

    private void updateEntries() {
        this.tableEntries.clear();
        for (Integer n : this.ccmodel.getAccessoryCellsBase().keySet()) {
            this.tableEntries.add(this.ccmodel.getAccessoryCellsBase().get((Object)n));
        }
        Collections.sort(this.tableEntries, new Comparator(){

            public int compare(CCData cCData, CCData cCData2) {
                return cCData.getKeyForSort().compareTo(cCData2.getKeyForSort());
            }
        });
    }

    public TableView getAccessoryView() {
        return this.accessoryView;
    }

    public CheckBox getAccessoryChkBox() {
        return this.accessoryChkBox;
    }

    class AddAccessoryToFinalPriceChkBoxEventHandler
    implements ChangeListener {
        AddAccessoryToFinalPriceChkBoxEventHandler() {
        }

        public void changed(ObservableValue observableValue, Boolean bl, Boolean bl2) {
            AccessoryPane.this.cccontroller.takeAccessoryPriceIntoAccountStateChanged(AccessoryPane.this.accessoryChkBox.isSelected());
            AccessoryPane.this.cccontroller.updateCalculatedPrice();
        }
    }
}

