/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCData;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.AccessoriesDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.AccessoryPane;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.CalculatorPane;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.InfoDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.SendPurchaseOrderDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.SpecialsDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.SpecialsPane;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.StatisticsDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.VehiclesDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.VehiclesPane;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.ViewPurchaseOrderDialog;
import de.qfs.lib.util.MapResourceBundle;
import java.util.LinkedList;
import java.util.function.Predicate;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;

public class CCViewFX
extends BorderPane {
    CCControllerFX controller;
    CCModel ccmodel;
    MapResourceBundle rb = CCModel.getRb();
    TabPane tabpane;
    private VehiclesPane vehiclesPane;
    private SpecialsPane specialsPane;
    private AccessoryPane accessoryPane;
    private CalculatorPane calculatorPane;
    private CCData selectedVehicle;
    private CCModel.CCSpecial selectedSpecial;
    private LinkedList selectedAccessories = new LinkedList();
    private static CCViewFX instance;

    public void updateSelectedVehicle() {
        this.selectedVehicle = (CCData)this.vehiclesPane.getVehiclesView().getSelectionModel().getSelectedItem();
    }

    public void updateSelectedSpecial() {
        this.selectedSpecial = (CCModel.CCSpecial)this.specialsPane.getSpecialsSelection().getSelectionModel().getSelectedItem();
    }

    public void updateSelectedAccessories() {
        this.selectedAccessories.clear();
        this.selectedAccessories.addAll(this.ccmodel.getAccessoryCellsBase().values());
        this.selectedAccessories.removeIf(new Predicate(){

            public boolean test(CCModel.CCAccessory cCAccessory) {
                return cCAccessory.getSelected() == false;
            }
        });
    }

    private CCViewFX(CCControllerFX cCControllerFX) {
        this.controller = cCControllerFX;
        this.ccmodel = cCControllerFX.getCcmodel();
    }

    public static CCViewFX getInstance(CCControllerFX cCControllerFX) {
        if (instance == null) {
            instance = new CCViewFX(cCControllerFX);
        }
        return instance;
    }

    public void build() {
        this.setId(CCModel.getRb().getString("frame.fx.id"));
        this.setStyle(this.controller.getCSSString());
        this.initContents();
        VBox vBox = new VBox();
        vBox.getChildren().setAll((Object[])new Node[]{this.makeMenus()});
        this.setTop((Node)vBox);
        this.setCenter((Node)this.tabpane);
        this.setBottom((Node)this.calculatorPane);
        this.updateAllPanes();
    }

    private MenuBar makeMenus() {
        MenuBar menuBar = new MenuBar();
        menuBar.setId(this.rb.getString("menu.id"));
        Menu menu = new Menu(this.toMnemonicMenuString(this.rb.getString("menu.file.name"), this.rb.getString("menu.file.mnemonic")));
        menu.setMnemonicParsing(true);
        menu.setId(this.rb.getString("menu.file.id"));
        menuBar.getMenus().add((Object)menu);
        MenuItem menuItem = new MenuItem(this.toMnemonicMenuString(this.rb.getString("menu.file.reset.name"), this.rb.getString("menu.file.reset.mnemonic")));
        menuItem.setMnemonicParsing(true);
        menuItem.setId(this.rb.getString("menu.file.reset.id"));
        menuItem.setOnAction((EventHandler)new miResetActionHandler());
        menu.getItems().add((Object)menuItem);
        if (this.ccmodel.getM_params().isLogin()) {
            menuItem = new MenuItem(this.toMnemonicMenuString(this.rb.getString("menu.file.logout.name"), this.rb.getString("menu.file.logout.mnemonic")));
            menuItem.setMnemonicParsing(true);
            menuItem.setId(this.rb.getString("menu.file.logout.id"));
            menuItem.setOnAction((EventHandler)new miLogoutActionHandler());
            menu.getItems().add((Object)menuItem);
        }
        menuItem = new MenuItem(this.toMnemonicMenuString(this.rb.getString("menu.file.exit.name"), this.rb.getString("menu.file.exit.mnemonic")));
        menuItem.setMnemonicParsing(true);
        menuItem.setId(this.rb.getString("menu.file.exit.id"));
        menuItem.setOnAction((EventHandler)new miExitActionHandler());
        menu.getItems().add((Object)menuItem);
        menu = new Menu(this.toMnemonicMenuString(this.rb.getString("menu.options.name"), this.rb.getString("menu.options.mnemonic")));
        menu.setMnemonicParsing(true);
        menu.setId(this.rb.getString("menu.options.id"));
        menuBar.getMenus().add((Object)menu);
        menuItem = new MenuItem(this.toMnemonicMenuString(this.rb.getString("menu.options.vehicles.name"), this.rb.getString("menu.options.vehicles.mnemonic")));
        menuItem.setMnemonicParsing(true);
        menuItem.setId(this.rb.getString("menu.options.vehicles.id"));
        menuItem.setOnAction((EventHandler)new miVehiclesActionHandler());
        menu.getItems().add((Object)menuItem);
        menuItem = new MenuItem(this.toMnemonicMenuString(this.rb.getString("menu.options.specials.name"), this.rb.getString("menu.options.specials.mnemonic")));
        menuItem.setMnemonicParsing(true);
        menuItem.setId(this.rb.getString("menu.options.specials.id"));
        menuItem.setOnAction((EventHandler)new miSpecialsActionHandler());
        menu.getItems().add((Object)menuItem);
        menuItem = new MenuItem(this.toMnemonicMenuString(this.rb.getString("menu.options.accessories.name"), this.rb.getString("menu.options.accessories.mnemonic")));
        menuItem.setMnemonicParsing(true);
        menuItem.setId(this.rb.getString("menu.options.accessories.id"));
        menuItem.setOnAction((EventHandler)new miAccessoriesActionHandler());
        menu.getItems().add((Object)menuItem);
        if (this.controller.isStandardUser()) {
            menu = new Menu(this.toMnemonicMenuString(this.rb.getString("menu.order.name"), this.rb.getString("menu.order.mnemonic")));
            menu.setMnemonicParsing(true);
            menu.setId(this.rb.getString("menu.order.id"));
            menuBar.getMenus().add((Object)menu);
            menuItem = new MenuItem(this.toMnemonicMenuString(this.rb.getString("menu.order.view.name"), this.rb.getString("menu.order.view.mnemonic")));
            menuItem.setMnemonicParsing(true);
            menuItem.setId(this.rb.getString("menu.order.view.id"));
            menuItem.setOnAction((EventHandler)new miViewOrderActionHandler());
            menu.getItems().add((Object)menuItem);
            menuItem = new MenuItem(this.toMnemonicMenuString(this.rb.getString("menu.order.send.name"), this.rb.getString("menu.order.send.mnemonic")));
            menuItem.setMnemonicParsing(true);
            menuItem.setId(this.rb.getString("menu.order.send.id"));
            menuItem.setOnAction((EventHandler)new miSendOrderActionHandler());
            menu.getItems().add((Object)menuItem);
            menuItem = new MenuItem(this.toMnemonicMenuString(this.rb.getString("menu.order.statistics.name"), this.rb.getString("menu.order.statistics.mnemonic")));
            menuItem.setMnemonicParsing(true);
            menuItem.setId(this.rb.getString("menu.order.stats.id"));
            menuItem.setOnAction((EventHandler)new miStatisticsActionHandler());
            menu.getItems().add((Object)menuItem);
        }
        menu = new Menu(this.toMnemonicMenuString(this.rb.getString("menu.help.name"), this.rb.getString("menu.help.mnemonic")));
        menu.setMnemonicParsing(true);
        menu.setId(this.rb.getString("menu.help.id"));
        menuBar.getMenus().add((Object)menu);
        menuItem = new MenuItem(this.toMnemonicMenuString(this.rb.getString("menu.help.about.name"), this.rb.getString("menu.help.about.mnemonic")));
        menuItem.setMnemonicParsing(true);
        menuItem.setId(this.rb.getString("menu.help.info.id"));
        menuItem.setOnAction((EventHandler)new miInfoActionHandler());
        menu.getItems().add((Object)menuItem);
        CheckMenuItem checkMenuItem = new CheckMenuItem(this.toMnemonicMenuString(this.rb.getString("menu.help.buggy.name"), this.rb.getString("menu.help.buggy.mnemonic")));
        checkMenuItem.setMnemonicParsing(true);
        checkMenuItem.setId(this.rb.getString("menu.help.buggy.id"));
        checkMenuItem.setOnAction((EventHandler)new miBuggyActionHandler());
        checkMenuItem.setSelected(this.ccmodel.getM_params().isBuggy());
        menu.getItems().add((Object)checkMenuItem);
        CheckMenuItem checkMenuItem2 = new CheckMenuItem(this.toMnemonicMenuString(this.rb.getString("menu.help.loadtest.name"), this.rb.getString("menu.help.loadtest.mnemonic")));
        checkMenuItem2.setMnemonicParsing(true);
        checkMenuItem2.setId(this.rb.getString("menu.help.load.id"));
        checkMenuItem2.setOnAction((EventHandler)new miLoadTestActionHandler());
        checkMenuItem2.setSelected(this.ccmodel.getM_params().isLoadtest());
        menu.getItems().add((Object)checkMenuItem2);
        return menuBar;
    }

    public String toMnemonicMenuString(String string, String string2) {
        String string3 = null;
        char c = Character.toLowerCase(string2.charAt(0));
        for (int i = 0; i < string.length(); ++i) {
            if (Character.toLowerCase(string.charAt(i)) != c) continue;
            string3 = string.substring(0, i) + "_" + string.substring(i);
            break;
        }
        return string3 == null ? string : string3;
    }

    private void initContents() {
        this.tabpane = new TabPane();
        this.tabpane.setPrefWidth(400.0);
        this.tabpane.setPrefHeight(300.0);
        this.tabpane.setId(this.rb.getString("panel.tab.id"));
        Tab tab = new Tab();
        Tab tab2 = new Tab();
        Tab tab3 = new Tab();
        tab.setId(this.rb.getString("panel.vehicles.table.id"));
        tab2.setId(this.rb.getString("panel.specials.id"));
        tab3.setId(this.rb.getString("panel.accessories.table.id"));
        tab.setText(this.rb.getString("panel.vehicles.name"));
        tab2.setText(this.rb.getString("panel.specials.name"));
        tab3.setText(this.rb.getString("panel.accessories.name"));
        this.vehiclesPane = new VehiclesPane(this.controller);
        tab.setContent((Node)this.vehiclesPane);
        this.specialsPane = new SpecialsPane(this.controller);
        tab2.setContent((Node)this.specialsPane);
        this.accessoryPane = new AccessoryPane(this.controller);
        tab3.setContent((Node)this.accessoryPane);
        this.tabpane.getTabs().addAll((Object[])new Tab[]{tab, tab2, tab3});
        this.tabpane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.calculatorPane = new CalculatorPane(this.controller);
    }

    public void updateAllPanes() {
        this.vehiclesPane.updateVehiclesPane();
        this.specialsPane.updateSpecialsPane();
        this.accessoryPane.updateAccessoryPane();
        this.calculatorPane.updateCalculationPane();
    }

    public static Image getImage(String string) {
        String string2 = CCModel.getRb().getString(string, null);
        return new Image(CCViewFX.class.getResourceAsStream("/" + string2));
    }

    public VehiclesPane getVehiclesPane() {
        return this.vehiclesPane;
    }

    public SpecialsPane getSpecialsPane() {
        return this.specialsPane;
    }

    public AccessoryPane getAccessoryPane() {
        return this.accessoryPane;
    }

    public CalculatorPane getCalculatorPane() {
        return this.calculatorPane;
    }

    public CCData getSelectedVehicle() {
        return this.selectedVehicle;
    }

    public CCModel.CCSpecial getSelectedSpecial() {
        return this.selectedSpecial;
    }

    public LinkedList getSelectedAccessories() {
        return this.selectedAccessories;
    }

    class miLoadTestActionHandler
    implements EventHandler {
        miLoadTestActionHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            CCViewFX.this.controller.loadtestStateChanged(!CCViewFX.this.ccmodel.getM_params().isLoadtest());
            CheckMenuItem checkMenuItem = (CheckMenuItem)actionEvent.getSource();
            checkMenuItem.setSelected(CCViewFX.this.ccmodel.getM_params().isLoadtest());
        }
    }

    class miBuggyActionHandler
    implements EventHandler {
        miBuggyActionHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            CCViewFX.this.controller.buggyStateChanged(!CCViewFX.this.ccmodel.getM_params().isBuggy());
            CheckMenuItem checkMenuItem = (CheckMenuItem)actionEvent.getSource();
            checkMenuItem.setSelected(CCViewFX.this.ccmodel.getM_params().isBuggy());
            CCViewFX.this.updateAllPanes();
        }
    }

    class miInfoActionHandler
    implements EventHandler {
        miInfoActionHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            InfoDialog infoDialog = new InfoDialog(CCViewFX.this.controller.getView().getScene().getWindow());
            infoDialog.showAndWait();
        }
    }

    class miSendOrderActionHandler
    implements EventHandler {
        miSendOrderActionHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            SendPurchaseOrderDialog sendPurchaseOrderDialog = new SendPurchaseOrderDialog(CCViewFX.this.controller.getView().getScene().getWindow(), CCViewFX.this.controller);
            sendPurchaseOrderDialog.showAndWait();
        }
    }

    class miStatisticsActionHandler
    implements EventHandler {
        miStatisticsActionHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            StatisticsDialog statisticsDialog = new StatisticsDialog(CCViewFX.this.controller.getView().getScene().getWindow(), CCViewFX.this.controller);
            statisticsDialog.showAndWait();
        }
    }

    class miViewOrderActionHandler
    implements EventHandler {
        miViewOrderActionHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            ViewPurchaseOrderDialog viewPurchaseOrderDialog = new ViewPurchaseOrderDialog(CCViewFX.this.controller.getView().getScene().getWindow(), CCViewFX.this.controller);
            viewPurchaseOrderDialog.showAndWait();
        }
    }

    class miAccessoriesActionHandler
    implements EventHandler {
        miAccessoriesActionHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            AccessoriesDialog accessoriesDialog = new AccessoriesDialog(CCViewFX.this.controller.getView().getScene().getWindow(), CCViewFX.this.controller);
            accessoriesDialog.showAndWait();
        }
    }

    class miSpecialsActionHandler
    implements EventHandler {
        miSpecialsActionHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            SpecialsDialog specialsDialog = new SpecialsDialog(CCViewFX.this.controller.getView().getScene().getWindow(), CCViewFX.this.controller);
            specialsDialog.showAndWait();
        }
    }

    class miVehiclesActionHandler
    implements EventHandler {
        miVehiclesActionHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            VehiclesDialog vehiclesDialog = new VehiclesDialog(CCViewFX.this.controller.getView().getScene().getWindow(), CCViewFX.this.controller);
            vehiclesDialog.showAndWait();
        }
    }

    class miExitActionHandler
    implements EventHandler {
        miExitActionHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            CCViewFX.this.controller.exit(0);
        }
    }

    class miLogoutActionHandler
    implements EventHandler {
        miLogoutActionHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            CCViewFX.this.controller.resetAll();
            CCViewFX.this.getScene().getWindow().hide();
            CCViewFX.this.controller.logout();
        }
    }

    class miResetActionHandler
    implements EventHandler {
        miResetActionHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            CCViewFX.this.controller.resetAll();
        }
    }
}

