/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.CCViewFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.MessageBox;
import java.text.NumberFormat;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;

public class CalculatorPane
extends GridPane {
    CCModel ccmodel = CCModel.getInstance();
    CCViewFX ccview;
    CCControllerFX cccontroller;
    private Label baseLabel;
    private TextField basePrice;
    private Label specialsLabel;
    private TextField specialsPrice;
    private Label accessoriesLabel;
    private TextField accessoriesPrice;
    private Label discountLabel;
    private TextField discountValue;
    private Label priceLabel;
    private TextField calculatedPrice;
    NumberFormat pformatter = NumberFormat.getPercentInstance();
    private boolean errorShown = false;
    private final String nonEditableTextFields = "-fx-alignment: center-right; -fx-border-color: null;-fx-background-color: null; -fx-select-on-focus:false;";
    private final String editableTextFields = "-fx-alignment: center-right;";
    private final String nonEditableBlueFields = "-fx-text-fill: blue; -fx-alignment: center-right; -fx-background-color: null; -fx-border-color: null; -fx-select-on-focus:false;";

    public CalculatorPane(final CCControllerFX cCControllerFX) {
        this.cccontroller = cCControllerFX;
        this.ccview = CCViewFX.getInstance(cCControllerFX);
        this.setId(CCModel.getRb().getString("panel.calculator.id"));
        this.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.setHgap(3.0);
        this.setVgap(3.0);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(45.0);
        columnConstraints.setHalignment(HPos.LEFT);
        this.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(40.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        this.getColumnConstraints().add((Object)columnConstraints2);
        ColumnConstraints columnConstraints3 = new ColumnConstraints();
        columnConstraints3.setPercentWidth(15.0);
        columnConstraints3.setHalignment(HPos.RIGHT);
        this.getColumnConstraints().add((Object)columnConstraints3);
        this.basePrice = new TextField("");
        this.basePrice.setText(this.ccmodel.getM_currencyFormatter().format(this.ccmodel.getM_baseprice()));
        this.basePrice.setId(CCModel.getRb().getString("panel.calculator.baseprice.field.id"));
        this.basePrice.setEditable(false);
        this.basePrice.setStyle("-fx-alignment: center-right; -fx-border-color: null;-fx-background-color: null; -fx-select-on-focus:false;");
        this.baseLabel = new Label(CCModel.getRb().getString("panel.vehicles.label"));
        this.baseLabel.setLabelFor((Node)this.basePrice);
        this.specialsPrice = new TextField("");
        this.specialsPrice.setId(CCModel.getRb().getString("panel.calculator.specialprice.field.id"));
        this.specialsPrice.setText(this.ccmodel.getM_currencyFormatter().format(0L));
        this.specialsPrice.setEditable(false);
        this.specialsPrice.setStyle("-fx-alignment: center-right; -fx-border-color: null;-fx-background-color: null; -fx-select-on-focus:false;");
        this.specialsLabel = new Label(CCModel.getRb().getString("panel.specials.label"));
        this.specialsLabel.setLabelFor((Node)this.specialsPrice);
        this.accessoriesPrice = new TextField("");
        this.accessoriesPrice.setId(CCModel.getRb().getString("panel.calculator.accessories.field.id"));
        this.accessoriesPrice.setText(this.ccmodel.getM_currencyFormatter().format(0L));
        this.accessoriesPrice.setEditable(false);
        this.accessoriesPrice.setStyle("-fx-alignment: center-right; -fx-border-color: null;-fx-background-color: null; -fx-select-on-focus:false;");
        this.accessoriesLabel = new Label(CCModel.getRb().getString("panel.accessories.label"));
        this.accessoriesLabel.setLabelFor((Node)this.accessoriesPrice);
        this.updateAccessoriesPriceInformation();
        this.discountValue = new TextField(this.formatPercent(this.ccmodel.getM_discount()));
        this.discountValue.setId(CCModel.getRb().getString("panel.calculator.discountvalue.field.id"));
        this.discountValue.setEditable(true);
        this.discountValue.setStyle("-fx-alignment: center-right;");
        this.discountValue.setMaxWidth(60.0);
        this.discountValue.setOnMousePressed(new EventHandler(){

            public void handle(MouseEvent mouseEvent) {
                CalculatorPane.this.discountValue.selectAll();
            }
        });
        this.discountValue.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (!CalculatorPane.this.errorShown) {
                    CalculatorPane.this.errorShown = true;
                    String string = CalculatorPane.this.discountValue.getText();
                    cCControllerFX.checkDiscountShowError(string);
                    cCControllerFX.updateCalculatedPrice();
                    CalculatorPane.this.ccview.requestFocus();
                }
            }
        });
        this.discountValue.focusedProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Boolean bl, Boolean bl2) {
                if (bl2.booleanValue()) {
                    CalculatorPane.this.errorShown = false;
                } else if (!CalculatorPane.this.errorShown) {
                    CalculatorPane.this.errorShown = true;
                    String string = CalculatorPane.this.discountValue.getText();
                    cCControllerFX.checkDiscountShowError(string);
                    cCControllerFX.updateCalculatedPrice();
                }
            }
        });
        this.discountLabel = new Label(CCModel.getRb().getString("panel.price.discount"));
        this.discountLabel.setLabelFor((Node)this.discountValue);
        this.calculatedPrice = new TextField("");
        this.setCalculatedPrice(0.0);
        this.calculatedPrice.setId(CCModel.getRb().getString("panel.calculator.calculated.field.id"));
        this.calculatedPrice.setEditable(false);
        this.calculatedPrice.setStyle("-fx-text-fill: blue; -fx-alignment: center-right; -fx-background-color: null; -fx-border-color: null; -fx-select-on-focus:false;");
        this.priceLabel = new Label(CCModel.getRb().getString("panel.price.calculated"));
        this.priceLabel.setStyle("-fx-text-fill: blue; -fx-alignment: center-right; -fx-background-color: null; -fx-border-color: null; -fx-select-on-focus:false;");
        this.priceLabel.setLabelFor((Node)this.calculatedPrice);
        Button button = new Button("-5%");
        button.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                cCControllerFX.increaseDiscount(CalculatorPane.this.discountValue.getText());
            }
        });
        this.add((Node)this.baseLabel, 0, 0);
        this.add((Node)this.basePrice, 1, 0);
        this.add((Node)this.specialsLabel, 0, 1);
        this.add((Node)this.specialsPrice, 1, 1);
        this.add((Node)this.accessoriesLabel, 0, 2);
        this.add((Node)this.accessoriesPrice, 1, 2);
        this.add((Node)this.discountLabel, 0, 3);
        this.add((Node)this.discountValue, 1, 3);
        this.add((Node)button, 2, 3);
        this.add((Node)this.priceLabel, 0, 4);
        this.add((Node)this.calculatedPrice, 1, 4);
    }

    public void setBasePrice(double d) {
        this.basePrice.setText(this.ccmodel.getM_currencyFormatter().format(d));
    }

    public void setSpecialsPrice(double d) {
        this.specialsPrice.setText(this.ccmodel.getM_currencyFormatter().format(d));
    }

    public void setAccessoriesPrice(double d) {
        this.accessoriesPrice.setText(this.ccmodel.getM_currencyFormatter().format(d));
    }

    public void setCalculatedPrice(double d) {
        this.calculatedPrice.setText(this.ccmodel.getM_currencyFormatter().format(d));
    }

    public void setDiscountText(int n) {
        Integer n2 = n;
        this.discountValue.setText(this.formatPercent(((Number)n2).floatValue() / 100.0f));
    }

    public void reset() {
        this.discountValue.setText(this.formatPercent(0.0));
    }

    public void updateCalculationPane() {
        String string = this.discountValue.getText();
        this.cccontroller.calcPanelUpdate(string);
        this.updateAccessoriesPriceInformation();
    }

    private void updateAccessoriesPriceInformation() {
        this.accessoriesLabel.setVisible(true);
        this.accessoriesLabel.setManaged(true);
        this.accessoriesPrice.setVisible(true);
        this.accessoriesPrice.setManaged(true);
    }

    public void showDiscountError(String string) {
        MessageBox.showOkDialog(this.ccview.getScene().getWindow(), null, "CarConfigurator - Error", string);
    }

    private String formatPercent(double d) {
        return this.pformatter.format(d).replace("\u00a0", "");
    }

    public TextField getCalculatedPrice() {
        return this.calculatedPrice;
    }
}

