/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import java.util.function.Predicate;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.stage.Window;

public class LoginDialog
extends Dialog {
    private CCControllerFX cccontroller;
    private EventHandler confirmLogin;
    private EventHandler cancelLogin;
    private Window dialogWindow;
    private DialogPane contentDialog;
    TextField userField;
    Label userLabel;
    PasswordField pwdField;
    Label pwdLabel;
    Label msgLabel;
    Button loginButton;
    Button cancelBtn;

    public LoginDialog(CCControllerFX cCControllerFX) {
        this.cccontroller = cCControllerFX;
        this.setTitle("LoginDialog");
        this.setResizable(false);
        this.setX(cCControllerFX.getCcmodel().getM_params().getXpos());
        this.setY(cCControllerFX.getCcmodel().getM_params().getYpos());
        this.contentDialog = new DialogPane();
        this.contentDialog.setId(CCModel.getRb().getString("dialog.login.id"));
        this.contentDialog.getChildren().removeIf(new Predicate(){

            public boolean test(Node node) {
                return node.getClass().equals(ButtonBar.class) || node.getClass().equals(GridPane.class);
            }
        });
        this.setupActions();
        this.contentDialog.setContent((Node)this.makeContent());
        this.setDialogPane(this.contentDialog);
        this.dialogWindow = this.getDialogPane().getScene().getWindow();
        this.dialogWindow.setOnCloseRequest(windowEvent -> this.loginCancelled());
    }

    private GridPane makeContent() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(3.0);
        gridPane.setVgap(3.0);
        gridPane.setStyle(this.cccontroller.getCSSString());
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.userField = new TextField();
        this.userField.setId(CCModel.getRb().getString("dialog.login.user.id"));
        this.userLabel = new Label(CCModel.getRb().getString("carconfig.login.user"));
        this.userLabel.setLabelFor((Node)this.userField);
        this.pwdField = new PasswordField();
        this.pwdField.setId(CCModel.getRb().getString("dialog.login.password.id"));
        this.pwdLabel = new Label(CCModel.getRb().getString("carconfig.login.password"));
        this.pwdLabel.setLabelFor((Node)this.pwdField);
        this.msgLabel = new Label(CCModel.getRb().getString("carconfig.login.loginsteps"));
        this.loginButton = new Button();
        this.loginButton.setId(CCModel.getRb().getString("dialog.login.loginbutton.id"));
        this.loginButton.setText(CCModel.getRb().getString("carconfig.login.login"));
        this.loginButton.setOnAction(this.confirmLogin);
        this.cancelBtn = new Button();
        this.cancelBtn.setId(CCModel.getRb().getString("dialog.login.cancelbutton.id"));
        this.cancelBtn.setText(CCModel.getRb().getString("carconfig.login.cancel"));
        this.cancelBtn.setOnAction(this.cancelLogin);
        gridPane.add((Node)this.userLabel, 0, 0);
        gridPane.add((Node)this.userField, 1, 0);
        gridPane.add((Node)this.pwdLabel, 0, 1);
        gridPane.add((Node)this.pwdField, 1, 1);
        gridPane.add((Node)this.msgLabel, 0, 2, 2, 1);
        gridPane.add((Node)this.loginButton, 0, 3);
        gridPane.add((Node)this.cancelBtn, 1, 3);
        return gridPane;
    }

    private void setupActions() {
        this.confirmLogin = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                String string = LoginDialog.this.userField.getText();
                String string2 = LoginDialog.this.pwdField.getText();
                LoginDialog.this.checkLogin(string, string2);
            }
        };
        this.cancelLogin = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                LoginDialog.this.loginCancelled();
            }
        };
    }

    protected void checkLogin(String string, String string2) {
        if (string.equals("tester") && string2.contentEquals("tester")) {
            this.cccontroller.changeUser(string);
            this.dialogWindow.hide();
        } else if (string.equals("user") && string2.contentEquals("user")) {
            this.cccontroller.changeUser(string);
            this.dialogWindow.hide();
        } else {
            this.msgLabel.setText(CCModel.getRb().getString("carconfig.login.loginfailed"));
            this.userField.setText("");
            this.pwdField.setText("");
        }
    }

    private void loginCancelled() {
        this.cccontroller.exit(0);
    }
}

