/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.GeneralStageFX;
import de.qfs.lib.util.Misc;
import java.util.Calendar;
import java.util.Random;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Window;
import javafx.util.Callback;

public class StatisticsDialog
extends GeneralStageFX {
    public StatisticsDialog(Window window, CCControllerFX cCControllerFX) {
        super(window, cCControllerFX);
        String string = "--";
        if (cCControllerFX.getView().getSelectedVehicle() != null && !Misc.emptyOrNull((String)cCControllerFX.getView().getSelectedVehicle().toString())) {
            string = cCControllerFX.getView().getSelectedVehicle().toString();
        }
        this.setTitle(CCModel.getRb().getString("dialog.statistics.name") + " - " + string);
        this.setResizable(false);
        BorderPane borderPane = new BorderPane();
        borderPane.setStyle(cCControllerFX.getCSSString());
        borderPane.setCenter(this.createMiddleElementsPane(string));
        borderPane.setBottom(this.createBottomOkPane());
        Scene scene = new Scene((Parent)borderPane);
        this.setScene(scene);
        this.dialogWindow = this.getScene().getWindow();
        this.dialogWindow.setOnCloseRequest(windowEvent -> this.dialogWindow.hide());
    }

    public Node createMiddleElementsPane(String string) {
        GridPane gridPane = new GridPane();
        gridPane.add(this.createVehicleDetailsElements(), 0, 0);
        gridPane.add(this.createTableElements(string), 0, 1);
        return gridPane;
    }

    public Node createTableElements(String string) {
        GridPane gridPane = new GridPane();
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(3);
        ObservableList observableList = FXCollections.observableArrayList();
        if ("Minigolf".equals(string)) {
            observableList.add((Object)new Object[]{n, 10});
            observableList.add((Object)new Object[]{n - 1, 32});
            observableList.add((Object)new Object[]{n - 2, 12});
            observableList.add((Object)new Object[]{n - 3, 2});
            observableList.add((Object)new Object[]{n - 4, 21});
            observableList.add((Object)new Object[]{n - 5, 12});
        } else if ("Rolo".equals(string)) {
            observableList.add((Object)new Object[]{n, 3});
            observableList.add((Object)new Object[]{n - 1, 8});
        } else if ("I5".equals(string)) {
            observableList.add((Object)new Object[]{n, 3});
            observableList.add((Object)new Object[]{n - 1, 12});
            observableList.add((Object)new Object[]{n - 2, 0});
            observableList.add((Object)new Object[]{n - 3, 19});
        } else if ("Rassant".equals(string)) {
            observableList.add((Object)new Object[]{n, 8});
            observableList.add((Object)new Object[]{n - 1, 2});
            observableList.add((Object)new Object[]{n - 2, 22});
            observableList.add((Object)new Object[]{n - 3, 4});
            observableList.add((Object)new Object[]{n - 4, 6});
            observableList.add((Object)new Object[]{n - 5, 15});
        } else if ("Rassant Family".equals(string)) {
            observableList.add((Object)new Object[]{n, 1});
            observableList.add((Object)new Object[]{n - 1, 13});
            observableList.add((Object)new Object[]{n - 2, 5});
            observableList.add((Object)new Object[]{n - 3, 27});
            observableList.add((Object)new Object[]{n - 4, 11});
        } else {
            observableList.add((Object)new Object[]{n, 0});
        }
        TableView tableView = new TableView(observableList);
        tableView.setItems(observableList);
        String[] stringArray = this.cccontroller.getCcmodel().getStatisticsColumnNames();
        TableColumn tableColumn = new TableColumn();
        TableColumn tableColumn2 = new TableColumn();
        tableColumn.setText(stringArray[0]);
        tableColumn2.setText(stringArray[1]);
        tableColumn.setMinWidth(100.0);
        tableColumn2.setMinWidth(100.0);
        tableView.getColumns().add((Object)tableColumn);
        tableView.getColumns().add((Object)tableColumn2);
        tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        tableColumn.setCellValueFactory(new Callback(){

            public ObservableValue call(TableColumn.CellDataFeatures cellDataFeatures) {
                Object[] objectArray = (Object[])cellDataFeatures.getValue();
                return new ReadOnlyObjectWrapper(objectArray[0]);
            }
        });
        tableColumn2.setCellValueFactory(new Callback(){

            public ObservableValue call(TableColumn.CellDataFeatures cellDataFeatures) {
                Object[] objectArray = (Object[])cellDataFeatures.getValue();
                return new ReadOnlyObjectWrapper(objectArray[1]);
            }
        });
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(100.0);
        columnConstraints.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        int n2 = 70 * observableList.size();
        gridPane.setPrefHeight((double)n2);
        gridPane.add((Node)tableView, 0, 0);
        return gridPane;
    }

    public Node createVehicleDetailsElements() {
        GridPane gridPane = new GridPane();
        GridPane gridPane2 = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(50.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane2.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(50.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane2.getColumnConstraints().add((Object)columnConstraints2);
        gridPane.add((Node)gridPane2, 0, 0);
        Random random = new Random();
        Label label = new Label(CCModel.getRb().getString("dialog.purchaseorder.vehicle.label"));
        label.setId(CCModel.getRb().getString("dialog.statistics.label.id") + random.nextInt());
        gridPane2.add((Node)label, 0, 0);
        String string = CCModel.getRb().getString("error.purchaseorder.novehicle");
        if (this.cccontroller.getView().getSelectedVehicle() != null) {
            string = this.cccontroller.getView().getSelectedVehicle().toString();
        }
        TextField textField = new TextField(string);
        textField.setId(CCModel.getRb().getString("dialog.statistics.textfield.id") + random.nextInt());
        textField.setEditable(false);
        gridPane2.add((Node)textField, 1, 0);
        return gridPane;
    }

    public Node createBottomOkPane() {
        FlowPane flowPane = new FlowPane();
        flowPane.alignmentProperty().setValue((Object)Pos.CENTER);
        flowPane.setMaxWidth(Double.MAX_VALUE);
        flowPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Button button = new Button(CCModel.getRb().getString("button.ok"));
        button.setId(CCModel.getRb().getString("dialog.statistics.okbutton.id"));
        button.setOnAction(actionEvent -> this.dialogWindow.hide());
        flowPane.getChildren().add((Object)button);
        return flowPane;
    }
}

