/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCData;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.GeneralStageFX;
import java.util.Random;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Window;

public class ViewPurchaseOrderDialog
extends GeneralStageFX {
    public ViewPurchaseOrderDialog(Window window, CCControllerFX cCControllerFX) {
        super(window, cCControllerFX);
        this.setTitle(CCModel.getRb().getString("dialog.viewpurchaseorder.name"));
        this.setResizable(true);
        BorderPane borderPane = new BorderPane();
        borderPane.setStyle(cCControllerFX.getCSSString());
        borderPane.setId(CCModel.getRb().getString("dialog.viewpurchaseorder.id"));
        borderPane.setPrefWidth(400.0);
        borderPane.setCenter(this.createMiddleElementsPane());
        borderPane.setBottom(this.createBottomOkPane());
        Scene scene = new Scene((Parent)borderPane);
        this.setScene(scene);
        this.dialogWindow = this.getScene().getWindow();
        this.dialogWindow.setOnCloseRequest(windowEvent -> this.dialogWindow.hide());
    }

    public Node createMiddleElementsPane() {
        GridPane gridPane = new GridPane();
        if (CCModel.getInstance().getM_params().isCleanname()) {
            gridPane.setId(CCModel.getRb().getString("dialog.viewpurchaseorder.panel.id"));
        }
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(100.0);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        gridPane.add(this.createVehicleDetailsElements(), 0, 0);
        gridPane.add(this.createSpecialsDetailsElements(), 0, 1);
        gridPane.add(this.createAccessoriesDetailsElements(), 0, 2);
        gridPane.add(this.createPriceDetailsElements(), 0, 3);
        return gridPane;
    }

    public Node createVehicleDetailsElements() {
        TitledPane titledPane = new TitledPane();
        titledPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        titledPane.setFont(this.cccontroller.getFont());
        titledPane.setText(CCModel.getRb().getString("dialog.purchaseorder.vehicle.title"));
        titledPane.setMaxWidth(Double.MAX_VALUE);
        titledPane.setMaxHeight(Double.MAX_VALUE);
        GridPane gridPane = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(50.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(50.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints2);
        titledPane.setContent((Node)gridPane);
        Label label = new Label(CCModel.getRb().getString("dialog.purchaseorder.vehicle.label"));
        label.setId(CCModel.getRb().getString("dialog.viewpurchaseorder.modellabel.id") + ViewPurchaseOrderDialog.createRandomString());
        gridPane.add((Node)label, 0, 0);
        String string = CCModel.getRb().getString("error.purchaseorder.novehicle");
        CCData cCData = this.cccontroller.getView().getSelectedVehicle();
        if (cCData != null) {
            string = cCData.toString();
        }
        TextField textField = new TextField(string);
        textField.setEditable(false);
        textField.setId(CCModel.getRb().getString("dialog.viewpurchaseorder.modelfield.id") + ViewPurchaseOrderDialog.createRandomString());
        gridPane.add((Node)textField, 1, 0);
        return titledPane;
    }

    public Node createSpecialsDetailsElements() {
        TitledPane titledPane = new TitledPane();
        titledPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        titledPane.setFont(this.cccontroller.getFont());
        titledPane.setText(CCModel.getRb().getString("dialog.purchaseorder.special.title"));
        titledPane.setMaxWidth(Double.MAX_VALUE);
        titledPane.setMaxHeight(Double.MAX_VALUE);
        GridPane gridPane = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(50.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(50.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints2);
        titledPane.setContent((Node)gridPane);
        Label label = new Label(CCModel.getRb().getString("dialog.purchaseorder.special.label"));
        label.setId(CCModel.getRb().getString("dialog.viewpurchaseorder.speciallabel.id") + ViewPurchaseOrderDialog.createRandomString());
        gridPane.add((Node)label, 0, 0);
        String string = "";
        CCModel.CCSpecial cCSpecial = this.cccontroller.getView().getSelectedSpecial();
        if (cCSpecial != null) {
            string = cCSpecial.getName();
        }
        TextField textField = new TextField(string);
        textField.setEditable(false);
        textField.setId(CCModel.getRb().getString("dialog.viewpurchaseorder.specialfield.id") + ViewPurchaseOrderDialog.createRandomString());
        gridPane.add((Node)textField, 1, 0);
        return titledPane;
    }

    public Node createAccessoriesDetailsElements() {
        TitledPane titledPane = new TitledPane();
        titledPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        titledPane.setFont(this.cccontroller.getFont());
        titledPane.setText(CCModel.getRb().getString("dialog.purchaseorder.accessory.title"));
        titledPane.setMaxWidth(Double.MAX_VALUE);
        titledPane.setMaxHeight(Double.MAX_VALUE);
        if (this.cccontroller.getView().getSelectedAccessories().isEmpty()) {
            Label label = new Label(CCModel.getRb().getString("error.purchaseorder.noaccessory"));
            titledPane.setAlignment(Pos.CENTER);
            titledPane.setContent((Node)label);
            return titledPane;
        }
        GridPane gridPane = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(50.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(50.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints2);
        titledPane.setContent((Node)gridPane);
        int n = 1;
        for (CCModel.CCAccessory cCAccessory : this.cccontroller.getView().getSelectedAccessories()) {
            Label label = new Label(CCModel.getRb().getString("dialog.purchaseorder.accessory.label") + " " + n);
            label.setId("label_" + cCAccessory.getName());
            gridPane.add((Node)label, 0, n);
            TextField textField = new TextField(cCAccessory.getName());
            textField.setEditable(false);
            textField.setId("name_" + cCAccessory.getName());
            gridPane.add((Node)textField, 1, n);
            ++n;
        }
        return titledPane;
    }

    public Node createPriceDetailsElements() {
        TitledPane titledPane = new TitledPane();
        titledPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        titledPane.setFont(this.cccontroller.getFont());
        titledPane.setText(CCModel.getRb().getString("dialog.purchaseorder.price.title"));
        titledPane.setMaxWidth(Double.MAX_VALUE);
        titledPane.setMaxHeight(Double.MAX_VALUE);
        GridPane gridPane = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(50.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(50.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints2);
        titledPane.setContent((Node)gridPane);
        Label label = new Label(CCModel.getRb().getString("dialog.purchaseorder.price.label"));
        label.setId(CCModel.getRb().getString("dialog.viewpurchaseorder.pricelabel.id") + ViewPurchaseOrderDialog.createRandomString());
        gridPane.add((Node)label, 0, 0);
        String string = this.cccontroller.getView().getCalculatorPane().getCalculatedPrice().getText();
        TextField textField = new TextField(string);
        textField.setEditable(false);
        textField.setId(CCModel.getRb().getString("dialog.viewpurchaseorder.pricefield.id") + ViewPurchaseOrderDialog.createRandomString());
        gridPane.add((Node)textField, 1, 0);
        return titledPane;
    }

    public Node createBottomOkPane() {
        FlowPane flowPane = new FlowPane();
        flowPane.alignmentProperty().setValue((Object)Pos.CENTER);
        flowPane.setMaxWidth(Double.MAX_VALUE);
        flowPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Button button = new Button(CCModel.getRb().getString("button.ok"));
        button.setId(CCModel.getRb().getString("dialog.viewpurchaseorder.okbutton.id"));
        button.setOnAction(actionEvent -> this.dialogWindow.hide());
        flowPane.getChildren().add((Object)button);
        return flowPane;
    }

    public static String createRandomString() {
        Random random = new Random();
        return "" + random.nextInt();
    }
}

