/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerSwing;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SortFilterModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.TableModelMod;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class AbstractTablePanel
extends JPanel
implements ListSelectionListener {
    CCModel ccmodel = CCModel.getInstance();
    CCControllerSwing cccontroller;
    TableModelMod model;
    SortFilterModel sorter;
    JTable table;

    public AbstractTablePanel(String string, Map map, String[] stringArray, Integer[] integerArray, String string2, CCControllerSwing cCControllerSwing) {
        this.cccontroller = cCControllerSwing;
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), string));
        this.setLayout(this.getPanelLayout());
        this.model = new TableModelMod(map, (Object[])stringArray);
        this.sorter = new SortFilterModel(this.model, cCControllerSwing);
        this.table = new JTable(this.sorter);
        this.table.setName(string2 + "Table");
        this.table.setShowGrid(false);
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(Double.class, new DoubleTableCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        if (!this.ccmodel.getM_params().isCleanname()) {
            jScrollPane.setName(string2 + "ScrollPane");
        }
        jScrollPane.getViewport().setBackground(Color.WHITE);
        this.add(jScrollPane);
        this.setTableLayout(stringArray, integerArray);
        this.sorter.addMouseListener(this.table);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.model.addTableModelListener(this.table);
    }

    protected LayoutManager getPanelLayout() {
        return new BoxLayout(this, 1);
    }

    public TableModelMod getModel() {
        return this.model;
    }

    public TableModel getSorter() {
        return this.sorter;
    }

    public void setTableLayout(String[] stringArray, Integer[] integerArray) {
        TableColumn tableColumn;
        int n;
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (n = 0; n < integerArray.length; ++n) {
            if (integerArray[n] <= 0) continue;
            tableColumn = tableColumnModel.getColumn(n);
            tableColumn.setMaxWidth(integerArray[n]);
            if (integerArray[n] <= 0) continue;
            tableColumn.setPreferredWidth(integerArray[n]);
        }
        for (n = stringArray.length - 1; n >= 0; --n) {
            if (!stringArray[n].equals("Hide")) continue;
            tableColumn = tableColumnModel.getColumn(n);
            this.table.removeColumn(tableColumn);
        }
    }

    protected void reset() {
        this.table.clearSelection();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public JTable getTable() {
        return this.table;
    }

    private class DoubleTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (jLabel.getText().length() > 0) {
                jLabel.setText(AbstractTablePanel.this.ccmodel.getM_currencyFormatter().format(Double.valueOf(jLabel.getText())));
                jLabel.setHorizontalAlignment(11);
            }
            return jLabel;
        }
    }
}

