/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerSwing;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.AccessoryDialogEditPanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.AccessoryDialogTablePanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.CCView;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.ChangeButtonPanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.OptionDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SortFilterModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class AccessoryDialog
extends OptionDialog {
    CCModel ccmodel = CCModel.getInstance();
    CCView ccview = CCView.getInstance();
    private AccessoryDialogTablePanel accessoryDialogTablePanel;
    private AccessoryDialogEditPanel accessoryDialogEditPanel;

    public AccessoryDialog(JFrame jFrame, CCControllerSwing cCControllerSwing) {
        super(jFrame, false, cCControllerSwing);
        this.setName(CCModel.getRb().getString("dialog.accessories.id"));
        this.setTitle(CCModel.getRb().getString("dialog.accessories.name"));
        this.setModal(true);
        this.setSize(420, 300);
        this.setLocation(this.ccmodel.getM_params().getXpos(), this.ccmodel.getM_params().getYpos());
        Container container = this.getContentPane();
        BorderLayout borderLayout = new BorderLayout();
        container.setLayout(borderLayout);
        JPanel jPanel = new JPanel();
        borderLayout = new BorderLayout();
        borderLayout.setHgap(20);
        jPanel.setLayout(borderLayout);
        this.accessoryDialogEditPanel = new AccessoryDialogEditPanel();
        this.accessoryDialogEditPanel.setName(CCModel.getRb().getString("dialog.accessories.editpanel.id"));
        jPanel.add((Component)this.accessoryDialogEditPanel, "South");
        this.accessoryDialogTablePanel = new AccessoryDialogTablePanel(CCModel.getRb().getString("dialog.accessories.label"), (Map)this.ccmodel.getAccessoryCellsDialog(), this.ccmodel.getAccessoryColumnNames(), this.ccmodel.getAccessoryColumnMaxWidth(), this.accessoryDialogEditPanel, cCControllerSwing);
        this.ccmodel.getAccessoryCellsDialog().addObserver((observable, object) -> {
            this.accessoryDialogTablePanel.getModel().setDataVector((Map)this.ccmodel.getAccessoryCellsDialog(), (Object[])this.ccmodel.getAccessoryColumnNames());
            ((SortFilterModel)this.accessoryDialogTablePanel.getSorter()).tableChanged();
            this.ccmodel.getAccessoryColumnNames()[0] = "Hide";
            this.accessoryDialogTablePanel.setTableLayout(this.ccmodel.getAccessoryColumnNames(), this.ccmodel.getAccessoryColumnMaxWidth());
            this.ccmodel.getAccessoryColumnNames()[0] = " ";
        });
        if (!this.ccmodel.getM_params().isCleanname()) {
            this.accessoryDialogTablePanel.setName(CCModel.getRb().getString("panel.accessories.table.id"));
        }
        jPanel.add((Component)this.accessoryDialogTablePanel, "Center");
        container.add((Component)jPanel, "Center");
        container.add((Component)new ChangeButtonPanel(this), "East");
        this.setVisible(true);
    }

    @Override
    public void newActionPerformed() {
        this.cccontroller.sleepForLoadtesting();
        Double d = this.accessoryDialogEditPanel.getAccessoryPrice();
        if (d <= 0.0) {
            this.showInvalidPriceDialog();
            return;
        }
        String string = this.accessoryDialogEditPanel.getAccessoryName();
        String string2 = this.accessoryDialogEditPanel.getAccessoryId();
        this.cccontroller.accessoryDialogNewAction(d, string, string2);
        this.accessoryDialogEditPanel.reset();
    }

    @Override
    public void changeActionPerformed() {
        int n = this.accessoryDialogTablePanel.table.getSelectionModel().getMinSelectionIndex();
        if (n >= 0) {
            Double d = this.accessoryDialogEditPanel.getAccessoryPrice();
            if (d > 0.0) {
                String string = this.accessoryDialogEditPanel.getAccessoryName();
                String string2 = this.accessoryDialogEditPanel.getAccessoryId();
                int n2 = (Integer)this.accessoryDialogTablePanel.table.getModel().getValueAt(n, CCModel.getACCESSORY_KEY_INDEX());
                this.cccontroller.accessoryDialogChangeAction(n2, string, string2, d);
                this.accessoryDialogEditPanel.reset();
            } else {
                this.showInvalidPriceDialog();
            }
        }
    }

    @Override
    public void deleteActionPerformed() {
        int n = this.accessoryDialogTablePanel.table.getSelectionModel().getMinSelectionIndex();
        if (n >= 0) {
            int n2 = (Integer)this.accessoryDialogTablePanel.table.getModel().getValueAt(n, CCModel.getACCESSORY_KEY_INDEX());
            this.cccontroller.accessoryDialogDeleteAction(n2);
        }
    }

    @Override
    public void cancelActionPerformed() {
        this.cccontroller.accessoryDialogCancelAction();
        this.dispose();
    }

    @Override
    public void confirmActionPerformed() {
        this.cccontroller.accessoryDialogConfirmAction();
        this.dispose();
    }

    @Override
    public void detailsActionPerformed() {
    }

    @Override
    public void overviewActionPerformed() {
    }

    public String getBusinessId() {
        return "ACCESSORIESDIALOG";
    }

    private void showInvalidPriceDialog() {
        JOptionPane.showMessageDialog(this.ccview.frame, CCModel.getRb().getString("error.price.invalid"), "CarConfigurator - Error", 0);
    }
}

