/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerSwing;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.CCView;
import de.qfs.lib.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CalculatorPanel
extends JPanel
implements ActionListener,
MouseListener {
    CCModel ccmodel = CCModel.getInstance();
    CCView ccview = CCView.getInstance();
    CCControllerSwing cccontroller;
    JTextField basePrice;
    JTextField specialsPrice;
    JTextField accessoriesPrice;
    JTextField calculatedPrice;
    JTextField discountValue;
    Action discountAction;
    NumberFormat pformatter = NumberFormat.getPercentInstance();
    boolean errorShown = false;

    public CalculatorPanel(String string, final CCControllerSwing cCControllerSwing) {
        this.cccontroller = cCControllerSwing;
        this.setName(CCModel.getRb().getString("panel.calculator.id"));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), string));
        this.setLayout(new BorderLayout(7, 0));
        JPanel jPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(0, 1);
        jPanel.setLayout(gridLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.basePrice = new JTextField("", 9);
        this.basePrice.setText(this.ccmodel.getM_currencyFormatter().format(this.ccmodel.getM_baseprice()));
        this.basePrice.setName(CCModel.getRb().getString("panel.calculator.baseprice.field.id"));
        this.basePrice.setHorizontalAlignment(4);
        this.basePrice.setEditable(false);
        this.basePrice.setBorder(null);
        JLabel jLabel = new JLabel(CCModel.getRb().getString("panel.vehicles.label"));
        jLabel.setLabelFor(this.basePrice);
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)this.basePrice, "East");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setSize(45, 10);
        this.specialsPrice = new JTextField("", 9);
        this.specialsPrice.setText(this.ccmodel.getM_currencyFormatter().format(0L));
        this.specialsPrice.setName(CCModel.getRb().getString("panel.calculator.specialprice.field.id"));
        this.specialsPrice.setHorizontalAlignment(4);
        this.specialsPrice.setEditable(false);
        this.specialsPrice.setBorder(null);
        JLabel jLabel2 = new JLabel(CCModel.getRb().getString("panel.specials.label"));
        jLabel2.setLabelFor(this.specialsPrice);
        jPanel3.add((Component)jLabel2, "West");
        jPanel3.add((Component)this.specialsPrice, "East");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setSize(45, 10);
        this.discountValue = new JTextField(this.formatPercent(this.ccmodel.getM_discount()), 4);
        this.discountValue.setName(CCModel.getRb().getString("panel.calculator.discountvalue.field.id"));
        this.discountValue.setHorizontalAlignment(4);
        this.discountValue.setEditable(true);
        this.discountValue.setBorder(null);
        this.discountValue.addActionListener(this);
        this.discountValue.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CalculatorPanel.this.errorShown = false;
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!CalculatorPanel.this.errorShown) {
                    String string = CalculatorPanel.this.discountValue.getText();
                    cCControllerSwing.checkDiscountShowError(string);
                    String string2 = Integer.valueOf(CalculatorPanel.this.ccmodel.getM_discount()).toString();
                    CalculatorPanel.this.discountValue.setText(string2 + "%");
                    cCControllerSwing.updateCalculatedPrice();
                }
            }
        });
        this.discountValue.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void update() {
                if (!Misc.emptyOrNull((String)CalculatorPanel.this.discountValue.getText())) {
                    String string = CalculatorPanel.this.discountValue.getText();
                    cCControllerSwing.checkDiscount(string);
                    cCControllerSwing.updateCalculatedPrice();
                }
            }
        });
        this.discountValue.addMouseListener(this);
        JLabel jLabel3 = new JLabel(CCModel.getRb().getString("panel.price.discount"));
        jLabel3.setLabelFor(this.discountValue);
        jPanel4.add((Component)jLabel3, "West");
        jPanel4.add((Component)this.discountValue, "East");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.calculatedPrice = new JTextField("", 10);
        this.setCalculatedPrice(0.0);
        this.calculatedPrice.setName(CCModel.getRb().getString("panel.calculator.calculated.field.id"));
        this.calculatedPrice.setHorizontalAlignment(4);
        this.calculatedPrice.setEditable(false);
        this.calculatedPrice.setBorder(null);
        this.calculatedPrice.setFont(this.calculatedPrice.getFont().deriveFont(1));
        this.calculatedPrice.setForeground(this.ccview.getM_theme().getTitleTextColor());
        JLabel jLabel4 = new JLabel(CCModel.getRb().getString("panel.price.calculated"));
        jLabel4.setFont(jLabel4.getFont().deriveFont(1));
        jLabel4.setForeground(this.ccview.getM_theme().getTitleTextColor());
        jLabel4.setLabelFor(this.calculatedPrice);
        jPanel5.add((Component)jLabel4, "West");
        jPanel5.add((Component)this.calculatedPrice, "East");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.setSize(45, 10);
        this.accessoriesPrice = new JTextField("", 9);
        this.accessoriesPrice.setText(this.ccmodel.getM_currencyFormatter().format(0L));
        this.accessoriesPrice.setName(CCModel.getRb().getString("panel.calculator.accessories.field.id"));
        this.accessoriesPrice.setHorizontalAlignment(4);
        this.accessoriesPrice.setEditable(false);
        this.accessoriesPrice.setBorder(null);
        JLabel jLabel5 = new JLabel(CCModel.getRb().getString("panel.accessories.label"));
        jLabel5.setLabelFor(this.accessoriesPrice);
        jPanel6.add((Component)jLabel5, "West");
        jPanel6.add((Component)this.accessoriesPrice, "East");
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel6);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        JPanel jPanel7 = new JPanel();
        this.add((Component)jPanel7, "West");
        JPanel jPanel8 = new JPanel();
        GridLayout gridLayout2 = new GridLayout(5, 1);
        jPanel8.setLayout(gridLayout2);
        JButton jButton = new JButton("-5%");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cCControllerSwing.increaseDiscount(CalculatorPanel.this.discountValue.getText());
            }
        });
        jPanel8.add(Box.createVerticalBox());
        jPanel8.add(Box.createVerticalBox());
        jPanel8.add(Box.createVerticalBox());
        Box box = Box.createHorizontalBox();
        box.add(jButton);
        box.add(Box.createHorizontalStrut(7));
        jPanel8.add(box);
        jPanel8.add(Box.createVerticalBox());
        this.add((Component)jPanel8, "East");
        this.add((Component)jPanel, "Center");
    }

    private String formatPercent(double d) {
        return this.pformatter.format(d).replace("\u00a0", "");
    }

    public void setBasePrice(double d) {
        this.basePrice.setText(this.ccmodel.getM_currencyFormatter().format(d));
    }

    public void setSpecialsPrice(double d) {
        this.specialsPrice.setText(this.ccmodel.getM_currencyFormatter().format(d));
    }

    public void setAccessoriesPrice(double d) {
        this.accessoriesPrice.setText(this.ccmodel.getM_currencyFormatter().format(d));
    }

    public void setCalculatedPrice(double d) {
        this.calculatedPrice.setText(this.ccmodel.getM_currencyFormatter().format(d));
    }

    public void setDiscountText(int n) {
        Integer n2 = n;
        try {
            this.discountValue.setText(this.formatPercent(((Number)n2).floatValue() / 100.0f));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void reset() {
        this.discountValue.setText(this.formatPercent(0.0));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.errorShown) {
            this.errorShown = true;
            String string = this.discountValue.getText();
            this.cccontroller.checkDiscountShowError(string);
            this.cccontroller.updateCalculatedPrice();
            this.discountValue.setFocusable(false);
            this.discountValue.setFocusable(true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.discountValue.selectAll();
    }

    public void showDiscountError(String string) {
        JOptionPane.showMessageDialog(this.ccview.frame, string, "CarConfigurator - Error", 0);
    }
}

