/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing;

import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.CarSplashWindow;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;

class CarSplash
extends Canvas
implements ImageObserver {
    private static final int FONT_SIZE = 13;
    private static final int VFONT_SIZE = 15;
    private static final int BORDER_DIST_X = 32;
    private static final int BORDER_DIST_Y = 54;
    private static final int VERSION_X = 300;
    private static final int VERSION_Y = 136;
    private static Color qfsBlue = new Color(20, 40, 110);
    private Image image;
    private String message;
    private Font font;
    private Font vfont;
    int x;
    int y;
    int w;
    int h;
    int vw;
    int vh;
    Image buffer;
    Image vbuffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CarSplash(Image image) {
        this.image = image;
        if (!this.prepareImage(image, -1, -1, this)) {
            CarSplash carSplash = this;
            synchronized (carSplash) {
                int n;
                long l = System.currentTimeMillis() + 2000L;
                while (((n = this.checkImage(image, null)) & 0xE0) == 0) {
                    try {
                        this.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() <= l) continue;
                    break;
                }
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.image == null) {
            return;
        }
        graphics.drawImage(this.image, 0, 0, this);
        this.paintVersion(graphics);
        this.paintMessage(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0xE0) != 0) {
            CarSplash carSplash = this;
            synchronized (carSplash) {
                this.notifyAll();
            }
            return false;
        }
        return true;
    }

    public void setMessage(String string) {
        this.message = string;
        Graphics graphics = this.getGraphics();
        this.paintMessage(graphics);
    }

    public void setImage(Image image) {
        this.image = image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintVersion(Graphics graphics) {
        CarSplash carSplash = this;
        synchronized (carSplash) {
            if (this.vfont == null) {
                String string = "CarConfigurator Swing";
                this.vfont = new Font("Verdana", 0, 15);
                this.vw = graphics.getFontMetrics(this.vfont).stringWidth(string);
                this.vh = graphics.getFontMetrics(this.vfont).getHeight();
                this.vbuffer = this.createImage(this.vw, this.vh);
                Graphics graphics2 = this.vbuffer.getGraphics();
                try {
                    boolean bl = graphics2.drawImage(this.image, 0, 0, this.vw, this.vh, 300 - this.vw, 136, 300, 136 + this.vh, this);
                    if (!bl) {
                        try {
                            this.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                graphics2.setColor(qfsBlue);
                graphics2.setFont(this.vfont);
                graphics2.drawString(string, 0, this.vh - graphics2.getFontMetrics().getDescent());
            }
        }
        if (this.vbuffer == null) {
            return;
        }
        try {
            graphics.drawImage(this.vbuffer, 300 - this.vw, 136, this);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintMessage(Graphics graphics) {
        Object object = this;
        synchronized (object) {
            if (this.font == null) {
                this.font = new Font("Verdana", 0, 13);
                this.w = 268;
                this.h = graphics.getFontMetrics(this.font).getHeight() + 3;
                this.x = 32;
                this.y = CarSplashWindow.getHEIGHT() - 54 - this.h / 2;
            }
            if (this.buffer == null) {
                this.buffer = this.createImage(this.w, this.h);
            }
        }
        if (this.buffer == null) {
            return;
        }
        try {
            object = this.buffer.getGraphics();
            boolean bl = ((Graphics)object).drawImage(this.image, 0, 0, this.w, this.h, this.x, this.y, this.x + this.w, this.y + this.h, this);
            if (!bl) {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ((Graphics)object).setFont(this.font);
            ((Graphics)object).setColor(qfsBlue);
            if (this.message != null) {
                int n = ((Graphics)object).getFontMetrics().stringWidth(this.message);
                ((Graphics)object).drawString(this.message, Math.max(1, this.w - n), this.h - 2 - ((Graphics)object).getFontMetrics().getDescent());
            }
            graphics.drawImage(this.buffer, this.x, this.y, this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

