/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing;

import de.qfs.lib.util.Misc;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;

public class SimpleTwoDTree
extends JComponent
implements MouseListener {
    public static final Color BORDER_COLOR = Color.DARK_GRAY;
    public static final Color HIGHLIGHT_BORDER_COLOR = Color.RED;
    public static final Color BOX_BACKGROUND_COLOR = new Color(195, 217, 255);
    public static final int BORDER_SIZE = 2;
    public static final int PADDING_TOP = 5;
    public static final int PADDING_RIGHT = 10;
    public static final int PADDING_BOTTOM = 5;
    public static final int PADDING_LEFT = 10;
    public static final int SPACE_BETWEEN_ROOT_AND_LEAFS = 40;
    public static final int SPACE_BETWEEN_LEAFS = 20;
    public static final int MARGIN = 30;
    private Box root;
    private final LinkedList leafs = new LinkedList();

    public SimpleTwoDTree() {
        this.addMouseListener(this);
    }

    public void setRoot(String string) {
        string = Misc.emptyOrNull((String)string) ? "" : string;
        this.root = new Box(string);
    }

    public void addLeaf(String string) {
        string = Misc.emptyOrNull((String)string) ? "" : string;
        this.leafs.add(new Box(string));
    }

    public List getAllBoxes() {
        LinkedList<Box> linkedList = new LinkedList<Box>();
        if (this.root != null) {
            linkedList.add(this.root.clone());
        }
        for (Box box : this.leafs) {
            linkedList.add(box.clone());
        }
        return linkedList;
    }

    public Font getDefaultFont() {
        Font font = super.getFont();
        return new Font(font.getName(), 0, 14);
    }

    public Dimension getStringDimensions(String string) {
        string = Misc.emptyOrNull((String)string) ? "" : string;
        Font font = this.getDefaultFont();
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        int n = (int)Math.ceil(d);
        int n2 = (int)Math.ceil(d2);
        return new Dimension(n, n2);
    }

    public Dimension getBoxDimension(Box box) {
        Dimension dimension = this.getStringDimensions(box.text);
        box.textwidth = dimension.width;
        box.textheight = dimension.height;
        dimension.height = 7 + dimension.height + 5 + 2;
        box.width = dimension.width = 12 + dimension.width + 10 + 2;
        box.height = dimension.height;
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        if (!Misc.emptyOrNull((Object)this.root)) {
            Dimension dimension = this.getBoxDimension(this.root);
            n = dimension.width;
            n2 = dimension.height;
            if (!this.leafs.isEmpty()) {
                n2 += 40;
            }
        }
        if (!this.leafs.isEmpty()) {
            int n3 = 0;
            int n4 = 0;
            boolean bl = true;
            for (Box box : this.leafs) {
                Dimension dimension = this.getBoxDimension(box);
                if (bl) {
                    n3 = dimension.width;
                    n4 = dimension.height;
                } else {
                    n3 += 20 + dimension.width;
                    n4 = Math.max(n4, dimension.height);
                }
                bl = false;
            }
            n = Math.max(n, n3);
            n2 += n4;
        }
        return new Dimension(n += 60, n2 += 60);
    }

    public void paintBox(Graphics2D graphics2D, int n, int n2, Box box) {
        box.posX = n;
        box.posY = n2;
        graphics2D.setColor(BOX_BACKGROUND_COLOR);
        graphics2D.fillRect(n, n2, box.width, box.height);
        graphics2D.setColor(box.selected ? HIGHLIGHT_BORDER_COLOR : BORDER_COLOR);
        for (int i = 0; i < 2; ++i) {
            graphics2D.drawRect(n, n2, box.width, box.height);
            graphics2D.drawRect(n + i, n2 + i, box.width - 2 * i, box.height - 2 * i);
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.setFont(this.getDefaultFont());
        graphics2D.drawString(box.text, n + 2 + 10, n2 + 2 + 5 + box.textheight);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        if (this.root.width == -1) {
            this.getPreferredSize();
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (!Misc.emptyOrNull((Object)this.root)) {
            this.paintBox(graphics2D, n / 2 - this.root.width / 2, 30, this.root);
        }
        int n3 = 30;
        int n4 = 30 + (Misc.emptyOrNull((Object)this.root) ? 0 : this.root.height) + 40;
        for (Box box : this.leafs) {
            this.paintBox(graphics2D, n3, n4, box);
            n3 += box.width + 20;
        }
        if (!Misc.emptyOrNull((Object)this.root)) {
            int n5 = this.root.posX + this.root.width / 2;
            int n6 = this.root.posY + this.root.height;
            graphics2D.setColor(Color.BLACK);
            for (Box box : this.leafs) {
                int n7 = box.posX + box.width / 2;
                int n8 = box.posY;
                graphics2D.drawLine(n5, n6, n7, n8);
            }
        }
    }

    public Box getBoxAt(int n, int n2) {
        if (this.root != null && this.root.posX <= n && n <= this.root.posX + this.root.width && this.root.posY <= n2 && n2 <= this.root.posY + this.root.height) {
            return this.root;
        }
        for (Box box : this.leafs) {
            if (box.posX > n || n > box.posX + box.width || box.posY > n2 || n2 > box.posY + box.height) continue;
            return box;
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Box box = this.getBoxAt(mouseEvent.getX(), mouseEvent.getY());
        if (box != null) {
            box.selected = !box.selected;
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public class Box {
        public String text;
        public int textwidth;
        public int textheight;
        public int posX = -1;
        public int posY = -1;
        public int width = -1;
        public int height = -1;
        public boolean selected = false;

        public Box(String string) {
            this.text = string;
        }

        public Box clone() {
            Box box = new Box(this.text);
            box.textwidth = this.textwidth;
            box.textheight = this.textheight;
            box.posX = this.posX;
            box.posY = this.posY;
            box.width = this.width;
            box.height = this.height;
            box.selected = this.selected;
            return box;
        }
    }
}

