/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.treetable;

import de.qfs.apps.qftest.demo.multi.treetable.TreeTable;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeModel;

public class TreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.demo.multi.treetable.TreeTableCellRenderer");
    private static final long serialVersionUID = 1L;
    protected int visibleRow;
    private final TreeTable treeTable;

    public TreeTableCellRenderer(TreeTable treeTable, TreeModel treeModel) {
        super(treeModel);
        if (TreeTableCellRenderer.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "TreeTableCellRenderer(TreeTable,TreeModel)", 45).addDetail("treeTable", (Object)treeTable)).addDetail("model", (Object)treeModel)).log();
        }
        this.treeTable = treeTable;
        this.setRowHeight(this.getRowHeight());
    }

    @Override
    public void setRowHeight(int n) {
        if (TreeTableCellRenderer.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setRowHeight(int)", 63).addDetail("rowHeight", n)).log();
        }
        if (n > 0) {
            super.setRowHeight(n);
            if (this.treeTable != null && this.treeTable.getRowHeight() != n) {
                this.treeTable.setRowHeight(this.getRowHeight());
            }
        }
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        if (TreeTableCellRenderer.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setBounds(int,int,int,int)", 80).addDetail("x", n)).addDetail("y", n2)).addDetail("w", n3)).addDetail("h", n4)).log();
        }
        super.setBounds(n, 0, n3, this.treeTable.getHeight());
    }

    @Override
    public void paint(Graphics graphics) {
        if (TreeTableCellRenderer.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "paint(Graphics)", 92).addDetail("g", (Object)graphics)).log();
        }
        graphics.translate(0, -this.visibleRow * this.getRowHeight());
        super.paint(graphics);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (TreeTableCellRenderer.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getTableCellRendererComponent(JTable,Object,boolean,boolean,int,int)", 106).addDetail("table", (Object)jTable)).addDetail("value", object)).addDetail("isSelected", bl)).addDetail("hasFocus", bl2)).addDetail("row", n)).addDetail("column", n2)).log();
        }
        if (bl) {
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setBackground(jTable.getBackground());
        }
        this.visibleRow = n;
        return this;
    }
}

