/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.swing;

import de.qfs.apps.qftest.demo.BaseDemo;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Logger;
import de.qfs.lib.util.MapResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SwingDemo
extends BaseDemo {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.swing.SwingDemo");
    private static Frame pFrame;
    private static JDialog dialog;
    private static Container pane;
    private static final int WIDTH = 380;
    private static JMenuBar menubar;
    private static JTabbedPane tabbed;
    private static JTextField field1;
    private static JTextField field2;
    private static JTextArea textArea;
    private static JCheckBox checkbox1;
    private static JCheckBox checkbox2;
    private static JLabel field1Label;
    private static JLabel field2Label;
    private static JLabel areaLabel;
    private static JLabel checkboxLabel;
    private static JLabel componentLabel;
    private static JList leftList;
    private static JList rightList;
    private static JTree tree;
    private static JPopupMenu menuComponentsPopup;
    private static JPopupMenu menuTextAreaPopup;
    private static JCheckBoxMenuItem miComponentsEnable;
    private static JCheckBoxMenuItem miComponentsPopupEnable;
    private static JCheckBoxMenuItem miTreeEnable;
    private static JMenuItem miColor1;
    private static JMenuItem miColor2;
    private static JMenuItem miColor3;
    private static JMenuItem miColorNormal;
    private static JMenuItem miDual1;
    private static JMenuItem miDual2;
    private static JMenuItem miTextAreaPopupItem1;
    private static JMenuItem miTextAreaPopupItem2;
    private static Color defaultBkgCl;
    private static Color defaultFgCl;
    private static ActionListener resetAction;
    private static ActionListener fileOpenAction;
    private static ActionListener fileSaveAction;
    private static ActionListener enableComponentsAction;
    private static ActionListener enableComponentsPopupAction;
    private static ActionListener enableTreeAction;
    private static ActionListener colorNormalChangeAction;
    private static ActionListener color1ChangeAction;
    private static ActionListener color2ChangeAction;
    private static ActionListener color3ChangeAction;
    private static ActionListener dual1ChangeAction;
    private static ActionListener dual2ChangeAction;
    private static ActionListener textArea1PopupAction;
    private static ActionListener textArea2PopupAction;
    private static MapResourceBundle rb;

    public SwingDemo(boolean bl) {
        super(bl);
    }

    public static void main(String[] stringArray) {
        SwingDemo swingDemo = new SwingDemo(false);
        BaseDemo.argdef = new String[]{"-dialog", "-fixed", "-other"};
        BaseDemo.setupAndRun(stringArray, swingDemo);
    }

    @Override
    protected void showFrameOrDialog() {
        Window window;
        if (SwingDemo.logger.level >= 7) {
            logger.log(7, "showFrameOrDialog()", "");
        }
        rb = new MapResourceBundle();
        rb.fetchProperties("/de/qfs/apps/qftest/demo/swing/resources/properties/swingdemo", this.getClass());
        menubar = new JMenuBar();
        if (this.asDialog) {
            pFrame = new JFrame();
            dialog = new JDialog(pFrame, "Swing Demo", true);
            window = dialog;
            pane = dialog.getContentPane();
            dialog.setJMenuBar(menubar);
        } else {
            pFrame = this.frame = new JFrame("Swing Demo");
            window = this.frame;
            pane = ((JFrame)this.frame).getContentPane();
            ((JFrame)this.frame).setJMenuBar(menubar);
        }
        window.setName("SwingDemo");
        tabbed = new JTabbedPane(3);
        tabbed.setName("SwingDemoTabbed");
        Grid grid = new Grid();
        grid.setName("SwingBaseGrid");
        this.setupActions();
        this.setupMenus();
        this.reset();
        this.setupPopupListeners();
        JButton jButton = new JButton(rb.getString("button.close"));
        jButton.setName("close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jButton.setPreferredSize(new Dimension(50, jButton.getPreferredSize().height));
        grid.addLine(new Component[]{tabbed}, 1.0);
        grid.addLine(new Component[]{new JLabel(), jButton, new JLabel()});
        pane.add((Component)grid);
        this.finishWindow(window);
        SwingDemo.changeComponentColor(defaultFgCl, defaultBkgCl);
    }

    public void setupMenus() {
        JMenu jMenu = new JMenu(rb.getString("menu.file.name"));
        jMenu.setName("mFile");
        jMenu.setMnemonic(rb.getString("menu.file.mnemonic").charAt(0));
        menubar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(rb.getString("menu.file.open.name"));
        jMenuItem.setName("miOpen");
        jMenuItem.setMnemonic(rb.getString("menu.file.open.mnemonic").charAt(0));
        jMenuItem.addActionListener(fileOpenAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(rb.getString("menu.file.save.name"));
        jMenuItem.setName("miSave");
        jMenuItem.setMnemonic(rb.getString("menu.file.save.mnemonic").charAt(0));
        jMenuItem.addActionListener(fileSaveAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(rb.getString("menu.file.reset.name"));
        jMenuItem.setName("miReset");
        jMenuItem.setMnemonic(rb.getString("menu.file.reset.mnemonic").charAt(0));
        jMenuItem.addActionListener(resetAction);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(rb.getString("menu.file.exit.name"));
        jMenuItem.setName("miExit");
        jMenuItem.setMnemonic(rb.getString("menu.file.exit.mnemonic").charAt(0));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu(rb.getString("menu.options.name"));
        jMenu2.setName("mOptions");
        jMenu2.setMnemonic(rb.getString("menu.options.mnemonic").charAt(0));
        JMenu jMenu3 = (JMenu)jMenu2.add(new JMenu(rb.getString("menu.options.comp.name")));
        jMenu3.setName("mOptionsComponents");
        jMenu3.setMnemonic(rb.getString("menu.options.comp.mnemonic").charAt(0));
        miComponentsEnable = new JCheckBoxMenuItem(rb.getString("menu.options.comp.enable.name"), true);
        miComponentsEnable.setName("miOptionsComponentsEnable");
        miComponentsEnable.setMnemonic(rb.getString("menu.options.comp.enable.mnemonic").charAt(0));
        miComponentsEnable.addActionListener(enableComponentsAction);
        jMenu3.add(miComponentsEnable);
        JMenu jMenu4 = (JMenu)jMenu3.add(new JMenu(rb.getString("menu.options.comp.display.name")));
        jMenu4.setName("mOptionsComponentsDisplay");
        jMenu4.setMnemonic(rb.getString("menu.options.comp.display.mnemonic").charAt(0));
        JMenu jMenu5 = (JMenu)jMenu4.add(new JMenu(rb.getString("menu.options.comp.display.colors.name")));
        jMenu5.setName("mOptionsComponentsDisplayColors");
        jMenu5.setMnemonic(rb.getString("menu.options.comp.display.colors.mnemonic").charAt(0));
        miColorNormal = new JMenuItem(rb.getString("menu.options.comp.display.colors.normal.name"));
        miColorNormal.setName("miColorNormal");
        miColorNormal.setMnemonic(rb.getString("menu.options.comp.display.colors.normal.mnemonic").charAt(0));
        miColorNormal.addActionListener(colorNormalChangeAction);
        jMenu5.add(miColorNormal);
        miColor1 = new JMenuItem(rb.getString("menu.options.comp.display.colors.color1.name"));
        miColor1.setName("miColor1");
        miColor1.setMnemonic(rb.getString("menu.options.comp.display.colors.color1.mnemonic").charAt(0));
        miColor1.addActionListener(color1ChangeAction);
        jMenu5.add(miColor1);
        miColor2 = new JMenuItem(rb.getString("menu.options.comp.display.colors.color2.name"));
        miColor2.setName("miColor2");
        miColor2.setMnemonic(rb.getString("menu.options.comp.display.colors.color2.mnemonic").charAt(0));
        miColor2.addActionListener(color2ChangeAction);
        jMenu5.add(miColor2);
        miColor3 = new JMenuItem(rb.getString("menu.options.comp.display.colors.color3.name"));
        miColor3.setName("miColor3");
        miColor3.setMnemonic(rb.getString("menu.options.comp.display.colors.color3.mnemonic").charAt(0));
        miColor3.addActionListener(color3ChangeAction);
        jMenu5.add(miColor3);
        jMenu5.addSeparator();
        JMenu jMenu6 = (JMenu)jMenu5.add(new JMenu(rb.getString("menu.options.comp.display.colors.dual.name")));
        jMenu6.setName("mOptionsComponentsDisplayColorsDualColor");
        jMenu6.setMnemonic(rb.getString("menu.options.comp.display.colors.dual.mnemonic").charAt(0));
        miDual1 = new JMenuItem(rb.getString("menu.options.comp.display.colors.dual.dual1.name"));
        miDual1.setName("miDualColor1");
        miDual1.setMnemonic(rb.getString("menu.options.comp.display.colors.dual.dual1.mnemonic").charAt(0));
        miDual1.addActionListener(dual1ChangeAction);
        jMenu6.add(miDual1);
        miDual2 = new JMenuItem(rb.getString("menu.options.comp.display.colors.dual.dual2.name"));
        miDual2.setName("miDualColor2");
        miDual2.setMnemonic(rb.getString("menu.options.comp.display.colors.dual.dual2.mnemonic").charAt(0));
        miDual2.addActionListener(dual2ChangeAction);
        jMenu6.add(miDual2);
        JMenu jMenu7 = (JMenu)jMenu2.add(new JMenu(rb.getString("menu.options.tree.name")));
        jMenu7.setName("mOptionsTree");
        jMenu7.setMnemonic(rb.getString("menu.options.tree.mnemonic").charAt(0));
        miTreeEnable = new JCheckBoxMenuItem(rb.getString("menu.options.tree.enable.name"), true);
        miTreeEnable.setName("miOptionsTreeEnable");
        miTreeEnable.setMnemonic(rb.getString("menu.options.tree.enable.mnemonic").charAt(0));
        miTreeEnable.addActionListener(enableTreeAction);
        jMenu7.add(miTreeEnable);
        menubar.add(jMenu2);
        JMenu jMenu8 = new JMenu(rb.getString("menu.help.name"));
        jMenu8.setName("mHelp");
        jMenu8.setMnemonic(rb.getString("menu.help.mnemonic").charAt(0));
        menubar.add(jMenu8);
        jMenuItem = new JMenuItem(rb.getString("menu.help.about.name"));
        jMenuItem.setName("miAbout");
        jMenuItem.setMnemonic(rb.getString("menu.help.about.mnemonic").charAt(0));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingDemo.this.showAbout(pFrame);
            }
        });
        jMenu8.add(jMenuItem);
        menubar.add(jMenu8);
        menuComponentsPopup = new JPopupMenu();
        menuComponentsPopup.setName("mComponentsPopup");
        miComponentsPopupEnable = new JCheckBoxMenuItem(rb.getString("popup.comp.enable.name"), miComponentsEnable.getState());
        miComponentsPopupEnable.setName("miComponentsPopupEnable");
        miComponentsPopupEnable.setMnemonic(rb.getString("popup.comp.enable.mnemonic").charAt(0));
        miComponentsPopupEnable.addActionListener(enableComponentsPopupAction);
        menuComponentsPopup.add(miComponentsPopupEnable);
        JMenu jMenu9 = (JMenu)menuComponentsPopup.add(new JMenu(rb.getString("popup.comp.colors.name")));
        jMenu9.setName("mColorsPopup");
        jMenu9.setMnemonic(rb.getString("popup.comp.colors.mnemonic").charAt(0));
        jMenuItem = new JMenuItem(rb.getString("popup.comp.colors.normal.name"));
        jMenuItem.setName("miColorPopupNormal");
        jMenuItem.setMnemonic(rb.getString("popup.comp.colors.normal.mnemonic").charAt(0));
        jMenuItem.addActionListener(colorNormalChangeAction);
        jMenu9.add(jMenuItem);
        jMenuItem = new JMenuItem(rb.getString("popup.comp.colors.color1.name"));
        jMenuItem.setName("miColorPopup1");
        jMenuItem.setMnemonic(rb.getString("popup.comp.colors.color1.mnemonic").charAt(0));
        jMenuItem.addActionListener(color1ChangeAction);
        jMenu9.add(jMenuItem);
        jMenuItem = new JMenuItem(rb.getString("popup.comp.colors.color2.name"));
        jMenuItem.setName("miColorPopup2");
        jMenuItem.setMnemonic(rb.getString("popup.comp.colors.color2.mnemonic").charAt(0));
        jMenuItem.addActionListener(color2ChangeAction);
        jMenu9.add(jMenuItem);
        jMenuItem = new JMenuItem(rb.getString("popup.comp.colors.color3.name"));
        jMenuItem.setName("miColorPopup3");
        jMenuItem.setMnemonic(rb.getString("popup.comp.colors.color3.mnemonic").charAt(0));
        jMenuItem.addActionListener(color3ChangeAction);
        jMenu9.add(jMenuItem);
        menuTextAreaPopup = new JPopupMenu();
        menuTextAreaPopup.setName("mTextFieldPopup");
        miTextAreaPopupItem1 = new JMenuItem(rb.getString("popup.text.1.name"));
        miTextAreaPopupItem1.setName("miTextAreaPopupFox");
        miTextAreaPopupItem1.setMnemonic(rb.getString("popup.text.1.mnemonic").charAt(0));
        miTextAreaPopupItem1.addActionListener(textArea1PopupAction);
        menuTextAreaPopup.add(miTextAreaPopupItem1);
        miTextAreaPopupItem2 = new JMenuItem(rb.getString("popup.text.2.name"));
        miTextAreaPopupItem2.setName("miTextAreaPopupTaxi");
        miTextAreaPopupItem2.setMnemonic(rb.getString("popup.text.2.mnemonic").charAt(0));
        miTextAreaPopupItem2.addActionListener(textArea2PopupAction);
        menuTextAreaPopup.add(miTextAreaPopupItem2);
    }

    public void setupMiscPane() {
        Grid grid = new Grid();
        grid.setName("MiscGrid");
        componentLabel = new JLabel();
        componentLabel.setName("componentLabel");
        grid.addLine(new Component[]{componentLabel});
        field1 = new JTextField("");
        field1.setName("field1");
        field1.setPreferredSize(new Dimension(380, SwingDemo.field1.getPreferredSize().height));
        field1.setEnabled(true);
        field1.setBorder(BorderFactory.createEtchedBorder());
        field1Label = new JLabel(rb.getString("tabbed.misc.field1.label"));
        field1Label.setName("field1Label");
        grid.addLine(new Component[]{field1Label, field1});
        field2 = new JTextField("");
        field2.setName("field2");
        field2.setPreferredSize(new Dimension(380, SwingDemo.field2.getPreferredSize().height));
        field2.setEnabled(true);
        field2.setBorder(BorderFactory.createEtchedBorder());
        field2Label = new JLabel(rb.getString("tabbed.misc.field2.label"));
        field2Label.setName("field2Label");
        grid.addLine(new Component[]{field2Label, field2});
        textArea = new JTextArea(rb.getString("tabbed.misc.area.content"));
        textArea.setName("textArea");
        textArea.setLineWrap(true);
        textArea.setPreferredSize(new Dimension(300, 100));
        textArea.setBorder(BorderFactory.createEtchedBorder());
        areaLabel = new JLabel(rb.getString("tabbed.misc.area.label"));
        areaLabel.setName("field2Label");
        grid.addLine(new Component[]{areaLabel});
        grid.addLine(new Component[]{textArea});
        checkbox1 = new JCheckBox(rb.getString("tabbed.misc.checkbox.small"));
        checkbox1.setName("checkBoxSmall");
        checkbox1.setBorder(BorderFactory.createEtchedBorder());
        checkbox2 = new JCheckBox(rb.getString("tabbed.misc.checkbox.large"));
        checkbox2.setName("checkBoxLarge");
        checkbox2.setBorder(BorderFactory.createEtchedBorder());
        checkboxLabel = new JLabel(rb.getString("tabbed.misc.checkbox.label"));
        checkboxLabel.setName("checkboxes");
        grid.addLine(new Component[]{checkboxLabel, checkbox1, checkbox2});
        grid.addGlue();
        tabbed.add(new String(rb.getString("tabbed.misc")), (Component)grid);
    }

    public void setupListPane() {
        Grid grid = new Grid();
        grid.setName("ListGrid");
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(rb.getString("tabbed.list.colors.red"));
        defaultListModel.addElement(rb.getString("tabbed.list.colors.green"));
        defaultListModel.addElement(rb.getString("tabbed.list.colors.blue"));
        defaultListModel.addElement(rb.getString("tabbed.list.colors.yello"));
        defaultListModel.addElement(rb.getString("tabbed.list.colors.cyan"));
        defaultListModel.addElement(rb.getString("tabbed.list.colors.magenta"));
        leftList = new DNDList((ListModel)defaultListModel);
        leftList.setName(rb.getString("tabbed.list.colors.left"));
        leftList.setVisibleRowCount(3);
        JScrollPane jScrollPane = new JScrollPane(leftList);
        jScrollPane.setName("left pane");
        DefaultListModel<String> defaultListModel2 = new DefaultListModel<String>();
        defaultListModel2.addElement(rb.getString("tabbed.list.colors.orange"));
        defaultListModel2.addElement(rb.getString("tabbed.list.colors.mauve"));
        defaultListModel2.addElement(rb.getString("tabbed.list.colors.khaki"));
        defaultListModel2.addElement(rb.getString("tabbed.list.colors.pink"));
        defaultListModel2.addElement(rb.getString("tabbed.list.colors.seagreen"));
        rightList = new DNDList((ListModel)defaultListModel2);
        rightList.setName(rb.getString("tabbed.list.colors.right"));
        rightList.setVisibleRowCount(3);
        JScrollPane jScrollPane2 = new JScrollPane(rightList);
        jScrollPane2.setName("right pane");
        JLabel jLabel = new JLabel(rb.getString("tabbed.list.list.label"));
        jLabel.setName("ListLabel");
        grid.addLine(new Component[]{jLabel}, 0.0);
        grid.addLine(new Component[]{jScrollPane, jScrollPane2}, 0.0);
        String[] stringArray = new String[]{"Hello", "Bonjour", "Guten Tag", "Ciao", "Hola", "Hej"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setName("Combo");
        JLabel jLabel2 = new JLabel(rb.getString("tabbed.list.combo.label"));
        jLabel.setName("ComboLabel");
        grid.addLine(new Component[]{jLabel2});
        grid.addLine(new Component[]{jComboBox});
        try {
            Component component = (Component)Class.forName("javax.swing.JSpinner").newInstance();
            component.setName("Spinner");
            JLabel jLabel3 = new JLabel(rb.getString("tabbed.list.spinner.label"));
            jLabel3.setName("SpinnerLabel");
            grid.addLine(new Component[]{jLabel3}, 0.0);
            grid.addLine(new Component[]{new JLabel(), component, new JLabel()}, 0.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        grid.addGlue();
        tabbed.add(new String(rb.getString("tabbed.list")), (Component)grid);
    }

    public void setupTablePane() {
        Object[] objectArray;
        Grid grid = new Grid();
        grid.setName("TableGrid");
        Object[][] objectArray2 = new Object[][]{{"2001", "5061", "8500", "EUR"}, {"2002", "4985", "9400", "EUR"}, {"2003", "6200", "9400", "USD"}};
        if (rb.getLocale() == Locale.GERMAN) {
            Object[] objectArray3 = new String[4];
            objectArray3[0] = "Jahr";
            objectArray3[1] = "Ausgaben";
            objectArray3[2] = "Einnahmen";
            objectArray = objectArray3;
            objectArray3[3] = "W\u00e4hrung";
        } else {
            String[] stringArray = new String[4];
            stringArray[0] = "Year";
            stringArray[1] = "Expenses";
            stringArray[2] = "Income";
            objectArray = stringArray;
            stringArray[3] = "Currency";
        }
        Object[] objectArray4 = objectArray;
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray2, objectArray4){

            public Class getColumnClass(int n) {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return Integer.class;
                    }
                    case 3: {
                        return String.class;
                    }
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 > 0;
            }
        };
        JTable jTable = new JTable(defaultTableModel){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                super.editingStopped(changeEvent);
                if (this.getSelectedRow() >= 0) {
                    this.scrollRectToVisible(this.getCellRect(this.getSelectedRow(), this.getEditingColumn(), true));
                }
            }
        };
        jTable.setName("Table");
        jTable.getTableHeader().setName("TableHeader");
        String[] stringArray = new String[]{"EUR", "USD"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(3);
        tableColumn.setCellEditor(defaultCellEditor);
        JLabel jLabel = new JLabel(rb.getString("tabbed.table.table.label"));
        grid.addLine(new Component[]{jLabel});
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setName("TablePane");
        jScrollPane.setPreferredSize(new Dimension(250, 80));
        grid.addLine(new Component[]{jScrollPane}, 1.0);
        tree = new JTree();
        tree.setName("Tree");
        JLabel jLabel2 = new JLabel(rb.getString("tabbed.table.tree.label"));
        JScrollPane jScrollPane2 = new JScrollPane(tree);
        jScrollPane2.setName("TreePane");
        jScrollPane2.setPreferredSize(new Dimension(380, 150));
        jLabel2.setName("TreeLabel");
        grid.addLine(new Component[]{jLabel2});
        grid.addLine(new Component[]{jScrollPane2}, 1.0);
        tabbed.add(new String(rb.getString("tabbed.table")), (Component)grid);
    }

    public void setupPopupListeners() {
        componentLabel.addMouseListener(new PopupListener());
        field1.addMouseListener(new PopupListener());
        field1Label.addMouseListener(new PopupListener());
        field2.addMouseListener(new PopupListener());
        field2Label.addMouseListener(new PopupListener());
        textArea.addMouseListener(new PopupListener());
        areaLabel.addMouseListener(new PopupListener());
        checkboxLabel.addMouseListener(new PopupListener());
        checkbox1.addMouseListener(new PopupListener());
        checkbox2.addMouseListener(new PopupListener());
    }

    public void setupActions() {
        resetAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingDemo.this.reset();
            }
        };
        fileOpenAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                String string = "0";
                String string2 = "0";
                JFileChooser jFileChooser = SwingUtil.createFileChooser(null, null, null);
                jFileChooser.setName("openDialog");
                jFileChooser.setDialogType(0);
                jFileChooser.setDialogTitle("Select input file");
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.showOpenDialog(pFrame);
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(jFileChooser.getName(file));
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                        String string3 = bufferedReader.readLine();
                        if (string3 != null) {
                            // empty if block
                        }
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        fileSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                JFileChooser jFileChooser = SwingUtil.createFileChooser(null, null, null);
                jFileChooser.setName("saveDialog");
                jFileChooser.setDialogType(1);
                jFileChooser.setDialogTitle("Save input file");
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.showSaveDialog(pFrame);
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(jFileChooser.getName(file));
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                        outputStreamWriter.write("#");
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        enableComponentsAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                miComponentsPopupEnable.setState(miComponentsEnable.getState());
                SwingDemo.enableComponents(miComponentsEnable.getState());
            }
        };
        enableComponentsPopupAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                miComponentsEnable.setState(miComponentsPopupEnable.getState());
                SwingDemo.enableComponents(miComponentsPopupEnable.getState());
            }
        };
        enableTreeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                tree.setEnabled(miTreeEnable.getState());
            }
        };
        colorNormalChangeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                componentLabel.setText("Components");
                SwingDemo.changeComponentColor(defaultFgCl, defaultBkgCl);
            }
        };
        color1ChangeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                componentLabel.setText("Components (in Pink)");
                SwingDemo.changeComponentColor(Color.pink, defaultBkgCl);
            }
        };
        color2ChangeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                componentLabel.setText("Components (in Magenta)");
                SwingDemo.changeComponentColor(Color.magenta, defaultBkgCl);
            }
        };
        color3ChangeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                componentLabel.setText("Components (in Red)");
                SwingDemo.changeComponentColor(Color.red, defaultBkgCl);
            }
        };
        dual1ChangeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                componentLabel.setText("Components (in dual colors: Black/White)");
                SwingDemo.changeComponentColor(Color.white, Color.black);
            }
        };
        dual2ChangeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                componentLabel.setText("Components (in dual colors: Blue/Cyan)");
                SwingDemo.changeComponentColor(Color.cyan, Color.blue);
            }
        };
        textArea1PopupAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                textArea.setText("The quick brown fox jumps over the lazy dog.");
            }
        };
        textArea2PopupAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                textArea.setText("Franz jagt in einem komplett verwahrlosten Taxi quer durch Bayern.");
            }
        };
    }

    public static void changeComponentColor(Color color, Color color2) {
        componentLabel.setForeground(color);
        componentLabel.setBackground(color2);
        field1.setBackground(color2);
        field1Label.setBackground(color2);
        field2.setBackground(color2);
        field2Label.setBackground(color2);
        textArea.setBackground(color2);
        checkbox1.setBackground(color2);
        checkbox2.setBackground(color2);
        checkboxLabel.setBackground(color2);
        field1.setForeground(color);
        field1Label.setForeground(color);
        field2.setForeground(color);
        field2Label.setForeground(color);
        textArea.setForeground(color);
        areaLabel.setForeground(color);
        checkbox1.setForeground(color);
        checkbox2.setForeground(color);
        checkboxLabel.setForeground(color);
    }

    public static void enableComponents(boolean bl) {
        field1.setEnabled(bl);
        field2.setEnabled(bl);
        textArea.setEnabled(bl);
        checkbox1.setEnabled(bl);
        checkbox2.setEnabled(bl);
    }

    public void showAbout(Frame frame) {
        JOptionPane.showMessageDialog(frame, "QF-Test        Swing Demo\nCopyright           (C)2005\nQuality First Software GmbH\n", "About", 1);
    }

    public void reset() {
        miComponentsPopupEnable.setEnabled(true);
        miComponentsEnable.setEnabled(true);
        miTreeEnable.setEnabled(true);
        tabbed.removeAll();
        this.setupMiscPane();
        this.setupListPane();
        this.setupTablePane();
        this.setupPopupListeners();
    }

    static {
        defaultBkgCl = Color.white;
        defaultFgCl = Color.black;
    }

    public static class DNDList
    extends JList
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        DropTarget dropTarget = null;
        DragSource dragSource = null;
        int dragIndex;

        public DNDList(ListModel listModel) {
            super(listModel);
            this.setSelectionMode(0);
            this.dropTarget = new DropTarget(this, this);
            this.dragSource = DragSource.getDefaultDragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this, 0x40000003, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Rectangle rectangle;
            if (logger.level >= 7) {
                logger.log(7, "dragGestureRecognized(DragGestureEvent)", logger.level < 8 ? "" : "event: " + dragGestureEvent);
            }
            this.dragIndex = -1;
            int n = this.locationToIndex(dragGestureEvent.getDragOrigin());
            if (n >= 0 && n < this.getModel().getSize() && (rectangle = this.getCellBounds(n, n)).contains(dragGestureEvent.getDragOrigin())) {
                Object e = this.getModel().getElementAt(n);
                if (e != null) {
                    StringSelection stringSelection = new StringSelection(e.toString());
                    this.dragIndex = n;
                    this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, stringSelection, this);
                } else if (logger.level >= 5) {
                    logger.log(5, "dragGestureRecognized(DragGestureEvent)", "Nothing selected");
                }
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dragEnter(DropTargetDragEvent)", logger.level < 8 ? "" : "event: " + dropTargetDragEvent);
            }
            dropTargetDragEvent.acceptDrag(2);
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dragExit(DropTargetEvent)", logger.level < 8 ? "" : "event: " + dropTargetEvent);
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dragOver(DropTargetDragEvent)", logger.level < 8 ? "" : "event: " + dropTargetDragEvent);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (logger.level >= 7) {
                logger.log(7, "drop(DropTargetDropEvent)", logger.level < 8 ? "" : "event: " + dropTargetDropEvent);
            }
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    if (dropTargetDropEvent.getDropAction() == 2 || dropTargetDropEvent.getDropAction() == 1) {
                        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        ((DefaultListModel)this.getModel()).addElement(string);
                    }
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            }
            catch (IOException iOException) {
                if (logger.level >= 1) {
                    logger.log(1, "catch(IOException)", (Throwable)iOException);
                }
                dropTargetDropEvent.rejectDrop();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                if (logger.level >= 1) {
                    logger.log(1, "catch(UnsupportedFlavorException)", (Throwable)unsupportedFlavorException);
                }
                dropTargetDropEvent.rejectDrop();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dropActionChanged(DropTargetDragEvent)", logger.level < 8 ? "" : "event: " + dropTargetDragEvent);
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dragDropEnd(DragSourceDropEvent)", logger.level < 8 ? "" : "event: " + dragSourceDropEvent + ", success: " + dragSourceDropEvent.getDropSuccess() + ", action:" + dragSourceDropEvent.getDropAction() + ", dragIndex: " + this.dragIndex);
            }
            if (dragSourceDropEvent.getDropSuccess() && this.dragIndex >= 0 && (dragSourceDropEvent.getDropAction() == 2 || dragSourceDropEvent.getDropAction() == 0x40000000)) {
                ((DefaultListModel)this.getModel()).removeElementAt(this.dragIndex);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dragEnter(DragSourceDragEvent)", logger.level < 8 ? "" : "event: " + dragSourceDragEvent);
            }
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dragExit(DragSourceEvent)", logger.level < 8 ? "" : "event: " + dragSourceEvent);
            }
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dragOver(DragSourceDragEvent)", logger.level < 8 ? "" : "event: " + dragSourceDragEvent);
            }
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            if (logger.level >= 7) {
                logger.log(7, "dropActionChanged(DragSourceDragEvent)", logger.level < 8 ? "" : "event: " + dragSourceDragEvent);
            }
        }
    }

    public class PopupListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (((Component)mouseEvent.getSource()).equals(textArea)) {
                SwingUtil.showPopup((JPopupMenu)menuTextAreaPopup, (Component)((Component)mouseEvent.getSource()), (int)mouseEvent.getX(), (int)mouseEvent.getY(), (boolean)false);
            } else {
                SwingUtil.showPopup((JPopupMenu)menuComponentsPopup, (Component)((Component)mouseEvent.getSource()), (int)mouseEvent.getX(), (int)mouseEvent.getY(), (boolean)false);
            }
        }
    }
}

