/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.swt.addressbook;

import de.qfs.apps.qftest.demo.multi.Multi;
import de.qfs.apps.qftest.demo.swt.addressbook.DataEntryDialog;
import de.qfs.apps.qftest.demo.swt.addressbook.FindListener;
import de.qfs.apps.qftest.demo.swt.addressbook.SearchDialog;
import de.qfs.apps.qftest.demo.swt.addressbook.WidgetRegistry;
import de.qfs.lib.log.Logger;
import de.qfs.lib.util.ArgsParser;
import de.qfs.lib.util.LogSetup;
import de.qfs.lib.util.Reflector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class AddressBook {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.swt.addressbook.AddressBook");
    private static ResourceBundle resAddressBook = ResourceBundle.getBundle("de/qfs/apps/qftest/demo/swt/addressbook/resources/properties/addressbook");
    private Shell shell;
    private Table table;
    private SearchDialog searchDialog;
    private File file;
    private boolean isModified;
    private String[] copyBuffer;
    private int lastSortColumn = -1;
    private static final String DELIMITER = "\t";
    private static final String[] columnNames = new String[]{resAddressBook.getString("Last_name"), resAddressBook.getString("First_name"), resAddressBook.getString("Business_phone"), resAddressBook.getString("Home_phone"), resAddressBook.getString("Email"), resAddressBook.getString("Fax")};
    public static Display display;
    public static AddressBook ab;
    public Widget mFile;

    public static void main(String[] stringArray) {
        ArgsParser argsParser = new ArgsParser();
        LogSetup.instance().addOptions(argsParser);
        try {
            argsParser.parse(stringArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LogSetup.instance().setupLogging("addressbook", argsParser);
        Class<Display> clazz = Display.class;
        Reflector.safeGet(clazz, (String)"creationHooks", (boolean)true);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                ab = new AddressBook();
                ab.start();
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LogSetup.instance().stopLogging();
        System.exit(0);
    }

    public void start() {
        display = new Display();
        block2: while (true) {
            this.shell = this.open(display);
            while (true) {
                if (this.shell.isDisposed()) continue block2;
                try {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                    continue;
                }
                catch (Throwable throwable) {
                    System.err.println("Exception in read and dispatch loop:");
                    throwable.printStackTrace();
                    continue;
                }
                break;
            }
            break;
        }
    }

    public Shell open(Display display) {
        this.shell = new Shell(display);
        WidgetRegistry.add("AddressBook", this.shell);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                shellEvent.doit = AddressBook.this.closeAddressBook();
            }
        });
        this.createMenuBar();
        this.searchDialog = new SearchDialog(this.shell);
        this.searchDialog.setSearchAreaNames(columnNames);
        this.searchDialog.addFindListener(new FindListener(){

            @Override
            public boolean find() {
                return AddressBook.this.findEntry();
            }
        });
        this.createTable();
        this.newAddressBook();
        this.shell.setSize(this.table.computeSize((int)-1, (int)-1).x, 300);
        this.shell.open();
        return this.shell;
    }

    private boolean closeAddressBook() {
        int n;
        MessageBox messageBox;
        if (this.isModified) {
            messageBox = new MessageBox(this.shell, 456);
            WidgetRegistry.add("MBox.AskClose", messageBox);
            messageBox.setText(this.shell.getText());
            messageBox.setMessage(resAddressBook.getString("Close_save"));
            n = messageBox.open();
            if (n == 256) {
                return false;
            }
            if (n == 64 && !this.save()) {
                return false;
            }
        }
        messageBox = this.table.getItems();
        for (n = 0; n < ((MessageBox)messageBox).length; ++n) {
            messageBox[n].dispose();
        }
        return true;
    }

    private Menu createMenuBar() {
        Menu menu = new Menu((Decorations)this.shell, 2);
        WidgetRegistry.add("MenuBar", menu);
        this.shell.setMenuBar(menu);
        this.createFileMenu(menu);
        this.createEditMenu(menu);
        this.createSearchMenu(menu);
        this.createHelpMenu(menu);
        return menu;
    }

    private String[] decodeLine(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = new String[this.table.getColumnCount()];
        for (int i = 0; i < stringArray.length - 1; ++i) {
            int n = string.indexOf(DELIMITER);
            if (n <= -1) {
                return null;
            }
            stringArray[i] = string.substring(0, n);
            string = string.substring(n + DELIMITER.length(), string.length());
        }
        if (string.indexOf(DELIMITER) != -1) {
            return null;
        }
        stringArray[stringArray.length - 1] = string;
        return stringArray;
    }

    private void displayError(String string) {
        MessageBox messageBox = new MessageBox(this.shell, 1);
        WidgetRegistry.add("MBox.Error", messageBox);
        messageBox.setMessage(string);
        messageBox.open();
    }

    private void editEntry(TableItem tableItem) {
        DataEntryDialog dataEntryDialog = new DataEntryDialog(this.shell);
        dataEntryDialog.setLabels(columnNames);
        String[] stringArray = new String[this.table.getColumnCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = tableItem.getText(i);
        }
        dataEntryDialog.setValues(stringArray);
        stringArray = dataEntryDialog.open();
        if (stringArray != null) {
            tableItem.setText(stringArray);
            this.isModified = true;
        }
    }

    private String encodeLine(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            string = string + stringArray[i] + DELIMITER;
        }
        string = string + stringArray[stringArray.length - 1] + "\n";
        return string;
    }

    private boolean findEntry() {
        Cursor cursor = new Cursor((Device)this.shell.getDisplay(), 1);
        this.shell.setCursor(cursor);
        boolean bl = this.searchDialog.getMatchCase();
        boolean bl2 = this.searchDialog.getMatchWord();
        String string = this.searchDialog.getSearchString();
        int n = this.searchDialog.getSelectedSearchArea();
        string = bl ? string : string.toLowerCase();
        boolean bl3 = false;
        if (this.searchDialog.getSearchDown()) {
            for (int i = this.table.getSelectionIndex() + 1; i < this.table.getItemCount(); ++i) {
                bl3 = this.findMatch(string, this.table.getItem(i), n, bl2, bl);
                if (!bl3) continue;
                this.table.setSelection(i);
                break;
            }
        } else {
            for (int i = this.table.getSelectionIndex() - 1; i > -1; --i) {
                bl3 = this.findMatch(string, this.table.getItem(i), n, bl2, bl);
                if (!bl3) continue;
                this.table.setSelection(i);
                break;
            }
        }
        this.shell.setCursor(null);
        if (cursor != null) {
            cursor.dispose();
        }
        return bl3;
    }

    private boolean findMatch(String string, TableItem tableItem, int n, boolean bl, boolean bl2) {
        String string2;
        String string3 = string2 = bl2 ? tableItem.getText(n) : tableItem.getText(n).toLowerCase();
        return bl ? string2 != null && string2.equals(string) : string2 != null && string2.indexOf(string) != -1;
    }

    private void newAddressBook() {
        this.shell.setText(resAddressBook.getString("Title_bar") + resAddressBook.getString("New_title"));
        this.file = null;
        this.isModified = false;
    }

    private void newEntry() {
        DataEntryDialog dataEntryDialog = new DataEntryDialog(this.shell);
        dataEntryDialog.setLabels(columnNames);
        String[] stringArray = dataEntryDialog.open();
        if (stringArray != null) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(stringArray);
            this.isModified = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openAddressBook() {
        int n;
        Object object;
        FileDialog fileDialog = new FileDialog(this.shell, 4096);
        WidgetRegistry.add("FileDialog", fileDialog);
        fileDialog.setFilterExtensions(new String[]{"*.adr;", "*.*"});
        fileDialog.setFilterNames(new String[]{resAddressBook.getString("Book_filter_name") + " (*.adr)", resAddressBook.getString("All_filter_name") + " (*.*)"});
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            this.displayError(resAddressBook.getString("File") + file.getName() + " " + resAddressBook.getString("Does_not_exist"));
            return;
        }
        Cursor cursor = new Cursor((Device)this.shell.getDisplay(), 1);
        this.shell.setCursor(cursor);
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        String[] stringArray = new String[]{};
        try {
            fileReader = new FileReader(file.getAbsolutePath());
            bufferedReader = new BufferedReader(fileReader);
            object = bufferedReader.readLine();
            while (object != null) {
                String[] stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[stringArray.length] = object;
                stringArray = stringArray2;
                object = bufferedReader.readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.displayError(resAddressBook.getString("File_not_found") + "\n" + file.getName());
            return;
        }
        catch (IOException iOException) {
            this.displayError(resAddressBook.getString("IO_error_read") + "\n" + file.getName());
            return;
        }
        finally {
            this.shell.setCursor(null);
            cursor.dispose();
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {
                    this.displayError(resAddressBook.getString("IO_error_close") + "\n" + file.getName());
                    return;
                }
            }
        }
        object = new String[stringArray.length][this.table.getColumnCount()];
        for (n = 0; n < stringArray.length; ++n) {
            object[n] = this.decodeLine(stringArray[n]);
        }
        Arrays.sort(object, new RowComparator(0));
        for (n = 0; n < ((String[][])object).length; ++n) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(object[n]);
        }
        this.shell.setText(resAddressBook.getString("Title_bar") + fileDialog.getFileName());
        this.isModified = false;
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save() {
        boolean bl;
        if (this.file == null) {
            return this.saveAs();
        }
        Cursor cursor = new Cursor((Device)this.shell.getDisplay(), 1);
        this.shell.setCursor(cursor);
        TableItem[] tableItemArray = this.table.getItems();
        String[] stringArray = new String[tableItemArray.length];
        for (int i = 0; i < tableItemArray.length; ++i) {
            String[] stringArray2 = new String[this.table.getColumnCount()];
            for (bl = false; bl < stringArray2.length; bl += 1) {
                stringArray2[bl] = tableItemArray[i].getText(bl ? 1 : 0);
            }
            stringArray[i] = this.encodeLine(stringArray2);
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.file.getAbsolutePath(), false);
            for (int i = 0; i < stringArray.length; ++i) {
                fileWriter.write(stringArray[i]);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.displayError(resAddressBook.getString("File_not_found") + "\n" + this.file.getName());
            bl = false;
            return bl;
        }
        catch (IOException iOException) {
            this.displayError(resAddressBook.getString("IO_error_write") + "\n" + this.file.getName());
            bl = false;
            return bl;
        }
        finally {
            this.shell.setCursor(null);
            cursor.dispose();
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    this.displayError(resAddressBook.getString("IO_error_close") + "\n" + this.file.getName());
                    return false;
                }
            }
        }
        this.shell.setText(resAddressBook.getString("Title_bar") + this.file.getName());
        this.isModified = false;
        return true;
    }

    private boolean saveAs() {
        File file;
        FileDialog fileDialog = new FileDialog(this.shell, 8192);
        WidgetRegistry.add("SaveDialog", fileDialog);
        fileDialog.setFilterExtensions(new String[]{"*.adr;", "*.*"});
        fileDialog.setFilterNames(new String[]{"Address Books (*.adr)", "All Files "});
        fileDialog.open();
        String string = fileDialog.getFileName();
        if (string.equals("")) {
            return false;
        }
        if (string.indexOf(".adr") != string.length() - 4) {
            string = string + ".adr";
        }
        if ((file = new File(fileDialog.getFilterPath(), string)).exists()) {
            MessageBox messageBox = new MessageBox(this.shell, 200);
            WidgetRegistry.add("MBox.FileExists", messageBox);
            messageBox.setText(resAddressBook.getString("Save_as_title"));
            messageBox.setMessage(resAddressBook.getString("File") + file.getName() + " " + resAddressBook.getString("Query_overwrite"));
            if (messageBox.open() != 64) {
                return false;
            }
        }
        this.file = file;
        return this.save();
    }

    private void sort(int n) {
        int n2;
        int n3;
        if (this.table.getItemCount() <= 1) {
            return;
        }
        TableItem[] tableItemArray = this.table.getItems();
        String[][] stringArray = new String[tableItemArray.length][this.table.getColumnCount()];
        for (n3 = 0; n3 < tableItemArray.length; ++n3) {
            for (n2 = 0; n2 < this.table.getColumnCount(); ++n2) {
                stringArray[n3][n2] = tableItemArray[n3].getText(n2);
            }
        }
        Arrays.sort(stringArray, new RowComparator(n));
        if (this.lastSortColumn != n) {
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                tableItemArray[n3].setText(stringArray[n3]);
            }
            this.lastSortColumn = n;
        } else {
            n3 = stringArray.length - 1;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                tableItemArray[n2].setText(stringArray[n3--]);
            }
            this.lastSortColumn = -1;
        }
    }

    private void createFileMenu(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 64);
        WidgetRegistry.add("MenuFile", menuItem);
        this.mFile = menuItem;
        menuItem.setText(resAddressBook.getString("File_menu_title"));
        Menu menu2 = new Menu((Decorations)this.shell, 4);
        WidgetRegistry.add("MenuFile.Menu", menu2);
        menuItem.setMenu(menu2);
        menu2.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                Menu menu = (Menu)menuEvent.widget;
                MenuItem[] menuItemArray = menu.getItems();
                menuItemArray[1].setEnabled(AddressBook.this.table.getSelectionCount() != 0);
                menuItemArray[5].setEnabled(AddressBook.this.file != null && AddressBook.this.isModified);
                menuItemArray[6].setEnabled(AddressBook.this.table.getItemCount() != 0);
            }
        });
        MenuItem menuItem2 = new MenuItem(menu2, 0);
        WidgetRegistry.add("MenuFile.NewContact", menuItem2);
        menuItem2.setText(resAddressBook.getString("New_contact"));
        menuItem2.setAccelerator(SWT.MOD1 + 78);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddressBook.this.newEntry();
            }
        });
        menuItem2 = new MenuItem(menu2, 0);
        WidgetRegistry.add("MenuFile.Edit", menuItem2);
        menuItem2.setText(resAddressBook.getString("Edit_contact"));
        menuItem2.setAccelerator(SWT.MOD1 + 69);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = AddressBook.this.table.getSelection();
                if (tableItemArray.length == 0) {
                    return;
                }
                AddressBook.this.editEntry(tableItemArray[0]);
            }
        });
        new MenuItem(menu2, 2);
        menuItem2 = new MenuItem(menu2, 0);
        WidgetRegistry.add("MenuFile.NewAddressBook", menuItem2);
        menuItem2.setText(resAddressBook.getString("New_address_book"));
        menuItem2.setAccelerator(SWT.MOD1 + 66);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (AddressBook.this.closeAddressBook()) {
                    AddressBook.this.newAddressBook();
                }
            }
        });
        menuItem2 = new MenuItem(menu2, 0);
        WidgetRegistry.add("MenuFile.Open", menuItem2);
        menuItem2.setText(resAddressBook.getString("Open_address_book"));
        menuItem2.setAccelerator(SWT.MOD1 + 79);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (AddressBook.this.closeAddressBook()) {
                    AddressBook.this.openAddressBook();
                }
            }
        });
        menuItem2 = new MenuItem(menu2, 0);
        WidgetRegistry.add("MenuFile.Save", menuItem2);
        menuItem2.setText(resAddressBook.getString("Save_address_book"));
        menuItem2.setAccelerator(SWT.MOD1 + 83);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddressBook.this.save();
            }
        });
        menuItem2 = new MenuItem(menu2, 0);
        WidgetRegistry.add("MenuFile.SaveAs", menuItem2);
        menuItem2.setText(resAddressBook.getString("Save_book_as"));
        menuItem2.setAccelerator(SWT.MOD1 + 65);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddressBook.this.saveAs();
            }
        });
        new MenuItem(menu2, 2);
        menuItem2 = new MenuItem(menu2, 0);
        WidgetRegistry.add("MenuFile.Exit", menuItem2);
        menuItem2.setText(resAddressBook.getString("Exit"));
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddressBook.this.shell.close();
            }
        });
    }

    private MenuItem createEditMenu(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 64);
        WidgetRegistry.add("MenuEdit", menuItem);
        menuItem.setText(resAddressBook.getString("Edit_menu_title"));
        Menu menu2 = new Menu((Decorations)this.shell, 4);
        WidgetRegistry.add("MenuEdit.Menu", menu2);
        menuItem.setMenu(menu2);
        menu2.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                Menu menu = (Menu)menuEvent.widget;
                MenuItem[] menuItemArray = menu.getItems();
                int n = AddressBook.this.table.getSelectionCount();
                menuItemArray[0].setEnabled(n != 0);
                menuItemArray[1].setEnabled(n != 0);
                menuItemArray[2].setEnabled(AddressBook.this.copyBuffer != null);
                menuItemArray[3].setEnabled(n != 0);
                menuItemArray[5].setEnabled(AddressBook.this.table.getItemCount() != 0);
            }
        });
        MenuItem menuItem2 = new MenuItem(menu2, 64);
        WidgetRegistry.add("MenuEdit.Edit", menuItem2);
        menuItem2.setText(resAddressBook.getString("Edit"));
        menuItem2.setAccelerator(SWT.MOD1 + 69);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = AddressBook.this.table.getSelection();
                if (tableItemArray.length == 0) {
                    return;
                }
                AddressBook.this.editEntry(tableItemArray[0]);
            }
        });
        menuItem2 = new MenuItem(menu2, 0);
        WidgetRegistry.add("MenuEdit.Copy", menuItem2);
        menuItem2.setText(resAddressBook.getString("Copy"));
        menuItem2.setAccelerator(SWT.MOD1 + 67);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = AddressBook.this.table.getSelection();
                if (tableItemArray.length == 0) {
                    return;
                }
                AddressBook.access$1202(AddressBook.this, new String[AddressBook.this.table.getColumnCount()]);
                for (int i = 0; i < AddressBook.this.copyBuffer.length; ++i) {
                    ((AddressBook)AddressBook.this).copyBuffer[i] = tableItemArray[0].getText(i);
                }
            }
        });
        menuItem2 = new MenuItem(menu2, 0);
        WidgetRegistry.add("MenuEdit.Paste", menuItem2);
        menuItem2.setText(resAddressBook.getString("Paste"));
        menuItem2.setAccelerator(SWT.MOD1 + 86);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (AddressBook.this.copyBuffer == null) {
                    return;
                }
                TableItem tableItem = new TableItem(AddressBook.this.table, 0);
                tableItem.setText(AddressBook.this.copyBuffer);
                AddressBook.this.isModified = true;
            }
        });
        menuItem2 = new MenuItem(menu2, 0);
        WidgetRegistry.add("MenuEdit.Delete", menuItem2);
        menuItem2.setText(resAddressBook.getString("Delete"));
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = AddressBook.this.table.getSelection();
                if (tableItemArray.length == 0) {
                    return;
                }
                tableItemArray[0].dispose();
                AddressBook.this.isModified = true;
            }
        });
        new MenuItem(menu2, 2);
        menuItem2 = new MenuItem(menu2, 64);
        WidgetRegistry.add("MenuEdit.Sort", menuItem2);
        menuItem2.setText(resAddressBook.getString("Sort"));
        Menu menu3 = this.createSortMenu();
        menuItem2.setMenu(menu3);
        return menuItem;
    }

    private Menu createSortMenu() {
        Menu menu = new Menu((Decorations)this.shell, 4);
        WidgetRegistry.add("MenuSort.Menu", menu);
        int n = 0;
        while (n < columnNames.length) {
            MenuItem menuItem = new MenuItem(menu, 0);
            WidgetRegistry.add("MenuSort." + columnNames[n], menuItem);
            menuItem.setText(columnNames[n]);
            final int n2 = n++;
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AddressBook.this.sort(n2);
                }
            });
        }
        return menu;
    }

    private void createSearchMenu(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 64);
        WidgetRegistry.add("MenuSearch", menuItem);
        menuItem.setText(resAddressBook.getString("Search_menu_title"));
        Menu menu2 = new Menu((Decorations)this.shell, 4);
        WidgetRegistry.add("MenuSearch.Menu", menu2);
        menuItem.setMenu(menu2);
        menuItem = new MenuItem(menu2, 0);
        WidgetRegistry.add("MenuSearch.Find", menuItem);
        menuItem.setText(resAddressBook.getString("Find"));
        menuItem.setAccelerator(SWT.MOD1 + 70);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddressBook.this.searchDialog.setMatchCase(false);
                AddressBook.this.searchDialog.setMatchWord(false);
                AddressBook.this.searchDialog.setSearchDown(true);
                AddressBook.this.searchDialog.setSearchString("");
                AddressBook.this.searchDialog.setSelectedSearchArea(0);
                AddressBook.this.searchDialog.open();
            }
        });
        menuItem = new MenuItem(menu2, 0);
        WidgetRegistry.add("MenuSearch.Next", menuItem);
        menuItem.setText(resAddressBook.getString("Find_next"));
        menuItem.setAccelerator(0x100000C);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddressBook.this.searchDialog.open();
            }
        });
    }

    private Menu createPopUpMenu() {
        Menu menu = new Menu((Decorations)this.shell, 8);
        WidgetRegistry.add("Table.Popup", menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                Menu menu = (Menu)menuEvent.widget;
                MenuItem[] menuItemArray = menu.getItems();
                int n = AddressBook.this.table.getSelectionCount();
                menuItemArray[2].setEnabled(n != 0);
                menuItemArray[3].setEnabled(n != 0);
                menuItemArray[4].setEnabled(AddressBook.this.copyBuffer != null);
                menuItemArray[5].setEnabled(n != 0);
                menuItemArray[7].setEnabled(AddressBook.this.table.getItemCount() != 0);
            }
        });
        MenuItem menuItem = new MenuItem(menu, 64);
        WidgetRegistry.add("Popup.New", menuItem);
        menuItem.setText(resAddressBook.getString("Pop_up_new"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddressBook.this.newEntry();
            }
        });
        new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 64);
        WidgetRegistry.add("Popup.Edit", menuItem);
        menuItem.setText(resAddressBook.getString("Pop_up_edit"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = AddressBook.this.table.getSelection();
                if (tableItemArray.length == 0) {
                    return;
                }
                AddressBook.this.editEntry(tableItemArray[0]);
            }
        });
        menuItem = new MenuItem(menu, 64);
        WidgetRegistry.add("Popup.Copy", menuItem);
        menuItem.setText(resAddressBook.getString("Pop_up_copy"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = AddressBook.this.table.getSelection();
                if (tableItemArray.length == 0) {
                    return;
                }
                AddressBook.access$1202(AddressBook.this, new String[AddressBook.this.table.getColumnCount()]);
                for (int i = 0; i < AddressBook.this.copyBuffer.length; ++i) {
                    ((AddressBook)AddressBook.this).copyBuffer[i] = tableItemArray[0].getText(i);
                }
            }
        });
        menuItem = new MenuItem(menu, 64);
        WidgetRegistry.add("Popup.Paste", menuItem);
        menuItem.setText(resAddressBook.getString("Pop_up_paste"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (AddressBook.this.copyBuffer == null) {
                    return;
                }
                TableItem tableItem = new TableItem(AddressBook.this.table, 0);
                tableItem.setText(AddressBook.this.copyBuffer);
                AddressBook.this.isModified = true;
            }
        });
        menuItem = new MenuItem(menu, 64);
        WidgetRegistry.add("Popup.Delete", menuItem);
        menuItem.setText(resAddressBook.getString("Pop_up_delete"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = AddressBook.this.table.getSelection();
                if (tableItemArray.length == 0) {
                    return;
                }
                tableItemArray[0].dispose();
                AddressBook.this.isModified = true;
            }
        });
        new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 0);
        WidgetRegistry.add("Popup.Find", menuItem);
        menuItem.setText(resAddressBook.getString("Pop_up_find"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddressBook.this.searchDialog.open();
            }
        });
        menuItem = new MenuItem(menu, 64);
        WidgetRegistry.add("Popup.Cascade", menuItem);
        menuItem.setText("Cascade");
        Menu menu2 = new Menu((Decorations)this.shell, 4);
        WidgetRegistry.add("Popup.Test", menu2);
        menuItem.setMenu(menu2);
        menuItem = new MenuItem(menu2, 64);
        WidgetRegistry.add("Popup.Cascade.Test", menuItem);
        menuItem.setText("Test");
        Menu menu3 = new Menu((Decorations)this.shell, 4);
        WidgetRegistry.add("Popup.Cascade.Nested", menu2);
        menuItem.setMenu(menu3);
        menuItem = new MenuItem(menu3, 0);
        WidgetRegistry.add("Popup.Cascade.Test.Nested", menuItem);
        menuItem.setText("Nest");
        return menu;
    }

    private void createHelpMenu(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 64);
        WidgetRegistry.add("MenuHelp", menuItem);
        menuItem.setText(resAddressBook.getString("Help_menu_title"));
        Menu menu2 = new Menu((Decorations)this.shell, 4);
        WidgetRegistry.add("MenuHelp.Menu", menu2);
        menuItem.setMenu(menu2);
        MenuItem menuItem2 = new MenuItem(menu2, 0);
        WidgetRegistry.add("MenuHelp.About", menuItem2);
        menuItem2.setText(resAddressBook.getString("About"));
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MessageBox messageBox = new MessageBox(AddressBook.this.shell, 0);
                WidgetRegistry.add("Message.About", messageBox);
                messageBox.setText(resAddressBook.getString("About_1") + AddressBook.this.shell.getText());
                messageBox.setMessage(AddressBook.this.shell.getText() + resAddressBook.getString("About_2"));
                int n = messageBox.open();
            }
        });
        menuItem2 = new MenuItem(menu2, 0);
        WidgetRegistry.add("MenuHelp.Multi", menuItem2);
        menuItem2.setText("Run Swing multi demo");
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                new Thread(){

                    @Override
                    public void run() {
                        Multi.main(new String[0]);
                    }
                }.start();
            }
        });
    }

    public Table getTable() {
        return this.table;
    }

    public Table createTable() {
        this.table = new Table((Composite)this.shell, 67620);
        WidgetRegistry.add("Table", this.table);
        this.table.setHeaderVisible(true);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                if (mouseEvent.button == 3) {
                    Menu menu = AddressBook.this.createPopUpMenu();
                    Point point = AddressBook.this.table.toDisplay(mouseEvent.x, mouseEvent.y);
                    menu.setLocation(point.x, point.y);
                    menu.setVisible(true);
                    if (logger.level >= 9) {
                        logger.log(9, "mouseDown(MouseEvent)", "Starting inner loop");
                    }
                    if (logger.level >= 9) {
                        logger.build("mouseDown(MouseEvent)").add("vis: ").add(menu.isVisible()).log(9);
                    }
                    while (!menu.isDisposed() && menu.isVisible()) {
                        if (logger.level >= 9) {
                            logger.log(9, "mouseDown(MouseEvent)", "Calling readAndDispatch");
                        }
                        if (!AddressBook.this.table.getDisplay().readAndDispatch()) {
                            if (logger.level >= 9) {
                                logger.log(9, "mouseDown(MouseEvent)", "Calling sleep");
                            }
                            AddressBook.this.table.getDisplay().sleep();
                        }
                        if (menu.isDisposed()) {
                            if (logger.level < 9) continue;
                            logger.log(9, "mouseDown(MouseEvent)", "Menu disposed");
                            continue;
                        }
                        if (logger.level < 9) continue;
                        logger.build("mouseDown(MouseEvent)").add("vis: ").add(menu.isVisible()).log(9);
                    }
                    menu.dispose();
                }
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = AddressBook.this.table.getSelection();
                if (tableItemArray.length > 0) {
                    AddressBook.this.editEntry(tableItemArray[0]);
                }
            }
        });
        int n = 0;
        while (n < columnNames.length) {
            TableColumn tableColumn = new TableColumn(this.table, 0);
            WidgetRegistry.add("Column." + columnNames[n], tableColumn);
            tableColumn.setText(columnNames[n]);
            tableColumn.setWidth(150);
            final int n2 = n++;
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AddressBook.this.sort(n2);
                }
            });
        }
        return this.table;
    }

    public void reinitTable() {
        this.table.dispose();
        this.createTable();
        for (int i = 0; i < 5; ++i) {
            String[] stringArray = new String[]{"last name" + i, "first name" + i, "phone" + i, "home phone" + i, "email" + i, "fax" + i};
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(stringArray);
        }
        this.isModified = false;
        this.shell.layout();
    }

    static /* synthetic */ String[] access$1202(AddressBook addressBook, String[] stringArray) {
        addressBook.copyBuffer = stringArray;
        return stringArray;
    }

    private class RowComparator
    implements Comparator {
        private int column;

        public RowComparator(int n) {
            this.column = n;
        }

        public int compare(Object object, Object object2) {
            String[] stringArray = (String[])object;
            String[] stringArray2 = (String[])object2;
            return stringArray[this.column].compareTo(stringArray2[this.column]);
        }
    }
}

