/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.swt.addressbook;

import de.qfs.lib.log.Logger;
import de.qfs.lib.util.Reflector;
import java.util.Hashtable;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Widget;

public abstract class WidgetRegistry {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.swt.WidgetRegistry");
    private static Hashtable map = new Hashtable();
    private static Hashtable reverse = new Hashtable();

    public static void add(String string, Object object) {
        if (WidgetRegistry.logger.level >= 7) {
            logger.log(7, "add(String,Object)", WidgetRegistry.logger.level < 8 ? "" : "name: " + string + ", widget: " + object);
        }
        if (reverse.get(object) != null && WidgetRegistry.logger.level >= 5) {
            logger.dumpStack(5, "add(String,Object)", "widget already registered: " + object);
        }
        if (object instanceof Widget) {
            ((Widget)object).setData("name", (Object)string);
        }
        map.put(string, object);
        reverse.put(object, string);
    }

    public static void remove(String string) {
        Object v;
        if (WidgetRegistry.logger.level >= 7) {
            logger.log(7, "remove(String)", WidgetRegistry.logger.level < 8 ? "" : "name: " + string);
        }
        if ((v = map.get(string)) != null) {
            map.remove(string);
            reverse.remove(v);
        }
    }

    public static void remove(Object object) {
        Object v;
        if (WidgetRegistry.logger.level >= 7) {
            logger.log(7, "remove(Object)", WidgetRegistry.logger.level < 8 ? "" : "widget: " + object);
        }
        if ((v = map.get(object)) != null) {
            map.remove(v);
            reverse.remove(object);
        }
    }

    public static Object lookup(String string) {
        if (WidgetRegistry.logger.level >= 7) {
            logger.log(7, "lookup(String)", WidgetRegistry.logger.level < 8 ? "" : "name: " + string);
        }
        Object v = map.get(string);
        boolean bl = false;
        if (v instanceof Widget) {
            bl = ((Widget)v).isDisposed();
        } else if (v instanceof MessageBox) {
            Integer n = (Integer)Reflector.safeGet(v, (String)"handle", (boolean)true);
            boolean bl2 = bl = n == null || n == 0;
        }
        if (bl) {
            if (WidgetRegistry.logger.level >= 9) {
                logger.log(9, "lookup(String)", "Object disposed");
            }
            map.remove(string);
            reverse.remove(v);
            return null;
        }
        return v;
    }

    public static Object lookup(String string, int n) {
        Object object;
        if (WidgetRegistry.logger.level >= 7) {
            logger.log(7, "lookup(String,int)", WidgetRegistry.logger.level < 8 ? "" : "name: " + string + ", timeout: " + n);
        }
        if ((object = WidgetRegistry.lookup(string)) != null) {
            return object;
        }
        if (n <= 0) {
            return null;
        }
        long l = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            object = WidgetRegistry.lookup(string);
            if (object == null) continue;
            return object;
        } while (System.currentTimeMillis() - l <= (long)n);
        return null;
    }

    public static String lookup(Object object) {
        if (WidgetRegistry.logger.level >= 7) {
            logger.log(7, "lookup(Object)", WidgetRegistry.logger.level < 8 ? "" : "widget: " + object);
        }
        return (String)reverse.get(object);
    }
}

