/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.swt.image;

import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public final class ImageCombo
extends Composite {
    private static final boolean gtk = "gtk".equals(SWT.getPlatform());
    private boolean dontDrop;
    Text text;
    Table table;
    int visibleItemCount;
    Shell popup;
    Button arrow;
    boolean hasFocus;
    Listener listener;
    Listener filter;
    Color foreground;
    Color background;
    Font font;

    public ImageCombo(Composite composite, int n) {
        n = ImageCombo.checkStyle(n);
        super(composite, n);
        this.dontDrop = false;
        this.visibleItemCount = 5;
        int n2 = 4;
        if (gtk) {
            n2 |= 0x800;
        }
        if ((n & 8) != 0) {
            n2 |= 8;
        }
        if ((n & 0x800000) != 0) {
            n2 |= 0x800000;
        }
        this.text = new Text((Composite)this, n2);
        int n3 = 1028;
        if ((n & 0x800000) != 0) {
            n3 |= 0x800000;
        }
        this.arrow = new Button((Composite)this, n3);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (ImageCombo.this.popup == event.widget) {
                    ImageCombo.this.popupEvent(event);
                    return;
                }
                if (ImageCombo.this.text == event.widget) {
                    ImageCombo.this.textEvent(event);
                    return;
                }
                if (ImageCombo.this.table == event.widget) {
                    ImageCombo.this.listEvent(event);
                    return;
                }
                if (ImageCombo.this.arrow == event.widget) {
                    ImageCombo.this.arrowEvent(event);
                    return;
                }
                if (ImageCombo.this == event.widget) {
                    ImageCombo.this.comboEvent(event);
                    return;
                }
                if (ImageCombo.this.getShell() == event.widget) {
                    ImageCombo.this.handleFocus(16);
                }
            }
        };
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = ((Control)event.widget).getShell();
                if (shell == ImageCombo.this.getShell()) {
                    ImageCombo.this.handleFocus(16);
                }
            }
        };
        int[] nArray = new int[]{12, 10, 11};
        for (int i = 0; i < nArray.length; ++i) {
            this.addListener(nArray[i], this.listener);
        }
        int[] nArray2 = new int[]{1, 2, 24, 3, 4, 31, 15};
        for (int i = 0; i < nArray2.length; ++i) {
            this.text.addListener(nArray2[i], this.listener);
        }
        int[] nArray3 = new int[]{13, 15};
        for (int i = 0; i < nArray3.length; ++i) {
            this.arrow.addListener(nArray3[i], this.listener);
        }
        this.createPopup(-1);
        this.initAccessible();
    }

    static int checkStyle(int n) {
        int n2 = gtk ? 0x6800008 : 0x6800808;
        return n & n2;
    }

    public void add(String string, Image image) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        TableItem tableItem = new TableItem(this.table, 0);
        tableItem.setText(string);
        if (image != null) {
            tableItem.setImage(image);
        }
    }

    public void add(String string, Image image, int n) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        TableItem tableItem = new TableItem(this.table, 0, n);
        if (image != null) {
            tableItem.setImage(image);
        }
        tableItem.setText(string);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)modifyListener);
        this.addListener(24, (Listener)typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)selectionListener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (gtk) {
                    this.setFocus();
                    return;
                }
                this.handleFocus(15);
                break;
            }
            case 13: {
                if (gtk) {
                    if (!this.dontDrop) {
                        this.dropDown(!this.isDropped());
                    }
                    this.dontDrop = false;
                    break;
                }
                this.dropDown(!this.isDropped());
            }
        }
    }

    public void clearSelection() {
        this.checkWidget();
        this.text.clearSelection();
        this.table.deselectAll();
    }

    void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.table.removeListener(12, this.listener);
                    this.popup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                this.popup = null;
                this.text = null;
                this.table = null;
                this.arrow = null;
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout(false);
            }
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        String[] stringArray = this.getStringsFromTable();
        int n5 = 0;
        GC gC = new GC((Drawable)this.text);
        int n6 = gC.stringExtent((String)" ").x;
        for (int i = 0; i < stringArray.length; ++i) {
            n5 = Math.max(gC.stringExtent((String)stringArray[i]).x, n5);
        }
        gC.dispose();
        Point point = this.text.computeSize(-1, -1, bl);
        Point point2 = this.arrow.computeSize(-1, -1, bl);
        Point point3 = this.table.computeSize(n, -1, bl);
        int n7 = this.getBorderWidth();
        n4 = Math.max(n2, Math.max(point.y, point2.y) + 2 * n7);
        n3 = Math.max(n, Math.max(n5 + 2 * n6 + point2.x + 2 * n7, point3.x));
        return new Point(n3, n4);
    }

    void createPopup(int n) {
        this.popup = new Shell(this.getShell(), 16392);
        int n2 = this.getStyle();
        int n3 = 516;
        if ((n2 & 0x800000) != 0) {
            n3 |= 0x800000;
        }
        if ((n2 & 0x4000000) != 0) {
            n3 |= 0x4000000;
        }
        if ((n2 & 0x2000000) != 0) {
            n3 |= 0x2000000;
        }
        this.table = new Table((Composite)this.popup, n3);
        if (this.font != null) {
            this.table.setFont(this.font);
        }
        if (this.foreground != null) {
            this.table.setForeground(this.foreground);
        }
        if (this.background != null) {
            this.table.setBackground(this.background);
        }
        int[] nArray = new int[]{21, 9, 27};
        for (int i = 0; i < nArray.length; ++i) {
            this.popup.addListener(nArray[i], this.listener);
        }
        int[] nArray2 = new int[]{4, 13, 31, 1, 2, 15, 12};
        for (int i = 0; i < nArray2.length; ++i) {
            this.table.addListener(nArray2[i], this.listener);
        }
        if (n != -1) {
            this.table.setSelection(n);
        }
    }

    public void deselect(int n) {
        this.checkWidget();
        this.table.deselect(n);
    }

    public void deselectAll() {
        this.checkWidget();
        this.table.deselectAll();
    }

    void dropDown(boolean bl) {
        if (bl == this.isDropped()) {
            return;
        }
        if (!bl) {
            this.popup.setVisible(false);
            if (!this.isDisposed() && this.arrow.isFocusControl()) {
                this.text.setFocus();
            }
            return;
        }
        if (this.getShell() != this.popup.getParent()) {
            int n = this.table.getSelectionIndex();
            this.table.removeListener(12, this.listener);
            this.popup.dispose();
            this.popup = null;
            this.table = null;
            this.createPopup(n);
        }
        Point point = this.getSize();
        int n = this.table.getItemCount();
        n = n == 0 ? this.visibleItemCount : Math.min(this.visibleItemCount, n);
        int n2 = this.table.getItemHeight() * n;
        Point point2 = this.table.computeSize(-1, n2, false);
        this.table.setBounds(1, 1, Math.max(point.x - 2, point2.x), point2.y);
        int n3 = this.table.getSelectionIndex();
        if (n3 != -1) {
            this.table.setTopIndex(n3);
        }
        Display display = this.getDisplay();
        Rectangle rectangle = this.table.getBounds();
        Rectangle rectangle2 = display.map((Control)this.getParent(), null, this.getBounds());
        Point point3 = this.getSize();
        Rectangle rectangle3 = this.getMonitor().getClientArea();
        int n4 = Math.max(point3.x, rectangle.width + 2);
        int n5 = rectangle.height + 2;
        int n6 = rectangle2.x;
        int n7 = rectangle2.y + point3.y;
        if (n7 + n5 > rectangle3.y + rectangle3.height) {
            n7 = rectangle2.y - n5;
        }
        this.popup.setBounds(n6, n7, n4, n5);
        this.popup.setVisible(true);
        this.table.setFocus();
    }

    Label getAssociatedLabel() {
        Control[] controlArray = this.getParent().getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            if (controlArray[i] != this || i <= 0 || !(controlArray[i - 1] instanceof Label)) continue;
            return (Label)controlArray[i - 1];
        }
        return null;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.text.getEditable();
    }

    public TableItem getItem(int n) {
        this.checkWidget();
        return this.table.getItem(n);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.table.getItemCount();
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.table.getItemHeight();
    }

    public TableItem[] getItems() {
        this.checkWidget();
        return this.table.getItems();
    }

    char getMnemonic(String string) {
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return '\u0000';
            }
            if (string.charAt(n) != '&') {
                return string.charAt(n);
            }
            if (++n >= n2) break;
        }
        return '\u0000';
    }

    String[] getStringsFromTable() {
        String[] stringArray = new String[this.table.getItems().length];
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.table.getItem(i).getText();
        }
        return stringArray;
    }

    public Point getSelection() {
        this.checkWidget();
        return this.text.getSelection();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.table.getSelectionIndex();
    }

    public int getStyle() {
        int n = super.getStyle();
        n &= 0xFFFFFFF7;
        if (!this.text.getEditable()) {
            n |= 8;
        }
        return n;
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.text.getLineHeight();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.text.getTextLimit();
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleItemCount;
    }

    void handleFocus(int n) {
        if (this.isDisposed()) {
            return;
        }
        switch (n) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                if (this.getEditable()) {
                    this.text.selectAll();
                }
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                Event event = new Event();
                this.notifyListeners(15, event);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control control = this.getDisplay().getFocusControl();
                if (control == this.arrow || control == this.table || control == this.text) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                Event event = new Event();
                this.notifyListeners(16, event);
                break;
            }
        }
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        return Arrays.asList(this.getStringsFromTable()).indexOf(string);
    }

    void initAccessible() {
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                String string = null;
                Label label = ImageCombo.this.getAssociatedLabel();
                if (label != null) {
                    string = ImageCombo.this.stripMnemonic(label.getText());
                }
                accessibleEvent.result = string;
            }

            public void getKeyboardShortcut(AccessibleEvent accessibleEvent) {
                char c;
                String string;
                String string2 = null;
                Label label = ImageCombo.this.getAssociatedLabel();
                if (label != null && (string = label.getText()) != null && (c = ImageCombo.this.getMnemonic(string)) != '\u0000') {
                    string2 = "Alt+" + c;
                }
                accessibleEvent.result = string2;
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = ImageCombo.this.getToolTipText();
            }
        };
        this.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.text.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.table.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.arrow.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = ImageCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }

            public void getKeyboardShortcut(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = "Alt+Down Arrow";
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = ImageCombo.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent accessibleTextEvent) {
                accessibleTextEvent.offset = ImageCombo.this.text.getCaretPosition();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = ImageCombo.this.toControl(accessibleControlEvent.x, accessibleControlEvent.y);
                if (ImageCombo.this.getBounds().contains(point)) {
                    accessibleControlEvent.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = ImageCombo.this.getBounds();
                Point point = ImageCombo.this.toDisplay(rectangle.x, rectangle.y);
                accessibleControlEvent.x = point.x;
                accessibleControlEvent.y = point.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 46;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getValue(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = ImageCombo.this.getText();
            }
        });
        this.text.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = ImageCombo.this.text.getEditable() ? 42 : 41;
            }
        });
        this.arrow.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getDefaultAction(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = ImageCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }
        });
    }

    boolean isDropped() {
        return this.popup.getVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.text.isFocusControl() || this.arrow.isFocusControl() || this.table.isFocusControl() || this.popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    void internalLayout(boolean bl) {
        if (this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rectangle = this.getClientArea();
        int n = rectangle.width;
        int n2 = rectangle.height;
        Point point = this.arrow.computeSize(-1, n2, bl);
        this.text.setBounds(0, 0, n - point.x, n2);
        this.arrow.setBounds(n - point.x, 0, point.x, point.y);
    }

    void listEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.getShell() == this.popup.getParent()) break;
                int n = this.table.getSelectionIndex();
                this.popup = null;
                this.table = null;
                this.createPopup(n);
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                this.dropDown(false);
                break;
            }
            case 13: {
                int n = this.table.getSelectionIndex();
                if (n == -1) {
                    return;
                }
                this.text.setText(this.table.getItem(n).getText());
                this.text.selectAll();
                this.table.setSelection(n);
                Event event2 = new Event();
                event2.time = event.time;
                event2.stateMask = event.stateMask;
                event2.doit = event.doit;
                this.notifyListeners(13, event2);
                event.doit = event2.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event event3 = new Event();
                event3.time = event.time;
                event3.detail = event.detail;
                event3.doit = event.doit;
                event3.character = event.character;
                event3.keyCode = event.keyCode;
                this.notifyListeners(31, event3);
                event.doit = event3.doit;
                event.detail = event3.detail;
                break;
            }
            case 2: {
                Event event4 = new Event();
                event4.time = event.time;
                event4.character = event.character;
                event4.keyCode = event.keyCode;
                event4.stateMask = event.stateMask;
                this.notifyListeners(2, event4);
                break;
            }
            case 1: {
                Event event5;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if ((event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    event5 = new Event();
                    event5.time = event.time;
                    event5.stateMask = event.stateMask;
                    this.notifyListeners(14, event5);
                }
                if (this.isDisposed()) break;
                event5 = new Event();
                event5.time = event.time;
                event5.character = event.character;
                event5.keyCode = event.keyCode;
                event5.stateMask = event.stateMask;
                this.notifyListeners(1, event5);
                break;
            }
        }
    }

    void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle rectangle = this.table.getBounds();
                Color color = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(color);
                event.gc.drawRectangle(0, 0, rectangle.width + 1, rectangle.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                if (gtk) {
                    Point point = this.arrow.toControl(this.getDisplay().getCursorLocation());
                    Point point2 = this.arrow.getSize();
                    if (point.x >= 0 && point.y >= 0 && point.x < point2.x && point.y < point2.y) {
                        this.dontDrop = true;
                    }
                }
                this.dropDown(false);
            }
        }
    }

    public void redraw() {
        super.redraw();
        this.text.redraw();
        this.arrow.redraw();
        if (this.popup.isVisible()) {
            this.table.redraw();
        }
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        super.redraw(n, n2, n3, n4, true);
    }

    public void remove(int n) {
        this.checkWidget();
        this.table.remove(n);
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        this.table.remove(n, n2);
    }

    public void remove(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        int n = -1;
        int n2 = this.table.getItemCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.table.getItem(i).getText().equals(string)) continue;
            n = i;
            break;
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        this.text.setText("");
        this.table.removeAll();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error((int)4);
        }
        this.removeListener(24, (SWTEventListener)modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)selectionListener);
        this.removeListener(14, (SWTEventListener)selectionListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (n == -1) {
            this.table.deselectAll();
            this.text.setText("");
            return;
        }
        if (0 <= n && n < this.table.getItemCount() && n != this.getSelectionIndex()) {
            this.text.setText(this.table.getItem(n).getText());
            this.text.selectAll();
            this.table.select(n);
            this.table.showSelection();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.background = color;
        if (this.text != null) {
            this.text.setBackground(color);
        }
        if (this.table != null) {
            this.table.setBackground(color);
        }
        if (this.arrow != null) {
            this.arrow.setBackground(color);
        }
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.text.setEditable(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
        if (this.text != null) {
            this.text.setEnabled(bl);
        }
        if (this.arrow != null) {
            this.arrow.setEnabled(bl);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.text.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        this.text.setFont(font);
        this.table.setFont(font);
        this.internalLayout(true);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
        if (this.text != null) {
            this.text.setForeground(color);
        }
        if (this.table != null) {
            this.table.setForeground(color);
        }
        if (this.arrow != null) {
            this.arrow.setForeground(color);
        }
    }

    public void setItem(int n, String string, Image image) {
        this.checkWidget();
        this.remove(n);
        this.add(string, image, n);
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        this.table.removeAll();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.add(stringArray[i], null);
        }
        if (!this.text.getEditable()) {
            this.text.setText("");
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error((int)4);
        }
        this.text.setSelection(point.x, point.y);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        int n = -1;
        int n2 = this.table.getItemCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.table.getItem(i).getText().equals(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            this.table.deselectAll();
            this.text.setText(string);
            return;
        }
        this.text.setText(string);
        this.text.selectAll();
        this.table.setSelection(n);
        this.table.showSelection();
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        this.text.setTextLimit(n);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.arrow.setToolTipText(string);
        this.text.setToolTipText(string);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.popup.setVisible(false);
        }
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.visibleItemCount = n;
    }

    String stripMnemonic(String string) {
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return string;
            }
            if (string.charAt(n) != '&') {
                return string.substring(0, n - 1) + string.substring(n, n2);
            }
            if (++n >= n2) break;
        }
        return string;
    }

    void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 1: {
                Event event2;
                if (event.character == '\r') {
                    this.dropDown(false);
                    event2 = new Event();
                    event2.time = event.time;
                    event2.stateMask = event.stateMask;
                    this.notifyListeners(14, event2);
                }
                if (this.isDisposed()) break;
                if (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) {
                    event.doit = false;
                    if ((event.stateMask & 0x10000) != 0) {
                        boolean bl = this.isDropped();
                        this.text.selectAll();
                        if (!bl) {
                            this.setFocus();
                        }
                        this.dropDown(!bl);
                        break;
                    }
                    int n = this.getSelectionIndex();
                    if (event.keyCode == 0x1000001) {
                        this.select(Math.max(n - 1, 0));
                    } else {
                        this.select(Math.min(n + 1, this.getItemCount() - 1));
                    }
                    if (n != this.getSelectionIndex()) {
                        Event event3 = new Event();
                        event3.time = event.time;
                        event3.stateMask = event.stateMask;
                        this.notifyListeners(13, event3);
                    }
                    if (this.isDisposed()) break;
                }
                event2 = new Event();
                event2.time = event.time;
                event2.character = event.character;
                event2.keyCode = event.keyCode;
                event2.stateMask = event.stateMask;
                this.notifyListeners(1, event2);
                break;
            }
            case 2: {
                Event event4 = new Event();
                event4.time = event.time;
                event4.character = event.character;
                event4.keyCode = event.keyCode;
                event4.stateMask = event.stateMask;
                this.notifyListeners(2, event4);
                break;
            }
            case 24: {
                this.table.deselectAll();
                Event event5 = new Event();
                event5.time = event.time;
                this.notifyListeners(24, event5);
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                boolean bl = this.isDropped();
                this.text.selectAll();
                if (!bl) {
                    this.setFocus();
                }
                this.dropDown(!bl);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                this.text.selectAll();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event event6 = new Event();
                event6.time = event.time;
                event6.detail = event.detail;
                event6.doit = event.doit;
                event6.character = event.character;
                event6.keyCode = event.keyCode;
                this.notifyListeners(31, event6);
                event.doit = event6.doit;
                event.detail = event6.detail;
                break;
            }
        }
    }
}

