/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.training;

import de.qfs.apps.qftest.demo.BaseDemo;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Logger;
import de.qfs.lib.util.MapResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;

public class Training
extends BaseDemo {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.training.Training");
    private static Frame pFrame;
    private static JTextField fileField;
    private static JTextField value1;
    private static JTextField value2;
    private static JTextField result;
    private static JButton add;
    private static JButton sub;
    private static JCheckBox allowAdd;
    private static JCheckBox allowSub;
    private static JTextField result2;
    private static JButton add2;
    private static JButton sub2;
    private static JTable table;
    private static Object[][] tableData;
    private static String[] tableHeaders;
    private static ActionListener incAction1;
    private static ActionListener incAction2;
    private static ActionListener decAction1;
    private static ActionListener decAction2;
    private static ActionListener additionAction;
    private static ActionListener subtractionAction;
    private static ActionListener tableAddAction;
    private static ActionListener tableSubtractAction;
    private static ActionListener allowAddAction;
    private static ActionListener allowSubAction;
    private static ActionListener fileOpenAction;
    private static ActionListener fileSaveAction;
    private static ActionListener resetAction;

    public Training(boolean bl) {
        super(bl);
    }

    public static void main(String[] stringArray) {
        Training training = new Training(false);
        BaseDemo.setupAndRun(stringArray, training);
    }

    @Override
    protected void showFrameOrDialog() {
        Container container;
        Window window;
        if (Training.logger.level >= 7) {
            logger.log(7, "showFrameOrDialog()", "");
        }
        MapResourceBundle mapResourceBundle = new MapResourceBundle();
        mapResourceBundle.fetchProperties("/de/qfs/apps/qftest/demo/training/resources/properties/training", this.getClass());
        JMenuBar jMenuBar = new JMenuBar();
        if (this.asDialog) {
            pFrame = new JFrame();
            JDialog jDialog = new JDialog(pFrame, "Training Demo", true);
            window = jDialog;
            container = jDialog.getContentPane();
            jDialog.setJMenuBar(jMenuBar);
        } else {
            pFrame = this.frame = new JFrame("Training Demo");
            window = this.frame;
            container = ((JFrame)this.frame).getContentPane();
            ((JFrame)this.frame).setJMenuBar(jMenuBar);
        }
        window.setName("TrainingDemo");
        Grid grid = new Grid();
        grid.setName("TrainingDemoGrid");
        grid.addGlue();
        SwingUtil.prepareKeymaps();
        JButton jButton = new JButton("+");
        jButton.setName("inc1");
        jButton.addActionListener(incAction1);
        jButton.setPreferredSize(new Dimension(50, jButton.getPreferredSize().height));
        JButton jButton2 = new JButton("+");
        jButton2.setName("inc2");
        jButton2.addActionListener(incAction2);
        jButton2.setPreferredSize(new Dimension(50, jButton2.getPreferredSize().height));
        JButton jButton3 = new JButton("-");
        jButton3.setName("dec1");
        jButton3.addActionListener(decAction1);
        jButton3.setPreferredSize(new Dimension(50, jButton3.getPreferredSize().height));
        JButton jButton4 = new JButton("-");
        jButton4.setName("dec2");
        jButton4.addActionListener(decAction2);
        jButton4.setPreferredSize(new Dimension(50, jButton4.getPreferredSize().height));
        add = new JButton(mapResourceBundle.getString("button.add"));
        add.setName("add");
        add.addActionListener(additionAction);
        add.setPreferredSize(new Dimension(50, Training.add.getPreferredSize().height));
        sub = new JButton(mapResourceBundle.getString("button.sub"));
        sub.setName("subtract");
        sub.addActionListener(subtractionAction);
        sub.setPreferredSize(new Dimension(50, Training.sub.getPreferredSize().height));
        JLabel jLabel = new JLabel(mapResourceBundle.getString("label.value1"));
        jLabel.setName("value1Label");
        jLabel.setPreferredSize(new Dimension(jLabel.getPreferredSize().width, Training.sub.getPreferredSize().height));
        JLabel jLabel2 = new JLabel(mapResourceBundle.getString("label.value2"));
        jLabel2.setName("value2Label");
        jLabel2.setPreferredSize(new Dimension(jLabel2.getPreferredSize().width, Training.sub.getPreferredSize().height));
        JLabel jLabel3 = new JLabel(mapResourceBundle.getString("label.result"));
        jLabel3.setName("resultLabel");
        jLabel3.setPreferredSize(new Dimension(jLabel.getPreferredSize().width, Training.sub.getPreferredSize().height));
        value1 = new JTextField("0");
        value1.setName("value1");
        value1.setPreferredSize(new Dimension(80, Training.add.getPreferredSize().height));
        value1.setHorizontalAlignment(4);
        value2 = new JTextField("0");
        value2.setName("value2");
        value2.setPreferredSize(new Dimension(80, Training.add.getPreferredSize().height));
        value2.setHorizontalAlignment(4);
        result = new JTextField("");
        result.setName("result");
        result.setHorizontalAlignment(4);
        result.setPreferredSize(new Dimension(80, Training.value2.getPreferredSize().height));
        result.setBackground(new Color(238, 242, 255));
        result.setEditable(false);
        Component component = Box.createHorizontalStrut(50);
        Component component2 = Box.createHorizontalStrut(50);
        Component component3 = Box.createHorizontalStrut(50);
        grid.addGrid((Component[][])new Component[][]{{jLabel, jButton3, jButton, value1, add}, {jLabel2, jButton4, jButton2, value2, sub}, {jLabel3, component, component2, result, component2}});
        JLabel jLabel4 = new JLabel(mapResourceBundle.getString("label.selectedFile"));
        jLabel4.setName("selectedFile");
        fileField = new JTextField("");
        fileField.setName("fileField");
        fileField.setPreferredSize(new Dimension(500, Training.fileField.getPreferredSize().height));
        fileField.setEnabled(false);
        grid.addLine(new Component[]{jLabel4, fileField});
        DefaultTableModel defaultTableModel = new DefaultTableModel(tableData, tableHeaders){

            public Class getColumnClass(int n) {
                switch (n) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return Integer.class;
                    }
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 1;
            }
        };
        table = new JTable(defaultTableModel){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                super.editingStopped(changeEvent);
                if (this.getSelectedRow() >= 0) {
                    this.scrollRectToVisible(this.getCellRect(this.getSelectedRow(), this.getEditingColumn(), true));
                }
            }
        };
        table.setName("Table");
        table.getTableHeader().setName("TableHeader");
        add2 = new JButton(mapResourceBundle.getString("button.add"));
        add2.setName("addTable");
        add2.addActionListener(tableAddAction);
        add2.setPreferredSize(new Dimension(50, Training.add2.getPreferredSize().height));
        sub2 = new JButton(mapResourceBundle.getString("button.sub"));
        sub2.setName("subtractTable");
        sub2.addActionListener(tableSubtractAction);
        sub2.setPreferredSize(new Dimension(50, Training.sub2.getPreferredSize().height));
        result2 = new JTextField("");
        result2.setName("resultTable");
        result2.setPreferredSize(new Dimension(150, Training.result2.getPreferredSize().height));
        result2.setHorizontalAlignment(4);
        result2.setBackground(new Color(238, 242, 255));
        result2.setEditable(false);
        JLabel jLabel5 = new JLabel(mapResourceBundle.getString("label.result"));
        jLabel3.setName("resultTableLabel");
        grid.addLine(new Component[]{table});
        grid.addLine(new Component[]{add2, sub2, jLabel5, result2, Box.createHorizontalStrut(56)});
        JMenu jMenu = new JMenu(mapResourceBundle.getString("menu.file.name"));
        jMenu.setName("mFile");
        jMenu.setMnemonic(mapResourceBundle.getString("menu.file.mnemonic").charAt(0));
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(mapResourceBundle.getString("menu.file.open.name"));
        jMenuItem.setName("miOpen");
        jMenuItem.setMnemonic(mapResourceBundle.getString("menu.file.open.mnemonic").charAt(0));
        jMenuItem.addActionListener(fileOpenAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(mapResourceBundle.getString("menu.file.save.name"));
        jMenuItem.setName("miSave");
        jMenuItem.setMnemonic(mapResourceBundle.getString("menu.file.save.mnemonic").charAt(0));
        jMenuItem.addActionListener(fileSaveAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(mapResourceBundle.getString("menu.file.reset.name"));
        jMenuItem.setName("miReset");
        jMenuItem.setMnemonic(mapResourceBundle.getString("menu.file.reset.mnemonic").charAt(0));
        jMenuItem.addActionListener(resetAction);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(mapResourceBundle.getString("menu.file.exit.name"));
        jMenuItem.setName("miExit");
        jMenuItem.setMnemonic(mapResourceBundle.getString("menu.file.exit.mnemonic").charAt(0));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        jMenu = new JMenu(mapResourceBundle.getString("menu.help.name"));
        jMenu.setName("mHelp");
        jMenu.setMnemonic(mapResourceBundle.getString("menu.help.mnemonic").charAt(0));
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem(mapResourceBundle.getString("menu.help.about.name"));
        jMenuItem.setName("miAbout");
        jMenuItem.setMnemonic(mapResourceBundle.getString("menu.help.about.mnemonic").charAt(0));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Training.this.showAbout(pFrame);
            }
        });
        jMenu.add(jMenuItem);
        allowAdd = new JCheckBox(mapResourceBundle.getString("checkbox.enableAdd"), true);
        allowAdd.setName("allowAdd");
        allowAdd.addActionListener(allowAddAction);
        allowSub = new JCheckBox(mapResourceBundle.getString("checkbox.enableSub"), true);
        allowSub.setName("allowSub");
        allowSub.addActionListener(allowSubAction);
        JButton jButton5 = new JButton(mapResourceBundle.getString("button.noop"));
        JButton jButton6 = new JButton(mapResourceBundle.getString("button.close"));
        jButton6.setName("close");
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jButton6.setPreferredSize(new Dimension(50, jButton6.getPreferredSize().height));
        grid.addLine(new Component[]{allowAdd, jButton5});
        grid.addLine(new Component[]{allowSub, jButton6});
        grid.addGlue();
        container.add((Component)grid);
        this.finishWindow(window);
        value1.requestFocus();
    }

    public void showAbout(Frame frame) {
        JOptionPane.showMessageDialog(frame, "QF-Test     Training Demo\nCopyright           (C)2005\nQuality First Software GmbH\n", "About", 1);
    }

    public static void showNumericErrorDialog(Frame frame, String string) {
        final JDialog jDialog = new JDialog(frame, "Numeric Error", true);
        Grid grid = new Grid();
        grid.setName("errorDialogGrid");
        int n = 250;
        JButton jButton = new JButton("Close");
        jButton.setPreferredSize(new Dimension(50, jButton.getPreferredSize().height));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        JLabel jLabel = new JLabel("\"" + string + "\"");
        jLabel.setName("errText1");
        JLabel jLabel2 = new JLabel("is an invalid numeric value or expression");
        jLabel2.setName("errText2");
        grid.addLine(new Component[]{Box.createHorizontalStrut(n / 3), jLabel});
        grid.addLine(new Component[]{jLabel2});
        grid.addLine(new Component[]{Box.createHorizontalStrut(n / 3), jButton, Box.createHorizontalStrut(n / 2)});
        jDialog.getContentPane().add((Component)grid);
        jDialog.setSize(n, 150);
        jDialog.setLocation(frame.getLocation().x + 5, frame.getLocation().y + 5);
        jDialog.show();
    }

    public static void showFileErrorDialog(Frame frame, String string) {
        final JDialog jDialog = new JDialog(frame, "File Error", true);
        Grid grid = new Grid();
        grid.setName("fileErrDialogGrid");
        int n = 250;
        JButton jButton = new JButton("Close");
        jButton.setPreferredSize(new Dimension(50, jButton.getPreferredSize().height));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        JLabel jLabel = new JLabel("\"" + string + "\"");
        jLabel.setName("errText1");
        JLabel jLabel2 = new JLabel("is not a valid file");
        jLabel2.setName("errText2");
        grid.addLine(new Component[]{Box.createHorizontalStrut(n / 3), jLabel});
        grid.addLine(new Component[]{jLabel2});
        grid.addLine(new Component[]{Box.createHorizontalStrut(n / 3), jButton, Box.createHorizontalStrut(n / 2)});
        jDialog.getContentPane().add((Component)grid);
        jDialog.setSize(n, 150);
        jDialog.setLocation(frame.getLocation().x + 5, frame.getLocation().y + 5);
        jDialog.show();
    }

    static {
        tableData = new Object[][]{{"Peter", (int)(Math.random() * 100.0)}, {"Paul", (int)(Math.random() * 100.0)}, {"Mary", (int)(Math.random() * 100.0)}};
        tableHeaders = new String[]{"Label", "Value"};
        incAction1 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(value1.getText());
                    value1.setText("" + (n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    Training.showNumericErrorDialog(pFrame, value1.getText());
                    value1.setText("0");
                    value1.requestFocus();
                }
            }
        };
        incAction2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(value2.getText());
                    value2.setText("" + (n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    Training.showNumericErrorDialog(pFrame, value2.getText());
                    value2.setText("0");
                    value2.requestFocus();
                }
            }
        };
        decAction1 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(value1.getText());
                    value1.setText("" + (n - 1));
                }
                catch (NumberFormatException numberFormatException) {
                    Training.showNumericErrorDialog(pFrame, value1.getText());
                    value1.setText("0");
                    value1.requestFocus();
                }
            }
        };
        decAction2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(value2.getText());
                    value2.setText("" + (n - 1));
                }
                catch (NumberFormatException numberFormatException) {
                    Training.showNumericErrorDialog(pFrame, value2.getText());
                    value2.setText("0");
                    value2.requestFocus();
                }
            }
        };
        additionAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(value1.getText());
                    int n2 = Integer.parseInt(value2.getText());
                    int n3 = n + n2;
                    result.setText("" + n3);
                }
                catch (NumberFormatException numberFormatException) {
                    Training.showNumericErrorDialog(pFrame, value1.getText() + " + " + value2.getText());
                    value1.requestFocus();
                }
            }
        };
        subtractionAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(value1.getText());
                    int n2 = Integer.parseInt(value2.getText());
                    int n3 = n - n2;
                    result.setText("" + n3);
                }
                catch (NumberFormatException numberFormatException) {
                    Training.showNumericErrorDialog(pFrame, value1.getText() + " - " + value2.getText());
                    value1.requestFocus();
                }
            }
        };
        tableAddAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Integer n = (Integer)table.getValueAt(0, 1);
                    Integer n2 = (Integer)table.getValueAt(1, 1);
                    Integer n3 = (Integer)table.getValueAt(2, 1);
                    int n4 = n + n2 + n3;
                    result2.setText("" + n4);
                }
                catch (NumberFormatException numberFormatException) {
                    Training.showNumericErrorDialog(pFrame, table.getValueAt(0, 1) + " + " + table.getValueAt(1, 1) + " + " + table.getValueAt(2, 1) + " + ");
                }
            }
        };
        tableSubtractAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Integer n = (Integer)table.getValueAt(0, 1);
                    Integer n2 = (Integer)table.getValueAt(1, 1);
                    Integer n3 = (Integer)table.getValueAt(2, 1);
                    int n4 = n - n2 - n3;
                    result2.setText("" + n4);
                }
                catch (NumberFormatException numberFormatException) {
                    Training.showNumericErrorDialog(pFrame, table.getValueAt(0, 1) + " - " + table.getValueAt(1, 1) + " - " + table.getValueAt(2, 1) + " - ");
                }
            }
        };
        allowAddAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                add.setEnabled(allowAdd.isSelected());
                add2.setEnabled(allowAdd.isSelected());
            }
        };
        allowSubAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                sub.setEnabled(allowSub.isSelected());
                sub2.setEnabled(allowSub.isSelected());
            }
        };
        fileOpenAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    logger.log(7, "actionPerformed(ActionEvent)", "FileOpenAction");
                }
                boolean bl = false;
                String string = "0";
                String string2 = "0";
                JFileChooser jFileChooser = SwingUtil.createFileChooser(null, null, null);
                jFileChooser.setName("openDialog");
                jFileChooser.setDialogType(0);
                jFileChooser.setDialogTitle("Select input file");
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.showOpenDialog(pFrame);
                fileField.setBackground(Color.white);
                fileField.setText("");
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file.getCanonicalPath());
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                        String string3 = bufferedReader.readLine();
                        if (string3 != null) {
                            if (logger.level >= 7) {
                                logger.log(7, "actionPerformed(ActionEvent)", "readline" + string3);
                            }
                            if (string3.startsWith("#")) {
                                int n;
                                if (logger.level >= 7) {
                                    logger.log(7, "actionPerformed(ActionEvent)", "# found");
                                }
                                string3 = string3.substring(1).trim();
                                if (logger.level >= 7) {
                                    logger.log(7, "actionPerformed(ActionEvent)", string3);
                                }
                                if ((n = string3.indexOf(44)) > 0) {
                                    string = string3.substring(0, n);
                                    string2 = string3.substring(n + 1);
                                    bl = true;
                                }
                            }
                        }
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (bl) {
                    value1.setText(string);
                    value2.setText(string2);
                    fileField.setText(jFileChooser.getName(file));
                } else if (file != null) {
                    fileField.setBackground(new Color(255, 97, 98));
                    fileField.setText(jFileChooser.getName(file));
                }
            }
        };
        fileSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                JFileChooser jFileChooser = SwingUtil.createFileChooser(null, null, null);
                jFileChooser.setName("saveDialog");
                jFileChooser.setDialogType(1);
                jFileChooser.setDialogTitle("Save input file");
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.showSaveDialog(pFrame);
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file.getCanonicalFile());
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                        outputStreamWriter.write("#" + value1.getText() + "," + value2.getText());
                        outputStreamWriter.close();
                        fileField.setText(jFileChooser.getName(file));
                    }
                    catch (IOException iOException) {}
                } else {
                    fileField.setText("");
                }
            }
        };
        resetAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                fileField.setText("");
                fileField.setBackground(Color.white);
                value1.setText("0");
                value2.setText("0");
                result.setText("0");
                result2.setText("0");
                add.setEnabled(true);
                sub.setEnabled(true);
                add2.setEnabled(true);
                sub2.setEnabled(true);
                allowAdd.setSelected(true);
                allowSub.setSelected(true);
                table.setValueAt(0, 0, 1);
                table.setValueAt(0, 1, 1);
                table.setValueAt(0, 2, 1);
                value1.requestFocus();
            }
        };
    }
}

