/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.tutorial;

import de.qfs.apps.qftest.demo.BaseDemo;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.log.Logger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;

public class ItemsDemo
extends BaseDemo {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.tutorial.ItemsDemo");
    private static Frame pFrame;

    public ItemsDemo(boolean bl) {
        super(bl);
    }

    public static void main(String[] stringArray) {
        ItemsDemo itemsDemo = new ItemsDemo(false);
        BaseDemo.argdef = new String[]{"-dialog", "-fixed", "-other"};
        BaseDemo.setupAndRun(stringArray, itemsDemo);
    }

    @Override
    protected void showFrameOrDialog() {
        Container container;
        Window window;
        if (ItemsDemo.logger.level >= 7) {
            logger.log(7, "showFrameOrDialog()", "");
        }
        if (this.asDialog) {
            pFrame = new JFrame();
            JDialog jDialog = new JDialog(pFrame, "Items Demo", true);
            window = jDialog;
            container = jDialog.getContentPane();
        } else {
            pFrame = this.frame = new JFrame("Items Demo");
            window = this.frame;
            container = ((JFrame)this.frame).getContentPane();
        }
        window.setName("ItemsDemo");
        Grid grid = new Grid();
        grid.setName("ItemsDemoGrid");
        JLabel jLabel = new JLabel(" Sample List: ");
        jLabel.setName("ListLabel");
        String[] stringArray = new String[]{"list item 1", "list item 2", "list item 3", "list item 4"};
        JList<String> jList = new JList<String>(stringArray);
        jList.setName("List");
        jList.setVisibleRowCount(4);
        jList.setPreferredSize(new Dimension(250, 80));
        grid.addLine(new Component[]{jLabel}, 0.0);
        grid.addLine(new Component[]{jList}, 1.0);
        Object[][] objectArray = this.argsParser.getBoolean("fixed", false) ? new Object[][]{{"table item 1", 35}, {"table item 2", 1}, {"table item 3", 59}} : new Object[][]{{"table item 1", (int)(Math.random() * 100.0)}, {"table item 2", (int)(Math.random() * 100.0)}, {"table item 3", (int)(Math.random() * 100.0)}};
        Object[] objectArray2 = new String[]{"Label", "Value"};
        final boolean bl = this.argsParser.getBoolean("other", false);
        if (bl) {
            objectArray = new Object[][]{{"2001", "$5061", "$8500"}, {"2002", "$4985", "$9400"}, {"2003", "$6200", "$9400"}};
            objectArray2 = new String[]{"Year", "Expenses", "Income"};
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, objectArray2){

            public Class getColumnClass(int n) {
                if (bl) {
                    return String.class;
                }
                switch (n) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return Integer.class;
                    }
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return !bl && n2 == 1;
            }
        };
        JTable jTable = new JTable(defaultTableModel){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                super.editingStopped(changeEvent);
                if (this.getSelectedRow() >= 0) {
                    this.scrollRectToVisible(this.getCellRect(this.getSelectedRow(), this.getEditingColumn(), true));
                }
            }
        };
        jTable.setName("Table");
        jTable.getTableHeader().setName("TableHeader");
        JLabel jLabel2 = new JLabel(bl ? " Expenses and Income per Year:" : " Sample Table:");
        grid.addLine(new Component[]{jLabel2}, 0.0);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setName("TablePane");
        jScrollPane.setPreferredSize(new Dimension(250, 100));
        grid.addLine(new Component[]{jScrollPane}, 1.0);
        JTree jTree = new JTree();
        jTree.setName("Tree");
        JLabel jLabel3 = new JLabel(" Sample Tree: ");
        JScrollPane jScrollPane2 = new JScrollPane(jTree);
        jScrollPane2.setName("TreePane");
        jScrollPane2.setPreferredSize(new Dimension(250, 120));
        jLabel3.setName("TreeLabel");
        grid.addLine(new Component[]{jLabel3}, 0.0);
        grid.addLine(new Component[]{jScrollPane2}, 1.0);
        grid.addGlue();
        JButton jButton = new JButton("close");
        jButton.setName("close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jButton.setPreferredSize(new Dimension(50, jButton.getPreferredSize().height));
        grid.addLine(new Component[]{jButton}, 0.0);
        grid.addGlue();
        container.add((Component)grid);
        this.finishWindow(window);
    }
}

