/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.browserexample;

import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class BrowserExample {
    static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_browser");
    int index;
    boolean busy;
    Image[] images;
    Image icon = null;
    boolean title = false;
    Composite parent;
    Text locationBar;
    Browser browser;
    ToolBar toolbar;
    Canvas canvas;
    ToolItem itemBack;
    ToolItem itemForward;
    Label status;
    ProgressBar progressBar;
    SWTError error = null;
    static final String[] imageLocations = new String[]{"eclipse01.bmp", "eclipse02.bmp", "eclipse03.bmp", "eclipse04.bmp", "eclipse05.bmp", "eclipse06.bmp", "eclipse07.bmp", "eclipse08.bmp", "eclipse09.bmp", "eclipse10.bmp", "eclipse11.bmp", "eclipse12.bmp"};
    static final String iconLocation = "document.gif";

    public BrowserExample(Composite composite, boolean bl) {
        this.parent = composite;
        try {
            this.browser = new Browser(composite, 2048);
        }
        catch (SWTError sWTError) {
            sWTError.printStackTrace();
            this.error = sWTError;
            composite.setLayout((Layout)new FillLayout());
            Label label = new Label(composite, 0x1000040);
            label.setText(BrowserExample.getResourceString("BrowserNotCreated"));
            composite.layout(true);
            return;
        }
        this.initResources();
        final Display display = composite.getDisplay();
        this.browser.setData("org.eclipse.swt.examples.browserexample.BrowserApplication", (Object)this);
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent windowEvent) {
                Shell shell = new Shell(display);
                if (BrowserExample.this.icon != null) {
                    shell.setImage(BrowserExample.this.icon);
                }
                shell.setLayout((Layout)new FillLayout());
                BrowserExample browserExample = new BrowserExample((Composite)shell, false);
                browserExample.setShellDecoration(BrowserExample.this.icon, true);
                windowEvent.browser = browserExample.getBrowser();
            }
        });
        if (bl) {
            this.browser.setUrl(BrowserExample.getResourceString("Startup"));
            this.show(false, null, null, true, true, true, true);
        } else {
            this.browser.addVisibilityWindowListener(new VisibilityWindowListener(){

                public void hide(WindowEvent windowEvent) {
                }

                public void show(WindowEvent windowEvent) {
                    Browser browser = (Browser)windowEvent.widget;
                    BrowserExample browserExample = (BrowserExample)browser.getData("org.eclipse.swt.examples.browserexample.BrowserApplication");
                    browserExample.show(true, windowEvent.location, windowEvent.size, windowEvent.addressBar, windowEvent.menuBar, windowEvent.statusBar, windowEvent.toolBar);
                }
            });
            this.browser.addCloseWindowListener(new CloseWindowListener(){

                public void close(WindowEvent windowEvent) {
                    Browser browser = (Browser)windowEvent.widget;
                    Shell shell = browser.getShell();
                    shell.close();
                }
            });
        }
    }

    public void dispose() {
        this.freeResources();
    }

    static String getResourceString(String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + string + "!";
        }
    }

    public SWTError getError() {
        return this.error;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setShellDecoration(Image image, boolean bl) {
        this.icon = image;
        this.title = bl;
    }

    void show(boolean bl, Point point, Point point2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Canvas canvas;
        final Shell shell = this.browser.getShell();
        if (bl) {
            if (point != null) {
                shell.setLocation(point);
            }
            if (point2 != null) {
                shell.setSize(shell.computeSize(point2.x, point2.y));
            }
        }
        FormData formData = null;
        if (bl5) {
            this.toolbar = new ToolBar(this.parent, 0);
            formData = new FormData();
            formData.top = new FormAttachment(0, 5);
            this.toolbar.setLayoutData((Object)formData);
            this.itemBack = new ToolItem(this.toolbar, 8);
            this.itemBack.setText(BrowserExample.getResourceString("Back"));
            this.itemForward = new ToolItem(this.toolbar, 8);
            this.itemForward.setText(BrowserExample.getResourceString("Forward"));
            canvas = new ToolItem(this.toolbar, 8);
            canvas.setText(BrowserExample.getResourceString("Stop"));
            ToolItem toolItem = new ToolItem(this.toolbar, 8);
            toolItem.setText(BrowserExample.getResourceString("Refresh"));
            ToolItem toolItem2 = new ToolItem(this.toolbar, 8);
            toolItem2.setText(BrowserExample.getResourceString("Go"));
            this.itemBack.setEnabled(this.browser.isBackEnabled());
            this.itemForward.setEnabled(this.browser.isForwardEnabled());
            Listener listener = new Listener((ToolItem)canvas, toolItem, toolItem2){
                final /* synthetic */ ToolItem val$itemStop;
                final /* synthetic */ ToolItem val$itemRefresh;
                final /* synthetic */ ToolItem val$itemGo;
                {
                    this.val$itemStop = toolItem;
                    this.val$itemRefresh = toolItem2;
                    this.val$itemGo = toolItem3;
                }

                public void handleEvent(Event event) {
                    ToolItem toolItem = (ToolItem)event.widget;
                    if (toolItem == BrowserExample.this.itemBack) {
                        BrowserExample.this.browser.back();
                    } else if (toolItem == BrowserExample.this.itemForward) {
                        BrowserExample.this.browser.forward();
                    } else if (toolItem == this.val$itemStop) {
                        BrowserExample.this.browser.stop();
                    } else if (toolItem == this.val$itemRefresh) {
                        BrowserExample.this.browser.refresh();
                    } else if (toolItem == this.val$itemGo) {
                        BrowserExample.this.browser.setUrl(BrowserExample.this.locationBar.getText());
                    }
                }
            };
            this.itemBack.addListener(13, listener);
            this.itemForward.addListener(13, listener);
            canvas.addListener(13, listener);
            toolItem.addListener(13, listener);
            toolItem2.addListener(13, listener);
            this.canvas = new Canvas(this.parent, 262144);
            formData = new FormData();
            formData.width = 24;
            formData.height = 24;
            formData.top = new FormAttachment(0, 5);
            formData.right = new FormAttachment(100, -5);
            this.canvas.setLayoutData((Object)formData);
            final Rectangle rectangle = this.images[0].getBounds();
            this.canvas.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Point point = ((Canvas)event.widget).getSize();
                    event.gc.drawImage(BrowserExample.this.images[BrowserExample.this.index], 0, 0, rectangle.width, rectangle.height, 0, 0, point.x, point.y);
                }
            });
            this.canvas.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    BrowserExample.this.browser.setUrl(BrowserExample.getResourceString("Startup"));
                }
            });
            final Display display = this.parent.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (BrowserExample.this.canvas.isDisposed()) {
                        return;
                    }
                    if (BrowserExample.this.busy) {
                        ++BrowserExample.this.index;
                        if (BrowserExample.this.index == BrowserExample.this.images.length) {
                            BrowserExample.this.index = 0;
                        }
                        BrowserExample.this.canvas.redraw();
                    }
                    display.timerExec(150, (Runnable)this);
                }
            });
        }
        if (bl2) {
            this.locationBar = new Text(this.parent, 2048);
            formData = new FormData();
            if (this.toolbar != null) {
                formData.top = new FormAttachment((Control)this.toolbar, 0, 128);
                formData.left = new FormAttachment((Control)this.toolbar, 5, 131072);
                formData.right = new FormAttachment((Control)this.canvas, -5, -1);
            } else {
                formData.top = new FormAttachment(0, 0);
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
            }
            this.locationBar.setLayoutData((Object)formData);
            this.locationBar.addListener(14, new Listener(){

                public void handleEvent(Event event) {
                    BrowserExample.this.browser.setUrl(BrowserExample.this.locationBar.getText());
                }
            });
        }
        if (bl4) {
            this.status = new Label(this.parent, 0);
            this.progressBar = new ProgressBar(this.parent, 0);
            formData = new FormData();
            formData.left = new FormAttachment(0, 5);
            formData.right = new FormAttachment((Control)this.progressBar, 0, -1);
            formData.bottom = new FormAttachment(100, -5);
            this.status.setLayoutData((Object)formData);
            formData = new FormData();
            formData.right = new FormAttachment(100, -5);
            formData.bottom = new FormAttachment(100, -5);
            this.progressBar.setLayoutData((Object)formData);
            this.browser.addStatusTextListener(new StatusTextListener(){

                public void changed(StatusTextEvent statusTextEvent) {
                    BrowserExample.this.status.setText(statusTextEvent.text);
                }
            });
        }
        this.parent.setLayout((Layout)new FormLayout());
        canvas = bl5 ? this.canvas : (bl2 ? this.locationBar : null);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = canvas != null ? new FormAttachment((Control)canvas, 5, -1) : new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = this.status != null ? new FormAttachment((Control)this.status, -5, -1) : new FormAttachment(100, 0);
        this.browser.setLayoutData((Object)formData);
        if (bl4 || bl5) {
            this.browser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent progressEvent) {
                    if (progressEvent.total == 0) {
                        return;
                    }
                    int n = progressEvent.current * 100 / progressEvent.total;
                    if (BrowserExample.this.progressBar != null) {
                        BrowserExample.this.progressBar.setSelection(n);
                    }
                    boolean bl = BrowserExample.this.busy = progressEvent.current != progressEvent.total;
                    if (!BrowserExample.this.busy) {
                        BrowserExample.this.index = 0;
                        if (BrowserExample.this.canvas != null) {
                            BrowserExample.this.canvas.redraw();
                        }
                    }
                }

                public void completed(ProgressEvent progressEvent) {
                    if (BrowserExample.this.progressBar != null) {
                        BrowserExample.this.progressBar.setSelection(0);
                    }
                    BrowserExample.this.busy = false;
                    BrowserExample.this.index = 0;
                    if (BrowserExample.this.canvas != null) {
                        BrowserExample.this.itemBack.setEnabled(BrowserExample.this.browser.isBackEnabled());
                        BrowserExample.this.itemForward.setEnabled(BrowserExample.this.browser.isForwardEnabled());
                        BrowserExample.this.canvas.redraw();
                    }
                }
            });
        }
        if (bl2 || bl4 || bl5) {
            this.browser.addLocationListener(new LocationListener(){

                public void changed(LocationEvent locationEvent) {
                    BrowserExample.this.busy = true;
                    if (locationEvent.top && BrowserExample.this.locationBar != null) {
                        BrowserExample.this.locationBar.setText(locationEvent.location);
                    }
                }

                public void changing(LocationEvent locationEvent) {
                }
            });
        }
        if (this.title) {
            this.browser.addTitleListener(new TitleListener(){

                public void changed(TitleEvent titleEvent) {
                    shell.setText(titleEvent.title + " - " + BrowserExample.getResourceString("window.title"));
                }
            });
        }
        this.parent.layout(true);
        if (bl) {
            shell.open();
        }
    }

    public void focus() {
        if (this.locationBar != null) {
            this.locationBar.setFocus();
        } else if (this.browser != null) {
            this.browser.setFocus();
        } else {
            this.parent.setFocus();
        }
    }

    void freeResources() {
        if (this.images != null) {
            for (int i = 0; i < this.images.length; ++i) {
                Image image = this.images[i];
                if (image == null) continue;
                image.dispose();
            }
            this.images = null;
        }
    }

    void initResources() {
        Class<?> clazz = this.getClass();
        if (resourceBundle != null) {
            try {
                if (this.images == null) {
                    this.images = new Image[imageLocations.length];
                    for (int i = 0; i < imageLocations.length; ++i) {
                        InputStream inputStream = clazz.getResourceAsStream(imageLocations[i]);
                        ImageData imageData = new ImageData(inputStream);
                        ImageData imageData2 = imageData.getTransparencyMask();
                        this.images[i] = new Image(null, imageData, imageData2);
                        try {
                            inputStream.close();
                            continue;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String string = resourceBundle != null ? BrowserExample.getResourceString("error.CouldNotLoadResources") : "Unable to load resources";
        this.freeResources();
        throw new RuntimeException(string);
    }

    public static void main(String[] stringArray) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText(BrowserExample.getResourceString("window.title"));
        InputStream inputStream = BrowserExample.class.getResourceAsStream(iconLocation);
        Image image = new Image((Device)display, inputStream);
        shell.setImage(image);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        BrowserExample browserExample = new BrowserExample((Composite)shell, true);
        browserExample.setShellDecoration(image, true);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        image.dispose();
        browserExample.dispose();
        display.dispose();
    }
}

