/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.clipboard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.examples.clipboard.MyType;

public class MyTypeTransfer
extends ByteArrayTransfer {
    private static final String MYTYPENAME = "name_list";
    private static final int MYTYPEID = MyTypeTransfer.registerType((String)"name_list");
    private static MyTypeTransfer _instance = new MyTypeTransfer();

    public static MyTypeTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkMyType(object) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        MyType[] myTypeArray = (MyType[])object;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int n = myTypeArray.length;
            for (int i = 0; i < n; ++i) {
                byte[] byArray = myTypeArray[i].firstName.getBytes();
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray);
                byArray = myTypeArray[i].firstName.getBytes();
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            super.javaToNative((Object)byArray, transferData);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] byArray = (byte[])super.nativeToJava(transferData);
            if (byArray == null) {
                return null;
            }
            MyType[] myTypeArray = new MyType[]{};
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                while (dataInputStream.available() > 20) {
                    MyType myType = new MyType();
                    int n = dataInputStream.readInt();
                    byte[] byArray2 = new byte[n];
                    dataInputStream.read(byArray2);
                    myType.firstName = new String(byArray2);
                    n = dataInputStream.readInt();
                    byArray2 = new byte[n];
                    dataInputStream.read(byArray2);
                    myType.lastName = new String(byArray2);
                    MyType[] myTypeArray2 = new MyType[myTypeArray.length + 1];
                    System.arraycopy(myTypeArray, 0, myTypeArray2, 0, myTypeArray.length);
                    myTypeArray2[myTypeArray.length] = myType;
                    myTypeArray = myTypeArray2;
                }
                dataInputStream.close();
            }
            catch (IOException iOException) {
                return null;
            }
            return myTypeArray;
        }
        return null;
    }

    protected String[] getTypeNames() {
        return new String[]{MYTYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{MYTYPEID};
    }

    boolean checkMyType(Object object) {
        if (object == null || !(object instanceof MyType[]) || ((MyType[])object).length == 0) {
            return false;
        }
        MyType[] myTypeArray = (MyType[])object;
        for (int i = 0; i < myTypeArray.length; ++i) {
            if (myTypeArray[i] != null && myTypeArray[i].firstName != null && myTypeArray[i].firstName.length() != 0 && myTypeArray[i].lastName != null && myTypeArray[i].lastName.length() != 0) continue;
            return false;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkMyType(object);
    }
}

