/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

abstract class AlignableTab
extends Tab {
    Button leftButton;
    Button rightButton;
    Button centerButton;
    Group alignmentGroup;

    AlignableTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createControlGroup() {
        super.createControlGroup();
        this.alignmentGroup = new Group((Composite)this.controlGroup, 0);
        this.alignmentGroup.setLayout((Layout)new GridLayout());
        this.alignmentGroup.setLayoutData((Object)new GridData(272));
        this.alignmentGroup.setText(ControlExample.getResourceString("Alignment"));
        this.leftButton = new Button((Composite)this.alignmentGroup, 16);
        this.leftButton.setText(ControlExample.getResourceString("Left"));
        this.centerButton = new Button((Composite)this.alignmentGroup, 16);
        this.centerButton.setText(ControlExample.getResourceString("Center"));
        this.rightButton = new Button((Composite)this.alignmentGroup, 16);
        this.rightButton.setText(ControlExample.getResourceString("Right"));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!((Button)selectionEvent.widget).getSelection()) {
                    return;
                }
                AlignableTab.this.setExampleWidgetAlignment();
            }
        };
        this.leftButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.centerButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.rightButton.addSelectionListener((SelectionListener)selectionAdapter);
    }

    abstract void setExampleWidgetAlignment();

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        Control[] controlArray = this.getExampleWidgets();
        if (controlArray.length != 0) {
            this.leftButton.setSelection((controlArray[0].getStyle() & 0x4000) != 0);
            this.centerButton.setSelection((controlArray[0].getStyle() & 0x1000000) != 0);
            this.rightButton.setSelection((controlArray[0].getStyle() & 0x20000) != 0);
        }
    }
}

