/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.examples.controlexample.AlignableTab;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

class AmpersandTestTab
extends AlignableTab {
    Button button1;
    Button button2;
    Button button3;
    Group textButtonGroup;

    AmpersandTestTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createControlGroup() {
        super.createControlGroup();
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.textButtonGroup = new Group((Composite)this.exampleGroup, 0);
        GridLayout gridLayout = new GridLayout();
        this.textButtonGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        this.textButtonGroup.setLayoutData((Object)new GridData(784));
        this.textButtonGroup.setText(ControlExample.getResourceString("Text_Buttons"));
    }

    @Override
    void createExampleWidgets() {
        int n = this.getDefaultStyle();
        if (this.borderButton.getSelection()) {
            n |= 0x800;
        }
        if (this.leftButton.getSelection()) {
            n |= 0x4000;
        }
        if (this.rightButton.getSelection()) {
            n |= 0x20000;
        }
        this.button1 = new Button((Composite)this.textButtonGroup, n);
        this.button1.setText("Standard Text");
        this.button2 = new Button((Composite)this.textButtonGroup, n);
        this.button2.setText("With &Mnemonic");
        this.button3 = new Button((Composite)this.textButtonGroup, n);
        this.button3.setText("Text with free && in it.");
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.button1, this.button2, this.button3};
    }

    @Override
    String getTabText() {
        return "AmpersandTestTab";
    }

    @Override
    void setExampleWidgetAlignment() {
        int n = 0;
        if (this.leftButton.getSelection()) {
            n = 16384;
        }
        if (this.centerButton.getSelection()) {
            n = 0x1000000;
        }
        if (this.rightButton.getSelection()) {
            n = 131072;
        }
        this.button1.setAlignment(n);
        this.button2.setAlignment(n);
        this.button3.setAlignment(n);
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.borderButton.setSelection((this.button1.getStyle() & 0x800) != 0);
    }
}

