/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.AlignableTab;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

class CLabelTab
extends AlignableTab {
    CLabel label1;
    CLabel label2;
    CLabel label3;
    Group textLabelGroup;
    Button shadowInButton;
    Button shadowOutButton;
    Button shadowNoneButton;

    CLabelTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.textLabelGroup = new Group((Composite)this.exampleGroup, 0);
        GridLayout gridLayout = new GridLayout();
        this.textLabelGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        this.textLabelGroup.setLayoutData((Object)new GridData(784));
        this.textLabelGroup.setText(ControlExample.getResourceString("Custom_Labels"));
    }

    @Override
    void createExampleWidgets() {
        int n = this.getDefaultStyle();
        if (this.shadowInButton.getSelection()) {
            n |= 4;
        }
        if (this.shadowNoneButton.getSelection()) {
            n |= 0x20;
        }
        if (this.shadowOutButton.getSelection()) {
            n |= 8;
        }
        if (this.leftButton.getSelection()) {
            n |= 0x4000;
        }
        if (this.centerButton.getSelection()) {
            n |= 0x1000000;
        }
        if (this.rightButton.getSelection()) {
            n |= 0x20000;
        }
        this.label1 = new CLabel((Composite)this.textLabelGroup, n);
        this.label1.setText(ControlExample.getResourceString("One"));
        this.label1.setImage(this.instance.images[0]);
        this.label2 = new CLabel((Composite)this.textLabelGroup, n);
        this.label2.setImage(this.instance.images[2]);
        this.label3 = new CLabel((Composite)this.textLabelGroup, n);
        this.label3.setText(ControlExample.getResourceString("Example_string") + "\n" + ControlExample.getResourceString("One_Two_Three"));
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.shadowNoneButton = new Button((Composite)this.styleGroup, 16);
        this.shadowNoneButton.setText("SWT.SHADOW_NONE");
        this.shadowInButton = new Button((Composite)this.styleGroup, 16);
        this.shadowInButton.setText("SWT.SHADOW_IN");
        this.shadowOutButton = new Button((Composite)this.styleGroup, 16);
        this.shadowOutButton.setText("SWT.SHADOW_OUT");
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if ((selectionEvent.widget.getStyle() & 0x10) != 0 && !((Button)selectionEvent.widget).getSelection()) {
                    return;
                }
                CLabelTab.this.recreateExampleWidgets();
            }
        };
        this.shadowInButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.shadowOutButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.shadowNoneButton.addSelectionListener((SelectionListener)selectionAdapter);
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.label1, this.label2, this.label3};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"Text"};
    }

    @Override
    String getTabText() {
        return "CLabel";
    }

    @Override
    void setExampleWidgetAlignment() {
        int n = 0;
        if (this.leftButton.getSelection()) {
            n = 16384;
        }
        if (this.centerButton.getSelection()) {
            n = 0x1000000;
        }
        if (this.rightButton.getSelection()) {
            n = 131072;
        }
        this.label1.setAlignment(n);
        this.label2.setAlignment(n);
        this.label3.setAlignment(n);
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.leftButton.setSelection((this.label1.getStyle() & 0x4000) != 0);
        this.centerButton.setSelection((this.label1.getStyle() & 0x1000000) != 0);
        this.rightButton.setSelection((this.label1.getStyle() & 0x20000) != 0);
        this.shadowInButton.setSelection((this.label1.getStyle() & 4) != 0);
        this.shadowOutButton.setSelection((this.label1.getStyle() & 8) != 0);
        this.shadowNoneButton.setSelection((this.label1.getStyle() & 0xC) == 0);
    }
}

