/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class CTabFolderTab
extends Tab {
    int lastSelectedTab = 0;
    CTabFolder tabFolder1;
    Group tabFolderGroup;
    Group itemGroup;
    Button topButton;
    Button bottomButton;
    Button flatButton;
    Button closeButton;
    static String[] CTabItems1 = new String[]{ControlExample.getResourceString("CTabItem1_0"), ControlExample.getResourceString("CTabItem1_1"), ControlExample.getResourceString("CTabItem1_2")};
    Button foregroundSelectionButton;
    Button backgroundSelectionButton;
    Button itemFontButton;
    Image foregroundSelectionImage;
    Image backgroundSelectionImage;
    Color foregroundSelectionColor;
    Color backgroundSelectionColor;
    Font itemFont;
    Button simpleTabButton;
    Button singleTabButton;
    Button imageButton;
    Button showMinButton;
    Button showMaxButton;
    Button unselectedCloseButton;
    Button unselectedImageButton;

    CTabFolderTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createColorGroup() {
        this.colorGroup = new Group((Composite)this.controlGroup, 0);
        this.colorGroup.setLayout((Layout)new GridLayout(2, false));
        this.colorGroup.setLayoutData((Object)new GridData(272));
        this.colorGroup.setText(ControlExample.getResourceString("Colors"));
        new Label((Composite)this.colorGroup, 0).setText(ControlExample.getResourceString("Foreground_Color"));
        this.foregroundButton = new Button((Composite)this.colorGroup, 8);
        new Label((Composite)this.colorGroup, 0).setText(ControlExample.getResourceString("Background_Color"));
        this.backgroundButton = new Button((Composite)this.colorGroup, 8);
        new Label((Composite)this.colorGroup, 0).setText(ControlExample.getResourceString("Selection_Foreground_Color"));
        this.foregroundSelectionButton = new Button((Composite)this.colorGroup, 8);
        new Label((Composite)this.colorGroup, 0).setText(ControlExample.getResourceString("Selection_Background_Color"));
        this.backgroundSelectionButton = new Button((Composite)this.colorGroup, 8);
        this.fontButton = new Button((Composite)this.colorGroup, 8);
        this.fontButton.setText(ControlExample.getResourceString("Font"));
        this.fontButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.itemFontButton = new Button((Composite)this.colorGroup, 8);
        this.itemFontButton.setText(ControlExample.getResourceString("Item_Font"));
        this.itemFontButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Button button = new Button((Composite)this.colorGroup, 8);
        button.setText(ControlExample.getResourceString("Defaults"));
        Shell shell = this.controlGroup.getShell();
        final ColorDialog colorDialog = new ColorDialog(shell);
        final FontDialog fontDialog = new FontDialog(shell);
        int n = 12;
        Display display = shell.getDisplay();
        this.foregroundImage = new Image((Device)display, n, n);
        this.backgroundImage = new Image((Device)display, n, n);
        this.foregroundSelectionImage = new Image((Device)display, n, n);
        this.backgroundSelectionImage = new Image((Device)display, n, n);
        this.foregroundButton.setImage(this.foregroundImage);
        this.foregroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RGB rGB;
                Color color = CTabFolderTab.this.foregroundColor;
                if (color == null && ((Control[])(rGB = CTabFolderTab.this.getExampleWidgets())).length > 0) {
                    color = rGB[0].getForeground();
                }
                if (color != null) {
                    colorDialog.setRGB(color.getRGB());
                }
                if ((rGB = colorDialog.open()) == null) {
                    return;
                }
                color = CTabFolderTab.this.foregroundColor;
                CTabFolderTab.this.foregroundColor = new Color((Device)selectionEvent.display, rGB);
                CTabFolderTab.this.setExampleWidgetForeground();
                if (color != null) {
                    color.dispose();
                }
            }
        });
        this.backgroundButton.setImage(this.backgroundImage);
        this.backgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RGB rGB;
                Color color = CTabFolderTab.this.backgroundColor;
                if (color == null && ((Control[])(rGB = CTabFolderTab.this.getExampleWidgets())).length > 0) {
                    color = rGB[0].getBackground();
                }
                if (color != null) {
                    colorDialog.setRGB(color.getRGB());
                }
                if ((rGB = colorDialog.open()) == null) {
                    return;
                }
                color = CTabFolderTab.this.backgroundColor;
                CTabFolderTab.this.backgroundColor = new Color((Device)selectionEvent.display, rGB);
                CTabFolderTab.this.setExampleWidgetBackground();
                if (color != null) {
                    color.dispose();
                }
            }
        });
        this.foregroundSelectionButton.setImage(this.foregroundSelectionImage);
        this.foregroundSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RGB rGB;
                Color color = CTabFolderTab.this.foregroundSelectionColor;
                if (color == null && ((Control[])(rGB = CTabFolderTab.this.getExampleWidgets())).length > 0) {
                    color = rGB[0].getForeground();
                }
                if (color != null) {
                    colorDialog.setRGB(color.getRGB());
                }
                if ((rGB = colorDialog.open()) == null) {
                    return;
                }
                color = CTabFolderTab.this.foregroundSelectionColor;
                CTabFolderTab.this.foregroundSelectionColor = new Color((Device)selectionEvent.display, rGB);
                CTabFolderTab.this.setExampleWidgetForeground();
                if (color != null) {
                    color.dispose();
                }
            }
        });
        this.backgroundSelectionButton.setImage(this.backgroundSelectionImage);
        this.backgroundSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RGB rGB;
                Color color = CTabFolderTab.this.backgroundSelectionColor;
                if (color == null && ((Control[])(rGB = CTabFolderTab.this.getExampleWidgets())).length > 0) {
                    color = rGB[0].getBackground();
                }
                if (color != null) {
                    colorDialog.setRGB(color.getRGB());
                }
                if ((rGB = colorDialog.open()) == null) {
                    return;
                }
                color = CTabFolderTab.this.backgroundSelectionColor;
                CTabFolderTab.this.backgroundSelectionColor = new Color((Device)selectionEvent.display, rGB);
                CTabFolderTab.this.setExampleWidgetBackground();
                if (color != null) {
                    color.dispose();
                }
            }
        });
        this.fontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FontData fontData;
                Font font = CTabFolderTab.this.font;
                if (font == null && ((Control[])(fontData = CTabFolderTab.this.getExampleWidgets())).length > 0) {
                    font = fontData[0].getFont();
                }
                if (font != null) {
                    fontDialog.setFontList(font.getFontData());
                }
                if ((fontData = fontDialog.open()) == null) {
                    return;
                }
                font = CTabFolderTab.this.font;
                CTabFolderTab.this.font = new Font((Device)selectionEvent.display, fontData);
                CTabFolderTab.this.setExampleWidgetFont();
                CTabFolderTab.this.setExampleWidgetSize();
                if (font != null) {
                    font.dispose();
                }
            }
        });
        this.itemFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Font font = CTabFolderTab.this.itemFont;
                if (font == null) {
                    font = CTabFolderTab.this.tabFolder1.getItem(0).getFont();
                }
                fontDialog.setFontList(font.getFontData());
                FontData fontData = fontDialog.open();
                if (fontData == null) {
                    return;
                }
                font = CTabFolderTab.this.itemFont;
                CTabFolderTab.this.itemFont = new Font((Device)selectionEvent.display, fontData);
                CTabFolderTab.this.setItemFont();
                CTabFolderTab.this.setExampleWidgetSize();
                if (font != null) {
                    font.dispose();
                }
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CTabFolderTab.this.resetColorsAndFonts();
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (CTabFolderTab.this.foregroundImage != null) {
                    CTabFolderTab.this.foregroundImage.dispose();
                }
                if (CTabFolderTab.this.backgroundImage != null) {
                    CTabFolderTab.this.backgroundImage.dispose();
                }
                if (CTabFolderTab.this.foregroundColor != null) {
                    CTabFolderTab.this.foregroundColor.dispose();
                }
                if (CTabFolderTab.this.backgroundColor != null) {
                    CTabFolderTab.this.backgroundColor.dispose();
                }
                if (CTabFolderTab.this.font != null) {
                    CTabFolderTab.this.font.dispose();
                }
                CTabFolderTab.this.foregroundColor = null;
                CTabFolderTab.this.backgroundColor = null;
                CTabFolderTab.this.font = null;
                if (CTabFolderTab.this.foregroundSelectionImage != null) {
                    CTabFolderTab.this.foregroundSelectionImage.dispose();
                }
                if (CTabFolderTab.this.backgroundSelectionImage != null) {
                    CTabFolderTab.this.backgroundSelectionImage.dispose();
                }
                if (CTabFolderTab.this.foregroundSelectionColor != null) {
                    CTabFolderTab.this.foregroundSelectionColor.dispose();
                }
                if (CTabFolderTab.this.backgroundSelectionColor != null) {
                    CTabFolderTab.this.backgroundSelectionColor.dispose();
                }
                CTabFolderTab.this.foregroundSelectionColor = null;
                CTabFolderTab.this.backgroundSelectionColor = null;
                if (CTabFolderTab.this.itemFont != null) {
                    CTabFolderTab.this.itemFont.dispose();
                }
                CTabFolderTab.this.itemFont = null;
            }
        });
    }

    @Override
    void createOtherGroup() {
        super.createOtherGroup();
        this.simpleTabButton = new Button((Composite)this.otherGroup, 32);
        this.simpleTabButton.setText(ControlExample.getResourceString("Set_Simple_Tabs"));
        this.simpleTabButton.setSelection(true);
        this.simpleTabButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CTabFolderTab.this.setSimpleTabs();
            }
        });
        this.singleTabButton = new Button((Composite)this.otherGroup, 32);
        this.singleTabButton.setText(ControlExample.getResourceString("Set_Single_Tabs"));
        this.singleTabButton.setSelection(false);
        this.singleTabButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CTabFolderTab.this.setSingleTabs();
            }
        });
        this.showMinButton = new Button((Composite)this.otherGroup, 32);
        this.showMinButton.setText(ControlExample.getResourceString("Set_Min_Visible"));
        this.showMinButton.setSelection(false);
        this.showMinButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CTabFolderTab.this.setMinimizeVisible();
            }
        });
        this.showMaxButton = new Button((Composite)this.otherGroup, 32);
        this.showMaxButton.setText(ControlExample.getResourceString("Set_Max_Visible"));
        this.showMaxButton.setSelection(false);
        this.showMaxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CTabFolderTab.this.setMaximizeVisible();
            }
        });
        this.imageButton = new Button((Composite)this.otherGroup, 32);
        this.imageButton.setText(ControlExample.getResourceString("Set_Image"));
        this.imageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CTabFolderTab.this.setImages();
            }
        });
        this.unselectedImageButton = new Button((Composite)this.otherGroup, 32);
        this.unselectedImageButton.setText(ControlExample.getResourceString("Set_Unselected_Image_Visible"));
        this.unselectedImageButton.setSelection(true);
        this.unselectedImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CTabFolderTab.this.setUnselectedImageVisible();
            }
        });
        this.unselectedCloseButton = new Button((Composite)this.otherGroup, 32);
        this.unselectedCloseButton.setText(ControlExample.getResourceString("Set_Unselected_Close_Visible"));
        this.unselectedCloseButton.setSelection(true);
        this.unselectedCloseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CTabFolderTab.this.setUnselectedCloseVisible();
            }
        });
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.tabFolderGroup = new Group((Composite)this.exampleGroup, 0);
        this.tabFolderGroup.setLayout((Layout)new GridLayout());
        this.tabFolderGroup.setLayoutData((Object)new GridData(784));
        this.tabFolderGroup.setText("CTabFolder");
    }

    @Override
    void createExampleWidgets() {
        int n = this.getDefaultStyle();
        if (this.topButton.getSelection()) {
            n |= 0x80;
        }
        if (this.bottomButton.getSelection()) {
            n |= 0x400;
        }
        if (this.borderButton.getSelection()) {
            n |= 0x800;
        }
        if (this.flatButton.getSelection()) {
            n |= 0x800000;
        }
        if (this.closeButton.getSelection()) {
            n |= 0x40;
        }
        this.tabFolder1 = new CTabFolder((Composite)this.tabFolderGroup, n);
        for (int i = 0; i < CTabItems1.length; ++i) {
            CTabItem cTabItem = new CTabItem(this.tabFolder1, 0);
            cTabItem.setText(CTabItems1[i]);
            Text text = new Text((Composite)this.tabFolder1, 8);
            text.setText(ControlExample.getResourceString("CTabItem_content") + ": " + i);
            cTabItem.setControl((Control)text);
        }
        this.tabFolder1.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CTabFolderTab.this.lastSelectedTab = CTabFolderTab.this.tabFolder1.getSelectionIndex();
            }
        });
        this.tabFolder1.setSelection(this.lastSelectedTab);
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.topButton = new Button((Composite)this.styleGroup, 16);
        this.topButton.setText("SWT.TOP");
        this.topButton.setSelection(true);
        this.bottomButton = new Button((Composite)this.styleGroup, 16);
        this.bottomButton.setText("SWT.BOTTOM");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
        this.flatButton = new Button((Composite)this.styleGroup, 32);
        this.flatButton.setText("SWT.FLAT");
        this.closeButton = new Button((Composite)this.styleGroup, 32);
        this.closeButton.setText("SWT.CLOSE");
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if ((selectionEvent.widget.getStyle() & 0x10) != 0 && !((Button)selectionEvent.widget).getSelection()) {
                    return;
                }
                CTabFolderTab.this.recreateExampleWidgets();
            }
        };
        this.topButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.bottomButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.borderButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.flatButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.closeButton.addSelectionListener((SelectionListener)selectionAdapter);
    }

    @Override
    String[] getCustomEventNames() {
        return new String[]{"CTabFolderEvent"};
    }

    @Override
    Item[] getExampleWidgetItems() {
        return this.tabFolder1.getItems();
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.tabFolder1};
    }

    @Override
    String getTabText() {
        return "CTabFolder";
    }

    @Override
    void hookCustomListener(final String string) {
        if (string == "CTabFolderEvent") {
            this.tabFolder1.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                public void close(CTabFolderEvent cTabFolderEvent) {
                    CTabFolderTab.this.log(string, (TypedEvent)cTabFolderEvent);
                }
            });
        }
    }

    @Override
    void resetColorsAndFonts() {
        Color color = this.foregroundSelectionColor;
        this.foregroundSelectionColor = null;
        if (color != null) {
            color.dispose();
        }
        color = this.backgroundSelectionColor;
        this.backgroundSelectionColor = null;
        if (color != null) {
            color.dispose();
        }
        Font font = this.itemFont;
        this.itemFont = null;
        if (font != null) {
            font.dispose();
        }
        super.resetColorsAndFonts();
    }

    @Override
    void setExampleWidgetForeground() {
        if (this.foregroundSelectionButton == null || this.tabFolder1 == null) {
            return;
        }
        this.tabFolder1.setSelectionForeground(this.foregroundSelectionColor);
        Color color = this.foregroundSelectionColor;
        if (color == null) {
            color = this.tabFolder1.getSelectionForeground();
        }
        this.drawImage(this.foregroundSelectionImage, color);
        this.foregroundSelectionButton.setImage(this.foregroundSelectionImage);
        super.setExampleWidgetForeground();
    }

    @Override
    void setExampleWidgetBackground() {
        if (this.backgroundSelectionButton == null || this.tabFolder1 == null) {
            return;
        }
        this.tabFolder1.setSelectionBackground(this.backgroundSelectionColor);
        Color color = this.backgroundSelectionColor;
        if (color == null) {
            color = this.tabFolder1.getSelectionBackground();
        }
        this.drawImage(this.backgroundSelectionImage, color);
        this.backgroundSelectionButton.setImage(this.backgroundSelectionImage);
        super.setExampleWidgetBackground();
    }

    @Override
    void setExampleWidgetFont() {
        if (this.instance.startup) {
            return;
        }
        if (this.itemFontButton == null) {
            return;
        }
        CTabItem[] cTabItemArray = this.tabFolder1.getItems();
        if (cTabItemArray.length > 0) {
            cTabItemArray[0].setFont(this.itemFont);
        }
        super.setExampleWidgetFont();
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.setSimpleTabs();
        this.setSingleTabs();
        this.setImages();
        this.setMinimizeVisible();
        this.setMaximizeVisible();
        this.setUnselectedCloseVisible();
        this.setUnselectedImageVisible();
        this.setExampleWidgetSize();
    }

    void setSimpleTabs() {
        this.tabFolder1.setSimple(this.simpleTabButton.getSelection());
        this.setExampleWidgetSize();
    }

    void setSingleTabs() {
        this.tabFolder1.setSingle(this.singleTabButton.getSelection());
        this.setExampleWidgetSize();
    }

    void setImages() {
        boolean bl = this.imageButton.getSelection();
        CTabItem[] cTabItemArray = this.tabFolder1.getItems();
        for (int i = 0; i < cTabItemArray.length; ++i) {
            if (bl) {
                cTabItemArray[i].setImage(this.instance.images[0]);
                continue;
            }
            cTabItemArray[i].setImage(null);
        }
        this.setExampleWidgetSize();
    }

    void setMinimizeVisible() {
        this.tabFolder1.setMinimizeVisible(this.showMinButton.getSelection());
        this.setExampleWidgetSize();
    }

    void setMaximizeVisible() {
        this.tabFolder1.setMaximizeVisible(this.showMaxButton.getSelection());
        this.setExampleWidgetSize();
    }

    void setUnselectedCloseVisible() {
        this.tabFolder1.setUnselectedCloseVisible(this.unselectedCloseButton.getSelection());
        this.setExampleWidgetSize();
    }

    void setUnselectedImageVisible() {
        this.tabFolder1.setUnselectedImageVisible(this.unselectedImageButton.getSelection());
        this.setExampleWidgetSize();
    }

    void setItemFont() {
        if (this.instance.startup) {
            return;
        }
        this.tabFolder1.getItem(0).setFont(this.itemFont);
        this.setExampleWidgetSize();
    }
}

