/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.examples.controlexample.AmpersandTestTab;
import org.eclipse.swt.examples.controlexample.ButtonTab;
import org.eclipse.swt.examples.controlexample.CanvasTab;
import org.eclipse.swt.examples.controlexample.ComboTab;
import org.eclipse.swt.examples.controlexample.CoolBarTab;
import org.eclipse.swt.examples.controlexample.DialogTab;
import org.eclipse.swt.examples.controlexample.GroupTab;
import org.eclipse.swt.examples.controlexample.LabelTab;
import org.eclipse.swt.examples.controlexample.LinkTab;
import org.eclipse.swt.examples.controlexample.ListTab;
import org.eclipse.swt.examples.controlexample.MenuTab;
import org.eclipse.swt.examples.controlexample.ProgressBarTab;
import org.eclipse.swt.examples.controlexample.SashTab;
import org.eclipse.swt.examples.controlexample.ShellTab;
import org.eclipse.swt.examples.controlexample.SliderTab;
import org.eclipse.swt.examples.controlexample.SpinnerTab;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.examples.controlexample.TabFolderTab;
import org.eclipse.swt.examples.controlexample.TableTab;
import org.eclipse.swt.examples.controlexample.TextTab;
import org.eclipse.swt.examples.controlexample.ToolBarTab;
import org.eclipse.swt.examples.controlexample.TreeTab;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ControlExample {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_control");
    private ShellTab shellTab;
    private TabFolder tabFolder;
    Image[] images;
    static final int ciClosedFolder = 0;
    static final int ciOpenFolder = 1;
    static final int ciTarget = 2;
    static final String[] imageLocations = new String[]{"closedFolder.gif", "openFolder.gif", "target.gif"};
    boolean startup = true;

    public ControlExample(Composite composite) {
        this.initResources();
        this.tabFolder = new TabFolder(composite, 0);
        Tab[] tabArray = this.createTabs();
        for (int i = 0; i < tabArray.length; ++i) {
            TabItem tabItem = new TabItem(this.tabFolder, 0);
            tabItem.setText(tabArray[i].getTabText());
            tabItem.setControl((Control)tabArray[i].createTabFolderPage(this.tabFolder));
            tabItem.setData((Object)tabArray[i]);
        }
        this.startup = false;
    }

    Tab[] createTabs() {
        Tab[] tabArray = new Tab[21];
        tabArray[0] = new ButtonTab(this);
        tabArray[1] = new CanvasTab(this);
        tabArray[2] = new ComboTab(this);
        tabArray[3] = new CoolBarTab(this);
        tabArray[4] = new DialogTab(this);
        tabArray[5] = new GroupTab(this);
        tabArray[6] = new LabelTab(this);
        tabArray[7] = new LinkTab(this);
        tabArray[8] = new ListTab(this);
        tabArray[9] = new MenuTab(this);
        tabArray[10] = new ProgressBarTab(this);
        tabArray[11] = new SashTab(this);
        this.shellTab = new ShellTab(this);
        tabArray[12] = this.shellTab;
        tabArray[13] = new SliderTab(this);
        tabArray[14] = new SpinnerTab(this);
        tabArray[15] = new TabFolderTab(this);
        tabArray[16] = new TableTab(this);
        tabArray[17] = new TextTab(this);
        tabArray[18] = new ToolBarTab(this);
        tabArray[19] = new TreeTab(this);
        tabArray[20] = new AmpersandTestTab(this);
        return tabArray;
    }

    public void dispose() {
        if (this.shellTab != null) {
            this.shellTab.closeAllShells();
        }
        this.shellTab = null;
        this.tabFolder = null;
        this.freeResources();
    }

    void freeResources() {
        if (this.images != null) {
            for (int i = 0; i < this.images.length; ++i) {
                Image image = this.images[i];
                if (image == null) continue;
                image.dispose();
            }
            this.images = null;
        }
    }

    static String getResourceString(String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + string + "!";
        }
    }

    static String getResourceString(String string, Object[] objectArray) {
        try {
            return MessageFormat.format(ControlExample.getResourceString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + string + "!";
        }
    }

    void initResources() {
        Class<ControlExample> clazz = ControlExample.class;
        if (resourceBundle != null) {
            try {
                if (this.images == null) {
                    this.images = new Image[imageLocations.length];
                    for (int i = 0; i < imageLocations.length; ++i) {
                        InputStream inputStream = clazz.getResourceAsStream(imageLocations[i]);
                        ImageData imageData = new ImageData(inputStream);
                        ImageData imageData2 = imageData.getTransparencyMask();
                        this.images[i] = new Image(null, imageData, imageData2);
                        try {
                            inputStream.close();
                            continue;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String string = resourceBundle != null ? ControlExample.getResourceString("error.CouldNotLoadResources") : "Unable to load resources";
        this.freeResources();
        throw new RuntimeException(string);
    }

    public static void main(String[] stringArray) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        ControlExample controlExample = new ControlExample((Composite)shell);
        shell.setText(ControlExample.getResourceString("window.title"));
        ControlExample.setShellSize(display, shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        controlExample.dispose();
        System.exit(0);
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }

    static void setShellSize(Display display, Shell shell) {
        Rectangle rectangle = display.getBounds();
        Point point = shell.computeSize(-1, -1);
        if (point.x > rectangle.width) {
            point.x = rectangle.width * 9 / 10;
        }
        if (point.y > rectangle.height) {
            point.y = rectangle.height * 9 / 10;
        }
        shell.setSize(point);
    }
}

