/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class DialogTab
extends Tab {
    Group dialogStyleGroup;
    Group resultGroup;
    Text textWidget;
    Combo dialogCombo;
    Button createButton;
    Button okButton;
    Button cancelButton;
    Button yesButton;
    Button noButton;
    Button retryButton;
    Button abortButton;
    Button ignoreButton;
    Button iconErrorButton;
    Button iconInformationButton;
    Button iconQuestionButton;
    Button iconWarningButton;
    Button iconWorkingButton;
    Button modelessButton;
    Button primaryModalButton;
    Button applicationModalButton;
    Button systemModalButton;
    Button saveButton;
    Button openButton;
    Button multiButton;
    static String[] FilterExtensions = new String[]{"*.txt", "*.bat", "*.doc", "*"};
    static String[] FilterNames = new String[]{ControlExample.getResourceString("FilterName_0"), ControlExample.getResourceString("FilterName_1"), ControlExample.getResourceString("FilterName_2"), ControlExample.getResourceString("FilterName_3")};

    DialogTab(ControlExample controlExample) {
        super(controlExample);
    }

    void buttonStyleSelected(SelectionEvent selectionEvent) {
        boolean bl = this.okButton.getSelection();
        boolean bl2 = this.cancelButton.getSelection();
        boolean bl3 = this.yesButton.getSelection();
        boolean bl4 = this.noButton.getSelection();
        boolean bl5 = this.abortButton.getSelection();
        boolean bl6 = this.retryButton.getSelection();
        boolean bl7 = this.ignoreButton.getSelection();
        this.okButton.setEnabled(!bl3 && !bl4 && !bl6 && !bl5 && !bl7);
        this.cancelButton.setEnabled(!bl5 && !bl7 && bl3 == bl4);
        this.yesButton.setEnabled(!bl && !bl6 && !bl5 && !bl7 && (!bl2 || bl3 || bl4));
        this.noButton.setEnabled(!bl && !bl6 && !bl5 && !bl7 && (!bl2 || bl3 || bl4));
        this.retryButton.setEnabled(!bl && !bl3 && !bl4);
        this.abortButton.setEnabled(!bl && !bl2 && !bl3 && !bl4);
        this.ignoreButton.setEnabled(!bl && !bl2 && !bl3 && !bl4);
        this.createButton.setEnabled(!bl && !bl2 && !bl3 && !bl4 && !bl6 && !bl5 && !bl7 || bl || bl3 && bl4 || bl3 && bl4 && bl2 || bl6 && bl2 || bl5 && bl6 && bl7);
    }

    void createButtonSelected(SelectionEvent selectionEvent) {
        int n = this.getDefaultStyle();
        if (this.okButton.getEnabled() && this.okButton.getSelection()) {
            n |= 0x20;
        }
        if (this.cancelButton.getEnabled() && this.cancelButton.getSelection()) {
            n |= 0x100;
        }
        if (this.yesButton.getEnabled() && this.yesButton.getSelection()) {
            n |= 0x40;
        }
        if (this.noButton.getEnabled() && this.noButton.getSelection()) {
            n |= 0x80;
        }
        if (this.retryButton.getEnabled() && this.retryButton.getSelection()) {
            n |= 0x400;
        }
        if (this.abortButton.getEnabled() && this.abortButton.getSelection()) {
            n |= 0x200;
        }
        if (this.ignoreButton.getEnabled() && this.ignoreButton.getSelection()) {
            n |= 0x800;
        }
        if (this.iconErrorButton.getEnabled() && this.iconErrorButton.getSelection()) {
            n |= 1;
        }
        if (this.iconInformationButton.getEnabled() && this.iconInformationButton.getSelection()) {
            n |= 2;
        }
        if (this.iconQuestionButton.getEnabled() && this.iconQuestionButton.getSelection()) {
            n |= 4;
        }
        if (this.iconWarningButton.getEnabled() && this.iconWarningButton.getSelection()) {
            n |= 8;
        }
        if (this.iconWorkingButton.getEnabled() && this.iconWorkingButton.getSelection()) {
            n |= 0x10;
        }
        if (this.primaryModalButton.getEnabled() && this.primaryModalButton.getSelection()) {
            n |= 0x8000;
        }
        if (this.applicationModalButton.getEnabled() && this.applicationModalButton.getSelection()) {
            n |= 0x10000;
        }
        if (this.systemModalButton.getEnabled() && this.systemModalButton.getSelection()) {
            n |= 0x20000;
        }
        if (this.saveButton.getEnabled() && this.saveButton.getSelection()) {
            n |= 0x2000;
        }
        if (this.openButton.getEnabled() && this.openButton.getSelection()) {
            n |= 0x1000;
        }
        if (this.multiButton.getEnabled() && this.multiButton.getSelection()) {
            n |= 2;
        }
        String string = this.dialogCombo.getText();
        Shell shell = this.tabFolderPage.getShell();
        if (string.equals(ControlExample.getResourceString("ColorDialog"))) {
            ColorDialog colorDialog = new ColorDialog(shell, n);
            colorDialog.setRGB(new RGB(100, 100, 100));
            colorDialog.setText(ControlExample.getResourceString("Title"));
            RGB rGB = colorDialog.open();
            this.textWidget.append(ControlExample.getResourceString("ColorDialog") + Text.DELIMITER);
            this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"" + rGB}) + Text.DELIMITER + Text.DELIMITER);
            return;
        }
        if (string.equals(ControlExample.getResourceString("DirectoryDialog"))) {
            DirectoryDialog directoryDialog = new DirectoryDialog(shell, n);
            directoryDialog.setMessage(ControlExample.getResourceString("Example_string"));
            directoryDialog.setText(ControlExample.getResourceString("Title"));
            String string2 = directoryDialog.open();
            this.textWidget.append(ControlExample.getResourceString("DirectoryDialog") + Text.DELIMITER);
            this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"" + string2}) + Text.DELIMITER + Text.DELIMITER);
            return;
        }
        if (string.equals(ControlExample.getResourceString("FileDialog"))) {
            FileDialog fileDialog = new FileDialog(shell, n);
            fileDialog.setFileName(ControlExample.getResourceString("readme_txt"));
            fileDialog.setFilterNames(FilterNames);
            fileDialog.setFilterExtensions(FilterExtensions);
            fileDialog.setText(ControlExample.getResourceString("Title"));
            String string3 = fileDialog.open();
            this.textWidget.append(ControlExample.getResourceString("FileDialog") + Text.DELIMITER);
            this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"" + string3}) + Text.DELIMITER + Text.DELIMITER);
            String[] stringArray = fileDialog.getFileNames();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                this.textWidget.append(stringArray[i] + Text.DELIMITER + Text.DELIMITER);
            }
            return;
        }
        if (string.equals(ControlExample.getResourceString("FontDialog"))) {
            FontDialog fontDialog = new FontDialog(shell, n);
            fontDialog.setText(ControlExample.getResourceString("Title"));
            FontData fontData = fontDialog.open();
            this.textWidget.append(ControlExample.getResourceString("FontDialog") + Text.DELIMITER);
            this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"" + fontData}) + Text.DELIMITER + Text.DELIMITER);
            return;
        }
        if (string.equals(ControlExample.getResourceString("PrintDialog"))) {
            PrintDialog printDialog = new PrintDialog(shell, n);
            printDialog.setText(ControlExample.getResourceString("Title"));
            PrinterData printerData = printDialog.open();
            this.textWidget.append(ControlExample.getResourceString("PrintDialog") + Text.DELIMITER);
            this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"" + printerData}) + Text.DELIMITER + Text.DELIMITER);
            return;
        }
        if (string.equals(ControlExample.getResourceString("MessageBox"))) {
            MessageBox messageBox = new MessageBox(shell, n);
            messageBox.setMessage(ControlExample.getResourceString("Example_string"));
            messageBox.setText(ControlExample.getResourceString("Title"));
            int n2 = messageBox.open();
            this.textWidget.append(ControlExample.getResourceString("MessageBox") + Text.DELIMITER);
            switch (n2) {
                case 32: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.OK"}));
                    break;
                }
                case 64: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.YES"}));
                    break;
                }
                case 128: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.NO"}));
                    break;
                }
                case 256: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.CANCEL"}));
                    break;
                }
                case 512: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.ABORT"}));
                    break;
                }
                case 1024: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.RETRY"}));
                    break;
                }
                case 2048: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.IGNORE"}));
                    break;
                }
                default: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"" + n2}));
                }
            }
            this.textWidget.append(Text.DELIMITER + Text.DELIMITER);
        }
        if (string.equals("MyDialog")) {
            this.createMyDialog();
        }
    }

    @Override
    void createControlGroup() {
        this.controlGroup = new Group(this.tabFolderPage, 0);
        GridLayout gridLayout = new GridLayout();
        this.controlGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        this.controlGroup.setLayoutData((Object)new GridData(272));
        this.controlGroup.setText(ControlExample.getResourceString("Parameters"));
        this.dialogStyleGroup = new Group((Composite)this.controlGroup, 0);
        this.dialogStyleGroup.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(64);
        gridData.horizontalSpan = 2;
        this.dialogStyleGroup.setLayoutData((Object)gridData);
        this.dialogStyleGroup.setText(ControlExample.getResourceString("Dialog_Type"));
    }

    @Override
    void createControlWidgets() {
        String[] stringArray = new String[]{ControlExample.getResourceString("ColorDialog"), ControlExample.getResourceString("DirectoryDialog"), ControlExample.getResourceString("FileDialog"), ControlExample.getResourceString("FontDialog"), ControlExample.getResourceString("PrintDialog"), ControlExample.getResourceString("MessageBox"), "MyDialog"};
        this.dialogCombo = new Combo((Composite)this.dialogStyleGroup, 8);
        this.dialogCombo.setItems(stringArray);
        this.dialogCombo.setText(stringArray[0]);
        this.dialogCombo.setVisibleItemCount(stringArray.length);
        this.createButton = new Button((Composite)this.dialogStyleGroup, 0);
        this.createButton.setText(ControlExample.getResourceString("Create_Dialog"));
        this.createButton.setLayoutData((Object)new GridData(64));
        Group group = new Group((Composite)this.controlGroup, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(272));
        group.setText(ControlExample.getResourceString("Button_Styles"));
        this.okButton = new Button((Composite)group, 32);
        this.okButton.setText("SWT.OK");
        this.cancelButton = new Button((Composite)group, 32);
        this.cancelButton.setText("SWT.CANCEL");
        this.yesButton = new Button((Composite)group, 32);
        this.yesButton.setText("SWT.YES");
        this.noButton = new Button((Composite)group, 32);
        this.noButton.setText("SWT.NO");
        this.retryButton = new Button((Composite)group, 32);
        this.retryButton.setText("SWT.RETRY");
        this.abortButton = new Button((Composite)group, 32);
        this.abortButton.setText("SWT.ABORT");
        this.ignoreButton = new Button((Composite)group, 32);
        this.ignoreButton.setText("SWT.IGNORE");
        Group group2 = new Group((Composite)this.controlGroup, 0);
        group2.setLayout((Layout)new GridLayout());
        group2.setLayoutData((Object)new GridData(272));
        group2.setText(ControlExample.getResourceString("Icon_Styles"));
        this.iconErrorButton = new Button((Composite)group2, 16);
        this.iconErrorButton.setText("SWT.ICON_ERROR");
        this.iconInformationButton = new Button((Composite)group2, 16);
        this.iconInformationButton.setText("SWT.ICON_INFORMATION");
        this.iconQuestionButton = new Button((Composite)group2, 16);
        this.iconQuestionButton.setText("SWT.ICON_QUESTION");
        this.iconWarningButton = new Button((Composite)group2, 16);
        this.iconWarningButton.setText("SWT.ICON_WARNING");
        this.iconWorkingButton = new Button((Composite)group2, 16);
        this.iconWorkingButton.setText("SWT.ICON_WORKING");
        Group group3 = new Group((Composite)this.controlGroup, 0);
        group3.setLayout((Layout)new GridLayout());
        group3.setLayoutData((Object)new GridData(272));
        group3.setText(ControlExample.getResourceString("Modal_Styles"));
        this.modelessButton = new Button((Composite)group3, 16);
        this.modelessButton.setText("SWT.MODELESS");
        this.primaryModalButton = new Button((Composite)group3, 16);
        this.primaryModalButton.setText("SWT.PRIMARY_MODAL");
        this.applicationModalButton = new Button((Composite)group3, 16);
        this.applicationModalButton.setText("SWT.APPLICATION_MODAL");
        this.systemModalButton = new Button((Composite)group3, 16);
        this.systemModalButton.setText("SWT.SYSTEM_MODAL");
        Group group4 = new Group((Composite)this.controlGroup, 0);
        group4.setLayout((Layout)new GridLayout());
        group4.setLayoutData((Object)new GridData(272));
        group4.setText(ControlExample.getResourceString("File_Dialog_Styles"));
        this.openButton = new Button((Composite)group4, 16);
        this.openButton.setText("SWT.OPEN");
        this.saveButton = new Button((Composite)group4, 16);
        this.saveButton.setText("SWT.SAVE");
        this.multiButton = new Button((Composite)group4, 32);
        this.multiButton.setText("SWT.MULTI");
        this.dialogCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DialogTab.this.dialogSelected(selectionEvent);
            }
        });
        this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DialogTab.this.createButtonSelected(selectionEvent);
            }
        });
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DialogTab.this.buttonStyleSelected(selectionEvent);
            }
        };
        this.okButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.cancelButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.yesButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.noButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.retryButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.abortButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.ignoreButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.okButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.yesButton.setEnabled(false);
        this.noButton.setEnabled(false);
        this.retryButton.setEnabled(false);
        this.abortButton.setEnabled(false);
        this.ignoreButton.setEnabled(false);
        this.iconErrorButton.setEnabled(false);
        this.iconInformationButton.setEnabled(false);
        this.iconQuestionButton.setEnabled(false);
        this.iconWarningButton.setEnabled(false);
        this.iconWorkingButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.openButton.setEnabled(false);
        this.openButton.setSelection(true);
        this.multiButton.setEnabled(false);
        this.iconInformationButton.setSelection(true);
        this.modelessButton.setSelection(true);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.exampleGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.resultGroup = new Group((Composite)this.exampleGroup, 0);
        this.resultGroup.setLayout((Layout)new GridLayout());
        this.resultGroup.setLayoutData((Object)new GridData(1808));
        this.resultGroup.setText(ControlExample.getResourceString("Dialog_Result"));
    }

    @Override
    void createExampleWidgets() {
        this.textWidget = new Text((Composite)this.resultGroup, 2816);
        GridData gridData = new GridData(1808);
        this.textWidget.setLayoutData((Object)gridData);
    }

    @Override
    void createListenersGroup() {
    }

    void dialogSelected(SelectionEvent selectionEvent) {
        String string = this.dialogCombo.getText();
        boolean bl = string.equals(ControlExample.getResourceString("MessageBox"));
        boolean bl2 = string.equals(ControlExample.getResourceString("FileDialog"));
        this.okButton.setEnabled(bl);
        this.cancelButton.setEnabled(bl);
        this.yesButton.setEnabled(bl);
        this.noButton.setEnabled(bl);
        this.retryButton.setEnabled(bl);
        this.abortButton.setEnabled(bl);
        this.ignoreButton.setEnabled(bl);
        this.iconErrorButton.setEnabled(bl);
        this.iconInformationButton.setEnabled(bl);
        this.iconQuestionButton.setEnabled(bl);
        this.iconWarningButton.setEnabled(bl);
        this.iconWorkingButton.setEnabled(bl);
        this.saveButton.setEnabled(bl2);
        this.openButton.setEnabled(bl2);
        this.multiButton.setEnabled(bl2);
        if (!bl) {
            this.okButton.setSelection(false);
            this.cancelButton.setSelection(false);
            this.yesButton.setSelection(false);
            this.noButton.setSelection(false);
            this.retryButton.setSelection(false);
            this.abortButton.setSelection(false);
            this.ignoreButton.setSelection(false);
        }
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[0];
    }

    @Override
    String getTabText() {
        return "Dialog";
    }

    @Override
    void recreateExampleWidgets() {
        if (this.textWidget == null) {
            super.recreateExampleWidgets();
        }
    }

    public void createMyDialog() {
        MyProgressDialog myProgressDialog = new MyProgressDialog(this.tabFolderPage.getShell());
        int n = 10;
        myProgressDialog.setTotalWorkUnits(n);
        myProgressDialog.open();
        for (int i = 1; i <= n; ++i) {
            myProgressDialog.setMessage(Integer.valueOf(i).toString());
            myProgressDialog.addProgress(1);
            if (i != 5) continue;
            MessageBox messageBox = new MessageBox(this.tabFolderPage.getShell(), 192);
            messageBox.setText("Title:");
            messageBox.setMessage("Yes or no?");
            int n2 = messageBox.open();
            if (n2 == 64) {
                this.textWidget.append("Yes");
            } else {
                this.textWidget.append("No");
            }
            this.textWidget.append(Text.DELIMITER + Text.DELIMITER);
        }
    }

    class MyProgressDialog {
        Shell shell;
        Label messageLabel;
        ProgressBar progressBar;
        Button cancelButton;
        boolean isCancelled = false;

        public MyProgressDialog(Shell shell) {
            this.shell = new Shell(shell, 67616);
            GridLayout gridLayout = new GridLayout();
            this.shell.setLayout((Layout)gridLayout);
            this.shell.setText("Progress dialog");
            this.shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent shellEvent) {
                    MyProgressDialog.this.isCancelled = true;
                }
            });
            this.messageLabel = new Label((Composite)this.shell, 256);
            this.messageLabel.setLayoutData((Object)new GridData(784));
            this.messageLabel.setText("My message.");
            this.progressBar = new ProgressBar((Composite)this.shell, 320);
            this.progressBar.setLayoutData((Object)new GridData(784));
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(0);
        }

        public Shell getShell() {
            return this.shell;
        }

        public void setMessage(String string) {
            this.messageLabel.setText(string);
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }

        public void setTotalWorkUnits(int n) {
            this.progressBar.setMaximum(n);
        }

        public void setProgress(int n) {
            this.progressBar.setSelection(n);
            Display display = Display.getCurrent();
            while (display.readAndDispatch()) {
            }
        }

        public void addProgress(int n) {
            this.setProgress(this.progressBar.getSelection() + n);
            if (this.progressBar.getSelection() == this.progressBar.getMaximum()) {
                this.close();
            }
        }

        public void open() {
            this.shell.pack();
            this.shell.setSize(300, 100);
            this.shell.open();
        }

        public void close() {
            this.shell.close();
            this.shell.dispose();
            this.shell = null;
            this.messageLabel = null;
            this.progressBar = null;
            this.cancelButton = null;
        }
    }
}

