/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

class GroupTab
extends Tab {
    Button titleButton;
    Group group1;
    Group groupGroup;
    Button shadowEtchedInButton;
    Button shadowEtchedOutButton;
    Button shadowInButton;
    Button shadowOutButton;
    Button shadowNoneButton;

    GroupTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createOtherGroup() {
        super.createOtherGroup();
        this.titleButton = new Button((Composite)this.otherGroup, 32);
        this.titleButton.setText(ControlExample.getResourceString("Title_Text"));
        this.titleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GroupTab.this.setTitleText();
            }
        });
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.groupGroup = new Group((Composite)this.exampleGroup, 0);
        this.groupGroup.setLayout((Layout)new GridLayout());
        this.groupGroup.setLayoutData((Object)new GridData(784));
        this.groupGroup.setText("Group");
    }

    @Override
    void createExampleWidgets() {
        int n = this.getDefaultStyle();
        if (this.shadowEtchedInButton.getSelection()) {
            n |= 0x10;
        }
        if (this.shadowEtchedOutButton.getSelection()) {
            n |= 0x40;
        }
        if (this.shadowInButton.getSelection()) {
            n |= 4;
        }
        if (this.shadowOutButton.getSelection()) {
            n |= 8;
        }
        if (this.shadowNoneButton.getSelection()) {
            n |= 0x20;
        }
        if (this.borderButton.getSelection()) {
            n |= 0x800;
        }
        this.group1 = new Group((Composite)this.groupGroup, n);
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.shadowEtchedInButton = new Button((Composite)this.styleGroup, 16);
        this.shadowEtchedInButton.setText("SWT.SHADOW_ETCHED_IN");
        this.shadowEtchedInButton.setSelection(true);
        this.shadowEtchedOutButton = new Button((Composite)this.styleGroup, 16);
        this.shadowEtchedOutButton.setText("SWT.SHADOW_ETCHED_OUT");
        this.shadowInButton = new Button((Composite)this.styleGroup, 16);
        this.shadowInButton.setText("SWT.SHADOW_IN");
        this.shadowOutButton = new Button((Composite)this.styleGroup, 16);
        this.shadowOutButton.setText("SWT.SHADOW_OUT");
        this.shadowNoneButton = new Button((Composite)this.styleGroup, 16);
        this.shadowNoneButton.setText("SWT.SHADOW_NONE");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!((Button)selectionEvent.widget).getSelection()) {
                    return;
                }
                GroupTab.this.recreateExampleWidgets();
            }
        };
        this.shadowEtchedInButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.shadowEtchedOutButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.shadowInButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.shadowOutButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.shadowNoneButton.addSelectionListener((SelectionListener)selectionAdapter);
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.group1};
    }

    @Override
    String getTabText() {
        return "Group";
    }

    void setTitleText() {
        if (this.titleButton.getSelection()) {
            this.group1.setText(ControlExample.getResourceString("Title_Text"));
        } else {
            this.group1.setText("");
        }
        this.setExampleWidgetSize();
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.shadowEtchedInButton.setSelection((this.group1.getStyle() & 0x10) != 0);
        this.shadowEtchedOutButton.setSelection((this.group1.getStyle() & 0x40) != 0);
        this.shadowInButton.setSelection((this.group1.getStyle() & 4) != 0);
        this.shadowOutButton.setSelection((this.group1.getStyle() & 8) != 0);
        this.shadowNoneButton.setSelection((this.group1.getStyle() & 0x20) != 0);
        this.borderButton.setSelection((this.group1.getStyle() & 0x800) != 0);
        this.setTitleText();
    }
}

