/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.RangeTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;

class ProgressBarTab
extends RangeTab {
    ProgressBar progressBar1;
    Group progressBarGroup;
    Button smoothButton;
    Button indeterminateButton;

    ProgressBarTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.progressBarGroup = new Group((Composite)this.exampleGroup, 0);
        this.progressBarGroup.setLayout((Layout)new GridLayout());
        this.progressBarGroup.setLayoutData((Object)new GridData(784));
        this.progressBarGroup.setText("ProgressBar");
    }

    @Override
    void createExampleWidgets() {
        int n = this.getDefaultStyle();
        if (this.horizontalButton.getSelection()) {
            n |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            n |= 0x200;
        }
        if (this.smoothButton.getSelection()) {
            n |= 0x10000;
        }
        if (this.borderButton.getSelection()) {
            n |= 0x800;
        }
        if (this.indeterminateButton.getSelection()) {
            n |= 2;
        }
        this.progressBar1 = new ProgressBar((Composite)this.progressBarGroup, n);
        this.progressBar1.setMaximum(100);
        this.progressBar1.setSelection(50);
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.smoothButton = new Button((Composite)this.styleGroup, 32);
        this.smoothButton.setText("SWT.SMOOTH");
        this.indeterminateButton = new Button((Composite)this.styleGroup, 32);
        this.indeterminateButton.setText("SWT.INDETERMINATE");
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.progressBar1};
    }

    @Override
    String getTabText() {
        return "ProgressBar";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        if (this.indeterminateButton.getSelection()) {
            this.selectionScale.setEnabled(false);
            this.minimumScale.setEnabled(false);
            this.maximumScale.setEnabled(false);
        } else {
            this.selectionScale.setEnabled(true);
            this.minimumScale.setEnabled(true);
            this.maximumScale.setEnabled(true);
        }
        this.maximumScale.setMaximum(this.progressBar1.getMaximum());
        this.smoothButton.setSelection((this.progressBar1.getStyle() & 0x10000) != 0);
        this.indeterminateButton.setSelection((this.progressBar1.getStyle() & 2) != 0);
    }

    @Override
    void setWidgetMaximum() {
        this.progressBar1.setMaximum(this.maximumScale.getSelection());
        this.updateScales();
    }

    @Override
    void setWidgetMinimum() {
        this.progressBar1.setMinimum(this.minimumScale.getSelection());
        this.updateScales();
    }

    @Override
    void setWidgetSelection() {
        this.progressBar1.setSelection(this.selectionScale.getSelection());
        this.updateScales();
    }

    void updateScales() {
        this.minimumScale.setSelection(this.progressBar1.getMinimum());
        this.selectionScale.setSelection(this.progressBar1.getSelection());
        this.maximumScale.setSelection(this.progressBar1.getMaximum());
    }
}

