/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;

abstract class RangeTab
extends Tab {
    Button horizontalButton;
    Button verticalButton;
    boolean orientationButtons = true;
    Scale minimumScale;
    Scale selectionScale;
    Scale maximumScale;

    RangeTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createControlWidgets() {
        this.createMinimumGroup();
        this.createMaximumGroup();
        this.createSelectionGroup();
    }

    void createMaximumGroup() {
        Group group = new Group((Composite)this.controlGroup, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(ControlExample.getResourceString("Maximum"));
        group.setLayoutData((Object)new GridData(768));
        this.maximumScale = new Scale((Composite)group, 0);
        this.maximumScale.setMaximum(100);
        this.maximumScale.setSelection(100);
        this.maximumScale.setPageIncrement(10);
        this.maximumScale.setIncrement(5);
        GridData gridData = new GridData(768);
        gridData.widthHint = 100;
        this.maximumScale.setLayoutData((Object)gridData);
        this.maximumScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RangeTab.this.setWidgetMaximum();
            }
        });
    }

    void createMinimumGroup() {
        Group group = new Group((Composite)this.controlGroup, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(ControlExample.getResourceString("Minimum"));
        group.setLayoutData((Object)new GridData(768));
        this.minimumScale = new Scale((Composite)group, 0);
        this.minimumScale.setMaximum(100);
        this.minimumScale.setSelection(0);
        this.minimumScale.setPageIncrement(10);
        this.minimumScale.setIncrement(5);
        GridData gridData = new GridData(768);
        gridData.widthHint = 100;
        this.minimumScale.setLayoutData((Object)gridData);
        this.minimumScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RangeTab.this.setWidgetMinimum();
            }
        });
    }

    void createSelectionGroup() {
        Group group = new Group((Composite)this.controlGroup, 0);
        group.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        group.setText(ControlExample.getResourceString("Selection"));
        this.selectionScale = new Scale((Composite)group, 0);
        this.selectionScale.setMaximum(100);
        this.selectionScale.setSelection(50);
        this.selectionScale.setPageIncrement(10);
        this.selectionScale.setIncrement(5);
        GridData gridData2 = new GridData(768);
        gridData2.widthHint = 100;
        this.selectionScale.setLayoutData((Object)gridData2);
        this.selectionScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RangeTab.this.setWidgetSelection();
            }
        });
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        if (this.orientationButtons) {
            this.horizontalButton = new Button((Composite)this.styleGroup, 16);
            this.horizontalButton.setText("SWT.HORIZONTAL");
            this.verticalButton = new Button((Composite)this.styleGroup, 16);
            this.verticalButton.setText("SWT.VERTICAL");
        }
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.setWidgetMinimum();
        this.setWidgetMaximum();
        this.setWidgetSelection();
        Control[] controlArray = this.getExampleWidgets();
        if (controlArray.length != 0) {
            if (this.orientationButtons) {
                this.horizontalButton.setSelection((controlArray[0].getStyle() & 0x100) != 0);
                this.verticalButton.setSelection((controlArray[0].getStyle() & 0x200) != 0);
            }
            this.borderButton.setSelection((controlArray[0].getStyle() & 0x800) != 0);
        }
    }

    abstract void setWidgetMaximum();

    abstract void setWidgetMinimum();

    abstract void setWidgetSelection();
}

