/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class ShellTab
extends Tab {
    Button noParentButton;
    Button parentButton;
    Button noTrimButton;
    Button closeButton;
    Button titleButton;
    Button minButton;
    Button maxButton;
    Button borderButton;
    Button resizeButton;
    Button onTopButton;
    Button toolButton;
    Button createButton;
    Button closeAllButton;
    Button modelessButton;
    Button primaryModalButton;
    Button applicationModalButton;
    Button systemModalButton;
    Button imageButton;
    Group parentStyleGroup;
    Group modalStyleGroup;
    int shellCount = 0;
    Shell[] shells = new Shell[4];

    ShellTab(ControlExample controlExample) {
        super(controlExample);
    }

    void closeAllShells() {
        for (int i = 0; i < this.shellCount; ++i) {
            if (!(this.shells[i] != null & !this.shells[i].isDisposed())) continue;
            this.shells[i].dispose();
        }
        this.shellCount = 0;
    }

    public void createButtonSelected(SelectionEvent selectionEvent) {
        Shell shell;
        if (this.shellCount >= this.shells.length) {
            Shell[] shellArray = new Shell[this.shells.length + 4];
            System.arraycopy(this.shells, 0, shellArray, 0, this.shells.length);
            this.shells = shellArray;
        }
        int n = 0;
        if (this.noTrimButton.getSelection()) {
            n |= 8;
        }
        if (this.closeButton.getSelection()) {
            n |= 0x40;
        }
        if (this.titleButton.getSelection()) {
            n |= 0x20;
        }
        if (this.minButton.getSelection()) {
            n |= 0x80;
        }
        if (this.maxButton.getSelection()) {
            n |= 0x400;
        }
        if (this.borderButton.getSelection()) {
            n |= 0x800;
        }
        if (this.resizeButton.getSelection()) {
            n |= 0x10;
        }
        if (this.onTopButton.getSelection()) {
            n |= 0x4000;
        }
        if (this.toolButton.getSelection()) {
            n |= 4;
        }
        if (this.modelessButton.getSelection()) {
            n |= 0;
        }
        if (this.primaryModalButton.getSelection()) {
            n |= 0x8000;
        }
        if (this.applicationModalButton.getSelection()) {
            n |= 0x10000;
        }
        if (this.systemModalButton.getSelection()) {
            n |= 0x20000;
        }
        if (this.noParentButton.getSelection()) {
            this.shells[this.shellCount] = new Shell(n);
        } else {
            shell = this.tabFolderPage.getShell();
            this.shells[this.shellCount] = new Shell(shell, n);
        }
        shell = this.shells[this.shellCount];
        Button button = new Button((Composite)shell, 8);
        button.setBounds(20, 20, 120, 30);
        Button button2 = new Button((Composite)shell, 8);
        button2.setBounds(160, 20, 120, 30);
        button2.setText(ControlExample.getResourceString("Close"));
        button2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
        shell.setSize(300, 100);
        shell.setText(ControlExample.getResourceString("Title") + this.shellCount);
        if (this.imageButton.getSelection()) {
            shell.setImage(this.instance.images[2]);
        }
        this.hookListeners((Widget)shell);
        shell.open();
        ++this.shellCount;
    }

    @Override
    void createControlGroup() {
        this.controlGroup = new Group(this.tabFolderPage, 0);
        this.controlGroup.setLayout((Layout)new GridLayout(2, true));
        this.controlGroup.setLayoutData((Object)new GridData(272));
        this.controlGroup.setText(ControlExample.getResourceString("Parameters"));
        this.styleGroup = new Group((Composite)this.controlGroup, 0);
        this.styleGroup.setLayout((Layout)new GridLayout());
        this.styleGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 3));
        this.styleGroup.setText(ControlExample.getResourceString("Decoration_Styles"));
        this.modalStyleGroup = new Group((Composite)this.controlGroup, 0);
        this.modalStyleGroup.setLayout((Layout)new GridLayout());
        this.modalStyleGroup.setLayoutData((Object)new GridData(272));
        this.modalStyleGroup.setText(ControlExample.getResourceString("Modal_Styles"));
        this.otherGroup = new Group((Composite)this.controlGroup, 0);
        this.otherGroup.setLayout((Layout)new GridLayout());
        this.otherGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.otherGroup.setText(ControlExample.getResourceString("Other"));
        this.parentStyleGroup = new Group((Composite)this.controlGroup, 0);
        this.parentStyleGroup.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(256);
        this.parentStyleGroup.setLayoutData((Object)gridData);
        this.parentStyleGroup.setText(ControlExample.getResourceString("Parent"));
    }

    @Override
    void createControlWidgets() {
        this.noParentButton = new Button((Composite)this.parentStyleGroup, 16);
        this.noParentButton.setText(ControlExample.getResourceString("No_Parent"));
        this.parentButton = new Button((Composite)this.parentStyleGroup, 16);
        this.parentButton.setText(ControlExample.getResourceString("Parent"));
        this.noTrimButton = new Button((Composite)this.styleGroup, 32);
        this.noTrimButton.setText("SWT.NO_TRIM");
        this.closeButton = new Button((Composite)this.styleGroup, 32);
        this.closeButton.setText("SWT.CLOSE");
        this.titleButton = new Button((Composite)this.styleGroup, 32);
        this.titleButton.setText("SWT.TITLE");
        this.minButton = new Button((Composite)this.styleGroup, 32);
        this.minButton.setText("SWT.MIN");
        this.maxButton = new Button((Composite)this.styleGroup, 32);
        this.maxButton.setText("SWT.MAX");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
        this.resizeButton = new Button((Composite)this.styleGroup, 32);
        this.resizeButton.setText("SWT.RESIZE");
        this.onTopButton = new Button((Composite)this.styleGroup, 32);
        this.onTopButton.setText("SWT.ON_TOP");
        this.toolButton = new Button((Composite)this.styleGroup, 32);
        this.toolButton.setText("SWT.TOOL");
        this.modelessButton = new Button((Composite)this.modalStyleGroup, 16);
        this.modelessButton.setText("SWT.MODELESS");
        this.primaryModalButton = new Button((Composite)this.modalStyleGroup, 16);
        this.primaryModalButton.setText("SWT.PRIMARY_MODAL");
        this.applicationModalButton = new Button((Composite)this.modalStyleGroup, 16);
        this.applicationModalButton.setText("SWT.APPLICATION_MODAL");
        this.systemModalButton = new Button((Composite)this.modalStyleGroup, 16);
        this.systemModalButton.setText("SWT.SYSTEM_MODAL");
        this.imageButton = new Button((Composite)this.otherGroup, 32);
        this.imageButton.setText(ControlExample.getResourceString("Image"));
        this.createButton = new Button((Composite)this.controlGroup, 0);
        GridData gridData = new GridData(128);
        this.createButton.setLayoutData((Object)gridData);
        this.createButton.setText(ControlExample.getResourceString("Create_Shell"));
        this.closeAllButton = new Button((Composite)this.controlGroup, 0);
        gridData = new GridData(32);
        this.closeAllButton.setText(ControlExample.getResourceString("Close_All_Shells"));
        this.closeAllButton.setLayoutData((Object)gridData);
        this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ShellTab.this.createButtonSelected(selectionEvent);
            }
        });
        this.closeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ShellTab.this.closeAllShells();
            }
        });
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ShellTab.this.decorationButtonSelected(selectionEvent);
            }
        };
        this.noTrimButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.closeButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.titleButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.minButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.maxButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.borderButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.resizeButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.applicationModalButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.systemModalButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.noParentButton.setSelection(true);
        this.modelessButton.setSelection(true);
    }

    public void decorationButtonSelected(SelectionEvent selectionEvent) {
        Button button = (Button)selectionEvent.widget;
        if (button == this.applicationModalButton || button == this.systemModalButton) {
            if (button.getSelection()) {
                this.closeButton.setSelection(true);
                this.noTrimButton.setSelection(false);
            }
            return;
        }
        if (button == this.closeButton && (this.applicationModalButton.getSelection() || this.systemModalButton.getSelection())) {
            this.closeButton.setSelection(true);
        }
        if (button.getSelection() && button != this.noTrimButton) {
            this.noTrimButton.setSelection(false);
            return;
        }
        if (button.getSelection() && button == this.noTrimButton) {
            if (this.applicationModalButton.getSelection() || this.systemModalButton.getSelection()) {
                this.noTrimButton.setSelection(false);
                return;
            }
            this.closeButton.setSelection(false);
            this.titleButton.setSelection(false);
            this.minButton.setSelection(false);
            this.maxButton.setSelection(false);
            this.borderButton.setSelection(false);
            this.resizeButton.setSelection(false);
            return;
        }
    }

    @Override
    String getTabText() {
        return "Shell";
    }
}

