/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;

class StyledTextTab
extends ScrollableTab {
    StyledText styledText;
    Group styledTextGroup;
    Group styledTextStyleGroup;
    Button wrapButton;
    Button readOnlyButton;
    Button fullSelectionButton;
    Button boldButton;
    Button italicButton;
    Button redButton;
    Button yellowButton;
    Button underlineButton;
    Button strikeoutButton;
    Image boldImage;
    Image italicImage;
    Image redImage;
    Image yellowImage;
    Image underlineImage;
    Image strikeoutImage;
    StyleRange[] styleRanges;

    StyledTextTab(ControlExample controlExample) {
        super(controlExample);
    }

    Image createBitmapImage(Display display, String string) {
        InputStream inputStream = ControlExample.class.getResourceAsStream(string + ".bmp");
        InputStream inputStream2 = ControlExample.class.getResourceAsStream(string + "_mask.bmp");
        ImageData imageData = new ImageData(inputStream);
        ImageData imageData2 = new ImageData(inputStream2);
        Image image = new Image((Device)display, imageData, imageData2);
        try {
            inputStream.close();
            inputStream2.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return image;
    }

    @Override
    void createControlWidgets() {
        super.createControlWidgets();
        this.createStyledTextStyleGroup();
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.styledTextGroup = new Group((Composite)this.exampleGroup, 0);
        this.styledTextGroup.setLayout((Layout)new GridLayout());
        this.styledTextGroup.setLayoutData((Object)new GridData(784));
        this.styledTextGroup.setText("StyledText");
    }

    @Override
    void createExampleWidgets() {
        int n = this.getDefaultStyle();
        if (this.singleButton.getSelection()) {
            n |= 4;
        }
        if (this.multiButton.getSelection()) {
            n |= 2;
        }
        if (this.horizontalButton.getSelection()) {
            n |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            n |= 0x200;
        }
        if (this.wrapButton.getSelection()) {
            n |= 0x40;
        }
        if (this.readOnlyButton.getSelection()) {
            n |= 8;
        }
        if (this.borderButton.getSelection()) {
            n |= 0x800;
        }
        if (this.fullSelectionButton.getSelection()) {
            n |= 0x10000;
        }
        this.styledText = new StyledText((Composite)this.styledTextGroup, n);
        this.styledText.setText(ControlExample.getResourceString("Example_string"));
        this.styledText.append("\n");
        this.styledText.append(ControlExample.getResourceString("One_Two_Three"));
        if (this.styleRanges != null) {
            this.styledText.setStyleRanges(this.styleRanges);
            this.styleRanges = null;
        }
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.wrapButton = new Button((Composite)this.styleGroup, 32);
        this.wrapButton.setText("SWT.WRAP");
        this.readOnlyButton = new Button((Composite)this.styleGroup, 32);
        this.readOnlyButton.setText("SWT.READ_ONLY");
        this.fullSelectionButton = new Button((Composite)this.styleGroup, 32);
        this.fullSelectionButton.setText("SWT.FULL_SELECTION");
    }

    void createStyledTextStyleGroup() {
        final Display display = this.controlGroup.getDisplay();
        this.styledTextStyleGroup = new Group((Composite)this.controlGroup, 0);
        this.styledTextStyleGroup.setText(ControlExample.getResourceString("StyledText_Styles"));
        this.styledTextStyleGroup.setLayout((Layout)new GridLayout(7, false));
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.styledTextStyleGroup.setLayoutData((Object)gridData);
        this.boldImage = this.createBitmapImage(display, "bold");
        this.italicImage = this.createBitmapImage(display, "italic");
        this.redImage = this.createBitmapImage(display, "red");
        this.yellowImage = this.createBitmapImage(display, "yellow");
        this.underlineImage = this.createBitmapImage(display, "underline");
        this.strikeoutImage = this.createBitmapImage(display, "strikeout");
        Label label = new Label((Composite)this.styledTextStyleGroup, 0);
        label.setText(ControlExample.getResourceString("StyledText_Style_Instructions"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 7;
        label.setLayoutData((Object)gridData);
        new Label((Composite)this.styledTextStyleGroup, 0).setText(ControlExample.getResourceString("Bold"));
        this.boldButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.boldButton.setImage(this.boldImage);
        new Label((Composite)this.styledTextStyleGroup, 0).setText(ControlExample.getResourceString("Underline"));
        this.underlineButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.underlineButton.setImage(this.underlineImage);
        new Label((Composite)this.styledTextStyleGroup, 0).setLayoutData((Object)new GridData(768));
        new Label((Composite)this.styledTextStyleGroup, 0).setText(ControlExample.getResourceString("Foreground_Style"));
        this.redButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.redButton.setImage(this.redImage);
        new Label((Composite)this.styledTextStyleGroup, 0).setText(ControlExample.getResourceString("Italic"));
        this.italicButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.italicButton.setImage(this.italicImage);
        new Label((Composite)this.styledTextStyleGroup, 0).setText(ControlExample.getResourceString("Strikeout"));
        this.strikeoutButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.strikeoutButton.setImage(this.strikeoutImage);
        new Label((Composite)this.styledTextStyleGroup, 0).setLayoutData((Object)new GridData(768));
        new Label((Composite)this.styledTextStyleGroup, 0).setText(ControlExample.getResourceString("Background_Style"));
        this.yellowButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.yellowButton.setImage(this.yellowImage);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Point point = StyledTextTab.this.styledText.getSelectionRange();
                if (point == null || point.y == 0) {
                    return;
                }
                for (int i = point.x; i < point.x + point.y; ++i) {
                    StyleRange styleRange;
                    StyleRange styleRange2 = StyledTextTab.this.styledText.getStyleRangeAtOffset(i);
                    if (styleRange2 != null) {
                        styleRange = (StyleRange)styleRange2.clone();
                        styleRange.start = i;
                        styleRange.length = 1;
                    } else {
                        styleRange = new StyleRange(i, 1, null, null, 0);
                    }
                    if (selectionEvent.widget == StyledTextTab.this.boldButton) {
                        styleRange.fontStyle ^= 1;
                    } else if (selectionEvent.widget == StyledTextTab.this.italicButton) {
                        styleRange.fontStyle ^= 2;
                    } else if (selectionEvent.widget == StyledTextTab.this.underlineButton) {
                        styleRange.underline = !styleRange.underline;
                    } else if (selectionEvent.widget == StyledTextTab.this.strikeoutButton) {
                        styleRange.strikeout = !styleRange.strikeout;
                    }
                    StyledTextTab.this.styledText.setStyleRange(styleRange);
                }
                StyledTextTab.this.styledText.setSelectionRange(point.x + point.y, 0);
            }
        };
        SelectionAdapter selectionAdapter2 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Point point = StyledTextTab.this.styledText.getSelectionRange();
                if (point == null || point.y == 0) {
                    return;
                }
                Color color = null;
                Color color2 = null;
                if (selectionEvent.widget == StyledTextTab.this.redButton) {
                    color = display.getSystemColor(3);
                } else if (selectionEvent.widget == StyledTextTab.this.yellowButton) {
                    color2 = display.getSystemColor(7);
                }
                for (int i = point.x; i < point.x + point.y; ++i) {
                    StyleRange styleRange;
                    StyleRange styleRange2 = StyledTextTab.this.styledText.getStyleRangeAtOffset(i);
                    if (styleRange2 != null) {
                        styleRange = (StyleRange)styleRange2.clone();
                        styleRange.start = i;
                        styleRange.length = 1;
                        styleRange.foreground = styleRange.foreground != null ? null : color;
                        styleRange.background = styleRange.background != null ? null : color2;
                    } else {
                        styleRange = new StyleRange(i, 1, color, color2, 0);
                    }
                    StyledTextTab.this.styledText.setStyleRange(styleRange);
                }
                StyledTextTab.this.styledText.setSelectionRange(point.x + point.y, 0);
            }
        };
        this.boldButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.italicButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.underlineButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.strikeoutButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.redButton.addSelectionListener((SelectionListener)selectionAdapter2);
        this.yellowButton.addSelectionListener((SelectionListener)selectionAdapter2);
        this.yellowButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                StyledTextTab.this.boldImage.dispose();
                StyledTextTab.this.italicImage.dispose();
                StyledTextTab.this.redImage.dispose();
                StyledTextTab.this.yellowImage.dispose();
                StyledTextTab.this.underlineImage.dispose();
                StyledTextTab.this.strikeoutImage.dispose();
            }
        });
    }

    @Override
    Composite createTabFolderPage(TabFolder tabFolder) {
        super.createTabFolderPage(tabFolder);
        this.tabFolderPage.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                StyledTextTab.this.setExampleWidgetSize();
            }
        });
        return this.tabFolderPage;
    }

    @Override
    void disposeExampleWidgets() {
        if (this.styledText != null) {
            this.styleRanges = this.styledText.getStyleRanges();
        }
        super.disposeExampleWidgets();
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.styledText};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"CaretOffset", "DoubleClickEnabled", "Editable", "HorizontalIndex", "HorizontalPixel", "Orientation", "Selection", "Tabs", "Text", "TextLimit", "TopIndex", "TopPixel", "WordWrap"};
    }

    @Override
    String getTabText() {
        return "StyledText";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.wrapButton.setSelection((this.styledText.getStyle() & 0x40) != 0);
        this.readOnlyButton.setSelection((this.styledText.getStyle() & 8) != 0);
        this.fullSelectionButton.setSelection((this.styledText.getStyle() & 0x10000) != 0);
        this.horizontalButton.setEnabled((this.styledText.getStyle() & 2) != 0);
        this.verticalButton.setEnabled((this.styledText.getStyle() & 2) != 0);
        this.wrapButton.setEnabled((this.styledText.getStyle() & 2) != 0);
    }
}

