/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.dnd;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DNDExample {
    private int dragOperation = 0;
    private Transfer[] dragTypes = new Transfer[0];
    private Control dragControl;
    private int dragControlType = 0;
    private DragSource dragSource;
    private String dragDataText;
    private String dragDataRTF;
    private String dragDataHTML;
    private String[] dragDataFiles;
    private List fileList;
    private boolean dragEnabled = false;
    private int dropOperation = 0;
    private int dropFeedback = 0;
    private int dropDefaultOperation = 0;
    private Transfer[] dropTypes = new Transfer[0];
    private DropTarget dropTarget;
    private Control dropControl;
    private int dropControlType = 0;
    private Composite defaultParent;
    private boolean dropEnabled = false;
    private Text dragConsole;
    private boolean dragEventDetail = false;
    private Text dropConsole;
    private boolean dropEventDetail = false;
    private static final int BUTTON_TOGGLE = 0;
    private static final int BUTTON_RADIO = 1;
    private static final int BUTTON_CHECK = 2;
    private static final int CANVAS = 3;
    private static final int LABEL = 4;
    private static final int LIST = 5;
    private static final int TABLE = 6;
    private static final int TREE = 7;
    private static final int TEXT = 8;

    public static void main(String[] stringArray) {
        Display display = new Display();
        DNDExample dNDExample = new DNDExample();
        dNDExample.open(display);
        display.dispose();
    }

    private void addDragTransfer(Transfer transfer) {
        Transfer[] transferArray = new Transfer[this.dragTypes.length + 1];
        System.arraycopy(this.dragTypes, 0, transferArray, 0, this.dragTypes.length);
        transferArray[this.dragTypes.length] = transfer;
        this.dragTypes = transferArray;
        if (this.dragSource != null) {
            this.dragSource.setTransfer(this.dragTypes);
        }
    }

    private void addDropTransfer(Transfer transfer) {
        Transfer[] transferArray = new Transfer[this.dropTypes.length + 1];
        System.arraycopy(this.dropTypes, 0, transferArray, 0, this.dropTypes.length);
        transferArray[this.dropTypes.length] = transfer;
        this.dropTypes = transferArray;
        if (this.dropTarget != null) {
            this.dropTarget.setTransfer(this.dropTypes);
        }
    }

    private void createDragOperations(Composite composite) {
        composite.setLayout((Layout)new RowLayout(512));
        final Button button = new Button(composite, 32);
        button.setText("DND.DROP_MOVE");
        button.setSelection(true);
        this.dragOperation = 2;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button2 = (Button)selectionEvent.widget;
                if (button2.getSelection()) {
                    DNDExample.this.dragOperation = DNDExample.this.dragOperation | 2;
                } else {
                    DNDExample.this.dragOperation = DNDExample.this.dragOperation & 0xFFFFFFFD;
                    if (DNDExample.this.dragOperation == 0) {
                        DNDExample.this.dragOperation = 2;
                        button.setSelection(true);
                    }
                }
                if (DNDExample.this.dragEnabled) {
                    DNDExample.this.createDragSource();
                }
            }
        });
        Button button2 = new Button(composite, 32);
        button2.setText("DND.DROP_COPY");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button2 = (Button)selectionEvent.widget;
                if (button2.getSelection()) {
                    DNDExample.this.dragOperation = DNDExample.this.dragOperation | 1;
                } else {
                    DNDExample.this.dragOperation = DNDExample.this.dragOperation & 0xFFFFFFFE;
                    if (DNDExample.this.dragOperation == 0) {
                        DNDExample.this.dragOperation = 2;
                        button.setSelection(true);
                    }
                }
                if (DNDExample.this.dragEnabled) {
                    DNDExample.this.createDragSource();
                }
            }
        });
        button2 = new Button(composite, 32);
        button2.setText("DND.DROP_LINK");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button2 = (Button)selectionEvent.widget;
                if (button2.getSelection()) {
                    DNDExample.this.dragOperation = DNDExample.this.dragOperation | 4;
                } else {
                    DNDExample.this.dragOperation = DNDExample.this.dragOperation & 0xFFFFFFFB;
                    if (DNDExample.this.dragOperation == 0) {
                        DNDExample.this.dragOperation = 2;
                        button.setSelection(true);
                    }
                }
                if (DNDExample.this.dragEnabled) {
                    DNDExample.this.createDragSource();
                }
            }
        });
    }

    private void createDragSource() {
        if (this.dragSource != null) {
            this.dragSource.dispose();
        }
        this.dragSource = new DragSource(this.dragControl, this.dragOperation);
        this.dragSource.setTransfer(this.dragTypes);
        this.dragSource.addDragListener(new DragSourceListener(){

            public void dragFinished(DragSourceEvent dragSourceEvent) {
                DNDExample.this.dragConsole.append(">>dragFinished\n");
                DNDExample.this.printEvent(dragSourceEvent);
                DNDExample.this.dragDataText = (DNDExample.this.dragDataRTF = (DNDExample.this.dragDataHTML = null));
                DNDExample.access$802(DNDExample.this, null);
                if (dragSourceEvent.detail == 2) {
                    switch (DNDExample.this.dragControlType) {
                        case 0: 
                        case 1: 
                        case 2: {
                            Button button = (Button)DNDExample.this.dragControl;
                            button.setText("");
                            break;
                        }
                        case 6: {
                            Table table = (Table)DNDExample.this.dragControl;
                            TableItem[] tableItemArray = table.getSelection();
                            for (int i = 0; i < tableItemArray.length; ++i) {
                                tableItemArray[i].dispose();
                            }
                            break;
                        }
                        case 8: {
                            Text text = (Text)DNDExample.this.dragControl;
                            text.clearSelection();
                            break;
                        }
                        case 7: {
                            Tree tree = (Tree)DNDExample.this.dragControl;
                            TreeItem[] treeItemArray = tree.getSelection();
                            for (int i = 0; i < treeItemArray.length; ++i) {
                                treeItemArray[i].dispose();
                            }
                            break;
                        }
                        case 3: {
                            DNDExample.this.dragControl.setData("STRINGS", null);
                            DNDExample.this.dragControl.redraw();
                            break;
                        }
                        case 4: {
                            Label label = (Label)DNDExample.this.dragControl;
                            label.setText("");
                            break;
                        }
                        case 5: {
                            List list = (List)DNDExample.this.dragControl;
                            int[] nArray = list.getSelectionIndices();
                            list.remove(nArray);
                            break;
                        }
                    }
                }
            }

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                DNDExample.this.dragConsole.append(">>dragSetData\n");
                DNDExample.this.printEvent(dragSourceEvent);
                if (TextTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
                    dragSourceEvent.data = DNDExample.this.dragDataText;
                }
                if (RTFTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
                    dragSourceEvent.data = DNDExample.this.dragDataRTF;
                }
                if (HTMLTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
                    dragSourceEvent.data = DNDExample.this.dragDataHTML;
                }
                if (FileTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
                    dragSourceEvent.data = DNDExample.this.dragDataFiles;
                }
            }

            public void dragStart(DragSourceEvent dragSourceEvent) {
                DNDExample.this.dragConsole.append(">>dragStart\n");
                DNDExample.this.printEvent(dragSourceEvent);
                DNDExample.access$802(DNDExample.this, DNDExample.this.fileList.getItems());
                switch (DNDExample.this.dragControlType) {
                    case 0: 
                    case 1: 
                    case 2: {
                        String[] stringArray = (String[])DNDExample.this.dragControl;
                        DNDExample.this.dragDataText = stringArray.getSelection() ? "true" : "false";
                        break;
                    }
                    case 6: {
                        int n;
                        String[] stringArray = (Table)DNDExample.this.dragControl;
                        Object object = stringArray.getSelection();
                        if (((TableItem[])object).length == 0) {
                            dragSourceEvent.doit = false;
                            break;
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        for (n = 0; n < ((Object)object).length; ++n) {
                            stringBuffer.append(object[n].getText());
                            if (((Object)object).length <= 1 || n >= ((Object)object).length - 1) continue;
                            stringBuffer.append("\n");
                        }
                        DNDExample.this.dragDataText = stringBuffer.toString();
                        break;
                    }
                    case 8: {
                        String[] stringArray = (Text)DNDExample.this.dragControl;
                        Object object = stringArray.getSelectionText();
                        if (((String)object).length() == 0) {
                            dragSourceEvent.doit = false;
                            break;
                        }
                        DNDExample.this.dragDataText = (String)object;
                        break;
                    }
                    case 7: {
                        int n;
                        String[] stringArray = (Tree)DNDExample.this.dragControl;
                        Object object = stringArray.getSelection();
                        if (((Object)object).length == 0) {
                            dragSourceEvent.doit = false;
                            break;
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        for (n = 0; n < ((Object)object).length; ++n) {
                            stringBuffer.append(object[n].getText());
                            if (((Object)object).length <= 1 || n >= ((Object)object).length - 1) continue;
                            stringBuffer.append("\n");
                        }
                        DNDExample.this.dragDataText = stringBuffer.toString();
                        break;
                    }
                    case 3: {
                        String[] stringArray = (String[])DNDExample.this.dragControl.getData("STRINGS");
                        if (stringArray == null || stringArray.length == 0) {
                            dragSourceEvent.doit = false;
                            break;
                        }
                        Object object = new StringBuffer();
                        for (int i = 0; i < stringArray.length; ++i) {
                            ((StringBuffer)object).append(stringArray[i]);
                            if (stringArray.length <= 1 || i >= stringArray.length - 1) continue;
                            ((StringBuffer)object).append("\n");
                        }
                        DNDExample.this.dragDataText = ((StringBuffer)object).toString();
                        break;
                    }
                    case 4: {
                        String[] stringArray = (Label)DNDExample.this.dragControl;
                        Object object = stringArray.getText();
                        if (((String)object).length() == 0) {
                            dragSourceEvent.doit = false;
                            break;
                        }
                        DNDExample.this.dragDataText = (String)object;
                        break;
                    }
                    case 5: {
                        int n;
                        String[] stringArray = (List)DNDExample.this.dragControl;
                        Object object = stringArray.getSelection();
                        if (((Object)object).length == 0) {
                            dragSourceEvent.doit = false;
                            break;
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        for (n = 0; n < ((Object)object).length; ++n) {
                            stringBuffer.append((String)object[n]);
                            if (((Object)object).length <= 1 || n >= ((Object)object).length - 1) continue;
                            stringBuffer.append("\n");
                        }
                        DNDExample.this.dragDataText = stringBuffer.toString();
                        break;
                    }
                    default: {
                        throw new SWTError(20);
                    }
                }
                if (DNDExample.this.dragDataText != null) {
                    DNDExample.this.dragDataRTF = "{\\rtf1{\\colortbl;\\red255\\green0\\blue0;}\\cf1\\b " + DNDExample.this.dragDataText + "}";
                    DNDExample.this.dragDataHTML = "<b>" + DNDExample.this.dragDataText + "</b>";
                }
                for (int i = 0; i < DNDExample.this.dragTypes.length; ++i) {
                    if (DNDExample.this.dragTypes[i] instanceof TextTransfer && DNDExample.this.dragDataText == null) {
                        dragSourceEvent.doit = false;
                    }
                    if (DNDExample.this.dragTypes[i] instanceof RTFTransfer && DNDExample.this.dragDataRTF == null) {
                        dragSourceEvent.doit = false;
                    }
                    if (DNDExample.this.dragTypes[i] instanceof HTMLTransfer && DNDExample.this.dragDataHTML == null) {
                        dragSourceEvent.doit = false;
                    }
                    if (!(DNDExample.this.dragTypes[i] instanceof FileTransfer) || DNDExample.this.dragDataFiles != null && DNDExample.this.dragDataFiles.length != 0) continue;
                    dragSourceEvent.doit = false;
                }
            }
        });
    }

    private void createDragTypes(Composite composite) {
        composite.setLayout((Layout)new GridLayout());
        Button button = new Button(composite, 32);
        button.setText("Text Transfer");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.addDragTransfer((Transfer)TextTransfer.getInstance());
                } else {
                    DNDExample.this.removeDragTransfer((Transfer)TextTransfer.getInstance());
                }
            }
        });
        button = new Button(composite, 32);
        button.setText("RTF Transfer");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.addDragTransfer((Transfer)RTFTransfer.getInstance());
                } else {
                    DNDExample.this.removeDragTransfer((Transfer)RTFTransfer.getInstance());
                }
            }
        });
        button = new Button(composite, 32);
        button.setText("HTML Transfer");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.addDragTransfer((Transfer)HTMLTransfer.getInstance());
                } else {
                    DNDExample.this.removeDragTransfer((Transfer)HTMLTransfer.getInstance());
                }
            }
        });
        button = new Button(composite, 32);
        button.setText("File Transfer");
        button.setLayoutData((Object)new GridData(2));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.addDragTransfer((Transfer)FileTransfer.getInstance());
                } else {
                    DNDExample.this.removeDragTransfer((Transfer)FileTransfer.getInstance());
                }
            }
        });
        button = new Button(composite, 8);
        button.setText("Select File(s)");
        button.setLayoutData((Object)new GridData(2));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(DNDExample.this.fileList.getShell(), 4098);
                String string = fileDialog.open();
                if (string != null && string.length() > 0) {
                    DNDExample.this.fileList.removeAll();
                    String string2 = System.getProperty("file.separator");
                    String string3 = fileDialog.getFilterPath();
                    String[] stringArray = fileDialog.getFileNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        DNDExample.this.fileList.add(string3 + string2 + stringArray[i]);
                    }
                }
            }
        });
        this.fileList = new List(composite, 2816);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.fileList.setLayoutData((Object)gridData);
    }

    private void createDragWidget(Composite composite) {
        composite.setLayout((Layout)new FormLayout());
        Combo combo = new Combo(composite, 8);
        combo.setItems(new String[]{"Toggle Button", "Radio Button", "Checkbox", "Canvas", "Label", "List", "Table", "Tree"});
        combo.select(4);
        this.dragControlType = combo.getSelectionIndex();
        this.dragControl = this.createWidget(this.dragControlType, composite, "Drag Source");
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object = DNDExample.this.dragControl.getLayoutData();
                Composite composite = DNDExample.this.dragControl.getParent();
                DNDExample.this.dragControl.dispose();
                Combo combo = (Combo)selectionEvent.widget;
                DNDExample.this.dragControlType = combo.getSelectionIndex();
                DNDExample.this.dragControl = DNDExample.this.createWidget(DNDExample.this.dragControlType, composite, "Drag Source");
                DNDExample.this.dragControl.setLayoutData(object);
                if (DNDExample.this.dragEnabled) {
                    DNDExample.this.createDragSource();
                }
                composite.layout();
            }
        });
        Button button = new Button(composite, 32);
        button.setText("DragSource");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                DNDExample.this.dragEnabled = button.getSelection();
                if (DNDExample.this.dragEnabled) {
                    DNDExample.this.createDragSource();
                } else {
                    if (DNDExample.this.dragSource != null) {
                        DNDExample.this.dragSource.dispose();
                    }
                    DNDExample.this.dragSource = null;
                }
            }
        });
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.bottom = new FormAttachment((Control)combo, -10);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(100, -10);
        this.dragControl.setLayoutData((Object)formData);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, -10);
        formData.left = new FormAttachment(0, 10);
        combo.setLayoutData((Object)formData);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, -10);
        formData.left = new FormAttachment((Control)combo, 10);
        button.setLayoutData((Object)formData);
    }

    private void createDropOperations(Composite composite) {
        composite.setLayout((Layout)new RowLayout(512));
        final Button button = new Button(composite, 32);
        button.setText("DND.DROP_MOVE");
        button.setSelection(true);
        this.dropOperation = 2;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button2 = (Button)selectionEvent.widget;
                if (button2.getSelection()) {
                    DNDExample.this.dropOperation = DNDExample.this.dropOperation | 2;
                } else {
                    DNDExample.this.dropOperation = DNDExample.this.dropOperation & 0xFFFFFFFD;
                    if (DNDExample.this.dropOperation == 0 || (DNDExample.this.dropDefaultOperation & 2) != 0) {
                        DNDExample.this.dropOperation = DNDExample.this.dropOperation | 2;
                        button.setSelection(true);
                    }
                }
                if (DNDExample.this.dropEnabled) {
                    DNDExample.this.createDropTarget();
                }
            }
        });
        final Button button2 = new Button(composite, 32);
        button2.setText("DND.DROP_COPY");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.dropOperation = DNDExample.this.dropOperation | 1;
                } else {
                    DNDExample.this.dropOperation = DNDExample.this.dropOperation & 0xFFFFFFFE;
                    if (DNDExample.this.dropOperation == 0 || (DNDExample.this.dropDefaultOperation & 1) != 0) {
                        DNDExample.this.dropOperation = 1;
                        button2.setSelection(true);
                    }
                }
                if (DNDExample.this.dropEnabled) {
                    DNDExample.this.createDropTarget();
                }
            }
        });
        final Button button3 = new Button(composite, 32);
        button3.setText("DND.DROP_LINK");
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.dropOperation = DNDExample.this.dropOperation | 4;
                } else {
                    DNDExample.this.dropOperation = DNDExample.this.dropOperation & 0xFFFFFFFB;
                    if (DNDExample.this.dropOperation == 0 || (DNDExample.this.dropDefaultOperation & 4) != 0) {
                        DNDExample.this.dropOperation = 4;
                        button3.setSelection(true);
                    }
                }
                if (DNDExample.this.dropEnabled) {
                    DNDExample.this.createDropTarget();
                }
            }
        });
        Button button4 = new Button(composite, 32);
        button4.setText("DND.DROP_DEFAULT");
        this.defaultParent = new Composite(composite, 0);
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.dropOperation = DNDExample.this.dropOperation | 0x10;
                    DNDExample.this.defaultParent.setVisible(true);
                } else {
                    DNDExample.this.dropOperation = DNDExample.this.dropOperation & 0xFFFFFFEF;
                    DNDExample.this.defaultParent.setVisible(false);
                }
                if (DNDExample.this.dropEnabled) {
                    DNDExample.this.createDropTarget();
                }
            }
        });
        this.defaultParent.setVisible(false);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 20;
        this.defaultParent.setLayout((Layout)gridLayout);
        Label label = new Label(this.defaultParent, 0);
        label.setText("Value for default operation is:");
        button4 = new Button(this.defaultParent, 16);
        button4.setText("DND.DROP_MOVE");
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button2 = (Button)selectionEvent.widget;
                if (button2.getSelection()) {
                    DNDExample.this.dropDefaultOperation = 2;
                    DNDExample.this.dropOperation = DNDExample.this.dropOperation | 2;
                    button.setSelection(true);
                    if (DNDExample.this.dropEnabled) {
                        DNDExample.this.createDropTarget();
                    }
                }
            }
        });
        button4 = new Button(this.defaultParent, 16);
        button4.setText("DND.DROP_COPY");
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.dropDefaultOperation = 1;
                    DNDExample.this.dropOperation = DNDExample.this.dropOperation | 1;
                    button2.setSelection(true);
                    if (DNDExample.this.dropEnabled) {
                        DNDExample.this.createDropTarget();
                    }
                }
            }
        });
        button4 = new Button(this.defaultParent, 16);
        button4.setText("DND.DROP_LINK");
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.dropDefaultOperation = 4;
                    DNDExample.this.dropOperation = DNDExample.this.dropOperation | 4;
                    button3.setSelection(true);
                    if (DNDExample.this.dropEnabled) {
                        DNDExample.this.createDropTarget();
                    }
                }
            }
        });
        button4 = new Button(this.defaultParent, 16);
        button4.setText("DND.DROP_NONE");
        button4.setSelection(true);
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.dropDefaultOperation = 0;
                    DNDExample.this.dropOperation = DNDExample.this.dropOperation & 0xFFFFFFEF;
                    if (DNDExample.this.dropEnabled) {
                        DNDExample.this.createDropTarget();
                    }
                }
            }
        });
    }

    private void createDropTarget() {
        if (this.dropTarget != null) {
            this.dropTarget.dispose();
        }
        this.dropTarget = new DropTarget(this.dropControl, this.dropOperation);
        this.dropTarget.setTransfer(this.dropTypes);
        this.dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent dropTargetEvent) {
                DNDExample.this.dropConsole.append(">>dragEnter\n");
                DNDExample.this.printEvent(dropTargetEvent);
                if (dropTargetEvent.detail == 16) {
                    dropTargetEvent.detail = DNDExample.this.dropDefaultOperation;
                }
                dropTargetEvent.feedback = DNDExample.this.dropFeedback;
            }

            public void dragLeave(DropTargetEvent dropTargetEvent) {
                DNDExample.this.dropConsole.append(">>dragLeave\n");
                DNDExample.this.printEvent(dropTargetEvent);
            }

            public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
                DNDExample.this.dropConsole.append(">>dragOperationChanged\n");
                DNDExample.this.printEvent(dropTargetEvent);
                if (dropTargetEvent.detail == 16) {
                    dropTargetEvent.detail = DNDExample.this.dropDefaultOperation;
                }
                dropTargetEvent.feedback = DNDExample.this.dropFeedback;
            }

            public void dragOver(DropTargetEvent dropTargetEvent) {
                DNDExample.this.dropConsole.append(">>dragOver\n");
                DNDExample.this.printEvent(dropTargetEvent);
                dropTargetEvent.feedback = DNDExample.this.dropFeedback;
            }

            public void drop(DropTargetEvent dropTargetEvent) {
                int n;
                int n2;
                int n3;
                int n4;
                String string;
                DNDExample.this.dropConsole.append(">>drop\n");
                DNDExample.this.printEvent(dropTargetEvent);
                String[] stringArray = null;
                if (TextTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType) || RTFTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType) || HTMLTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType)) {
                    stringArray = new String[]{(String)dropTargetEvent.data};
                }
                if (FileTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType)) {
                    stringArray = (String[])dropTargetEvent.data;
                }
                if (stringArray == null || stringArray.length == 0) {
                    DNDExample.this.dropConsole.append("!!Invalid data dropped");
                    return;
                }
                if (stringArray.length == 1 && (DNDExample.this.dropControlType == 6 || DNDExample.this.dropControlType == 7 || DNDExample.this.dropControlType == 5)) {
                    string = stringArray[0];
                    n4 = 0;
                    int n5 = string.indexOf("\n", 0);
                    while (n5 > 0) {
                        ++n4;
                        n5 = string.indexOf("\n", n5 + 1);
                    }
                    if (n4 > 0) {
                        stringArray = new String[n4 + 1];
                        n3 = 0;
                        n2 = string.indexOf("\n");
                        n = 0;
                        while (n3 < n2) {
                            stringArray[n++] = string.substring(n3, n2);
                            n3 = n2 + 1;
                            if ((n2 = string.indexOf("\n", n3)) != -1) continue;
                            n2 = string.length();
                        }
                    }
                }
                switch (DNDExample.this.dropControlType) {
                    case 0: 
                    case 1: 
                    case 2: {
                        string = (Button)DNDExample.this.dropControl;
                        string.setText(stringArray[0]);
                        break;
                    }
                    case 6: {
                        string = (Table)DNDExample.this.dropControl;
                        Point point = dropTargetEvent.display.map(null, (Control)string, dropTargetEvent.x, dropTargetEvent.y);
                        TableItem tableItem = string.getItem(point);
                        n3 = tableItem == null ? string.getItemCount() : string.indexOf(tableItem);
                        for (n2 = 0; n2 < stringArray.length; ++n2) {
                            TableItem tableItem2 = new TableItem((Table)string, 0, n3);
                            tableItem2.setText(0, stringArray[n2]);
                            tableItem2.setText(1, "dropped item");
                        }
                        TableColumn[] tableColumnArray = string.getColumns();
                        for (n = 0; n < tableColumnArray.length; ++n) {
                            tableColumnArray[n].pack();
                        }
                        break;
                    }
                    case 8: {
                        string = (Text)DNDExample.this.dropControl;
                        for (n4 = 0; n4 < stringArray.length; ++n4) {
                            string.append(stringArray[n4] + "\n");
                        }
                        break;
                    }
                    case 7: {
                        string = (Tree)DNDExample.this.dropControl;
                        Point point = dropTargetEvent.display.map(null, (Control)string, dropTargetEvent.x, dropTargetEvent.y);
                        TreeItem treeItem = string.getItem(point);
                        for (n3 = 0; n3 < stringArray.length; ++n3) {
                            TreeItem treeItem2 = treeItem != null ? new TreeItem(treeItem, 0) : new TreeItem((Tree)string, 0);
                            treeItem2.setText(stringArray[n3]);
                        }
                        break;
                    }
                    case 3: {
                        DNDExample.this.dropControl.setData("STRINGS", (Object)stringArray);
                        DNDExample.this.dropControl.redraw();
                        break;
                    }
                    case 4: {
                        string = (Label)DNDExample.this.dropControl;
                        string.setText(stringArray[0]);
                        break;
                    }
                    case 5: {
                        string = (List)DNDExample.this.dropControl;
                        for (n4 = 0; n4 < stringArray.length; ++n4) {
                            string.add(stringArray[n4]);
                        }
                        break;
                    }
                    default: {
                        throw new SWTError(20);
                    }
                }
            }

            public void dropAccept(DropTargetEvent dropTargetEvent) {
                DNDExample.this.dropConsole.append(">>dropAccept\n");
                DNDExample.this.printEvent(dropTargetEvent);
            }
        });
    }

    private void createFeedbackTypes(Group group) {
        group.setLayout((Layout)new RowLayout(512));
        Button button = new Button((Composite)group, 32);
        button.setText("FEEDBACK_SELECT");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.dropFeedback = DNDExample.this.dropFeedback | 1;
                } else {
                    DNDExample.this.dropFeedback = DNDExample.this.dropFeedback & 0xFFFFFFFE;
                }
            }
        });
        button = new Button((Composite)group, 32);
        button.setText("FEEDBACK_SCROLL");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.dropFeedback = DNDExample.this.dropFeedback | 8;
                } else {
                    DNDExample.this.dropFeedback = DNDExample.this.dropFeedback & 0xFFFFFFF7;
                }
            }
        });
        button = new Button((Composite)group, 32);
        button.setText("FEEDBACK_INSERT_BEFORE");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.dropFeedback = DNDExample.this.dropFeedback | 2;
                } else {
                    DNDExample.this.dropFeedback = DNDExample.this.dropFeedback & 0xFFFFFFFD;
                }
            }
        });
        button = new Button((Composite)group, 32);
        button.setText("FEEDBACK_INSERT_AFTER");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.dropFeedback = DNDExample.this.dropFeedback | 4;
                } else {
                    DNDExample.this.dropFeedback = DNDExample.this.dropFeedback & 0xFFFFFFFB;
                }
            }
        });
        button = new Button((Composite)group, 32);
        button.setText("FEEDBACK_EXPAND");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.dropFeedback = DNDExample.this.dropFeedback | 0x10;
                } else {
                    DNDExample.this.dropFeedback = DNDExample.this.dropFeedback & 0xFFFFFFEF;
                }
            }
        });
    }

    private void createDropTypes(Composite composite) {
        composite.setLayout((Layout)new RowLayout(512));
        Button button = new Button(composite, 32);
        button.setText("Text Transfer");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.addDropTransfer((Transfer)TextTransfer.getInstance());
                } else {
                    DNDExample.this.removeDropTransfer((Transfer)TextTransfer.getInstance());
                }
            }
        });
        button = new Button(composite, 32);
        button.setText("RTF Transfer");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.addDropTransfer((Transfer)RTFTransfer.getInstance());
                } else {
                    DNDExample.this.removeDropTransfer((Transfer)RTFTransfer.getInstance());
                }
            }
        });
        button = new Button(composite, 32);
        button.setText("HTML Transfer");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.addDropTransfer((Transfer)HTMLTransfer.getInstance());
                } else {
                    DNDExample.this.removeDropTransfer((Transfer)HTMLTransfer.getInstance());
                }
            }
        });
        button = new Button(composite, 32);
        button.setText("File Transfer");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DNDExample.this.addDropTransfer((Transfer)FileTransfer.getInstance());
                } else {
                    DNDExample.this.removeDropTransfer((Transfer)FileTransfer.getInstance());
                }
            }
        });
    }

    private void createDropWidget(Composite composite) {
        composite.setLayout((Layout)new FormLayout());
        Combo combo = new Combo(composite, 8);
        combo.setItems(new String[]{"Toggle Button", "Radio Button", "Checkbox", "Canvas", "Label", "List", "Table", "Tree", "Text"});
        combo.select(4);
        this.dropControlType = combo.getSelectionIndex();
        this.dropControl = this.createWidget(this.dropControlType, composite, "Drop Target");
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object = DNDExample.this.dropControl.getLayoutData();
                Composite composite = DNDExample.this.dropControl.getParent();
                DNDExample.this.dropControl.dispose();
                Combo combo = (Combo)selectionEvent.widget;
                DNDExample.this.dropControlType = combo.getSelectionIndex();
                DNDExample.this.dropControl = DNDExample.this.createWidget(DNDExample.this.dropControlType, composite, "Drop Target");
                DNDExample.this.dropControl.setLayoutData(object);
                if (DNDExample.this.dropEnabled) {
                    DNDExample.this.createDropTarget();
                }
                composite.layout();
            }
        });
        Button button = new Button(composite, 32);
        button.setText("DropTarget");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                DNDExample.this.dropEnabled = button.getSelection();
                if (DNDExample.this.dropEnabled) {
                    DNDExample.this.createDropTarget();
                } else {
                    if (DNDExample.this.dropTarget != null) {
                        DNDExample.this.dropTarget.dispose();
                    }
                    DNDExample.this.dropTarget = null;
                }
            }
        });
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.bottom = new FormAttachment((Control)combo, -10);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(100, -10);
        this.dropControl.setLayoutData((Object)formData);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, -10);
        formData.left = new FormAttachment(0, 10);
        combo.setLayoutData((Object)formData);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, -10);
        formData.left = new FormAttachment((Control)combo, 10);
        button.setLayoutData((Object)formData);
    }

    private Control createWidget(int n, Composite composite, String string) {
        switch (n) {
            case 2: {
                Button button = new Button(composite, 32);
                button.setText(string + " Check box");
                return button;
            }
            case 0: {
                Button button = new Button(composite, 2);
                button.setText(string + " Toggle button");
                return button;
            }
            case 1: {
                Button button = new Button(composite, 16);
                button.setText(string + " Radio button");
                return button;
            }
            case 6: {
                Table table = new Table(composite, 2050);
                TableColumn tableColumn = new TableColumn(table, 0);
                TableColumn tableColumn2 = new TableColumn(table, 0);
                for (int i = 0; i < 10; ++i) {
                    TableItem tableItem = new TableItem(table, 0);
                    tableItem.setText(0, string + " name " + i);
                    tableItem.setText(1, string + " value " + i);
                }
                tableColumn.pack();
                tableColumn2.pack();
                return table;
            }
            case 8: {
                Text text = new Text(composite, 2818);
                text.setText(string + " Text");
                return text;
            }
            case 7: {
                Tree tree = new Tree(composite, 2048);
                for (int i = 0; i < 3; ++i) {
                    TreeItem treeItem = new TreeItem(tree, 0);
                    treeItem.setText(string + " item " + i);
                    for (int j = 0; j < 3; ++j) {
                        TreeItem treeItem2 = new TreeItem(treeItem, 0);
                        treeItem2.setText(string + " item " + j);
                        for (int k = 0; k < 3; ++k) {
                            TreeItem treeItem3 = new TreeItem(treeItem2, 0);
                            treeItem3.setText(string + " item " + k);
                        }
                    }
                }
                return tree;
            }
            case 3: {
                Canvas canvas = new Canvas(composite, 2048);
                canvas.setData("STRINGS", (Object)new String[]{string + " Canvas widget"});
                canvas.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent paintEvent) {
                        Canvas canvas = (Canvas)paintEvent.widget;
                        Image image = (Image)canvas.getData("IMAGE");
                        if (image != null) {
                            paintEvent.gc.drawImage(image, 5, 5);
                        } else {
                            String[] stringArray = (String[])canvas.getData("STRINGS");
                            if (stringArray != null) {
                                FontMetrics fontMetrics = paintEvent.gc.getFontMetrics();
                                int n = fontMetrics.getHeight();
                                int n2 = 5;
                                for (int i = 0; i < stringArray.length; ++i) {
                                    paintEvent.gc.drawString(stringArray[i], 5, n2);
                                    n2 += n + 5;
                                }
                            }
                        }
                    }
                });
                return canvas;
            }
            case 4: {
                Label label = new Label(composite, 2048);
                label.setText(string + " Label");
                return label;
            }
            case 5: {
                List list = new List(composite, 2048);
                list.setItems(new String[]{string + " Item a", string + " Item b", string + " Item c", string + " Item d"});
                return list;
            }
        }
        throw new SWTError(20);
    }

    public void open(Display display) {
        Shell shell = new Shell(display);
        shell.setText("Drag and Drop Example");
        shell.setLayout((Layout)new FillLayout());
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)shell, 768);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        composite.setLayout((Layout)new FormLayout());
        Label label = new Label(composite, 16384);
        label.setText("Drag Source:");
        Group group = new Group(composite, 0);
        group.setText("Widget");
        this.createDragWidget((Composite)group);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Group group2 = new Group(composite2, 0);
        group2.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        group2.setText("Allowed Operation(s):");
        this.createDragOperations((Composite)group2);
        Group group3 = new Group(composite2, 0);
        group3.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        group3.setText("Transfer Type(s):");
        this.createDragTypes((Composite)group3);
        this.dragConsole = new Text(composite2, 2826);
        this.dragConsole.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Menu menu = new Menu((Decorations)shell, 8);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText("Clear");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DNDExample.this.dragConsole.setText("");
            }
        });
        menuItem = new MenuItem(menu, 32);
        menuItem.setText("Show Event detail");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                DNDExample.this.dragEventDetail = menuItem.getSelection();
            }
        });
        this.dragConsole.setMenu(menu);
        Label label2 = new Label(composite, 16384);
        label2.setText("Drop Target:");
        Group group4 = new Group(composite, 0);
        group4.setText("Widget");
        this.createDropWidget((Composite)group4);
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        Group group5 = new Group(composite3, 0);
        group5.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 2));
        group5.setText("Allowed Operation(s):");
        this.createDropOperations((Composite)group5);
        Group group6 = new Group(composite3, 0);
        group6.setText("Transfer Type(s):");
        this.createDropTypes((Composite)group6);
        Group group7 = new Group(composite3, 0);
        group7.setText("Feedback Type(s):");
        this.createFeedbackTypes(group7);
        this.dropConsole = new Text(composite3, 2826);
        this.dropConsole.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        menu = new Menu((Decorations)shell, 8);
        menuItem = new MenuItem(menu, 8);
        menuItem.setText("Clear");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DNDExample.this.dropConsole.setText("");
            }
        });
        menuItem = new MenuItem(menu, 32);
        menuItem.setText("Show Event detail");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                DNDExample.this.dropEventDetail = menuItem.getSelection();
            }
        });
        this.dropConsole.setMenu(menu);
        int n = 200;
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.left = new FormAttachment(0, 10);
        label.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)label, 10);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(50, -10);
        formData.height = n;
        group.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)group, 10);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(50, -10);
        formData.bottom = new FormAttachment(100, -10);
        composite2.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.left = new FormAttachment((Control)composite2, 10);
        label2.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)label2, 10);
        formData.left = new FormAttachment((Control)composite2, 10);
        formData.right = new FormAttachment(100, -10);
        formData.height = n;
        group4.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)group4, 10);
        formData.left = new FormAttachment((Control)composite2, 10);
        formData.right = new FormAttachment(100, -10);
        formData.bottom = new FormAttachment(100, -10);
        composite3.setLayoutData((Object)formData);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Point point = shell.computeSize(-1, -1);
        Rectangle rectangle = shell.getMonitor().getClientArea();
        shell.setSize(Math.min(point.x, rectangle.width - 20), Math.min(point.y, rectangle.height - 20));
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void printEvent(DragSourceEvent dragSourceEvent) {
        if (!this.dragEventDetail) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("widget: ");
        stringBuffer.append(dragSourceEvent.widget);
        stringBuffer.append(", time: ");
        stringBuffer.append(dragSourceEvent.time);
        stringBuffer.append(", operation: ");
        stringBuffer.append(dragSourceEvent.detail);
        stringBuffer.append(", type: ");
        stringBuffer.append(dragSourceEvent.dataType != null ? dragSourceEvent.dataType.type : 0L);
        stringBuffer.append(", doit: ");
        stringBuffer.append(dragSourceEvent.doit);
        stringBuffer.append(", data: ");
        stringBuffer.append(dragSourceEvent.data);
        stringBuffer.append("\n");
        this.dragConsole.append(stringBuffer.toString());
    }

    private void printEvent(DropTargetEvent dropTargetEvent) {
        if (!this.dropEventDetail) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("widget; ");
        stringBuffer.append(dropTargetEvent.widget);
        stringBuffer.append(", time: ");
        stringBuffer.append(dropTargetEvent.time);
        stringBuffer.append(", x: ");
        stringBuffer.append(dropTargetEvent.x);
        stringBuffer.append(", y: ");
        stringBuffer.append(dropTargetEvent.y);
        stringBuffer.append(", item: ");
        stringBuffer.append(dropTargetEvent.item);
        stringBuffer.append(", operations: ");
        stringBuffer.append(dropTargetEvent.operations);
        stringBuffer.append(", operation: ");
        stringBuffer.append(dropTargetEvent.detail);
        stringBuffer.append(", feedback: ");
        stringBuffer.append(dropTargetEvent.feedback);
        if (dropTargetEvent.dataTypes != null) {
            for (int i = 0; i < dropTargetEvent.dataTypes.length; ++i) {
                stringBuffer.append(", dataType ");
                stringBuffer.append(i);
                stringBuffer.append(": ");
                stringBuffer.append(dropTargetEvent.dataTypes[i].type);
            }
        } else {
            stringBuffer.append(", dataTypes: none");
        }
        stringBuffer.append(", currentDataType: ");
        stringBuffer.append(dropTargetEvent.currentDataType);
        stringBuffer.append(", data: ");
        stringBuffer.append(dropTargetEvent.data);
        stringBuffer.append("\n");
        this.dropConsole.append(stringBuffer.toString());
    }

    private void removeDragTransfer(Transfer transfer) {
        if (this.dragTypes.length == 1) {
            this.dragTypes = new Transfer[0];
        } else {
            int n = -1;
            for (int i = 0; i < this.dragTypes.length; ++i) {
                if (this.dragTypes[i] != transfer) continue;
                n = i;
                break;
            }
            if (n == -1) {
                return;
            }
            Transfer[] transferArray = new Transfer[this.dragTypes.length - 1];
            System.arraycopy(this.dragTypes, 0, transferArray, 0, n);
            System.arraycopy(this.dragTypes, n + 1, transferArray, n, this.dragTypes.length - n - 1);
            this.dragTypes = transferArray;
        }
        if (this.dragSource != null) {
            this.dragSource.setTransfer(this.dragTypes);
        }
    }

    private void removeDropTransfer(Transfer transfer) {
        if (this.dropTypes.length == 1) {
            this.dropTypes = new Transfer[0];
        } else {
            int n = -1;
            for (int i = 0; i < this.dropTypes.length; ++i) {
                if (this.dropTypes[i] != transfer) continue;
                n = i;
                break;
            }
            if (n == -1) {
                return;
            }
            Transfer[] transferArray = new Transfer[this.dropTypes.length - 1];
            System.arraycopy(this.dropTypes, 0, transferArray, 0, n);
            System.arraycopy(this.dropTypes, n + 1, transferArray, n, this.dropTypes.length - n - 1);
            this.dropTypes = transferArray;
        }
        if (this.dropTarget != null) {
            this.dropTarget.setTransfer(this.dropTypes);
        }
    }

    static /* synthetic */ String[] access$802(DNDExample dNDExample, String[] stringArray) {
        dNDExample.dragDataFiles = stringArray;
        return stringArray;
    }
}

