/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class ImageTransfer
extends ByteArrayTransfer {
    private static final String TYPENAME = "imagedata";
    private static final int TYPEID = ImageTransfer.registerType((String)"imagedata");
    private static ImageTransfer _instance = new ImageTransfer();

    public static ImageTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        ImageData imageData = (ImageData)object;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{imageData};
            imageLoader.save((OutputStream)dataOutputStream, 0);
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            super.javaToNative((Object)byArray, transferData);
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object nativeToJava(TransferData transferData) {
        ImageData imageData;
        if (!this.isSupportedType(transferData)) {
            return null;
        }
        byte[] byArray = (byte[])super.nativeToJava(transferData);
        if (byArray == null) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            imageData = new ImageData((InputStream)dataInputStream);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return imageData;
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

