/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.fileviewer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.examples.fileviewer.IconCache;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class FileViewer {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_fileviewer");
    private static final String DRIVE_A = "a:" + File.separator;
    private static final String DRIVE_B = "b:" + File.separator;
    private Display display;
    private Shell shell;
    private ToolBar toolBar;
    private Label numObjectsLabel;
    private Label diskSpaceLabel;
    private File currentDirectory = null;
    private boolean initial = true;
    private boolean isDragging = false;
    private boolean isDropping = false;
    private File[] processedDropFiles = null;
    private File[] deferredRefreshFiles = null;
    private boolean deferredRefreshRequested = false;
    private ProgressDialog progressDialog = null;
    private static final String COMBODATA_ROOTS = "Combo.roots";
    private static final String COMBODATA_LASTTEXT = "Combo.lastText";
    private Combo combo;
    private IconCache iconCache = new IconCache();
    private static final String TREEITEMDATA_FILE = "TreeItem.file";
    private static final String TREEITEMDATA_IMAGEEXPANDED = "TreeItem.imageExpanded";
    private static final String TREEITEMDATA_IMAGECOLLAPSED = "TreeItem.imageCollapsed";
    private static final String TREEITEMDATA_STUB = "TreeItem.stub";
    private Tree tree;
    private Label treeScopeLabel;
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
    private static final String TABLEITEMDATA_FILE = "TableItem.file";
    private static final String TABLEDATA_DIR = "Table.dir";
    private static final int[] tableWidths = new int[]{150, 60, 75, 150};
    private final String[] tableTitles = new String[]{FileViewer.getResourceString("table.Name.title"), FileViewer.getResourceString("table.Size.title"), FileViewer.getResourceString("table.Type.title"), FileViewer.getResourceString("table.Modified.title")};
    private Table table;
    private Label tableContentsOfLabel;
    private final Object workerLock = new Object();
    private volatile Thread workerThread = null;
    private volatile boolean workerStopped = false;
    private volatile boolean workerCancelled = false;
    private volatile File workerStateDir = null;
    private volatile File workerNextDir = null;
    private boolean simulateOnly = true;
    private final Runnable workerRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!FileViewer.this.workerStopped) {
                Object object = FileViewer.this.workerLock;
                synchronized (object) {
                    FileViewer.this.workerCancelled = false;
                    FileViewer.this.workerStateDir = FileViewer.this.workerNextDir;
                }
                FileViewer.this.workerExecute();
                object = FileViewer.this.workerLock;
                synchronized (object) {
                    try {
                        if (!FileViewer.this.workerCancelled && FileViewer.this.workerStateDir == FileViewer.this.workerNextDir) {
                            FileViewer.this.workerLock.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            FileViewer.this.workerThread = null;
            FileViewer.this.display.wake();
        }
    };

    public static void main(String[] stringArray) {
        Display display = new Display();
        FileViewer fileViewer = new FileViewer();
        Shell shell = fileViewer.open(display);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        fileViewer.close();
        display.dispose();
    }

    public Shell open(Display display) {
        this.display = display;
        this.iconCache.initResources(display);
        this.shell = new Shell();
        this.createShellContents();
        this.notifyRefreshFiles(null);
        this.shell.open();
        return this.shell;
    }

    void close() {
        this.workerStop();
        this.iconCache.freeResources();
    }

    static String getResourceString(String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + string + "!";
        }
    }

    static String getResourceString(String string, Object[] objectArray) {
        try {
            return MessageFormat.format(FileViewer.getResourceString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + string + "!";
        }
    }

    private void createShellContents() {
        this.shell.setText(FileViewer.getResourceString("Title", new Object[]{""}));
        Image[] imageArray = this.iconCache.stockImages;
        this.iconCache.getClass();
        this.shell.setImage(imageArray[0]);
        Menu menu = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menu);
        this.createFileMenu(menu);
        this.createHelpMenu(menu);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.shell.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        gridData.widthHint = 185;
        this.createComboView((Composite)this.shell, gridData);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.createToolBar(this.shell, gridData);
        SashForm sashForm = new SashForm((Composite)this.shell, 0);
        sashForm.setOrientation(256);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        sashForm.setLayoutData((Object)gridData);
        this.createTreeView((Composite)sashForm);
        this.createTableView((Composite)sashForm);
        sashForm.setWeights(new int[]{2, 5});
        this.numObjectsLabel = new Label((Composite)this.shell, 2048);
        gridData = new GridData(784);
        gridData.widthHint = 185;
        this.numObjectsLabel.setLayoutData((Object)gridData);
        this.diskSpaceLabel = new Label((Composite)this.shell, 2048);
        gridData = new GridData(784);
        gridData.horizontalSpan = 2;
        this.diskSpaceLabel.setLayoutData((Object)gridData);
    }

    private void createFileMenu(Menu menu) {
        Menu menu2 = new Menu(menu);
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(FileViewer.getResourceString("menu.File.text"));
        menuItem.setMenu(menu2);
        final MenuItem menuItem2 = new MenuItem(menu2, 32);
        menuItem2.setText(FileViewer.getResourceString("menu.File.SimulateOnly.text"));
        menuItem2.setSelection(this.simulateOnly);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileViewer.this.simulateOnly = menuItem2.getSelection();
            }
        });
        MenuItem menuItem3 = new MenuItem(menu2, 8);
        menuItem3.setText(FileViewer.getResourceString("menu.File.Close.text"));
        menuItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileViewer.this.shell.close();
            }
        });
    }

    private void createHelpMenu(Menu menu) {
        Menu menu2 = new Menu(menu);
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(FileViewer.getResourceString("menu.Help.text"));
        menuItem.setMenu(menu2);
        MenuItem menuItem2 = new MenuItem(menu2, 8);
        menuItem2.setText(FileViewer.getResourceString("menu.Help.About.text"));
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MessageBox messageBox = new MessageBox(FileViewer.this.shell, 34);
                messageBox.setText(FileViewer.getResourceString("dialog.About.title"));
                messageBox.setMessage(FileViewer.getResourceString("dialog.About.description", new Object[]{System.getProperty("os.name")}));
                messageBox.open();
            }
        });
    }

    private void createToolBar(final Shell shell, Object object) {
        this.toolBar = new ToolBar((Composite)shell, 0);
        this.toolBar.setLayoutData(object);
        ToolItem toolItem = new ToolItem(this.toolBar, 2);
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(this.iconCache.stockImages[this.iconCache.cmdParent]);
        toolItem.setToolTipText(FileViewer.getResourceString("tool.Parent.tiptext"));
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileViewer.this.doParent();
            }
        });
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(this.iconCache.stockImages[this.iconCache.cmdRefresh]);
        toolItem.setToolTipText(FileViewer.getResourceString("tool.Refresh.tiptext"));
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileViewer.this.doRefresh();
            }
        });
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MessageBox messageBox = new MessageBox(shell, 34);
                messageBox.setText(FileViewer.getResourceString("dialog.NotImplemented.title"));
                messageBox.setMessage(FileViewer.getResourceString("dialog.ActionNotImplemented.description"));
                messageBox.open();
            }
        };
        toolItem = new ToolItem(this.toolBar, 2);
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(this.iconCache.stockImages[this.iconCache.cmdCut]);
        toolItem.setToolTipText(FileViewer.getResourceString("tool.Cut.tiptext"));
        toolItem.addSelectionListener((SelectionListener)selectionAdapter);
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(this.iconCache.stockImages[this.iconCache.cmdCopy]);
        toolItem.setToolTipText(FileViewer.getResourceString("tool.Copy.tiptext"));
        toolItem.addSelectionListener((SelectionListener)selectionAdapter);
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(this.iconCache.stockImages[this.iconCache.cmdPaste]);
        toolItem.setToolTipText(FileViewer.getResourceString("tool.Paste.tiptext"));
        toolItem.addSelectionListener((SelectionListener)selectionAdapter);
        toolItem = new ToolItem(this.toolBar, 2);
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(this.iconCache.stockImages[this.iconCache.cmdDelete]);
        toolItem.setToolTipText(FileViewer.getResourceString("tool.Delete.tiptext"));
        toolItem.addSelectionListener((SelectionListener)selectionAdapter);
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(this.iconCache.stockImages[this.iconCache.cmdRename]);
        toolItem.setToolTipText(FileViewer.getResourceString("tool.Rename.tiptext"));
        toolItem.addSelectionListener((SelectionListener)selectionAdapter);
        toolItem = new ToolItem(this.toolBar, 2);
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(this.iconCache.stockImages[this.iconCache.cmdSearch]);
        toolItem.setToolTipText(FileViewer.getResourceString("tool.Search.tiptext"));
        toolItem.addSelectionListener((SelectionListener)selectionAdapter);
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(this.iconCache.stockImages[this.iconCache.cmdPrint]);
        toolItem.setToolTipText(FileViewer.getResourceString("tool.Print.tiptext"));
        toolItem.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private void createComboView(Composite composite, Object object) {
        this.combo = new Combo(composite, 0);
        this.combo.setLayoutData(object);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                File[] fileArray = (File[])FileViewer.this.combo.getData(FileViewer.COMBODATA_ROOTS);
                if (fileArray == null) {
                    return;
                }
                int n = FileViewer.this.combo.getSelectionIndex();
                if (n >= 0 && n < fileArray.length) {
                    FileViewer.this.notifySelectedDirectory(fileArray[n]);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                String string = (String)FileViewer.this.combo.getData(FileViewer.COMBODATA_LASTTEXT);
                String string2 = FileViewer.this.combo.getText();
                if (string2 == null) {
                    return;
                }
                if (string != null && string.equals(string2)) {
                    return;
                }
                FileViewer.this.combo.setData(FileViewer.COMBODATA_LASTTEXT, (Object)string2);
                FileViewer.this.notifySelectedDirectory(new File(string2));
            }
        });
    }

    private void createTreeView(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        this.treeScopeLabel = new Label(composite2, 2048);
        this.treeScopeLabel.setText(FileViewer.getResourceString("details.AllFolders.text"));
        this.treeScopeLabel.setLayoutData((Object)new GridData(784));
        this.tree = new Tree(composite2, 2820);
        this.tree.setLayoutData((Object)new GridData(1808));
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeItem[] treeItemArray = FileViewer.this.tree.getSelection();
                if (treeItemArray != null && treeItemArray.length != 0) {
                    TreeItem treeItem = treeItemArray[0];
                    File file = (File)treeItem.getData(FileViewer.TREEITEMDATA_FILE);
                    FileViewer.this.notifySelectedDirectory(file);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                TreeItem[] treeItemArray = FileViewer.this.tree.getSelection();
                if (treeItemArray != null && treeItemArray.length != 0) {
                    TreeItem treeItem = treeItemArray[0];
                    treeItem.setExpanded(true);
                    FileViewer.this.treeExpandItem(treeItem);
                }
            }
        });
        this.tree.addTreeListener((TreeListener)new TreeAdapter(){

            public void treeExpanded(TreeEvent treeEvent) {
                TreeItem treeItem = (TreeItem)treeEvent.item;
                Image image = (Image)treeItem.getData(FileViewer.TREEITEMDATA_IMAGEEXPANDED);
                if (image != null) {
                    treeItem.setImage(image);
                }
                FileViewer.this.treeExpandItem(treeItem);
            }

            public void treeCollapsed(TreeEvent treeEvent) {
                TreeItem treeItem = (TreeItem)treeEvent.item;
                Image image = (Image)treeItem.getData(FileViewer.TREEITEMDATA_IMAGECOLLAPSED);
                if (image != null) {
                    treeItem.setImage(image);
                }
            }
        });
        this.createTreeDragSource(this.tree);
        this.createTreeDropTarget(this.tree);
    }

    private DragSource createTreeDragSource(final Tree tree) {
        DragSource dragSource = new DragSource((Control)tree, 3);
        dragSource.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){
            TreeItem[] dndSelection = null;
            String[] sourceNames = null;

            public void dragStart(DragSourceEvent dragSourceEvent) {
                this.dndSelection = tree.getSelection();
                this.sourceNames = null;
                dragSourceEvent.doit = this.dndSelection.length > 0;
                FileViewer.this.isDragging = true;
                FileViewer.access$602(FileViewer.this, null);
            }

            public void dragFinished(DragSourceEvent dragSourceEvent) {
                FileViewer.this.dragSourceHandleDragFinished(dragSourceEvent, this.sourceNames);
                this.dndSelection = null;
                this.sourceNames = null;
                FileViewer.this.isDragging = false;
                FileViewer.access$602(FileViewer.this, null);
                FileViewer.this.handleDeferredRefresh();
            }

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                if (this.dndSelection == null || this.dndSelection.length == 0) {
                    return;
                }
                if (!FileTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
                    return;
                }
                this.sourceNames = new String[this.dndSelection.length];
                for (int i = 0; i < this.dndSelection.length; ++i) {
                    File file = (File)this.dndSelection[i].getData(FileViewer.TREEITEMDATA_FILE);
                    this.sourceNames[i] = file.getAbsolutePath();
                }
                dragSourceEvent.data = this.sourceNames;
            }
        });
        return dragSource;
    }

    private DropTarget createTreeDropTarget(final Tree tree) {
        DropTarget dropTarget = new DropTarget((Control)tree, 3);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent dropTargetEvent) {
                FileViewer.this.isDropping = true;
            }

            public void dragLeave(DropTargetEvent dropTargetEvent) {
                FileViewer.this.isDropping = false;
                FileViewer.this.handleDeferredRefresh();
            }

            public void dragOver(DropTargetEvent dropTargetEvent) {
                FileViewer.this.dropTargetValidate(dropTargetEvent, this.getTargetFile(dropTargetEvent));
                dropTargetEvent.feedback |= 0x18;
            }

            public void drop(DropTargetEvent dropTargetEvent) {
                File file = this.getTargetFile(dropTargetEvent);
                if (FileViewer.this.dropTargetValidate(dropTargetEvent, file)) {
                    FileViewer.this.dropTargetHandleDrop(dropTargetEvent, file);
                }
            }

            private File getTargetFile(DropTargetEvent dropTargetEvent) {
                TreeItem treeItem = tree.getItem(tree.toControl(new Point(dropTargetEvent.x, dropTargetEvent.y)));
                File file = null;
                if (treeItem != null) {
                    file = (File)treeItem.getData(FileViewer.TREEITEMDATA_FILE);
                }
                return file;
            }
        });
        return dropTarget;
    }

    private void treeExpandItem(TreeItem treeItem) {
        Cursor[] cursorArray = this.iconCache.stockCursors;
        this.iconCache.getClass();
        this.shell.setCursor(cursorArray[1]);
        Object object = treeItem.getData(TREEITEMDATA_STUB);
        if (object == null) {
            this.treeRefreshItem(treeItem, true);
        }
        Cursor[] cursorArray2 = this.iconCache.stockCursors;
        this.iconCache.getClass();
        this.shell.setCursor(cursorArray2[0]);
    }

    private void treeRefresh(File[] fileArray) {
        TreeItem treeItem;
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < treeItemArray.length; ++i) {
            treeItem = treeItemArray[i];
            File file = (File)treeItem.getData(TREEITEMDATA_FILE);
            if (file == null || n == fileArray.length) {
                treeItem.dispose();
                continue;
            }
            File file2 = fileArray[n];
            int n3 = FileViewer.compareFiles(file2, file);
            if (n3 == 0) {
                this.treeRefreshItem(treeItem, false);
                ++n2;
                ++n;
                continue;
            }
            if (n3 < 0) {
                TreeItem treeItem2 = new TreeItem(this.tree, 0, n2);
                this.treeInitVolume(treeItem2, file2);
                new TreeItem(treeItem2, 0);
                ++n2;
                ++n;
                --i;
                continue;
            }
            treeItem.dispose();
        }
        while (n < fileArray.length) {
            File file = fileArray[n];
            treeItem = new TreeItem(this.tree, 0);
            this.treeInitVolume(treeItem, file);
            new TreeItem(treeItem, 0);
            ++n;
        }
    }

    private void treeRefreshItem(TreeItem treeItem, boolean bl) {
        File[] fileArray;
        File file = (File)treeItem.getData(TREEITEMDATA_FILE);
        if (!bl && !treeItem.getExpanded()) {
            if (treeItem.getData(TREEITEMDATA_STUB) != null) {
                FileViewer.treeItemRemoveAll(treeItem);
                new TreeItem(treeItem, 0);
                treeItem.setData(TREEITEMDATA_STUB, null);
            }
            return;
        }
        treeItem.setData(TREEITEMDATA_STUB, (Object)this);
        File[] fileArray2 = fileArray = file != null ? FileViewer.getDirectoryList(file) : null;
        if (fileArray == null || fileArray.length == 0) {
            FileViewer.treeItemRemoveAll(treeItem);
            treeItem.setExpanded(false);
            return;
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        File[] fileArray3 = fileArray;
        int n = 0;
        int n2 = 0;
        File file2 = null;
        for (int i = 0; i < treeItemArray.length; ++i) {
            while (file2 == null && n < fileArray3.length) {
                if ((file2 = fileArray3[n++]).isDirectory()) continue;
                file2 = null;
            }
            TreeItem treeItem2 = treeItemArray[i];
            File file3 = (File)treeItem2.getData(TREEITEMDATA_FILE);
            if (file3 == null || file2 == null) {
                treeItem2.dispose();
                continue;
            }
            int n3 = FileViewer.compareFiles(file2, file3);
            if (n3 == 0) {
                this.treeRefreshItem(treeItem2, false);
                file2 = null;
                ++n2;
                continue;
            }
            if (n3 < 0) {
                TreeItem treeItem3 = new TreeItem(treeItem, 0, n2);
                this.treeInitFolder(treeItem3, file2);
                new TreeItem(treeItem3, 0);
                file2 = null;
                ++n2;
                --i;
                continue;
            }
            treeItem2.dispose();
        }
        while (file2 != null || n < fileArray3.length) {
            if (file2 != null) {
                TreeItem treeItem4 = new TreeItem(treeItem, 0);
                this.treeInitFolder(treeItem4, file2);
                new TreeItem(treeItem4, 0);
                if (n == fileArray3.length) break;
            }
            if ((file2 = fileArray3[n++]).isDirectory()) continue;
            file2 = null;
        }
    }

    private static void treeItemRemoveAll(TreeItem treeItem) {
        TreeItem[] treeItemArray = treeItem.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            treeItemArray[i].dispose();
        }
    }

    private void treeInitFolder(TreeItem treeItem, File file) {
        treeItem.setText(file.getName());
        treeItem.setImage(this.iconCache.stockImages[this.iconCache.iconClosedFolder]);
        treeItem.setData(TREEITEMDATA_FILE, (Object)file);
        treeItem.setData(TREEITEMDATA_IMAGEEXPANDED, (Object)this.iconCache.stockImages[this.iconCache.iconOpenFolder]);
        treeItem.setData(TREEITEMDATA_IMAGECOLLAPSED, (Object)this.iconCache.stockImages[this.iconCache.iconClosedFolder]);
    }

    private void treeInitVolume(TreeItem treeItem, File file) {
        treeItem.setText(file.getPath());
        Image[] imageArray = this.iconCache.stockImages;
        this.iconCache.getClass();
        treeItem.setImage(imageArray[1]);
        treeItem.setData(TREEITEMDATA_FILE, (Object)file);
        treeItem.setData(TREEITEMDATA_IMAGEEXPANDED, (Object)this.iconCache.stockImages[this.iconCache.iconOpenDrive]);
        Image[] imageArray2 = this.iconCache.stockImages;
        this.iconCache.getClass();
        treeItem.setData(TREEITEMDATA_IMAGECOLLAPSED, (Object)imageArray2[1]);
    }

    private void createTableView(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        this.tableContentsOfLabel = new Label(composite2, 2048);
        this.tableContentsOfLabel.setLayoutData((Object)new GridData(784));
        this.table = new Table(composite2, 68354);
        this.table.setLayoutData((Object)new GridData(1808));
        for (int i = 0; i < this.tableTitles.length; ++i) {
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setText(this.tableTitles[i]);
            tableColumn.setWidth(tableWidths[i]);
        }
        this.table.setHeaderVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileViewer.this.notifySelectedFiles(this.getSelectedFiles());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                FileViewer.this.doDefaultFileAction(this.getSelectedFiles());
            }

            private File[] getSelectedFiles() {
                TableItem[] tableItemArray = FileViewer.this.table.getSelection();
                File[] fileArray = new File[tableItemArray.length];
                for (int i = 0; i < tableItemArray.length; ++i) {
                    fileArray[i] = (File)tableItemArray[i].getData(FileViewer.TABLEITEMDATA_FILE);
                }
                return fileArray;
            }
        });
        this.createTableDragSource(this.table);
        this.createTableDropTarget(this.table);
    }

    private DragSource createTableDragSource(final Table table) {
        DragSource dragSource = new DragSource((Control)table, 3);
        dragSource.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){
            TableItem[] dndSelection = null;
            String[] sourceNames = null;

            public void dragStart(DragSourceEvent dragSourceEvent) {
                this.dndSelection = table.getSelection();
                this.sourceNames = null;
                dragSourceEvent.doit = this.dndSelection.length > 0;
                FileViewer.this.isDragging = true;
            }

            public void dragFinished(DragSourceEvent dragSourceEvent) {
                FileViewer.this.dragSourceHandleDragFinished(dragSourceEvent, this.sourceNames);
                this.dndSelection = null;
                this.sourceNames = null;
                FileViewer.this.isDragging = false;
                FileViewer.this.handleDeferredRefresh();
            }

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                if (this.dndSelection == null || this.dndSelection.length == 0) {
                    return;
                }
                if (!FileTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
                    return;
                }
                this.sourceNames = new String[this.dndSelection.length];
                for (int i = 0; i < this.dndSelection.length; ++i) {
                    File file = (File)this.dndSelection[i].getData(FileViewer.TABLEITEMDATA_FILE);
                    this.sourceNames[i] = file.getAbsolutePath();
                }
                dragSourceEvent.data = this.sourceNames;
            }
        });
        return dragSource;
    }

    private DropTarget createTableDropTarget(final Table table) {
        DropTarget dropTarget = new DropTarget((Control)table, 3);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent dropTargetEvent) {
                FileViewer.this.isDropping = true;
            }

            public void dragLeave(DropTargetEvent dropTargetEvent) {
                FileViewer.this.isDropping = false;
                FileViewer.this.handleDeferredRefresh();
            }

            public void dragOver(DropTargetEvent dropTargetEvent) {
                FileViewer.this.dropTargetValidate(dropTargetEvent, this.getTargetFile(dropTargetEvent));
                dropTargetEvent.feedback |= 0x18;
            }

            public void drop(DropTargetEvent dropTargetEvent) {
                File file = this.getTargetFile(dropTargetEvent);
                if (FileViewer.this.dropTargetValidate(dropTargetEvent, file)) {
                    FileViewer.this.dropTargetHandleDrop(dropTargetEvent, file);
                }
            }

            private File getTargetFile(DropTargetEvent dropTargetEvent) {
                TableItem tableItem = table.getItem(table.toControl(new Point(dropTargetEvent.x, dropTargetEvent.y)));
                File file = null;
                if (tableItem == null) {
                    if (dropTargetEvent.detail == 1) {
                        file = (File)table.getData(FileViewer.TABLEDATA_DIR);
                    }
                } else {
                    file = (File)tableItem.getData(FileViewer.TABLEITEMDATA_FILE);
                }
                return file;
            }
        });
        return dropTarget;
    }

    void notifySelectedDirectory(File file) {
        TreeItem[] treeItemArray;
        if (file == null) {
            return;
        }
        if (this.currentDirectory != null && file.equals(this.currentDirectory)) {
            return;
        }
        this.currentDirectory = file;
        this.notifySelectedFiles(null);
        this.shell.setText(FileViewer.getResourceString("Title", new Object[]{this.currentDirectory.getPath()}));
        this.workerUpdate(file, false);
        File[] fileArray = (File[])this.combo.getData(COMBODATA_ROOTS);
        int n = -1;
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!file.equals(fileArray[i])) continue;
                n = i;
                break;
            }
        }
        if (n == -1) {
            this.combo.setText(file.getPath());
        } else {
            this.combo.select(n);
        }
        Vector<File> vector = new Vector<File>();
        while (file != null) {
            vector.add(file);
            file = file.getParentFile();
        }
        TreeItem[] treeItemArray2 = this.tree.getItems();
        TreeItem treeItem = null;
        for (int i = vector.size() - 1; i >= 0; --i) {
            File file2;
            File file3 = (File)vector.elementAt(i);
            TreeItem treeItem2 = null;
            for (int j = 0; j < treeItemArray2.length && ((treeItem2 = treeItemArray2[j]).isDisposed() || (file2 = (File)treeItem2.getData(TREEITEMDATA_FILE)) == null || !file2.equals(file3)); ++j) {
            }
            if (treeItem2 == null) break;
            treeItem = treeItem2;
            if (i != 0 && !treeItem2.getExpanded()) {
                this.treeExpandItem(treeItem2);
                treeItem2.setExpanded(true);
            }
            treeItemArray2 = treeItem2.getItems();
        }
        if (treeItem != null) {
            TreeItem[] treeItemArray3 = new TreeItem[1];
            treeItemArray = treeItemArray3;
            treeItemArray3[0] = treeItem;
        } else {
            treeItemArray = new TreeItem[]{};
        }
        this.tree.setSelection(treeItemArray);
    }

    void notifySelectedFiles(File[] fileArray) {
        if (fileArray != null && fileArray.length != 0) {
            this.numObjectsLabel.setText(FileViewer.getResourceString("details.NumberOfSelectedFiles.text", new Object[]{fileArray.length}));
            long l = 0L;
            for (int i = 0; i < fileArray.length; ++i) {
                l += fileArray[i].length();
            }
            this.diskSpaceLabel.setText(FileViewer.getResourceString("details.FileSize.text", new Object[]{l}));
        } else {
            this.diskSpaceLabel.setText("");
            if (this.currentDirectory != null) {
                int n = FileViewer.getDirectoryList(this.currentDirectory).length;
                this.numObjectsLabel.setText(FileViewer.getResourceString("details.DirNumberOfObjects.text", new Object[]{n}));
            } else {
                this.numObjectsLabel.setText("");
            }
        }
    }

    void notifyRefreshFiles(File[] fileArray) {
        if (fileArray != null && fileArray.length == 0) {
            return;
        }
        if (this.deferredRefreshRequested && this.deferredRefreshFiles != null && fileArray != null) {
            File[] fileArray2 = new File[this.deferredRefreshFiles.length + fileArray.length];
            System.arraycopy(this.deferredRefreshFiles, 0, fileArray2, 0, this.deferredRefreshFiles.length);
            System.arraycopy(fileArray, 0, fileArray2, this.deferredRefreshFiles.length, fileArray.length);
            this.deferredRefreshFiles = fileArray2;
        } else {
            this.deferredRefreshFiles = fileArray;
            this.deferredRefreshRequested = true;
        }
        this.handleDeferredRefresh();
    }

    void handleDeferredRefresh() {
        File[] fileArray;
        File file;
        if (this.isDragging || this.isDropping || !this.deferredRefreshRequested) {
            return;
        }
        if (this.progressDialog != null) {
            this.progressDialog.close();
            this.progressDialog = null;
        }
        this.deferredRefreshRequested = false;
        File[] fileArray2 = this.deferredRefreshFiles;
        this.deferredRefreshFiles = null;
        Cursor[] cursorArray = this.iconCache.stockCursors;
        this.iconCache.getClass();
        this.shell.setCursor(cursorArray[1]);
        boolean bl = false;
        if (fileArray2 != null) {
            for (int i = 0; i < fileArray2.length; ++i) {
                file = fileArray2[i];
                if (file.equals(this.currentDirectory)) {
                    bl = true;
                } else {
                    fileArray = file.getParentFile();
                    if (fileArray == null || !fileArray.equals(this.currentDirectory)) continue;
                    bl = true;
                }
                break;
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.workerUpdate(this.currentDirectory, true);
        }
        File[] fileArray3 = this.getRoots();
        if (fileArray2 == null) {
            int n;
            boolean bl2 = false;
            fileArray = (File[])this.combo.getData(COMBODATA_ROOTS);
            if (fileArray != null && fileArray.length == fileArray3.length) {
                for (n = 0; n < fileArray3.length; ++n) {
                    if (fileArray3[n].equals(fileArray[n])) continue;
                    bl2 = true;
                    break;
                }
            } else {
                bl2 = true;
            }
            if (bl2) {
                this.combo.removeAll();
                this.combo.setData(COMBODATA_ROOTS, (Object)fileArray3);
                for (n = 0; n < fileArray3.length; ++n) {
                    File file2 = fileArray3[n];
                    this.combo.add(file2.getPath());
                }
            }
        }
        this.treeRefresh(fileArray3);
        file = this.currentDirectory;
        this.currentDirectory = null;
        this.notifySelectedDirectory(file);
        Cursor[] cursorArray2 = this.iconCache.stockCursors;
        this.iconCache.getClass();
        this.shell.setCursor(cursorArray2[0]);
    }

    void doDefaultFileAction(File[] fileArray) {
        if (fileArray.length == 0) {
            return;
        }
        File file = fileArray[0];
        if (file.isDirectory()) {
            this.notifySelectedDirectory(file);
        } else {
            String string = file.getAbsolutePath();
            if (!Program.launch((String)string)) {
                MessageBox messageBox = new MessageBox(this.shell, 33);
                messageBox.setMessage(FileViewer.getResourceString("error.FailedLaunch.message", new Object[]{string}));
                messageBox.setText(this.shell.getText());
                messageBox.open();
            }
        }
    }

    void doParent() {
        if (this.currentDirectory == null) {
            return;
        }
        File file = this.currentDirectory.getParentFile();
        this.notifySelectedDirectory(file);
    }

    void doRefresh() {
        this.notifyRefreshFiles(null);
    }

    private boolean dropTargetValidate(DropTargetEvent dropTargetEvent, File file) {
        if (file != null && file.isDirectory()) {
            if (dropTargetEvent.detail != 1 && dropTargetEvent.detail != 2) {
                dropTargetEvent.detail = 2;
            }
        } else {
            dropTargetEvent.detail = 0;
        }
        return dropTargetEvent.detail != 0;
    }

    private void dropTargetHandleDrop(DropTargetEvent dropTargetEvent, File file) {
        if (!this.dropTargetValidate(dropTargetEvent, file)) {
            return;
        }
        String[] stringArray = (String[])dropTargetEvent.data;
        if (stringArray == null) {
            dropTargetEvent.detail = 0;
        }
        if (dropTargetEvent.detail == 0) {
            return;
        }
        this.progressDialog = new ProgressDialog(this.shell, dropTargetEvent.detail == 2 ? 2 : 0);
        this.progressDialog.setTotalWorkUnits(stringArray.length);
        this.progressDialog.open();
        Vector<File> vector = new Vector<File>();
        block0: for (int i = 0; i < stringArray.length && !this.progressDialog.isCancelled(); ++i) {
            File file2 = new File(stringArray[i]);
            File file3 = new File(file, file2.getName());
            if (file2.equals(file3)) continue;
            this.progressDialog.setDetailFile(file2, 0);
            while (!this.progressDialog.isCancelled()) {
                if (this.copyFileStructure(file2, file3)) {
                    vector.add(file2);
                    continue block0;
                }
                if (!this.progressDialog.isCancelled()) {
                    int n;
                    MessageBox messageBox;
                    if (dropTargetEvent.detail == 2 && !this.isDragging) {
                        messageBox = new MessageBox(this.shell, 1281);
                        messageBox.setText(FileViewer.getResourceString("dialog.FailedCopy.title"));
                        messageBox.setMessage(FileViewer.getResourceString("dialog.FailedCopy.description", new Object[]{file2, file3}));
                        n = messageBox.open();
                        if (n == 256) {
                            i = stringArray.length;
                            dropTargetEvent.detail = 0;
                            continue block0;
                        }
                    } else {
                        messageBox = new MessageBox(this.shell, 3585);
                        messageBox.setText(FileViewer.getResourceString("dialog.FailedCopy.title"));
                        messageBox.setMessage(FileViewer.getResourceString("dialog.FailedCopy.description", new Object[]{file2, file3}));
                        n = messageBox.open();
                        if (n == 512) {
                            i = stringArray.length;
                        }
                        if (n != 1024) continue block0;
                    }
                }
                this.progressDialog.addProgress(1);
            }
        }
        if (this.isDragging) {
            this.processedDropFiles = vector.toArray(new File[vector.size()]);
        } else {
            this.progressDialog.close();
            this.progressDialog = null;
        }
        this.notifyRefreshFiles(new File[]{file});
    }

    private void dragSourceHandleDragFinished(DragSourceEvent dragSourceEvent, String[] stringArray) {
        int n;
        File[] fileArray;
        if (stringArray == null) {
            return;
        }
        if (dragSourceEvent.detail != 2) {
            return;
        }
        if (this.processedDropFiles != null) {
            fileArray = this.processedDropFiles;
        } else {
            fileArray = new File[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                fileArray[n] = new File(stringArray[n]);
            }
        }
        if (this.progressDialog == null) {
            this.progressDialog = new ProgressDialog(this.shell, 2);
        }
        this.progressDialog.setTotalWorkUnits(fileArray.length);
        this.progressDialog.setProgress(0);
        this.progressDialog.open();
        for (n = 0; n < fileArray.length && !this.progressDialog.isCancelled(); ++n) {
            File file = fileArray[n];
            this.progressDialog.setDetailFile(file, 1);
            while (!this.progressDialog.isCancelled() && !this.deleteFileStructure(file)) {
                if (this.progressDialog.isCancelled()) continue;
                MessageBox messageBox = new MessageBox(this.shell, 3585);
                messageBox.setText(FileViewer.getResourceString("dialog.FailedDelete.title"));
                messageBox.setMessage(FileViewer.getResourceString("dialog.FailedDelete.description", new Object[]{file}));
                int n2 = messageBox.open();
                if (n2 == 512) {
                    n = stringArray.length;
                }
                if (n2 != 1024) continue;
                break;
            }
            this.progressDialog.addProgress(1);
        }
        this.notifyRefreshFiles(fileArray);
        this.progressDialog.close();
        this.progressDialog = null;
    }

    File[] getRoots() {
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            Vector<File> vector = new Vector<File>();
            vector.add(new File(DRIVE_A));
            vector.add(new File(DRIVE_B));
            for (char c = 'c'; c <= 'z'; c = (char)(c + '\u0001')) {
                File file = new File(c + ":" + File.separator);
                if (!file.isDirectory() || !file.exists()) continue;
                vector.add(file);
                if (!this.initial || c != 99) continue;
                this.currentDirectory = file;
                this.initial = false;
            }
            File[] fileArray = vector.toArray(new File[vector.size()]);
            FileViewer.sortFiles(fileArray);
            return fileArray;
        }
        File file = new File(File.separator);
        if (this.initial) {
            this.currentDirectory = file;
            this.initial = false;
        }
        return new File[]{file};
    }

    static File[] getDirectoryList(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return new File[0];
        }
        FileViewer.sortFiles(fileArray);
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean copyFileStructure(File file, File file2) {
        block27: {
            block26: {
                if (file == null || file2 == null) {
                    return false;
                }
                File file3 = file2;
                do {
                    if (!file.equals(file3)) continue;
                    return false;
                } while ((file3 = file3.getParentFile()) != null);
                if (!file.isDirectory()) break block26;
                if (this.progressDialog != null) {
                    this.progressDialog.setDetailFile(file, 0);
                }
                if (!this.simulateOnly && !file2.mkdirs()) {
                    return false;
                }
                File[] fileArray = file.listFiles();
                if (fileArray == null) break block27;
                if (this.progressDialog != null) {
                    this.progressDialog.addWorkUnits(fileArray.length);
                }
                for (int i = 0; i < fileArray.length; ++i) {
                    File file4 = fileArray[i];
                    File file5 = new File(file2, file4.getName());
                    if (!this.copyFileStructure(file4, file5)) {
                        return false;
                    }
                    if (this.progressDialog == null) continue;
                    this.progressDialog.addProgress(1);
                    if (!this.progressDialog.isCancelled()) continue;
                    return false;
                }
                break block27;
            }
            if (!this.simulateOnly) {
                FileReader fileReader = null;
                OutputStreamWriter outputStreamWriter = null;
                try {
                    int n;
                    fileReader = new FileReader(file);
                    outputStreamWriter = new FileWriter(file2);
                    while ((n = fileReader.read()) != -1) {
                        outputStreamWriter.write(n);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    boolean bl = false;
                    return bl;
                }
                catch (IOException iOException) {
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (fileReader != null) {
                            fileReader.close();
                        }
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    boolean deleteFileStructure(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            File[] fileArray;
            if (this.progressDialog != null) {
                this.progressDialog.setDetailFile(file, 1);
            }
            if ((fileArray = file.listFiles()) != null) {
                if (this.progressDialog != null) {
                    this.progressDialog.addWorkUnits(fileArray.length);
                }
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (!this.deleteFileStructure(file2)) {
                        return false;
                    }
                    if (this.progressDialog == null) continue;
                    this.progressDialog.addProgress(1);
                    if (!this.progressDialog.isCancelled()) continue;
                    return false;
                }
            }
        }
        if (this.simulateOnly) {
            return true;
        }
        return file.delete();
    }

    static void sortFiles(File[] fileArray) {
        FileViewer.sortBlock(fileArray, 0, fileArray.length - 1, new File[fileArray.length]);
    }

    private static void sortBlock(File[] fileArray, int n, int n2, File[] fileArray2) {
        int n3;
        int n4 = n2 - n + 1;
        if (n4 < 8) {
            for (int i = n2; i > n; --i) {
                for (int j = n2; j > n; --j) {
                    if (FileViewer.compareFiles(fileArray[j - 1], fileArray[j]) <= 0) continue;
                    File file = fileArray[j];
                    fileArray[j] = fileArray[j - 1];
                    fileArray[j - 1] = file;
                }
            }
            return;
        }
        int n5 = (n + n2) / 2;
        FileViewer.sortBlock(fileArray, n, n5, fileArray2);
        FileViewer.sortBlock(fileArray, n5 + 1, n2, fileArray2);
        int n6 = n;
        int n7 = n5 + 1;
        for (n3 = 0; n3 < n4; ++n3) {
            fileArray2[n3] = n6 > n5 || n7 <= n2 && FileViewer.compareFiles(fileArray[n6], fileArray[n7]) > 0 ? fileArray[n7++] : fileArray[n6++];
        }
        for (n3 = 0; n3 < n4; ++n3) {
            fileArray[n3 + n] = fileArray2[n3];
        }
    }

    private static int compareFiles(File file, File file2) {
        int n = file.getName().compareToIgnoreCase(file2.getName());
        if (n == 0) {
            n = file.getName().compareTo(file2.getName());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerStop() {
        if (this.workerThread == null) {
            return;
        }
        Object object = this.workerLock;
        synchronized (object) {
            this.workerCancelled = true;
            this.workerStopped = true;
            this.workerLock.notifyAll();
        }
        while (this.workerThread != null) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerUpdate(File file, boolean bl) {
        if (file == null) {
            return;
        }
        if (!bl && this.workerNextDir != null && this.workerNextDir.equals(file)) {
            return;
        }
        Object object = this.workerLock;
        synchronized (object) {
            this.workerNextDir = file;
            this.workerStopped = false;
            this.workerCancelled = true;
            this.workerLock.notifyAll();
        }
        if (this.workerThread == null) {
            this.workerThread = new Thread(this.workerRunnable);
            this.workerThread.start();
        }
    }

    private void workerExecute() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                FileViewer.this.tableContentsOfLabel.setText(FileViewer.getResourceString("details.ContentsOf.text", new Object[]{FileViewer.this.workerStateDir.getPath()}));
                FileViewer.this.table.removeAll();
                FileViewer.this.table.setData(FileViewer.TABLEDATA_DIR, (Object)FileViewer.this.workerStateDir);
            }
        });
        File[] fileArray = FileViewer.getDirectoryList(this.workerStateDir);
        for (int i = 0; !this.workerCancelled && i < fileArray.length; ++i) {
            this.workerAddFileDetails(fileArray[i]);
        }
    }

    private void workerAddFileDetails(final File file) {
        Image image;
        String string;
        String string2;
        String string3 = file.getName();
        String string4 = dateFormat.format(new Date(file.lastModified()));
        if (file.isDirectory()) {
            string2 = FileViewer.getResourceString("filetype.Folder");
            string = "";
            image = this.iconCache.stockImages[this.iconCache.iconClosedFolder];
        } else {
            string = FileViewer.getResourceString("filesize.KB", new Object[]{(file.length() + 512L) / 1024L});
            int n = string3.lastIndexOf(46);
            if (n != -1) {
                String string5 = string3.substring(n);
                Program program = Program.findProgram((String)string5);
                if (program != null) {
                    string2 = program.getName();
                    image = this.iconCache.getIconFromProgram(program);
                } else {
                    string2 = FileViewer.getResourceString("filetype.Unknown", new Object[]{string5.toUpperCase()});
                    image = this.iconCache.stockImages[this.iconCache.iconFile];
                }
            } else {
                string2 = FileViewer.getResourceString("filetype.None");
                image = this.iconCache.stockImages[this.iconCache.iconFile];
            }
        }
        final String[] stringArray = new String[]{string3, string, string2, string4};
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (FileViewer.this.shell.isDisposed()) {
                    return;
                }
                TableItem tableItem = new TableItem(FileViewer.this.table, 0);
                tableItem.setText(stringArray);
                tableItem.setImage(image);
                tableItem.setData(FileViewer.TABLEITEMDATA_FILE, (Object)file);
            }
        });
    }

    static /* synthetic */ File[] access$602(FileViewer fileViewer, File[] fileArray) {
        fileViewer.processedDropFiles = fileArray;
        return fileArray;
    }

    class ProgressDialog {
        public static final int COPY = 0;
        public static final int DELETE = 1;
        public static final int MOVE = 2;
        Shell shell;
        Label messageLabel;
        Label detailLabel;
        ProgressBar progressBar;
        Button cancelButton;
        boolean isCancelled = false;
        final String[] operationKeyName = new String[]{"Copy", "Delete", "Move"};

        public ProgressDialog(Shell shell, int n) {
            this.shell = new Shell(shell, 67616);
            GridLayout gridLayout = new GridLayout();
            this.shell.setLayout((Layout)gridLayout);
            this.shell.setText(FileViewer.getResourceString("progressDialog." + this.operationKeyName[n] + ".title"));
            this.shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent shellEvent) {
                    ProgressDialog.this.isCancelled = true;
                }
            });
            this.messageLabel = new Label((Composite)this.shell, 256);
            this.messageLabel.setLayoutData((Object)new GridData(784));
            this.messageLabel.setText(FileViewer.getResourceString("progressDialog." + this.operationKeyName[n] + ".description"));
            this.progressBar = new ProgressBar((Composite)this.shell, 320);
            this.progressBar.setLayoutData((Object)new GridData(784));
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(0);
            this.detailLabel = new Label((Composite)this.shell, 256);
            GridData gridData = new GridData(770);
            gridData.widthHint = 400;
            this.detailLabel.setLayoutData((Object)gridData);
            this.cancelButton = new Button((Composite)this.shell, 8);
            this.cancelButton.setLayoutData((Object)new GridData(144));
            this.cancelButton.setText(FileViewer.getResourceString("progressDialog.cancelButton.text"));
            this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ProgressDialog.this.isCancelled = true;
                    ProgressDialog.this.cancelButton.setEnabled(false);
                }
            });
        }

        public void setDetailFile(File file, int n) {
            this.detailLabel.setText(FileViewer.getResourceString("progressDialog." + this.operationKeyName[n] + ".operation", new Object[]{file}));
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }

        public void setTotalWorkUnits(int n) {
            this.progressBar.setMaximum(n);
        }

        public void addWorkUnits(int n) {
            this.setTotalWorkUnits(this.progressBar.getMaximum() + n);
        }

        public void setProgress(int n) {
            this.progressBar.setSelection(n);
            while (FileViewer.this.display.readAndDispatch()) {
            }
        }

        public void addProgress(int n) {
            this.setProgress(this.progressBar.getSelection() + n);
        }

        public void open() {
            this.shell.pack();
            Shell shell = (Shell)this.shell.getParent();
            Rectangle rectangle = shell.getBounds();
            Rectangle rectangle2 = this.shell.getBounds();
            rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
            rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
            this.shell.setBounds(rectangle2);
            this.shell.open();
        }

        public void close() {
            this.shell.close();
            this.shell.dispose();
            this.shell = null;
            this.messageLabel = null;
            this.detailLabel = null;
            this.progressBar = null;
            this.cancelButton = null;
        }
    }
}

