/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.fileviewer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.examples.fileviewer.FileViewer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;

class IconCache {
    public final int shellIcon = 0;
    public final int iconClosedDrive = 1;
    public final int iconClosedFolder = 2;
    public final int iconFile = 3;
    public final int iconOpenDrive = 4;
    public final int iconOpenFolder = 5;
    public final int cmdCopy = 6;
    public final int cmdCut = 7;
    public final int cmdDelete = 8;
    public final int cmdParent = 9;
    public final int cmdPaste = 10;
    public final int cmdPrint = 11;
    public final int cmdRefresh = 12;
    public final int cmdRename = 13;
    public final int cmdSearch = 14;
    public final String[] stockImageLocations = new String[]{"generic_example.gif", "icon_ClosedDrive.gif", "icon_ClosedFolder.gif", "icon_File.gif", "icon_OpenDrive.gif", "icon_OpenFolder.gif", "cmd_Copy.gif", "cmd_Cut.gif", "cmd_Delete.gif", "cmd_Parent.gif", "cmd_Paste.gif", "cmd_Print.gif", "cmd_Refresh.gif", "cmd_Rename.gif", "cmd_Search.gif"};
    public Image[] stockImages;
    public final int cursorDefault = 0;
    public final int cursorWait = 1;
    public Cursor[] stockCursors;
    private Hashtable iconCache;

    public void initResources(Display display) {
        if (this.stockImages == null) {
            this.stockImages = new Image[this.stockImageLocations.length];
            for (int i = 0; i < this.stockImageLocations.length; ++i) {
                Image image = this.createStockImage(display, this.stockImageLocations[i]);
                if (image == null) {
                    this.freeResources();
                    throw new IllegalStateException(FileViewer.getResourceString("error.CouldNotLoadResources"));
                }
                this.stockImages[i] = image;
            }
        }
        if (this.stockCursors == null) {
            this.stockCursors = new Cursor[]{null, new Cursor((Device)display, 1)};
        }
        this.iconCache = new Hashtable();
    }

    public void freeResources() {
        Image image;
        int n;
        if (this.stockImages != null) {
            for (n = 0; n < this.stockImages.length; ++n) {
                image = this.stockImages[n];
                if (image == null) continue;
                image.dispose();
            }
            this.stockImages = null;
        }
        if (this.iconCache != null) {
            Enumeration enumeration = this.iconCache.elements();
            while (enumeration.hasMoreElements()) {
                image = (Image)enumeration.nextElement();
                image.dispose();
            }
        }
        if (this.stockCursors != null) {
            for (n = 0; n < this.stockCursors.length; ++n) {
                image = this.stockCursors[n];
                if (image == null) continue;
                image.dispose();
            }
            this.stockCursors = null;
        }
    }

    private Image createStockImage(Display display, String string) {
        InputStream inputStream = IconCache.class.getResourceAsStream(string);
        ImageData imageData = new ImageData(inputStream);
        ImageData imageData2 = imageData.getTransparencyMask();
        Image image = new Image((Device)display, imageData, imageData2);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return image;
    }

    public Image getIconFromProgram(Program program) {
        Image image = (Image)this.iconCache.get(program);
        if (image == null) {
            ImageData imageData = program.getImageData();
            if (imageData != null) {
                image = new Image(null, imageData, imageData.getTransparencyMask());
                this.iconCache.put(program, image);
            } else {
                image = this.stockImages[3];
            }
        }
        return image;
    }
}

