/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.examples.graphics.BlackHoleTab;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.examples.graphics.IntroTab;
import org.eclipse.swt.examples.graphics.LineTab;
import org.eclipse.swt.examples.graphics.StarPolyTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class GraphicsExample {
    Composite parent;
    GraphicsTab[] tabs;
    GraphicsTab tab;
    Object[] tabBackground;
    boolean animate;
    Listener redrawListener;
    ToolBar toolBar;
    Tree tabList;
    Canvas canvas;
    Composite controlPanel;
    Composite tabPanel;
    ToolItem playItem;
    ToolItem pauseItem;
    ToolItem backItem;
    ToolItem dbItem;
    Spinner timerSpinner;
    Menu backMenu;
    MenuItem customMI;
    Image customImage;
    Color customColor;
    Vector images;
    static boolean advanceGraphics;
    static boolean advanceGraphicsInit;
    static final int TIMER = 30;
    static final ResourceBundle RESOURCE_BUNDLE;

    public GraphicsExample(final Composite composite) {
        this.parent = composite;
        this.redrawListener = new Listener(){

            public void handleEvent(Event event) {
                GraphicsExample.this.redraw();
            }
        };
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 1;
        composite.setLayout((Layout)gridLayout);
        this.tabs = this.createTabs();
        this.images = new Vector();
        this.createToolBar(composite);
        this.createTabList(composite);
        Sash sash = new Sash(composite, 512);
        this.createTabPanel(composite);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.toolBar.setLayoutData((Object)gridData);
        gridData = new GridData(0x1000000, 4, false, true);
        gridData.widthHint = this.tabList.computeSize((int)-1, (int)-1).x + 50;
        this.tabList.setLayoutData((Object)gridData);
        gridData = new GridData(0x1000000, 4, false, true);
        sash.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        this.tabPanel.setLayoutData((Object)gridData);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail != 1) {
                    GridData gridData = (GridData)GraphicsExample.this.tabList.getLayoutData();
                    gridData.widthHint = event.x - GraphicsExample.this.tabList.computeTrim((int)0, (int)0, (int)0, (int)0).width;
                    composite.layout(true);
                    GraphicsExample.this.animate = GraphicsExample.this.pauseItem.getEnabled();
                } else {
                    GraphicsExample.this.animate = false;
                }
            }
        });
        this.setTab(this.tab);
        this.startAnimationTimer();
    }

    boolean checkAdvancedGraphics() {
        if (advanceGraphicsInit) {
            return advanceGraphics;
        }
        advanceGraphicsInit = true;
        Display display = Display.getCurrent();
        try {
            Path path = new Path((Device)display);
            path.dispose();
        }
        catch (SWTException sWTException) {
            Shell shell = display.getActiveShell();
            Shell shell2 = null;
            if (shell == null) {
                shell = shell2 = new Shell(display);
            }
            MessageBox messageBox = new MessageBox(shell, 40);
            messageBox.setText(RESOURCE_BUNDLE.getString("Warning"));
            messageBox.setMessage(RESOURCE_BUNDLE.getString("LibNotFound"));
            messageBox.open();
            if (shell2 != null) {
                shell2.dispose();
            }
            return false;
        }
        advanceGraphics = true;
        return true;
    }

    void createCanvas(Composite composite) {
        this.canvas = new Canvas(composite, 262144);
        this.canvas.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                GC gC;
                Rectangle rectangle = GraphicsExample.this.canvas.getClientArea();
                Image image = null;
                if (GraphicsExample.this.dbItem.getSelection()) {
                    image = new Image((Device)GraphicsExample.this.canvas.getDisplay(), rectangle);
                    gC = new GC((Drawable)image);
                } else {
                    gC = event.gc;
                }
                GraphicsExample.this.paintBackground(gC, rectangle);
                GraphicsTab graphicsTab = GraphicsExample.this.getTab();
                if (graphicsTab != null) {
                    graphicsTab.paint(gC, rectangle.width, rectangle.height);
                }
                if (gC != event.gc) {
                    gC.dispose();
                }
                if (image != null) {
                    event.gc.drawImage(image, 0, 0);
                    image.dispose();
                }
            }
        });
    }

    void createControlPanel(Composite composite) {
        Group group = new Group(composite, 0);
        this.controlPanel = group;
        group.setText(GraphicsExample.getResourceString("Settings"));
        this.controlPanel.setLayout((Layout)new RowLayout());
    }

    void createTabPanel(Composite composite) {
        this.tabPanel = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.tabPanel.setLayout((Layout)gridLayout);
        this.createCanvas(this.tabPanel);
        this.createControlPanel(this.tabPanel);
        GridData gridData = new GridData(4, 4, true, true);
        this.canvas.setLayoutData((Object)gridData);
        gridData = new GridData(4, 0x1000000, true, false);
        this.controlPanel.setLayoutData((Object)gridData);
    }

    void createToolBar(final Composite composite) {
        Image image;
        MenuItem menuItem;
        final Display display = composite.getDisplay();
        this.toolBar = new ToolBar(composite, 0x800000);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (event.widget == GraphicsExample.this.playItem) {
                            GraphicsExample.this.animate = true;
                            GraphicsExample.this.playItem.setEnabled(!GraphicsExample.this.animate);
                            GraphicsExample.this.pauseItem.setEnabled(GraphicsExample.this.animate);
                            break;
                        }
                        if (event.widget == GraphicsExample.this.pauseItem) {
                            GraphicsExample.this.animate = false;
                            GraphicsExample.this.playItem.setEnabled(!GraphicsExample.this.animate);
                            GraphicsExample.this.pauseItem.setEnabled(GraphicsExample.this.animate);
                            break;
                        }
                        if (event.widget != GraphicsExample.this.backItem) break;
                        ToolItem toolItem = (ToolItem)event.widget;
                        ToolBar toolBar = toolItem.getParent();
                        Rectangle rectangle = toolItem.getBounds();
                        Point point = toolBar.toDisplay(new Point(rectangle.x, rectangle.y));
                        GraphicsExample.this.backMenu.setLocation(point.x, point.y + rectangle.height);
                        GraphicsExample.this.backMenu.setVisible(true);
                    }
                }
            }
        };
        this.playItem = new ToolItem(this.toolBar, 8);
        this.playItem.setText(GraphicsExample.getResourceString("Play"));
        this.playItem.setImage(this.loadImage(display, "play.gif"));
        this.playItem.addListener(13, listener);
        this.pauseItem = new ToolItem(this.toolBar, 8);
        this.pauseItem.setText(GraphicsExample.getResourceString("Pause"));
        this.pauseItem.setImage(this.loadImage(display, "pause.gif"));
        this.pauseItem.addListener(13, listener);
        this.backItem = new ToolItem(this.toolBar, 8);
        this.backItem.setText(GraphicsExample.getResourceString("Background"));
        this.backItem.addListener(13, listener);
        String[] stringArray = new String[]{GraphicsExample.getResourceString("White"), GraphicsExample.getResourceString("Black"), GraphicsExample.getResourceString("Red"), GraphicsExample.getResourceString("Green"), GraphicsExample.getResourceString("Blue"), GraphicsExample.getResourceString("CustomColor")};
        Color[] colorArray = new Color[]{display.getSystemColor(1), display.getSystemColor(2), display.getSystemColor(3), display.getSystemColor(5), display.getSystemColor(9), null};
        this.backMenu = new Menu((Control)composite);
        Listener listener2 = new Listener(){

            public void handleEvent(Event event) {
                MenuItem menuItem = (MenuItem)event.widget;
                if (GraphicsExample.this.customMI == menuItem) {
                    ColorDialog colorDialog = new ColorDialog(composite.getShell());
                    RGB rGB = colorDialog.open();
                    if (rGB == null) {
                        return;
                    }
                    if (GraphicsExample.this.customColor != null) {
                        GraphicsExample.this.customColor.dispose();
                    }
                    GraphicsExample.this.customColor = new Color((Device)display, rGB);
                    if (GraphicsExample.this.customImage != null) {
                        GraphicsExample.this.customImage.dispose();
                    }
                    GraphicsExample.this.customImage = GraphicsExample.this.createImage(display, GraphicsExample.this.customColor);
                    menuItem.setData((Object)new Object[]{GraphicsExample.this.customColor, GraphicsExample.this.customImage});
                    menuItem.setImage(GraphicsExample.this.customImage);
                }
                GraphicsExample.this.tabBackground = (Object[])menuItem.getData();
                GraphicsExample.this.backItem.setImage((Image)GraphicsExample.this.tabBackground[1]);
                GraphicsExample.this.canvas.redraw();
            }
        };
        for (int i = 0; i < stringArray.length; ++i) {
            menuItem = new MenuItem(this.backMenu, 0);
            menuItem.setText(stringArray[i]);
            menuItem.addListener(13, listener2);
            image = null;
            if (colorArray[i] != null) {
                image = this.createImage(display, colorArray[i]);
                this.images.addElement(image);
                menuItem.setImage(image);
            } else {
                this.customMI = menuItem;
            }
            menuItem.setData((Object)new Object[]{colorArray[i], image});
            if (this.tabBackground != null) continue;
            this.tabBackground = (Object[])menuItem.getData();
            this.backItem.setImage((Image)this.tabBackground[1]);
        }
        this.dbItem = new ToolItem(this.toolBar, 32);
        this.dbItem.setText(GraphicsExample.getResourceString("DoubleBuffer"));
        this.dbItem.setImage(this.loadImage(display, "db.gif"));
        ToolItem toolItem = new ToolItem(this.toolBar, 2);
        menuItem = new Composite((Composite)this.toolBar, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 3;
        gridLayout.marginWidth = 3;
        menuItem.setLayout((Layout)gridLayout);
        this.timerSpinner = new Spinner((Composite)menuItem, 2112);
        image = new GridData(0x1000000, 0x1000000, false, false);
        this.timerSpinner.setLayoutData((Object)image);
        Label label = new Label((Composite)menuItem, 0);
        label.setText(GraphicsExample.getResourceString("Animation"));
        image = new GridData(0x1000000, 0x1000000, false, false);
        label.setLayoutData((Object)image);
        this.timerSpinner.setMaximum(1000);
        this.timerSpinner.setSelection(30);
        this.timerSpinner.setSelection(30);
        toolItem.setControl((Control)menuItem);
        toolItem.setWidth(menuItem.computeSize((int)-1, (int)-1).x);
    }

    Image createImage(Display display, Color color) {
        Image image = new Image((Device)display, 16, 16);
        GC gC = new GC((Drawable)image);
        gC.setBackground(color);
        Rectangle rectangle = image.getBounds();
        gC.fillRectangle(rectangle);
        if (color.equals((Object)display.getSystemColor(2))) {
            gC.setForeground(display.getSystemColor(1));
        }
        gC.drawRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        gC.dispose();
        return image;
    }

    /*
     * WARNING - void declaration
     */
    void createTabList(Composite composite) {
        void var4_9;
        TreeItem treeItem;
        this.tabList = new Tree(composite, 2820);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.tabs.length; ++i) {
            GraphicsTab object = this.tabs[i];
            hashSet.add(object.getCategory());
        }
        for (String string : hashSet) {
            treeItem = new TreeItem(this.tabList, 0);
            treeItem.setText(string);
        }
        TreeItem[] treeItemArray = this.tabList.getItems();
        boolean bl = false;
        while (var4_9 < treeItemArray.length) {
            treeItem = treeItemArray[var4_9];
            for (int i = 0; i < this.tabs.length; ++i) {
                GraphicsTab graphicsTab = this.tabs[i];
                if (!treeItem.getText().equals(graphicsTab.getCategory())) continue;
                TreeItem treeItem2 = new TreeItem(treeItem, 0);
                treeItem2.setText(graphicsTab.getText());
                treeItem2.setData((Object)graphicsTab);
            }
            ++var4_9;
        }
        this.tabList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                if (treeItem != null) {
                    GraphicsExample.this.setTab((GraphicsTab)treeItem.getData());
                }
            }
        });
    }

    GraphicsTab[] createTabs() {
        this.tab = new IntroTab(this);
        return new GraphicsTab[]{new LineTab(this), new StarPolyTab(this), this.tab, new BlackHoleTab(this)};
    }

    public void dispose() {
        int n;
        if (this.tabs != null) {
            for (n = 0; n < this.tabs.length; ++n) {
                GraphicsTab graphicsTab = this.tabs[n];
                graphicsTab.dispose();
            }
        }
        this.tabs = null;
        if (this.images != null) {
            for (n = 0; n < this.images.size(); ++n) {
                ((Image)this.images.elementAt(n)).dispose();
            }
        }
        this.images = null;
        if (this.customColor != null) {
            this.customColor.dispose();
        }
        this.customColor = null;
        if (this.customImage != null) {
            this.customImage.dispose();
        }
        this.customImage = null;
    }

    TreeItem findItemByData(TreeItem[] treeItemArray, Object object) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            TreeItem treeItem = treeItemArray[i];
            if (treeItem.getData() == object) {
                return treeItem;
            }
            if ((treeItem = this.findItemByData(treeItem.getItems(), object)) == null) continue;
            return treeItem;
        }
        return null;
    }

    public GraphicsTab getTab() {
        return this.tab;
    }

    Listener getRedrawListener() {
        return this.redrawListener;
    }

    static String getResourceString(String string) {
        try {
            return RESOURCE_BUNDLE.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + string + "!";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Image loadImage(Display display, Class clazz, String string) {
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        Image image = null;
        try {
            image = new Image((Device)display, inputStream);
        }
        catch (SWTException sWTException) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return image;
    }

    Image loadImage(Display display, String string) {
        Image image = GraphicsExample.loadImage(display, GraphicsExample.class, string);
        if (image != null) {
            this.images.addElement(image);
        }
        return image;
    }

    void paintBackground(GC gC, Rectangle rectangle) {
        gC.setBackground((Color)this.tabBackground[0]);
        gC.fillRectangle(rectangle);
    }

    public void redraw() {
        this.canvas.redraw();
    }

    public void setFocus() {
        this.tabList.setFocus();
    }

    public void setTab(GraphicsTab graphicsTab) {
        TreeItem treeItem;
        TreeItem[] treeItemArray;
        this.tab = graphicsTab;
        Control[] controlArray = this.controlPanel.getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            treeItemArray = controlArray[i];
            treeItemArray.dispose();
        }
        if (graphicsTab != null) {
            graphicsTab.createControlPanel(this.controlPanel);
            this.animate = graphicsTab.isAnimated();
        }
        this.playItem.setEnabled(!this.animate);
        this.pauseItem.setEnabled(this.animate);
        GridData gridData = (GridData)this.controlPanel.getLayoutData();
        controlArray = this.controlPanel.getChildren();
        gridData.exclude = controlArray.length == 0;
        this.controlPanel.setVisible(!gridData.exclude);
        if (gridData.exclude) {
            this.tabPanel.layout();
        } else {
            this.tabPanel.layout(controlArray);
        }
        if (graphicsTab != null && ((treeItemArray = this.tabList.getSelection()).length == 0 || treeItemArray[0].getData() != graphicsTab) && (treeItem = this.findItemByData(this.tabList.getItems(), graphicsTab)) != null) {
            this.tabList.setSelection(new TreeItem[]{treeItem});
        }
        this.canvas.redraw();
    }

    void startAnimationTimer() {
        final Display display = Display.getCurrent();
        display.timerExec(this.timerSpinner.getSelection(), new Runnable(){

            @Override
            public void run() {
                GraphicsTab graphicsTab;
                if (GraphicsExample.this.canvas.isDisposed()) {
                    return;
                }
                if (GraphicsExample.this.animate && (graphicsTab = GraphicsExample.this.getTab()) != null && graphicsTab.isAnimated()) {
                    Rectangle rectangle = GraphicsExample.this.canvas.getClientArea();
                    graphicsTab.next(rectangle.width, rectangle.height);
                    GraphicsExample.this.canvas.redraw();
                    GraphicsExample.this.canvas.update();
                }
                display.timerExec(GraphicsExample.this.timerSpinner.getSelection(), (Runnable)this);
            }
        });
    }

    public static void main(String[] stringArray) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText(GraphicsExample.getResourceString("SWTGraphics"));
        final GraphicsExample graphicsExample = new GraphicsExample((Composite)shell);
        shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                graphicsExample.dispose();
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    static {
        RESOURCE_BUNDLE = ResourceBundle.getBundle("examples_graphics");
    }
}

