/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.layoutexample;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.layoutexample.LayoutExample;
import org.eclipse.swt.examples.layoutexample.Tab;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

class FillLayoutTab
extends Tab {
    Button horizontal;
    Button vertical;
    FillLayout fillLayout;
    TableEditor comboEditor;
    CCombo combo;

    FillLayoutTab(LayoutExample layoutExample) {
        super(layoutExample);
    }

    @Override
    void createChildWidgets() {
        super.createChildWidgets();
        this.comboEditor = new TableEditor(this.table);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FillLayoutTab.this.resetEditors();
                FillLayoutTab.this.index = FillLayoutTab.this.table.getSelectionIndex();
                if (FillLayoutTab.this.index == -1) {
                    return;
                }
                TableItem tableItem = FillLayoutTab.this.comboEditor.getItem();
                FillLayoutTab.this.newItem = FillLayoutTab.this.table.getItem(FillLayoutTab.this.index);
                if (FillLayoutTab.this.newItem == tableItem || FillLayoutTab.this.newItem != FillLayoutTab.this.lastSelected) {
                    FillLayoutTab.this.lastSelected = FillLayoutTab.this.newItem;
                    return;
                }
                FillLayoutTab.this.table.showSelection();
                FillLayoutTab.this.combo = new CCombo((Composite)FillLayoutTab.this.table, 8);
                FillLayoutTab.this.createComboEditor(FillLayoutTab.this.combo, FillLayoutTab.this.comboEditor);
            }
        });
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = new TableItem(FillLayoutTab.this.table, 0);
                tableItem.setText(0, String.valueOf(FillLayoutTab.this.table.indexOf(tableItem)));
                tableItem.setText(1, "Button");
                FillLayoutTab.this.data.addElement("Button");
                FillLayoutTab.this.resetEditors();
            }
        });
    }

    @Override
    void createControlWidgets() {
        Group group = new Group((Composite)this.controlGroup, 0);
        group.setText(LayoutExample.getResourceString("Type"));
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        this.horizontal = new Button((Composite)group, 16);
        this.horizontal.setText("SWT.HORIZONTAL");
        this.horizontal.setLayoutData((Object)new GridData(768));
        this.horizontal.setSelection(true);
        this.horizontal.addSelectionListener(this.selectionListener);
        this.vertical = new Button((Composite)group, 16);
        this.vertical.setText("SWT.VERTICAL");
        this.vertical.setLayoutData((Object)new GridData(768));
        this.vertical.addSelectionListener(this.selectionListener);
        super.createControlWidgets();
        this.sash.setWeights(new int[]{4, 1});
    }

    @Override
    void createLayout() {
        this.fillLayout = new FillLayout();
        this.layoutComposite.setLayout((Layout)this.fillLayout);
    }

    @Override
    void disposeEditors() {
        this.comboEditor.setEditor(null, null, -1);
        this.combo.dispose();
    }

    @Override
    StringBuffer generateLayoutCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t\tFillLayout fillLayout = new FillLayout ();\n");
        if (this.fillLayout.type == 512) {
            stringBuffer.append("\t\tfillLayout.type = SWT.VERTICAL;\n");
        }
        stringBuffer.append("\t\tshell.setLayout (fillLayout);\n");
        for (int i = 0; i < this.children.length; ++i) {
            Control control = this.children[i];
            stringBuffer.append(this.getChildCode(control, i));
        }
        return stringBuffer;
    }

    @Override
    String[] getLayoutDataFieldNames() {
        return new String[]{"", "Control"};
    }

    @Override
    String getTabText() {
        return "FillLayout";
    }

    @Override
    void resetEditors() {
        TableItem tableItem = this.comboEditor.getItem();
        this.comboEditor.setEditor(null, null, -1);
        if (tableItem != null) {
            int n = this.table.indexOf(tableItem);
            this.data.insertElementAt(this.combo.getText(), n);
            tableItem.setText(1, this.data.elementAt(n).toString());
            this.combo.dispose();
        }
        this.setLayoutState();
        this.refreshLayoutComposite();
        this.layoutComposite.layout(true);
        this.layoutGroup.layout(true);
    }

    @Override
    void setLayoutState() {
        this.fillLayout.type = this.vertical.getSelection() ? 512 : 256;
    }
}

