/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.layoutexample;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.layoutexample.LayoutExample;
import org.eclipse.swt.examples.layoutexample.Tab;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

class FormLayoutTab
extends Tab {
    Combo marginHeight;
    Combo marginWidth;
    FormLayout formLayout;
    TableEditor comboEditor;
    TableEditor widthEditor;
    TableEditor heightEditor;
    TableEditor leftEditor;
    TableEditor rightEditor;
    TableEditor topEditor;
    TableEditor bottomEditor;
    CCombo combo;
    Text widthText;
    Text heightText;
    Button leftAttach;
    Button rightAttach;
    Button topAttach;
    Button bottomAttach;
    final int COMBO_COL = 1;
    final int WIDTH_COL = 2;
    final int HEIGHT_COL = 3;
    final int LEFT_COL = 4;
    final int RIGHT_COL = 5;
    final int TOP_COL = 6;
    final int BOTTOM_COL = 7;
    final int MODIFY_COLS = 4;
    final int TOTAL_COLS = 8;

    FormLayoutTab(LayoutExample layoutExample) {
        super(layoutExample);
    }

    int alignmentConstant(String string) {
        if (string.equals("LEFT")) {
            return 16384;
        }
        if (string.equals("RIGHT")) {
            return 131072;
        }
        if (string.equals("TOP")) {
            return 128;
        }
        if (string.equals("BOTTOM")) {
            return 1024;
        }
        if (string.equals("CENTER")) {
            return 0x1000000;
        }
        return -1;
    }

    String alignmentString(int n) {
        switch (n) {
            case 16384: {
                return "LEFT";
            }
            case 131072: {
                return "RIGHT";
            }
            case 128: {
                return "TOP";
            }
            case 1024: {
                return "BOTTOM";
            }
            case 0x1000000: {
                return "CENTER";
            }
        }
        return "DEFAULT";
    }

    String checkAttachment(String string, FormAttachment formAttachment) {
        int n;
        String string2 = formAttachment.control.getClass().toString();
        String string3 = string2.substring(string2.lastIndexOf(46) + 1);
        for (n = 0; n < string.length() && !Character.isDigit(string.charAt(n)); ++n) {
        }
        String string4 = string.substring(n, string.indexOf(44));
        return string3 + string4 + "," + formAttachment.offset + ":" + this.alignmentString(formAttachment.alignment);
    }

    @Override
    void createChildWidgets() {
        super.createChildWidgets();
        this.table.getColumn(4).setWidth(100);
        this.table.getColumn(5).setWidth(100);
        this.table.getColumn(6).setWidth(100);
        this.table.getColumn(7).setWidth(100);
        this.comboEditor = new TableEditor(this.table);
        this.widthEditor = new TableEditor(this.table);
        this.heightEditor = new TableEditor(this.table);
        this.leftEditor = new TableEditor(this.table);
        this.rightEditor = new TableEditor(this.table);
        this.topEditor = new TableEditor(this.table);
        this.bottomEditor = new TableEditor(this.table);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                FormLayoutTab.this.resetEditors();
                FormLayoutTab.this.index = FormLayoutTab.this.table.getSelectionIndex();
                Point point = new Point(mouseEvent.x, mouseEvent.y);
                FormLayoutTab.this.newItem = FormLayoutTab.this.table.getItem(point);
                if (FormLayoutTab.this.newItem == null) {
                    return;
                }
                TableItem tableItem = FormLayoutTab.this.comboEditor.getItem();
                if (FormLayoutTab.this.newItem == tableItem || FormLayoutTab.this.newItem != FormLayoutTab.this.lastSelected) {
                    FormLayoutTab.this.lastSelected = FormLayoutTab.this.newItem;
                    return;
                }
                FormLayoutTab.this.table.showSelection();
                FormLayoutTab.this.combo = new CCombo((Composite)FormLayoutTab.this.table, 8);
                FormLayoutTab.this.createComboEditor(FormLayoutTab.this.combo, FormLayoutTab.this.comboEditor);
                FormLayoutTab.this.widthText = new Text((Composite)FormLayoutTab.this.table, 4);
                FormLayoutTab.this.widthText.setText(((String[])FormLayoutTab.this.data.elementAt(FormLayoutTab.this.index))[2]);
                FormLayoutTab.this.createTextEditor(FormLayoutTab.this.widthText, FormLayoutTab.this.widthEditor, 2);
                FormLayoutTab.this.heightText = new Text((Composite)FormLayoutTab.this.table, 4);
                FormLayoutTab.this.heightText.setText(((String[])FormLayoutTab.this.data.elementAt(FormLayoutTab.this.index))[3]);
                FormLayoutTab.this.createTextEditor(FormLayoutTab.this.heightText, FormLayoutTab.this.heightEditor, 3);
                FormLayoutTab.this.leftAttach = new Button((Composite)FormLayoutTab.this.table, 8);
                FormLayoutTab.this.leftAttach.setText(LayoutExample.getResourceString("Attach_Edit"));
                FormLayoutTab.this.leftEditor.horizontalAlignment = 16384;
                FormLayoutTab.this.leftEditor.grabHorizontal = true;
                FormLayoutTab.this.leftEditor.minimumWidth = FormLayoutTab.this.leftAttach.computeSize((int)-1, (int)-1).x;
                FormLayoutTab.this.leftEditor.setEditor((Control)FormLayoutTab.this.leftAttach, FormLayoutTab.this.newItem, 4);
                FormLayoutTab.this.leftAttach.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        Shell shell = FormLayoutTab.this.tabFolderPage.getShell();
                        AttachDialog attachDialog = new AttachDialog(shell);
                        attachDialog.setText(LayoutExample.getResourceString("Left_Attachment"));
                        attachDialog.setColumn(4);
                        String string = attachDialog.open();
                        FormLayoutTab.this.newItem.setText(4, string);
                        FormLayoutTab.this.resetEditors();
                    }
                });
                FormLayoutTab.this.rightAttach = new Button((Composite)FormLayoutTab.this.table, 8);
                FormLayoutTab.this.rightAttach.setText(LayoutExample.getResourceString("Attach_Edit"));
                FormLayoutTab.this.rightEditor.horizontalAlignment = 16384;
                FormLayoutTab.this.rightEditor.grabHorizontal = true;
                FormLayoutTab.this.rightEditor.minimumWidth = FormLayoutTab.this.rightAttach.computeSize((int)-1, (int)-1).x;
                FormLayoutTab.this.rightEditor.setEditor((Control)FormLayoutTab.this.rightAttach, FormLayoutTab.this.newItem, 5);
                FormLayoutTab.this.rightAttach.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        Shell shell = FormLayoutTab.this.tabFolderPage.getShell();
                        AttachDialog attachDialog = new AttachDialog(shell);
                        attachDialog.setText(LayoutExample.getResourceString("Right_Attachment"));
                        attachDialog.setColumn(5);
                        String string = attachDialog.open();
                        FormLayoutTab.this.newItem.setText(5, string);
                        if (FormLayoutTab.this.newItem.getText(4).endsWith(")")) {
                            FormLayoutTab.this.newItem.setText(4, "");
                        }
                        FormLayoutTab.this.resetEditors();
                    }
                });
                FormLayoutTab.this.topAttach = new Button((Composite)FormLayoutTab.this.table, 8);
                FormLayoutTab.this.topAttach.setText(LayoutExample.getResourceString("Attach_Edit"));
                FormLayoutTab.this.topEditor.horizontalAlignment = 16384;
                FormLayoutTab.this.topEditor.grabHorizontal = true;
                FormLayoutTab.this.topEditor.minimumWidth = FormLayoutTab.this.topAttach.computeSize((int)-1, (int)-1).x;
                FormLayoutTab.this.topEditor.setEditor((Control)FormLayoutTab.this.topAttach, FormLayoutTab.this.newItem, 6);
                FormLayoutTab.this.topAttach.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        Shell shell = FormLayoutTab.this.tabFolderPage.getShell();
                        AttachDialog attachDialog = new AttachDialog(shell);
                        attachDialog.setText(LayoutExample.getResourceString("Top_Attachment"));
                        attachDialog.setColumn(6);
                        String string = attachDialog.open();
                        FormLayoutTab.this.newItem.setText(6, string);
                        FormLayoutTab.this.resetEditors();
                    }
                });
                FormLayoutTab.this.bottomAttach = new Button((Composite)FormLayoutTab.this.table, 8);
                FormLayoutTab.this.bottomAttach.setText(LayoutExample.getResourceString("Attach_Edit"));
                FormLayoutTab.this.bottomEditor.horizontalAlignment = 16384;
                FormLayoutTab.this.bottomEditor.grabHorizontal = true;
                FormLayoutTab.this.bottomEditor.minimumWidth = FormLayoutTab.this.bottomAttach.computeSize((int)-1, (int)-1).x;
                FormLayoutTab.this.bottomEditor.setEditor((Control)FormLayoutTab.this.bottomAttach, FormLayoutTab.this.newItem, 7);
                FormLayoutTab.this.bottomAttach.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        Shell shell = FormLayoutTab.this.tabFolderPage.getShell();
                        AttachDialog attachDialog = new AttachDialog(shell);
                        attachDialog.setText(LayoutExample.getResourceString("Bottom_Attachment"));
                        attachDialog.setColumn(7);
                        String string = attachDialog.open();
                        FormLayoutTab.this.newItem.setText(7, string);
                        if (FormLayoutTab.this.newItem.getText(6).endsWith(")")) {
                            FormLayoutTab.this.newItem.setText(6, "");
                        }
                        FormLayoutTab.this.resetEditors();
                    }
                });
                block6: for (int i = 0; i < FormLayoutTab.this.table.getColumnCount(); ++i) {
                    Rectangle rectangle = FormLayoutTab.this.newItem.getBounds(i);
                    if (!rectangle.contains(point)) continue;
                    switch (i) {
                        case 0: {
                            FormLayoutTab.this.resetEditors();
                            continue block6;
                        }
                        case 1: {
                            FormLayoutTab.this.combo.setFocus();
                            continue block6;
                        }
                        case 2: {
                            FormLayoutTab.this.widthText.setFocus();
                            continue block6;
                        }
                        case 3: {
                            FormLayoutTab.this.heightText.setFocus();
                            continue block6;
                        }
                    }
                }
            }
        });
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = new TableItem(FormLayoutTab.this.table, 0);
                String[] stringArray = new String[]{String.valueOf(FormLayoutTab.this.table.indexOf(tableItem)), "Button", "-1", "-1", "0,0 (" + LayoutExample.getResourceString("Default") + ")", "", "0,0 (" + LayoutExample.getResourceString("Default") + ")", ""};
                tableItem.setText(stringArray);
                FormLayoutTab.this.data.addElement(stringArray);
                FormLayoutTab.this.resetEditors();
            }
        });
    }

    @Override
    void createControlWidgets() {
        String[] stringArray = new String[]{"0", "3", "5", "10"};
        Group group = new Group((Composite)this.controlGroup, 0);
        group.setText(LayoutExample.getResourceString("Margins"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        new Label((Composite)group, 0).setText("marginHeight");
        this.marginHeight = new Combo((Composite)group, 0);
        this.marginHeight.setItems(stringArray);
        this.marginHeight.select(0);
        this.marginHeight.addSelectionListener(this.selectionListener);
        this.marginHeight.addTraverseListener(this.traverseListener);
        GridData gridData = new GridData(768);
        gridData.widthHint = 60;
        this.marginHeight.setLayoutData((Object)gridData);
        new Label((Composite)group, 0).setText("marginWidth");
        this.marginWidth = new Combo((Composite)group, 0);
        this.marginWidth.setItems(stringArray);
        this.marginWidth.select(0);
        this.marginWidth.addSelectionListener(this.selectionListener);
        this.marginWidth.addTraverseListener(this.traverseListener);
        gridData = new GridData(768);
        gridData.widthHint = 60;
        this.marginWidth.setLayoutData((Object)gridData);
        super.createControlWidgets();
        this.sash.setWeights(new int[]{6, 4});
    }

    @Override
    void createLayout() {
        this.formLayout = new FormLayout();
        this.layoutComposite.setLayout((Layout)this.formLayout);
    }

    @Override
    void disposeEditors() {
        this.comboEditor.setEditor(null, null, -1);
        this.combo.dispose();
        this.widthText.dispose();
        this.heightText.dispose();
        this.leftAttach.dispose();
        this.rightAttach.dispose();
        this.topAttach.dispose();
        this.bottomAttach.dispose();
    }

    @Override
    StringBuffer generateLayoutCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t\tFormLayout formLayout = new FormLayout ();\n");
        if (this.formLayout.marginHeight != 0) {
            stringBuffer.append("\t\tformLayout.marginHeight = " + this.formLayout.marginHeight + ";\n");
        }
        if (this.formLayout.marginWidth != 0) {
            stringBuffer.append("\t\tformLayout.marginWidth = " + this.formLayout.marginWidth + ";\n");
        }
        stringBuffer.append("\t\tshell.setLayout (formLayout);\n");
        boolean bl = true;
        for (int i = 0; i < this.children.length; ++i) {
            int n;
            String string;
            TableItem tableItem;
            Control control = this.children[i];
            stringBuffer.append(this.getChildCode(control, i));
            FormData formData = (FormData)control.getLayoutData();
            if (formData == null) continue;
            stringBuffer.append("\t\t");
            if (bl) {
                stringBuffer.append("FormData ");
                bl = false;
            }
            stringBuffer.append("data = new FormData ();\n");
            if (formData.width != -1) {
                stringBuffer.append("\t\tdata.width = " + formData.width + ";\n");
            }
            if (formData.height != -1) {
                stringBuffer.append("\t\tdata.height = " + formData.height + ";\n");
            }
            if (formData.left != null) {
                if (formData.left.control != null) {
                    tableItem = this.table.getItem(i);
                    string = tableItem.getText(4);
                    n = Integer.valueOf(string.substring(string.indexOf(44) - 1, string.indexOf(44)));
                    stringBuffer.append("\t\tdata.left = new FormAttachment (" + this.names[n] + ", " + formData.left.offset + ", SWT." + this.alignmentString(formData.left.alignment) + ");\n");
                } else if (formData.right != null || formData.left.numerator != 0 || formData.left.offset != 0) {
                    stringBuffer.append("\t\tdata.left = new FormAttachment (" + formData.left.numerator + ", " + formData.left.offset + ");\n");
                }
            }
            if (formData.right != null) {
                if (formData.right.control != null) {
                    tableItem = this.table.getItem(i);
                    string = tableItem.getText(5);
                    n = Integer.valueOf(string.substring(string.indexOf(44) - 1, string.indexOf(44)));
                    stringBuffer.append("\t\tdata.right = new FormAttachment (" + this.names[n] + ", " + formData.right.offset + ", SWT." + this.alignmentString(formData.right.alignment) + ");\n");
                } else {
                    stringBuffer.append("\t\tdata.right = new FormAttachment (" + formData.right.numerator + ", " + formData.right.offset + ");\n");
                }
            }
            if (formData.top != null) {
                if (formData.top.control != null) {
                    tableItem = this.table.getItem(i);
                    string = tableItem.getText(6);
                    n = Integer.valueOf(string.substring(string.indexOf(44) - 1, string.indexOf(44)));
                    stringBuffer.append("\t\tdata.top = new FormAttachment (" + this.names[n] + ", " + formData.top.offset + ", SWT." + this.alignmentString(formData.top.alignment) + ");\n");
                } else if (formData.bottom != null || formData.top.numerator != 0 || formData.top.offset != 0) {
                    stringBuffer.append("\t\tdata.top = new FormAttachment (" + formData.top.numerator + ", " + formData.top.offset + ");\n");
                }
            }
            if (formData.bottom != null) {
                if (formData.bottom.control != null) {
                    tableItem = this.table.getItem(i);
                    string = tableItem.getText(7);
                    n = Integer.valueOf(string.substring(string.indexOf(44) - 1, string.indexOf(44)));
                    stringBuffer.append("\t\tdata.bottom = new FormAttachment (" + this.names[n] + ", " + formData.bottom.offset + ", SWT." + this.alignmentString(formData.bottom.alignment) + ");\n");
                } else {
                    stringBuffer.append("\t\tdata.bottom = new FormAttachment (" + formData.bottom.numerator + ", " + formData.bottom.offset + ");\n");
                }
            }
            stringBuffer.append("\t\t" + this.names[i] + ".setLayoutData (data);\n");
        }
        return stringBuffer;
    }

    @Override
    String[] getLayoutDataFieldNames() {
        return new String[]{"", "Control", "width", "height", "left", "right", "top", "bottom"};
    }

    @Override
    String getTabText() {
        return "FormLayout";
    }

    @Override
    void resetEditors() {
        this.resetEditors(false);
    }

    @Override
    void resetEditors(boolean bl) {
        TableItem tableItem = this.comboEditor.getItem();
        if (tableItem != null) {
            int n = this.table.indexOf(tableItem);
            try {
                Integer.valueOf(this.widthText.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.widthText.setText(tableItem.getText(2));
            }
            try {
                Integer.valueOf(this.heightText.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.heightText.setText(tableItem.getText(3));
            }
            String[] stringArray = new String[]{String.valueOf(n), this.combo.getText(), this.widthText.getText(), this.heightText.getText()};
            this.data.setElementAt(stringArray, n);
            for (int i = 0; i < 4; ++i) {
                tableItem.setText(i, ((String[])this.data.elementAt(n))[i]);
            }
            if (!bl) {
                this.disposeEditors();
            }
        }
        this.setLayoutState();
        this.refreshLayoutComposite();
        this.setLayoutData();
        this.layoutComposite.layout(true);
        this.layoutGroup.layout(true);
    }

    FormAttachment setAttachment(String string) {
        int n;
        int n2;
        int n3 = string.indexOf(44);
        char c = string.charAt(0);
        if (Character.isLetter(c)) {
            int n4;
            int n5;
            String string2 = string.substring(0, n3);
            for (n5 = 0; n5 < string2.length() && !Character.isDigit(string2.charAt(n5)); ++n5) {
            }
            String string3 = string2.substring(n5);
            int n6 = Integer.valueOf(string3);
            Control control = this.children[n6];
            int n7 = string.indexOf(58);
            try {
                n4 = Integer.valueOf(string.substring(n3 + 1, n7));
            }
            catch (NumberFormatException numberFormatException) {
                n4 = 0;
            }
            String string4 = string.substring(n7 + 1);
            return new FormAttachment(control, n4, this.alignmentConstant(string4));
        }
        try {
            n2 = Integer.valueOf(string.substring(0, n3));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        try {
            n = Integer.valueOf(string.substring(n3 + 1));
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return new FormAttachment(n2, n);
    }

    @Override
    void setLayoutData() {
        Control[] controlArray = this.layoutComposite.getChildren();
        TableItem[] tableItemArray = this.table.getItems();
        for (int i = 0; i < controlArray.length; ++i) {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            int n = Integer.valueOf(tableItemArray[i].getText(2));
            int n2 = Integer.valueOf(tableItemArray[i].getText(3));
            FormData formData = new FormData();
            if (n > 0) {
                formData.width = n;
            }
            if (n2 > 0) {
                formData.height = n2;
            }
            if ((string5 = tableItemArray[i].getText(4)).length() > 0) {
                formData.left = this.setAttachment(string5);
                if (formData.left.control != null) {
                    string4 = this.checkAttachment(string5, formData.left);
                    tableItemArray[i].setText(4, string4);
                }
            }
            if ((string3 = tableItemArray[i].getText(5)).length() > 0) {
                formData.right = this.setAttachment(string3);
                if (formData.right.control != null) {
                    string4 = this.checkAttachment(string3, formData.right);
                    tableItemArray[i].setText(5, string4);
                }
            }
            if ((string2 = tableItemArray[i].getText(6)).length() > 0) {
                formData.top = this.setAttachment(string2);
                if (formData.top.control != null) {
                    string4 = this.checkAttachment(string2, formData.top);
                    tableItemArray[i].setText(6, string4);
                }
            }
            if ((string = tableItemArray[i].getText(7)).length() > 0) {
                formData.bottom = this.setAttachment(string);
                if (formData.bottom.control != null) {
                    string4 = this.checkAttachment(string, formData.bottom);
                    tableItemArray[i].setText(7, string4);
                }
            }
            controlArray[i].setLayoutData((Object)formData);
        }
    }

    @Override
    void setLayoutState() {
        try {
            this.formLayout.marginHeight = Integer.valueOf(this.marginHeight.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.formLayout.marginHeight = 0;
            this.marginHeight.select(0);
        }
        try {
            this.formLayout.marginWidth = Integer.valueOf(this.marginWidth.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.formLayout.marginWidth = 0;
            this.marginWidth.select(0);
        }
    }

    public class AttachDialog
    extends Dialog {
        String result;
        String controlInput;
        String positionInput;
        String alignmentInput;
        String offsetInput;
        int col;

        public AttachDialog(Shell shell, int n) {
            super(shell, n);
            this.result = "";
            this.col = 0;
        }

        public AttachDialog(Shell shell) {
            this(shell, 0);
        }

        public void setColumn(int n) {
            this.col = n;
        }

        public String open() {
            Shell shell = this.getParent();
            final Shell shell2 = new Shell(shell, 67680);
            shell2.setText(this.getText());
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            gridLayout.makeColumnsEqualWidth = true;
            shell2.setLayout((Layout)gridLayout);
            TableItem tableItem = FormLayoutTab.this.leftEditor.getItem();
            String string = this.result = tableItem.getText(this.col);
            String string2 = "0";
            String string3 = "";
            String string4 = "DEFAULT";
            String string5 = "0";
            boolean bl = false;
            if (string.length() != 0) {
                char c = string.charAt(0);
                if (Character.isLetter(c)) {
                    bl = true;
                    string3 = string.substring(0, string.indexOf(44));
                    string4 = string.substring(string.indexOf(58) + 1);
                    string5 = string.substring(string.indexOf(44) + 1, string.indexOf(58));
                } else {
                    string2 = string.substring(0, string.indexOf(44));
                    string5 = string.substring(string.indexOf(44) + 1);
                    if (string5.endsWith(")")) {
                        string5 = string5.substring(0, string5.indexOf(32));
                    }
                }
            }
            final Button button = new Button((Composite)shell2, 16);
            button.setText(LayoutExample.getResourceString("Position"));
            button.setSelection(!bl);
            final Combo combo = new Combo((Composite)shell2, 0);
            combo.setItems(new String[]{"0", "25", "50", "75", "100"});
            combo.setText(string2);
            combo.setEnabled(!bl);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            combo.setLayoutData((Object)gridData);
            Button button2 = new Button((Composite)shell2, 16);
            button2.setText(LayoutExample.getResourceString("Control"));
            button2.setSelection(bl);
            final Combo combo2 = new Combo((Composite)shell2, 8);
            TableItem[] tableItemArray = FormLayoutTab.this.table.getItems();
            TableItem tableItem2 = FormLayoutTab.this.leftEditor.getItem();
            for (int i = 0; i < FormLayoutTab.this.table.getItemCount(); ++i) {
                if (tableItemArray[i].getText(0).length() <= 0 || tableItemArray[i] == tableItem2) continue;
                combo2.add(tableItemArray[i].getText(1) + i);
            }
            if (string3.length() != 0) {
                combo2.setText(string3);
            } else {
                combo2.select(0);
            }
            combo2.setEnabled(bl);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            combo2.setLayoutData((Object)gridData);
            new Label((Composite)shell2, 0).setText(LayoutExample.getResourceString("Alignment"));
            final Combo combo3 = new Combo((Composite)shell2, 0);
            String[] stringArray = this.col == 4 || this.col == 5 ? new String[]{"SWT.LEFT", "SWT.RIGHT", "SWT.CENTER", "SWT.DEFAULT"} : new String[]{"SWT.TOP", "SWT.BOTTOM", "SWT.CENTER", "SWT.DEFAULT"};
            combo3.setItems(stringArray);
            combo3.setText("SWT." + string4);
            combo3.setEnabled(bl);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            combo3.setLayoutData((Object)gridData);
            new Label((Composite)shell2, 0).setText(LayoutExample.getResourceString("Offset"));
            final Text text = new Text((Composite)shell2, 2052);
            text.setText(string5);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            text.setLayoutData((Object)gridData);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    combo.setEnabled(true);
                    combo2.setEnabled(false);
                    combo3.setEnabled(false);
                }
            });
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    combo.setEnabled(false);
                    combo2.setEnabled(true);
                    combo3.setEnabled(true);
                }
            });
            Button button3 = new Button((Composite)shell2, 8);
            button3.setText(LayoutExample.getResourceString("Clear"));
            button3.setLayoutData((Object)new GridData(128));
            button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AttachDialog.this.result = "";
                    shell2.close();
                }
            });
            Button button4 = new Button((Composite)shell2, 8);
            button4.setText(LayoutExample.getResourceString("OK"));
            button4.setLayoutData((Object)new GridData(64));
            button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AttachDialog.this.controlInput = combo2.getText();
                    AttachDialog.this.alignmentInput = combo3.getText().substring(4);
                    AttachDialog.this.positionInput = combo.getText();
                    if (AttachDialog.this.positionInput.length() == 0) {
                        AttachDialog.this.positionInput = "0";
                    }
                    try {
                        Integer.valueOf(AttachDialog.this.positionInput).intValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        AttachDialog.this.positionInput = "0";
                    }
                    AttachDialog.this.offsetInput = text.getText();
                    if (AttachDialog.this.offsetInput.length() == 0) {
                        AttachDialog.this.offsetInput = "0";
                    }
                    try {
                        Integer.valueOf(AttachDialog.this.offsetInput).intValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        AttachDialog.this.offsetInput = "0";
                    }
                    AttachDialog.this.result = button.getSelection() || AttachDialog.this.controlInput.length() == 0 ? AttachDialog.this.positionInput + "," + AttachDialog.this.offsetInput : AttachDialog.this.controlInput + "," + AttachDialog.this.offsetInput + ":" + AttachDialog.this.alignmentInput;
                    shell2.close();
                }
            });
            Button button5 = new Button((Composite)shell2, 8);
            button5.setText(LayoutExample.getResourceString("Cancel"));
            button5.setLayoutData((Object)new GridData(32));
            button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.close();
                }
            });
            shell2.setDefaultButton(button4);
            shell2.pack();
            Point point = shell.getLocation();
            point.x = point.x + shell.getBounds().width / 2 - shell2.getBounds().width / 2;
            point.y = point.y + shell.getBounds().height / 2 - shell2.getBounds().height / 2;
            shell2.setLocation(point);
            shell2.open();
            Display display = shell2.getDisplay();
            while (!shell2.isDisposed()) {
                if (!display.readAndDispatch()) continue;
                display.sleep();
            }
            return this.result;
        }
    }
}

